/* SPDX-FileCopyrightText: 2024 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import Filter from 'gmp/models/filter';
import {isDefined} from 'gmp/utils/identity';
import FormGroup from 'web/components/form/FormGroup';
import Spinner from 'web/components/form/Spinner';
import useTranslation from 'web/hooks/useTranslation';

interface MinQodGroupProps {
  qod?: number;
  filter?: Filter;
  name?: string;
  onChange?: (value: number, name: string) => void;
}

const MinQodGroup = ({
  qod,
  onChange,
  filter,
  name = 'min_qod',
}: MinQodGroupProps) => {
  const [_] = useTranslation();

  if (!isDefined(qod) && isDefined(filter)) {
    qod = filter.get('min_qod') as number | undefined;
  }
  return (
    <FormGroup direction="row" title={_('QoD')}>
      <span>{_('must be at least')}</span>
      <Spinner
        data-testid="min-qod"
        max={100}
        min={0}
        name={name}
        step={1}
        type="int"
        value={qod}
        onChange={
          onChange as ((value: number, name?: string) => void) | undefined
        }
      />
      <span>%</span>
    </FormGroup>
  );
};

export default MinQodGroup;
