// Copyright (c) Facebook, Inc. and its affiliates.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/* automatically @generated by rust-bindgen 0.60.1 */

#![allow(improper_ctypes)]
#![allow(non_snake_case)]
#![allow(non_camel_case_types)]
#![allow(non_upper_case_globals)]
#![cfg_attr(test, allow(deref_nullptr))]

#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const __BITS_PER_LONG: u32 = 64;
pub const __FD_SETSIZE: u32 = 1024;
pub const _IOC_NRBITS: u32 = 8;
pub const _IOC_TYPEBITS: u32 = 8;
pub const _IOC_SIZEBITS: u32 = 14;
pub const _IOC_DIRBITS: u32 = 2;
pub const _IOC_NRMASK: u32 = 255;
pub const _IOC_TYPEMASK: u32 = 255;
pub const _IOC_SIZEMASK: u32 = 16383;
pub const _IOC_DIRMASK: u32 = 3;
pub const _IOC_NRSHIFT: u32 = 0;
pub const _IOC_TYPESHIFT: u32 = 8;
pub const _IOC_SIZESHIFT: u32 = 16;
pub const _IOC_DIRSHIFT: u32 = 30;
pub const _IOC_NONE: u32 = 0;
pub const _IOC_WRITE: u32 = 1;
pub const _IOC_READ: u32 = 2;
pub const IOC_IN: u32 = 1073741824;
pub const IOC_OUT: u32 = 2147483648;
pub const IOC_INOUT: u32 = 3221225472;
pub const IOCSIZE_MASK: u32 = 1073676288;
pub const IOCSIZE_SHIFT: u32 = 16;
pub const BTRFS_IOCTL_MAGIC: u32 = 148;
pub const BTRFS_VOL_NAME_MAX: u32 = 255;
pub const BTRFS_LABEL_SIZE: u32 = 256;
pub const BTRFS_PATH_NAME_MAX: u32 = 4087;
pub const BTRFS_DEVICE_PATH_NAME_MAX: u32 = 1024;
pub const BTRFS_SUBVOL_NAME_MAX: u32 = 4039;
pub const BTRFS_SUBVOL_CREATE_ASYNC: u32 = 1;
pub const BTRFS_SUBVOL_RDONLY: u32 = 2;
pub const BTRFS_SUBVOL_QGROUP_INHERIT: u32 = 4;
pub const BTRFS_DEVICE_SPEC_BY_ID: u32 = 8;
pub const BTRFS_VOL_ARG_V2_FLAGS_SUPPORTED: u32 = 15;
pub const BTRFS_FSID_SIZE: u32 = 16;
pub const BTRFS_UUID_SIZE: u32 = 16;
pub const BTRFS_UUID_UNPARSED_SIZE: u32 = 37;
pub const BTRFS_QGROUP_LIMIT_MAX_RFER: u32 = 1;
pub const BTRFS_QGROUP_LIMIT_MAX_EXCL: u32 = 2;
pub const BTRFS_QGROUP_LIMIT_RSV_RFER: u32 = 4;
pub const BTRFS_QGROUP_LIMIT_RSV_EXCL: u32 = 8;
pub const BTRFS_QGROUP_LIMIT_RFER_CMPR: u32 = 16;
pub const BTRFS_QGROUP_LIMIT_EXCL_CMPR: u32 = 32;
pub const BTRFS_QGROUP_INHERIT_SET_LIMITS: u32 = 1;
pub const BTRFS_SCRUB_READONLY: u32 = 1;
pub const BTRFS_IOCTL_DEV_REPLACE_CONT_READING_FROM_SRCDEV_MODE_ALWAYS: u32 = 0;
pub const BTRFS_IOCTL_DEV_REPLACE_CONT_READING_FROM_SRCDEV_MODE_AVOID: u32 = 1;
pub const BTRFS_IOCTL_DEV_REPLACE_STATE_NEVER_STARTED: u32 = 0;
pub const BTRFS_IOCTL_DEV_REPLACE_STATE_STARTED: u32 = 1;
pub const BTRFS_IOCTL_DEV_REPLACE_STATE_FINISHED: u32 = 2;
pub const BTRFS_IOCTL_DEV_REPLACE_STATE_CANCELED: u32 = 3;
pub const BTRFS_IOCTL_DEV_REPLACE_STATE_SUSPENDED: u32 = 4;
pub const BTRFS_IOCTL_DEV_REPLACE_CMD_START: u32 = 0;
pub const BTRFS_IOCTL_DEV_REPLACE_CMD_STATUS: u32 = 1;
pub const BTRFS_IOCTL_DEV_REPLACE_CMD_CANCEL: u32 = 2;
pub const BTRFS_IOCTL_DEV_REPLACE_RESULT_NO_ERROR: u32 = 0;
pub const BTRFS_IOCTL_DEV_REPLACE_RESULT_NOT_STARTED: u32 = 1;
pub const BTRFS_IOCTL_DEV_REPLACE_RESULT_ALREADY_STARTED: u32 = 2;
pub const BTRFS_IOCTL_DEV_REPLACE_RESULT_SCRUB_INPROGRESS: u32 = 3;
pub const BTRFS_FEATURE_COMPAT_RO_FREE_SPACE_TREE: u32 = 1;
pub const BTRFS_FEATURE_COMPAT_RO_FREE_SPACE_TREE_VALID: u32 = 2;
pub const BTRFS_FEATURE_INCOMPAT_MIXED_BACKREF: u32 = 1;
pub const BTRFS_FEATURE_INCOMPAT_DEFAULT_SUBVOL: u32 = 2;
pub const BTRFS_FEATURE_INCOMPAT_MIXED_GROUPS: u32 = 4;
pub const BTRFS_FEATURE_INCOMPAT_COMPRESS_LZO: u32 = 8;
pub const BTRFS_FEATURE_INCOMPAT_COMPRESS_ZSTD: u32 = 16;
pub const BTRFS_FEATURE_INCOMPAT_BIG_METADATA: u32 = 32;
pub const BTRFS_FEATURE_INCOMPAT_EXTENDED_IREF: u32 = 64;
pub const BTRFS_FEATURE_INCOMPAT_RAID56: u32 = 128;
pub const BTRFS_FEATURE_INCOMPAT_SKINNY_METADATA: u32 = 256;
pub const BTRFS_FEATURE_INCOMPAT_NO_HOLES: u32 = 512;
pub const BTRFS_BALANCE_CTL_PAUSE: u32 = 1;
pub const BTRFS_BALANCE_CTL_CANCEL: u32 = 2;
pub const BTRFS_BALANCE_DATA: u32 = 1;
pub const BTRFS_BALANCE_SYSTEM: u32 = 2;
pub const BTRFS_BALANCE_METADATA: u32 = 4;
pub const BTRFS_BALANCE_TYPE_MASK: u32 = 7;
pub const BTRFS_BALANCE_FORCE: u32 = 8;
pub const BTRFS_BALANCE_RESUME: u32 = 16;
pub const BTRFS_BALANCE_ARGS_PROFILES: u32 = 1;
pub const BTRFS_BALANCE_ARGS_USAGE: u32 = 2;
pub const BTRFS_BALANCE_ARGS_DEVID: u32 = 4;
pub const BTRFS_BALANCE_ARGS_DRANGE: u32 = 8;
pub const BTRFS_BALANCE_ARGS_VRANGE: u32 = 16;
pub const BTRFS_BALANCE_ARGS_LIMIT: u32 = 32;
pub const BTRFS_BALANCE_ARGS_LIMIT_RANGE: u32 = 64;
pub const BTRFS_BALANCE_ARGS_STRIPES_RANGE: u32 = 128;
pub const BTRFS_BALANCE_ARGS_USAGE_RANGE: u32 = 1024;
pub const BTRFS_BALANCE_ARGS_MASK: u32 = 1279;
pub const BTRFS_BALANCE_ARGS_CONVERT: u32 = 256;
pub const BTRFS_BALANCE_ARGS_SOFT: u32 = 512;
pub const BTRFS_BALANCE_STATE_RUNNING: u32 = 1;
pub const BTRFS_BALANCE_STATE_PAUSE_REQ: u32 = 2;
pub const BTRFS_BALANCE_STATE_CANCEL_REQ: u32 = 4;
pub const BTRFS_INO_LOOKUP_PATH_MAX: u32 = 4080;
pub const BTRFS_DEFRAG_RANGE_COMPRESS: u32 = 1;
pub const BTRFS_DEFRAG_RANGE_START_IO: u32 = 2;
pub const BTRFS_SAME_DATA_DIFFERS: u32 = 1;
pub const BTRFS_LOGICAL_INO_ARGS_IGNORE_OFFSET: u32 = 1;
pub const BTRFS_DEV_STATS_RESET: u32 = 1;
pub const BTRFS_QUOTA_CTL_ENABLE: u32 = 1;
pub const BTRFS_QUOTA_CTL_DISABLE: u32 = 2;
pub const BTRFS_QUOTA_CTL_RESCAN__NOTUSED: u32 = 3;
pub const BTRFS_SEND_FLAG_NO_FILE_DATA: u32 = 1;
pub const BTRFS_SEND_FLAG_OMIT_STREAM_HEADER: u32 = 2;
pub const BTRFS_SEND_FLAG_OMIT_END_CMD: u32 = 4;
pub const BTRFS_SEND_FLAG_MASK: u32 = 7;
pub const BTRFS_ROOT_TREE_OBJECTID: u32 = 1;
pub const BTRFS_EXTENT_TREE_OBJECTID: u32 = 2;
pub const BTRFS_CHUNK_TREE_OBJECTID: u32 = 3;
pub const BTRFS_DEV_TREE_OBJECTID: u32 = 4;
pub const BTRFS_FS_TREE_OBJECTID: u32 = 5;
pub const BTRFS_ROOT_TREE_DIR_OBJECTID: u32 = 6;
pub const BTRFS_CSUM_TREE_OBJECTID: u32 = 7;
pub const BTRFS_QUOTA_TREE_OBJECTID: u32 = 8;
pub const BTRFS_UUID_TREE_OBJECTID: u32 = 9;
pub const BTRFS_FREE_SPACE_TREE_OBJECTID: u32 = 10;
pub const BTRFS_DEV_STATS_OBJECTID: u32 = 0;
pub const BTRFS_BALANCE_OBJECTID: i32 = -4;
pub const BTRFS_ORPHAN_OBJECTID: i32 = -5;
pub const BTRFS_TREE_LOG_OBJECTID: i32 = -6;
pub const BTRFS_TREE_LOG_FIXUP_OBJECTID: i32 = -7;
pub const BTRFS_TREE_RELOC_OBJECTID: i32 = -8;
pub const BTRFS_DATA_RELOC_TREE_OBJECTID: i32 = -9;
pub const BTRFS_EXTENT_CSUM_OBJECTID: i32 = -10;
pub const BTRFS_FREE_SPACE_OBJECTID: i32 = -11;
pub const BTRFS_FREE_INO_OBJECTID: i32 = -12;
pub const BTRFS_MULTIPLE_OBJECTIDS: i32 = -255;
pub const BTRFS_FIRST_FREE_OBJECTID: u32 = 256;
pub const BTRFS_LAST_FREE_OBJECTID: i32 = -256;
pub const BTRFS_FIRST_CHUNK_TREE_OBJECTID: u32 = 256;
pub const BTRFS_DEV_ITEMS_OBJECTID: u32 = 1;
pub const BTRFS_BTREE_INODE_OBJECTID: u32 = 1;
pub const BTRFS_EMPTY_SUBVOL_DIR_OBJECTID: u32 = 2;
pub const BTRFS_DEV_REPLACE_DEVID: u32 = 0;
pub const BTRFS_INODE_ITEM_KEY: u32 = 1;
pub const BTRFS_INODE_REF_KEY: u32 = 12;
pub const BTRFS_INODE_EXTREF_KEY: u32 = 13;
pub const BTRFS_XATTR_ITEM_KEY: u32 = 24;
pub const BTRFS_ORPHAN_ITEM_KEY: u32 = 48;
pub const BTRFS_DIR_LOG_ITEM_KEY: u32 = 60;
pub const BTRFS_DIR_LOG_INDEX_KEY: u32 = 72;
pub const BTRFS_DIR_ITEM_KEY: u32 = 84;
pub const BTRFS_DIR_INDEX_KEY: u32 = 96;
pub const BTRFS_EXTENT_DATA_KEY: u32 = 108;
pub const BTRFS_EXTENT_CSUM_KEY: u32 = 128;
pub const BTRFS_ROOT_ITEM_KEY: u32 = 132;
pub const BTRFS_ROOT_BACKREF_KEY: u32 = 144;
pub const BTRFS_ROOT_REF_KEY: u32 = 156;
pub const BTRFS_EXTENT_ITEM_KEY: u32 = 168;
pub const BTRFS_METADATA_ITEM_KEY: u32 = 169;
pub const BTRFS_TREE_BLOCK_REF_KEY: u32 = 176;
pub const BTRFS_EXTENT_DATA_REF_KEY: u32 = 178;
pub const BTRFS_EXTENT_REF_V0_KEY: u32 = 180;
pub const BTRFS_SHARED_BLOCK_REF_KEY: u32 = 182;
pub const BTRFS_SHARED_DATA_REF_KEY: u32 = 184;
pub const BTRFS_BLOCK_GROUP_ITEM_KEY: u32 = 192;
pub const BTRFS_FREE_SPACE_INFO_KEY: u32 = 198;
pub const BTRFS_FREE_SPACE_EXTENT_KEY: u32 = 199;
pub const BTRFS_FREE_SPACE_BITMAP_KEY: u32 = 200;
pub const BTRFS_DEV_EXTENT_KEY: u32 = 204;
pub const BTRFS_DEV_ITEM_KEY: u32 = 216;
pub const BTRFS_CHUNK_ITEM_KEY: u32 = 228;
pub const BTRFS_QGROUP_STATUS_KEY: u32 = 240;
pub const BTRFS_QGROUP_INFO_KEY: u32 = 242;
pub const BTRFS_QGROUP_LIMIT_KEY: u32 = 244;
pub const BTRFS_QGROUP_RELATION_KEY: u32 = 246;
pub const BTRFS_BALANCE_ITEM_KEY: u32 = 248;
pub const BTRFS_TEMPORARY_ITEM_KEY: u32 = 248;
pub const BTRFS_DEV_STATS_KEY: u32 = 249;
pub const BTRFS_PERSISTENT_ITEM_KEY: u32 = 249;
pub const BTRFS_DEV_REPLACE_KEY: u32 = 250;
pub const BTRFS_UUID_KEY_SUBVOL: u32 = 251;
pub const BTRFS_UUID_KEY_RECEIVED_SUBVOL: u32 = 252;
pub const BTRFS_STRING_ITEM_KEY: u32 = 253;
pub const BTRFS_CSUM_SIZE: u32 = 32;
pub const BTRFS_CSUM_TYPE_CRC32: u32 = 0;
pub const BTRFS_FT_UNKNOWN: u32 = 0;
pub const BTRFS_FT_REG_FILE: u32 = 1;
pub const BTRFS_FT_DIR: u32 = 2;
pub const BTRFS_FT_CHRDEV: u32 = 3;
pub const BTRFS_FT_BLKDEV: u32 = 4;
pub const BTRFS_FT_FIFO: u32 = 5;
pub const BTRFS_FT_SOCK: u32 = 6;
pub const BTRFS_FT_SYMLINK: u32 = 7;
pub const BTRFS_FT_XATTR: u32 = 8;
pub const BTRFS_FT_MAX: u32 = 9;
pub const BTRFS_FREE_SPACE_EXTENT: u32 = 1;
pub const BTRFS_FREE_SPACE_BITMAP: u32 = 2;
pub const BTRFS_HEADER_FLAG_WRITTEN: u32 = 1;
pub const BTRFS_HEADER_FLAG_RELOC: u32 = 2;
pub const BTRFS_SUPER_FLAG_ERROR: u32 = 4;
pub const BTRFS_SUPER_FLAG_SEEDING: u64 = 4294967296;
pub const BTRFS_SUPER_FLAG_METADUMP: u64 = 8589934592;
pub const BTRFS_SUPER_FLAG_METADUMP_V2: u64 = 17179869184;
pub const BTRFS_SUPER_FLAG_CHANGING_FSID: u64 = 34359738368;
pub const BTRFS_EXTENT_FLAG_DATA: u32 = 1;
pub const BTRFS_EXTENT_FLAG_TREE_BLOCK: u32 = 2;
pub const BTRFS_BLOCK_FLAG_FULL_BACKREF: u32 = 256;
pub const BTRFS_EXTENT_FLAG_SUPER: u64 = 281474976710656;
pub const BTRFS_ROOT_SUBVOL_RDONLY: u32 = 1;
pub const BTRFS_ROOT_SUBVOL_DEAD: u64 = 281474976710656;
pub const BTRFS_FILE_EXTENT_INLINE: u32 = 0;
pub const BTRFS_FILE_EXTENT_REG: u32 = 1;
pub const BTRFS_FILE_EXTENT_PREALLOC: u32 = 2;
pub const BTRFS_FILE_EXTENT_TYPES: u32 = 2;
pub const BTRFS_DEV_REPLACE_ITEM_CONT_READING_FROM_SRCDEV_MODE_ALWAYS: u32 = 0;
pub const BTRFS_DEV_REPLACE_ITEM_CONT_READING_FROM_SRCDEV_MODE_AVOID: u32 = 1;
pub const BTRFS_DEV_REPLACE_ITEM_STATE_NEVER_STARTED: u32 = 0;
pub const BTRFS_DEV_REPLACE_ITEM_STATE_STARTED: u32 = 1;
pub const BTRFS_DEV_REPLACE_ITEM_STATE_SUSPENDED: u32 = 2;
pub const BTRFS_DEV_REPLACE_ITEM_STATE_FINISHED: u32 = 3;
pub const BTRFS_DEV_REPLACE_ITEM_STATE_CANCELED: u32 = 4;
pub const BTRFS_BLOCK_GROUP_DATA: u32 = 1;
pub const BTRFS_BLOCK_GROUP_SYSTEM: u32 = 2;
pub const BTRFS_BLOCK_GROUP_METADATA: u32 = 4;
pub const BTRFS_BLOCK_GROUP_RAID0: u32 = 8;
pub const BTRFS_BLOCK_GROUP_RAID1: u32 = 16;
pub const BTRFS_BLOCK_GROUP_DUP: u32 = 32;
pub const BTRFS_BLOCK_GROUP_RAID10: u32 = 64;
pub const BTRFS_BLOCK_GROUP_RAID5: u32 = 128;
pub const BTRFS_BLOCK_GROUP_RAID6: u32 = 256;
pub const BTRFS_BLOCK_GROUP_TYPE_MASK: u32 = 7;
pub const BTRFS_BLOCK_GROUP_PROFILE_MASK: u32 = 504;
pub const BTRFS_BLOCK_GROUP_RAID56_MASK: u32 = 384;
pub const BTRFS_AVAIL_ALLOC_BIT_SINGLE: u64 = 281474976710656;
pub const BTRFS_SPACE_INFO_GLOBAL_RSV: u64 = 562949953421312;
pub const BTRFS_EXTENDED_PROFILE_MASK: u64 = 281474976711160;
pub const BTRFS_FREE_SPACE_USING_BITMAPS: u32 = 1;
pub const BTRFS_QGROUP_LEVEL_SHIFT: u32 = 48;
pub const BTRFS_QGROUP_STATUS_FLAG_ON: u32 = 1;
pub const BTRFS_QGROUP_STATUS_FLAG_RESCAN: u32 = 2;
pub const BTRFS_QGROUP_STATUS_FLAG_INCONSISTENT: u32 = 4;
pub const BTRFS_QGROUP_STATUS_VERSION: u32 = 1;
pub type __s8 = ::std::os::raw::c_schar;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___kernel_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_fd_set))
    );
    fn test_field_fds_bits() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<__kernel_fd_set>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).fds_bits) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(__kernel_fd_set),
                "::",
                stringify!(fds_bits)
            )
        );
    }
    test_field_fds_bits();
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___kernel_fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_fsid_t))
    );
    fn test_field_val() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<__kernel_fsid_t>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).val) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(__kernel_fsid_t),
                "::",
                stringify!(val)
            )
        );
    }
    test_field_val();
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __poll_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_vol_args {
    pub fd: __s64,
    pub name: [::std::os::raw::c_char; 4088usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_vol_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_vol_args>(),
        4096usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_vol_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_vol_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_vol_args))
    );
    fn test_field_fd() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_vol_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args),
                "::",
                stringify!(fd)
            )
        );
    }
    test_field_fd();
    fn test_field_name() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_vol_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args),
                "::",
                stringify!(name)
            )
        );
    }
    test_field_name();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_qgroup_limit {
    pub flags: __u64,
    pub max_rfer: __u64,
    pub max_excl: __u64,
    pub rsv_rfer: __u64,
    pub rsv_excl: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_qgroup_limit() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_qgroup_limit>(),
        40usize,
        concat!("Size of: ", stringify!(btrfs_qgroup_limit))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_qgroup_limit>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_qgroup_limit))
    );
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_max_rfer() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).max_rfer) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit),
                "::",
                stringify!(max_rfer)
            )
        );
    }
    test_field_max_rfer();
    fn test_field_max_excl() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).max_excl) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit),
                "::",
                stringify!(max_excl)
            )
        );
    }
    test_field_max_excl();
    fn test_field_rsv_rfer() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rsv_rfer) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit),
                "::",
                stringify!(rsv_rfer)
            )
        );
    }
    test_field_rsv_rfer();
    fn test_field_rsv_excl() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rsv_excl) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit),
                "::",
                stringify!(rsv_excl)
            )
        );
    }
    test_field_rsv_excl();
}
#[repr(C)]
#[derive(Debug)]
pub struct btrfs_qgroup_inherit {
    pub flags: __u64,
    pub num_qgroups: __u64,
    pub num_ref_copies: __u64,
    pub num_excl_copies: __u64,
    pub lim: btrfs_qgroup_limit,
    pub qgroups: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_btrfs_qgroup_inherit() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_qgroup_inherit>(),
        72usize,
        concat!("Size of: ", stringify!(btrfs_qgroup_inherit))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_qgroup_inherit>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_qgroup_inherit))
    );
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_inherit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_inherit),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_num_qgroups() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_inherit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_qgroups) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_inherit),
                "::",
                stringify!(num_qgroups)
            )
        );
    }
    test_field_num_qgroups();
    fn test_field_num_ref_copies() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_inherit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_ref_copies) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_inherit),
                "::",
                stringify!(num_ref_copies)
            )
        );
    }
    test_field_num_ref_copies();
    fn test_field_num_excl_copies() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_inherit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_excl_copies) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_inherit),
                "::",
                stringify!(num_excl_copies)
            )
        );
    }
    test_field_num_excl_copies();
    fn test_field_lim() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_inherit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).lim) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_inherit),
                "::",
                stringify!(lim)
            )
        );
    }
    test_field_lim();
    fn test_field_qgroups() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_inherit>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).qgroups) as usize - ptr as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_inherit),
                "::",
                stringify!(qgroups)
            )
        );
    }
    test_field_qgroups();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_qgroup_limit_args {
    pub qgroupid: __u64,
    pub lim: btrfs_qgroup_limit,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_qgroup_limit_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_qgroup_limit_args>(),
        48usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_qgroup_limit_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_qgroup_limit_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_qgroup_limit_args))
    );
    fn test_field_qgroupid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_qgroup_limit_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).qgroupid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_qgroup_limit_args),
                "::",
                stringify!(qgroupid)
            )
        );
    }
    test_field_qgroupid();
    fn test_field_lim() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_qgroup_limit_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).lim) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_qgroup_limit_args),
                "::",
                stringify!(lim)
            )
        );
    }
    test_field_lim();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct btrfs_ioctl_vol_args_v2 {
    pub fd: __s64,
    pub transid: __u64,
    pub flags: __u64,
    pub __bindgen_anon_1: btrfs_ioctl_vol_args_v2__bindgen_ty_1,
    pub __bindgen_anon_2: btrfs_ioctl_vol_args_v2__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union btrfs_ioctl_vol_args_v2__bindgen_ty_1 {
    pub __bindgen_anon_1: btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1,
    pub unused: [__u64; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1 {
    pub size: __u64,
    pub qgroup_inherit: *mut btrfs_qgroup_inherit,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1)
        )
    );
    fn test_field_size() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1),
                "::",
                stringify!(size)
            )
        );
    }
    test_field_size();
    fn test_field_qgroup_inherit() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).qgroup_inherit) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_1__bindgen_ty_1),
                "::",
                stringify!(qgroup_inherit)
            )
        );
    }
    test_field_qgroup_inherit();
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_vol_args_v2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_vol_args_v2__bindgen_ty_1>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_vol_args_v2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_1)
        )
    );
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_vol_args_v2__bindgen_ty_1>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_1),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union btrfs_ioctl_vol_args_v2__bindgen_ty_2 {
    pub name: [::std::os::raw::c_char; 4040usize],
    pub devid: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_vol_args_v2__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_vol_args_v2__bindgen_ty_2>(),
        4040usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_vol_args_v2__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_2)
        )
    );
    fn test_field_name() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_vol_args_v2__bindgen_ty_2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_2),
                "::",
                stringify!(name)
            )
        );
    }
    test_field_name();
    fn test_field_devid() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_vol_args_v2__bindgen_ty_2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args_v2__bindgen_ty_2),
                "::",
                stringify!(devid)
            )
        );
    }
    test_field_devid();
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_vol_args_v2() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_vol_args_v2>(),
        4096usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_vol_args_v2))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_vol_args_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_vol_args_v2))
    );
    fn test_field_fd() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_vol_args_v2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args_v2),
                "::",
                stringify!(fd)
            )
        );
    }
    test_field_fd();
    fn test_field_transid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_vol_args_v2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).transid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args_v2),
                "::",
                stringify!(transid)
            )
        );
    }
    test_field_transid();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_vol_args_v2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_vol_args_v2),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_scrub_progress {
    pub data_extents_scrubbed: __u64,
    pub tree_extents_scrubbed: __u64,
    pub data_bytes_scrubbed: __u64,
    pub tree_bytes_scrubbed: __u64,
    pub read_errors: __u64,
    pub csum_errors: __u64,
    pub verify_errors: __u64,
    pub no_csum: __u64,
    pub csum_discards: __u64,
    pub super_errors: __u64,
    pub malloc_errors: __u64,
    pub uncorrectable_errors: __u64,
    pub corrected_errors: __u64,
    pub last_physical: __u64,
    pub unverified_errors: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_scrub_progress() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_scrub_progress>(),
        120usize,
        concat!("Size of: ", stringify!(btrfs_scrub_progress))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_scrub_progress>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_scrub_progress))
    );
    fn test_field_data_extents_scrubbed() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).data_extents_scrubbed) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(data_extents_scrubbed)
            )
        );
    }
    test_field_data_extents_scrubbed();
    fn test_field_tree_extents_scrubbed() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).tree_extents_scrubbed) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(tree_extents_scrubbed)
            )
        );
    }
    test_field_tree_extents_scrubbed();
    fn test_field_data_bytes_scrubbed() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).data_bytes_scrubbed) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(data_bytes_scrubbed)
            )
        );
    }
    test_field_data_bytes_scrubbed();
    fn test_field_tree_bytes_scrubbed() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).tree_bytes_scrubbed) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(tree_bytes_scrubbed)
            )
        );
    }
    test_field_tree_bytes_scrubbed();
    fn test_field_read_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).read_errors) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(read_errors)
            )
        );
    }
    test_field_read_errors();
    fn test_field_csum_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).csum_errors) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(csum_errors)
            )
        );
    }
    test_field_csum_errors();
    fn test_field_verify_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).verify_errors) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(verify_errors)
            )
        );
    }
    test_field_verify_errors();
    fn test_field_no_csum() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).no_csum) as usize - ptr as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(no_csum)
            )
        );
    }
    test_field_no_csum();
    fn test_field_csum_discards() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).csum_discards) as usize - ptr as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(csum_discards)
            )
        );
    }
    test_field_csum_discards();
    fn test_field_super_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).super_errors) as usize - ptr as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(super_errors)
            )
        );
    }
    test_field_super_errors();
    fn test_field_malloc_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).malloc_errors) as usize - ptr as usize
            },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(malloc_errors)
            )
        );
    }
    test_field_malloc_errors();
    fn test_field_uncorrectable_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).uncorrectable_errors) as usize - ptr as usize
            },
            88usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(uncorrectable_errors)
            )
        );
    }
    test_field_uncorrectable_errors();
    fn test_field_corrected_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).corrected_errors) as usize - ptr as usize
            },
            96usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(corrected_errors)
            )
        );
    }
    test_field_corrected_errors();
    fn test_field_last_physical() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).last_physical) as usize - ptr as usize
            },
            104usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(last_physical)
            )
        );
    }
    test_field_last_physical();
    fn test_field_unverified_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_scrub_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unverified_errors) as usize - ptr as usize
            },
            112usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_scrub_progress),
                "::",
                stringify!(unverified_errors)
            )
        );
    }
    test_field_unverified_errors();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_scrub_args {
    pub devid: __u64,
    pub start: __u64,
    pub end: __u64,
    pub flags: __u64,
    pub progress: btrfs_scrub_progress,
    pub unused: [__u64; 109usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_scrub_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_scrub_args>(),
        1024usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_scrub_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_scrub_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_scrub_args))
    );
    fn test_field_devid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_scrub_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_scrub_args),
                "::",
                stringify!(devid)
            )
        );
    }
    test_field_devid();
    fn test_field_start() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_scrub_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_scrub_args),
                "::",
                stringify!(start)
            )
        );
    }
    test_field_start();
    fn test_field_end() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_scrub_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_scrub_args),
                "::",
                stringify!(end)
            )
        );
    }
    test_field_end();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_scrub_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_scrub_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_progress() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_scrub_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).progress) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_scrub_args),
                "::",
                stringify!(progress)
            )
        );
    }
    test_field_progress();
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_scrub_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            152usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_scrub_args),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_dev_replace_start_params {
    pub srcdevid: __u64,
    pub cont_reading_from_srcdev_mode: __u64,
    pub srcdev_name: [__u8; 1025usize],
    pub tgtdev_name: [__u8; 1025usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_dev_replace_start_params() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_dev_replace_start_params>(),
        2072usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_ioctl_dev_replace_start_params)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_dev_replace_start_params>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_ioctl_dev_replace_start_params)
        )
    );
    fn test_field_srcdevid() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_start_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).srcdevid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_start_params),
                "::",
                stringify!(srcdevid)
            )
        );
    }
    test_field_srcdevid();
    fn test_field_cont_reading_from_srcdev_mode() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_start_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).cont_reading_from_srcdev_mode) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_start_params),
                "::",
                stringify!(cont_reading_from_srcdev_mode)
            )
        );
    }
    test_field_cont_reading_from_srcdev_mode();
    fn test_field_srcdev_name() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_start_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).srcdev_name) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_start_params),
                "::",
                stringify!(srcdev_name)
            )
        );
    }
    test_field_srcdev_name();
    fn test_field_tgtdev_name() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_start_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).tgtdev_name) as usize - ptr as usize
            },
            1041usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_start_params),
                "::",
                stringify!(tgtdev_name)
            )
        );
    }
    test_field_tgtdev_name();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_dev_replace_status_params {
    pub replace_state: __u64,
    pub progress_1000: __u64,
    pub time_started: __u64,
    pub time_stopped: __u64,
    pub num_write_errors: __u64,
    pub num_uncorrectable_read_errors: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_dev_replace_status_params() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_dev_replace_status_params>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_ioctl_dev_replace_status_params)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_dev_replace_status_params>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_ioctl_dev_replace_status_params)
        )
    );
    fn test_field_replace_state() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_status_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).replace_state) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_status_params),
                "::",
                stringify!(replace_state)
            )
        );
    }
    test_field_replace_state();
    fn test_field_progress_1000() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_status_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).progress_1000) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_status_params),
                "::",
                stringify!(progress_1000)
            )
        );
    }
    test_field_progress_1000();
    fn test_field_time_started() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_status_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).time_started) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_status_params),
                "::",
                stringify!(time_started)
            )
        );
    }
    test_field_time_started();
    fn test_field_time_stopped() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_status_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).time_stopped) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_status_params),
                "::",
                stringify!(time_stopped)
            )
        );
    }
    test_field_time_stopped();
    fn test_field_num_write_errors() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_status_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_write_errors) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_status_params),
                "::",
                stringify!(num_write_errors)
            )
        );
    }
    test_field_num_write_errors();
    fn test_field_num_uncorrectable_read_errors() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_status_params>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_uncorrectable_read_errors) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_status_params),
                "::",
                stringify!(num_uncorrectable_read_errors)
            )
        );
    }
    test_field_num_uncorrectable_read_errors();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct btrfs_ioctl_dev_replace_args {
    pub cmd: __u64,
    pub result: __u64,
    pub __bindgen_anon_1: btrfs_ioctl_dev_replace_args__bindgen_ty_1,
    pub spare: [__u64; 64usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union btrfs_ioctl_dev_replace_args__bindgen_ty_1 {
    pub start: btrfs_ioctl_dev_replace_start_params,
    pub status: btrfs_ioctl_dev_replace_status_params,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_dev_replace_args__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_dev_replace_args__bindgen_ty_1>(),
        2072usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_ioctl_dev_replace_args__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_dev_replace_args__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_ioctl_dev_replace_args__bindgen_ty_1)
        )
    );
    fn test_field_start() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_args__bindgen_ty_1>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_args__bindgen_ty_1),
                "::",
                stringify!(start)
            )
        );
    }
    test_field_start();
    fn test_field_status() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_args__bindgen_ty_1>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).status) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_args__bindgen_ty_1),
                "::",
                stringify!(status)
            )
        );
    }
    test_field_status();
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_dev_replace_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_dev_replace_args>(),
        2600usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_dev_replace_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_dev_replace_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_dev_replace_args))
    );
    fn test_field_cmd() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).cmd) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_args),
                "::",
                stringify!(cmd)
            )
        );
    }
    test_field_cmd();
    fn test_field_result() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).result) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_args),
                "::",
                stringify!(result)
            )
        );
    }
    test_field_result();
    fn test_field_spare() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_dev_replace_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).spare) as usize - ptr as usize
            },
            2088usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_replace_args),
                "::",
                stringify!(spare)
            )
        );
    }
    test_field_spare();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_dev_info_args {
    pub devid: __u64,
    pub uuid: [__u8; 16usize],
    pub bytes_used: __u64,
    pub total_bytes: __u64,
    pub unused: [__u64; 379usize],
    pub path: [__u8; 1024usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_dev_info_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_dev_info_args>(),
        4096usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_dev_info_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_dev_info_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_dev_info_args))
    );
    fn test_field_devid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_dev_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_info_args),
                "::",
                stringify!(devid)
            )
        );
    }
    test_field_devid();
    fn test_field_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_dev_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).uuid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_info_args),
                "::",
                stringify!(uuid)
            )
        );
    }
    test_field_uuid();
    fn test_field_bytes_used() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_dev_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).bytes_used) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_info_args),
                "::",
                stringify!(bytes_used)
            )
        );
    }
    test_field_bytes_used();
    fn test_field_total_bytes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_dev_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).total_bytes) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_info_args),
                "::",
                stringify!(total_bytes)
            )
        );
    }
    test_field_total_bytes();
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_dev_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_info_args),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
    fn test_field_path() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_dev_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).path) as usize - ptr as usize
            },
            3072usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_dev_info_args),
                "::",
                stringify!(path)
            )
        );
    }
    test_field_path();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_fs_info_args {
    pub max_id: __u64,
    pub num_devices: __u64,
    pub fsid: [__u8; 16usize],
    pub nodesize: __u32,
    pub sectorsize: __u32,
    pub clone_alignment: __u32,
    pub reserved32: __u32,
    pub reserved: [__u64; 122usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_fs_info_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_fs_info_args>(),
        1024usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_fs_info_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_fs_info_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_fs_info_args))
    );
    fn test_field_max_id() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_fs_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).max_id) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_fs_info_args),
                "::",
                stringify!(max_id)
            )
        );
    }
    test_field_max_id();
    fn test_field_num_devices() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_fs_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_devices) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_fs_info_args),
                "::",
                stringify!(num_devices)
            )
        );
    }
    test_field_num_devices();
    fn test_field_fsid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_fs_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).fsid) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_fs_info_args),
                "::",
                stringify!(fsid)
            )
        );
    }
    test_field_fsid();
    fn test_field_nodesize() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_fs_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).nodesize) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_fs_info_args),
                "::",
                stringify!(nodesize)
            )
        );
    }
    test_field_nodesize();
    fn test_field_sectorsize() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_fs_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sectorsize) as usize - ptr as usize
            },
            36usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_fs_info_args),
                "::",
                stringify!(sectorsize)
            )
        );
    }
    test_field_sectorsize();
    fn test_field_clone_alignment() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_fs_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).clone_alignment) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_fs_info_args),
                "::",
                stringify!(clone_alignment)
            )
        );
    }
    test_field_clone_alignment();
    fn test_field_reserved32() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_fs_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved32) as usize - ptr as usize
            },
            44usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_fs_info_args),
                "::",
                stringify!(reserved32)
            )
        );
    }
    test_field_reserved32();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_fs_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_fs_info_args),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_feature_flags {
    pub compat_flags: __u64,
    pub compat_ro_flags: __u64,
    pub incompat_flags: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_feature_flags() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_feature_flags>(),
        24usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_feature_flags))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_feature_flags>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_feature_flags))
    );
    fn test_field_compat_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_feature_flags>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).compat_flags) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_feature_flags),
                "::",
                stringify!(compat_flags)
            )
        );
    }
    test_field_compat_flags();
    fn test_field_compat_ro_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_feature_flags>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).compat_ro_flags) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_feature_flags),
                "::",
                stringify!(compat_ro_flags)
            )
        );
    }
    test_field_compat_ro_flags();
    fn test_field_incompat_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_feature_flags>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).incompat_flags) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_feature_flags),
                "::",
                stringify!(incompat_flags)
            )
        );
    }
    test_field_incompat_flags();
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct btrfs_balance_args {
    pub profiles: __u64,
    pub __bindgen_anon_1: btrfs_balance_args__bindgen_ty_1,
    pub devid: __u64,
    pub pstart: __u64,
    pub pend: __u64,
    pub vstart: __u64,
    pub vend: __u64,
    pub target: __u64,
    pub flags: __u64,
    pub __bindgen_anon_2: btrfs_balance_args__bindgen_ty_2,
    pub stripes_min: __u32,
    pub stripes_max: __u32,
    pub unused: [__u64; 6usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union btrfs_balance_args__bindgen_ty_1 {
    pub usage: __u64,
    pub __bindgen_anon_1: btrfs_balance_args__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_balance_args__bindgen_ty_1__bindgen_ty_1 {
    pub usage_min: __u32,
    pub usage_max: __u32,
}
#[test]
fn bindgen_test_layout_btrfs_balance_args__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_balance_args__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_balance_args__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_balance_args__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_balance_args__bindgen_ty_1__bindgen_ty_1)
        )
    );
    fn test_field_usage_min() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_balance_args__bindgen_ty_1__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).usage_min) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args__bindgen_ty_1__bindgen_ty_1),
                "::",
                stringify!(usage_min)
            )
        );
    }
    test_field_usage_min();
    fn test_field_usage_max() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_balance_args__bindgen_ty_1__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).usage_max) as usize - ptr as usize
            },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args__bindgen_ty_1__bindgen_ty_1),
                "::",
                stringify!(usage_max)
            )
        );
    }
    test_field_usage_max();
}
#[test]
fn bindgen_test_layout_btrfs_balance_args__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_balance_args__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(btrfs_balance_args__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_balance_args__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_balance_args__bindgen_ty_1)
        )
    );
    fn test_field_usage() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args__bindgen_ty_1>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).usage) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args__bindgen_ty_1),
                "::",
                stringify!(usage)
            )
        );
    }
    test_field_usage();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union btrfs_balance_args__bindgen_ty_2 {
    pub limit: __u64,
    pub __bindgen_anon_1: btrfs_balance_args__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_balance_args__bindgen_ty_2__bindgen_ty_1 {
    pub limit_min: __u32,
    pub limit_max: __u32,
}
#[test]
fn bindgen_test_layout_btrfs_balance_args__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_balance_args__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_balance_args__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_balance_args__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_balance_args__bindgen_ty_2__bindgen_ty_1)
        )
    );
    fn test_field_limit_min() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_balance_args__bindgen_ty_2__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).limit_min) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args__bindgen_ty_2__bindgen_ty_1),
                "::",
                stringify!(limit_min)
            )
        );
    }
    test_field_limit_min();
    fn test_field_limit_max() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_balance_args__bindgen_ty_2__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).limit_max) as usize - ptr as usize
            },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args__bindgen_ty_2__bindgen_ty_1),
                "::",
                stringify!(limit_max)
            )
        );
    }
    test_field_limit_max();
}
#[test]
fn bindgen_test_layout_btrfs_balance_args__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_balance_args__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(btrfs_balance_args__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_balance_args__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_balance_args__bindgen_ty_2)
        )
    );
    fn test_field_limit() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args__bindgen_ty_2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).limit) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args__bindgen_ty_2),
                "::",
                stringify!(limit)
            )
        );
    }
    test_field_limit();
}
#[test]
fn bindgen_test_layout_btrfs_balance_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_balance_args>(),
        136usize,
        concat!("Size of: ", stringify!(btrfs_balance_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_balance_args>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_balance_args))
    );
    fn test_field_profiles() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).profiles) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(profiles)
            )
        );
    }
    test_field_profiles();
    fn test_field_devid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(devid)
            )
        );
    }
    test_field_devid();
    fn test_field_pstart() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).pstart) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(pstart)
            )
        );
    }
    test_field_pstart();
    fn test_field_pend() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).pend) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(pend)
            )
        );
    }
    test_field_pend();
    fn test_field_vstart() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).vstart) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(vstart)
            )
        );
    }
    test_field_vstart();
    fn test_field_vend() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).vend) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(vend)
            )
        );
    }
    test_field_vend();
    fn test_field_target() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).target) as usize - ptr as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(target)
            )
        );
    }
    test_field_target();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_stripes_min() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stripes_min) as usize - ptr as usize
            },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(stripes_min)
            )
        );
    }
    test_field_stripes_min();
    fn test_field_stripes_max() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stripes_max) as usize - ptr as usize
            },
            84usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(stripes_max)
            )
        );
    }
    test_field_stripes_max();
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            88usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_args),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_balance_progress {
    pub expected: __u64,
    pub considered: __u64,
    pub completed: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_balance_progress() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_balance_progress>(),
        24usize,
        concat!("Size of: ", stringify!(btrfs_balance_progress))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_balance_progress>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_balance_progress))
    );
    fn test_field_expected() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).expected) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_progress),
                "::",
                stringify!(expected)
            )
        );
    }
    test_field_expected();
    fn test_field_considered() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).considered) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_progress),
                "::",
                stringify!(considered)
            )
        );
    }
    test_field_considered();
    fn test_field_completed() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_progress>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).completed) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_progress),
                "::",
                stringify!(completed)
            )
        );
    }
    test_field_completed();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct btrfs_ioctl_balance_args {
    pub flags: __u64,
    pub state: __u64,
    pub data: btrfs_balance_args,
    pub meta: btrfs_balance_args,
    pub sys: btrfs_balance_args,
    pub stat: btrfs_balance_progress,
    pub unused: [__u64; 72usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_balance_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_balance_args>(),
        1024usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_balance_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_balance_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_balance_args))
    );
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_balance_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_state() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_balance_args),
                "::",
                stringify!(state)
            )
        );
    }
    test_field_state();
    fn test_field_data() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_balance_args),
                "::",
                stringify!(data)
            )
        );
    }
    test_field_data();
    fn test_field_meta() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).meta) as usize - ptr as usize
            },
            152usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_balance_args),
                "::",
                stringify!(meta)
            )
        );
    }
    test_field_meta();
    fn test_field_sys() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sys) as usize - ptr as usize
            },
            288usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_balance_args),
                "::",
                stringify!(sys)
            )
        );
    }
    test_field_sys();
    fn test_field_stat() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stat) as usize - ptr as usize
            },
            424usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_balance_args),
                "::",
                stringify!(stat)
            )
        );
    }
    test_field_stat();
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            448usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_balance_args),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_ino_lookup_args {
    pub treeid: __u64,
    pub objectid: __u64,
    pub name: [::std::os::raw::c_char; 4080usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_ino_lookup_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_ino_lookup_args>(),
        4096usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_ino_lookup_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_ino_lookup_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_ino_lookup_args))
    );
    fn test_field_treeid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_ino_lookup_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).treeid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_ino_lookup_args),
                "::",
                stringify!(treeid)
            )
        );
    }
    test_field_treeid();
    fn test_field_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_ino_lookup_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).objectid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_ino_lookup_args),
                "::",
                stringify!(objectid)
            )
        );
    }
    test_field_objectid();
    fn test_field_name() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_ino_lookup_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_ino_lookup_args),
                "::",
                stringify!(name)
            )
        );
    }
    test_field_name();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_search_key {
    pub tree_id: __u64,
    pub min_objectid: __u64,
    pub max_objectid: __u64,
    pub min_offset: __u64,
    pub max_offset: __u64,
    pub min_transid: __u64,
    pub max_transid: __u64,
    pub min_type: __u32,
    pub max_type: __u32,
    pub nr_items: __u32,
    pub unused: __u32,
    pub unused1: __u64,
    pub unused2: __u64,
    pub unused3: __u64,
    pub unused4: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_search_key() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_search_key>(),
        104usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_search_key))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_search_key>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_search_key))
    );
    fn test_field_tree_id() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).tree_id) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(tree_id)
            )
        );
    }
    test_field_tree_id();
    fn test_field_min_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).min_objectid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(min_objectid)
            )
        );
    }
    test_field_min_objectid();
    fn test_field_max_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).max_objectid) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(max_objectid)
            )
        );
    }
    test_field_max_objectid();
    fn test_field_min_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).min_offset) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(min_offset)
            )
        );
    }
    test_field_min_offset();
    fn test_field_max_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).max_offset) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(max_offset)
            )
        );
    }
    test_field_max_offset();
    fn test_field_min_transid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).min_transid) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(min_transid)
            )
        );
    }
    test_field_min_transid();
    fn test_field_max_transid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).max_transid) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(max_transid)
            )
        );
    }
    test_field_max_transid();
    fn test_field_min_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).min_type) as usize - ptr as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(min_type)
            )
        );
    }
    test_field_min_type();
    fn test_field_max_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).max_type) as usize - ptr as usize
            },
            60usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(max_type)
            )
        );
    }
    test_field_max_type();
    fn test_field_nr_items() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).nr_items) as usize - ptr as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(nr_items)
            )
        );
    }
    test_field_nr_items();
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            68usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
    fn test_field_unused1() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused1) as usize - ptr as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(unused1)
            )
        );
    }
    test_field_unused1();
    fn test_field_unused2() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused2) as usize - ptr as usize
            },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(unused2)
            )
        );
    }
    test_field_unused2();
    fn test_field_unused3() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused3) as usize - ptr as usize
            },
            88usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(unused3)
            )
        );
    }
    test_field_unused3();
    fn test_field_unused4() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused4) as usize - ptr as usize
            },
            96usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_key),
                "::",
                stringify!(unused4)
            )
        );
    }
    test_field_unused4();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_search_header {
    pub transid: __u64,
    pub objectid: __u64,
    pub offset: __u64,
    pub type_: __u32,
    pub len: __u32,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_search_header() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_search_header>(),
        32usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_search_header))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_search_header>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_search_header))
    );
    fn test_field_transid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_header>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).transid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_header),
                "::",
                stringify!(transid)
            )
        );
    }
    test_field_transid();
    fn test_field_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_header>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).objectid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_header),
                "::",
                stringify!(objectid)
            )
        );
    }
    test_field_objectid();
    fn test_field_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_header>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_header),
                "::",
                stringify!(offset)
            )
        );
    }
    test_field_offset();
    fn test_field_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_header>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_header),
                "::",
                stringify!(type_)
            )
        );
    }
    test_field_type();
    fn test_field_len() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_header>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize
            },
            28usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_header),
                "::",
                stringify!(len)
            )
        );
    }
    test_field_len();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_search_args {
    pub key: btrfs_ioctl_search_key,
    pub buf: [::std::os::raw::c_char; 3992usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_search_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_search_args>(),
        4096usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_search_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_search_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_search_args))
    );
    fn test_field_key() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_args),
                "::",
                stringify!(key)
            )
        );
    }
    test_field_key();
    fn test_field_buf() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).buf) as usize - ptr as usize
            },
            104usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_args),
                "::",
                stringify!(buf)
            )
        );
    }
    test_field_buf();
}
#[repr(C)]
#[derive(Debug)]
pub struct btrfs_ioctl_search_args_v2 {
    pub key: btrfs_ioctl_search_key,
    pub buf_size: __u64,
    pub buf: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_search_args_v2() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_search_args_v2>(),
        112usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_search_args_v2))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_search_args_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_search_args_v2))
    );
    fn test_field_key() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_args_v2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_args_v2),
                "::",
                stringify!(key)
            )
        );
    }
    test_field_key();
    fn test_field_buf_size() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_args_v2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).buf_size) as usize - ptr as usize
            },
            104usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_args_v2),
                "::",
                stringify!(buf_size)
            )
        );
    }
    test_field_buf_size();
    fn test_field_buf() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_search_args_v2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).buf) as usize - ptr as usize
            },
            112usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_search_args_v2),
                "::",
                stringify!(buf)
            )
        );
    }
    test_field_buf();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_clone_range_args {
    pub src_fd: __s64,
    pub src_offset: __u64,
    pub src_length: __u64,
    pub dest_offset: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_clone_range_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_clone_range_args>(),
        32usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_clone_range_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_clone_range_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_clone_range_args))
    );
    fn test_field_src_fd() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_clone_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).src_fd) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_clone_range_args),
                "::",
                stringify!(src_fd)
            )
        );
    }
    test_field_src_fd();
    fn test_field_src_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_clone_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).src_offset) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_clone_range_args),
                "::",
                stringify!(src_offset)
            )
        );
    }
    test_field_src_offset();
    fn test_field_src_length() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_clone_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).src_length) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_clone_range_args),
                "::",
                stringify!(src_length)
            )
        );
    }
    test_field_src_length();
    fn test_field_dest_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_clone_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).dest_offset) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_clone_range_args),
                "::",
                stringify!(dest_offset)
            )
        );
    }
    test_field_dest_offset();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_defrag_range_args {
    pub start: __u64,
    pub len: __u64,
    pub flags: __u64,
    pub extent_thresh: __u32,
    pub compress_type: __u32,
    pub unused: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_defrag_range_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_defrag_range_args>(),
        48usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_defrag_range_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_defrag_range_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_defrag_range_args))
    );
    fn test_field_start() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_defrag_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_defrag_range_args),
                "::",
                stringify!(start)
            )
        );
    }
    test_field_start();
    fn test_field_len() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_defrag_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_defrag_range_args),
                "::",
                stringify!(len)
            )
        );
    }
    test_field_len();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_defrag_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_defrag_range_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_extent_thresh() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_defrag_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).extent_thresh) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_defrag_range_args),
                "::",
                stringify!(extent_thresh)
            )
        );
    }
    test_field_extent_thresh();
    fn test_field_compress_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_defrag_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).compress_type) as usize - ptr as usize
            },
            28usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_defrag_range_args),
                "::",
                stringify!(compress_type)
            )
        );
    }
    test_field_compress_type();
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_defrag_range_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_defrag_range_args),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_same_extent_info {
    pub fd: __s64,
    pub logical_offset: __u64,
    pub bytes_deduped: __u64,
    pub status: __s32,
    pub reserved: __u32,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_same_extent_info() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_same_extent_info>(),
        32usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_same_extent_info))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_same_extent_info>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_same_extent_info))
    );
    fn test_field_fd() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_extent_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_extent_info),
                "::",
                stringify!(fd)
            )
        );
    }
    test_field_fd();
    fn test_field_logical_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_extent_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).logical_offset) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_extent_info),
                "::",
                stringify!(logical_offset)
            )
        );
    }
    test_field_logical_offset();
    fn test_field_bytes_deduped() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_extent_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).bytes_deduped) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_extent_info),
                "::",
                stringify!(bytes_deduped)
            )
        );
    }
    test_field_bytes_deduped();
    fn test_field_status() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_extent_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).status) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_extent_info),
                "::",
                stringify!(status)
            )
        );
    }
    test_field_status();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_extent_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            28usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_extent_info),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
}
#[repr(C)]
#[derive(Debug)]
pub struct btrfs_ioctl_same_args {
    pub logical_offset: __u64,
    pub length: __u64,
    pub dest_count: __u16,
    pub reserved1: __u16,
    pub reserved2: __u32,
    pub info: __IncompleteArrayField<btrfs_ioctl_same_extent_info>,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_same_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_same_args>(),
        24usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_same_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_same_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_same_args))
    );
    fn test_field_logical_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).logical_offset) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_args),
                "::",
                stringify!(logical_offset)
            )
        );
    }
    test_field_logical_offset();
    fn test_field_length() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_args),
                "::",
                stringify!(length)
            )
        );
    }
    test_field_length();
    fn test_field_dest_count() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).dest_count) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_args),
                "::",
                stringify!(dest_count)
            )
        );
    }
    test_field_dest_count();
    fn test_field_reserved1() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize
            },
            18usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_args),
                "::",
                stringify!(reserved1)
            )
        );
    }
    test_field_reserved1();
    fn test_field_reserved2() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize
            },
            20usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_args),
                "::",
                stringify!(reserved2)
            )
        );
    }
    test_field_reserved2();
    fn test_field_info() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_same_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).info) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_same_args),
                "::",
                stringify!(info)
            )
        );
    }
    test_field_info();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_space_info {
    pub flags: __u64,
    pub total_bytes: __u64,
    pub used_bytes: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_space_info() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_space_info>(),
        24usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_space_info))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_space_info>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_space_info))
    );
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_space_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_space_info),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_total_bytes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_space_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).total_bytes) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_space_info),
                "::",
                stringify!(total_bytes)
            )
        );
    }
    test_field_total_bytes();
    fn test_field_used_bytes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_space_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).used_bytes) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_space_info),
                "::",
                stringify!(used_bytes)
            )
        );
    }
    test_field_used_bytes();
}
#[repr(C)]
#[derive(Debug)]
pub struct btrfs_ioctl_space_args {
    pub space_slots: __u64,
    pub total_spaces: __u64,
    pub spaces: __IncompleteArrayField<btrfs_ioctl_space_info>,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_space_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_space_args>(),
        16usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_space_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_space_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_space_args))
    );
    fn test_field_space_slots() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_space_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).space_slots) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_space_args),
                "::",
                stringify!(space_slots)
            )
        );
    }
    test_field_space_slots();
    fn test_field_total_spaces() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_space_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).total_spaces) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_space_args),
                "::",
                stringify!(total_spaces)
            )
        );
    }
    test_field_total_spaces();
    fn test_field_spaces() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_space_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).spaces) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_space_args),
                "::",
                stringify!(spaces)
            )
        );
    }
    test_field_spaces();
}
#[repr(C)]
#[derive(Debug)]
pub struct btrfs_data_container {
    pub bytes_left: __u32,
    pub bytes_missing: __u32,
    pub elem_cnt: __u32,
    pub elem_missed: __u32,
    pub val: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_btrfs_data_container() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_data_container>(),
        16usize,
        concat!("Size of: ", stringify!(btrfs_data_container))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_data_container>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_data_container))
    );
    fn test_field_bytes_left() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_data_container>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).bytes_left) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_data_container),
                "::",
                stringify!(bytes_left)
            )
        );
    }
    test_field_bytes_left();
    fn test_field_bytes_missing() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_data_container>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).bytes_missing) as usize - ptr as usize
            },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_data_container),
                "::",
                stringify!(bytes_missing)
            )
        );
    }
    test_field_bytes_missing();
    fn test_field_elem_cnt() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_data_container>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).elem_cnt) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_data_container),
                "::",
                stringify!(elem_cnt)
            )
        );
    }
    test_field_elem_cnt();
    fn test_field_elem_missed() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_data_container>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).elem_missed) as usize - ptr as usize
            },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_data_container),
                "::",
                stringify!(elem_missed)
            )
        );
    }
    test_field_elem_missed();
    fn test_field_val() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_data_container>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).val) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_data_container),
                "::",
                stringify!(val)
            )
        );
    }
    test_field_val();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_ino_path_args {
    pub inum: __u64,
    pub size: __u64,
    pub reserved: [__u64; 4usize],
    pub fspath: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_ino_path_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_ino_path_args>(),
        56usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_ino_path_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_ino_path_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_ino_path_args))
    );
    fn test_field_inum() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_ino_path_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).inum) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_ino_path_args),
                "::",
                stringify!(inum)
            )
        );
    }
    test_field_inum();
    fn test_field_size() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_ino_path_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_ino_path_args),
                "::",
                stringify!(size)
            )
        );
    }
    test_field_size();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_ino_path_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_ino_path_args),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
    fn test_field_fspath() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_ino_path_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).fspath) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_ino_path_args),
                "::",
                stringify!(fspath)
            )
        );
    }
    test_field_fspath();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_logical_ino_args {
    pub logical: __u64,
    pub size: __u64,
    pub reserved: [__u64; 3usize],
    pub flags: __u64,
    pub inodes: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_logical_ino_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_logical_ino_args>(),
        56usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_logical_ino_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_logical_ino_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_logical_ino_args))
    );
    fn test_field_logical() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_logical_ino_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).logical) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_logical_ino_args),
                "::",
                stringify!(logical)
            )
        );
    }
    test_field_logical();
    fn test_field_size() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_logical_ino_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_logical_ino_args),
                "::",
                stringify!(size)
            )
        );
    }
    test_field_size();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_logical_ino_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_logical_ino_args),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_logical_ino_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_logical_ino_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_inodes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_logical_ino_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).inodes) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_logical_ino_args),
                "::",
                stringify!(inodes)
            )
        );
    }
    test_field_inodes();
}
pub const btrfs_dev_stat_values_BTRFS_DEV_STAT_WRITE_ERRS: btrfs_dev_stat_values = 0;
pub const btrfs_dev_stat_values_BTRFS_DEV_STAT_READ_ERRS: btrfs_dev_stat_values = 1;
pub const btrfs_dev_stat_values_BTRFS_DEV_STAT_FLUSH_ERRS: btrfs_dev_stat_values = 2;
pub const btrfs_dev_stat_values_BTRFS_DEV_STAT_CORRUPTION_ERRS: btrfs_dev_stat_values = 3;
pub const btrfs_dev_stat_values_BTRFS_DEV_STAT_GENERATION_ERRS: btrfs_dev_stat_values = 4;
pub const btrfs_dev_stat_values_BTRFS_DEV_STAT_VALUES_MAX: btrfs_dev_stat_values = 5;
pub type btrfs_dev_stat_values = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_get_dev_stats {
    pub devid: __u64,
    pub nr_items: __u64,
    pub flags: __u64,
    pub values: [__u64; 5usize],
    pub unused: [__u64; 121usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_get_dev_stats() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_get_dev_stats>(),
        1032usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_get_dev_stats))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_get_dev_stats>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_get_dev_stats))
    );
    fn test_field_devid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_dev_stats>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_dev_stats),
                "::",
                stringify!(devid)
            )
        );
    }
    test_field_devid();
    fn test_field_nr_items() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_dev_stats>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).nr_items) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_dev_stats),
                "::",
                stringify!(nr_items)
            )
        );
    }
    test_field_nr_items();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_dev_stats>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_dev_stats),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_values() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_dev_stats>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).values) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_dev_stats),
                "::",
                stringify!(values)
            )
        );
    }
    test_field_values();
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_dev_stats>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_dev_stats),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_quota_ctl_args {
    pub cmd: __u64,
    pub status: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_quota_ctl_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_quota_ctl_args>(),
        16usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_quota_ctl_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_quota_ctl_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_quota_ctl_args))
    );
    fn test_field_cmd() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_quota_ctl_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).cmd) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_quota_ctl_args),
                "::",
                stringify!(cmd)
            )
        );
    }
    test_field_cmd();
    fn test_field_status() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_quota_ctl_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).status) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_quota_ctl_args),
                "::",
                stringify!(status)
            )
        );
    }
    test_field_status();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_quota_rescan_args {
    pub flags: __u64,
    pub progress: __u64,
    pub reserved: [__u64; 6usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_quota_rescan_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_quota_rescan_args>(),
        64usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_quota_rescan_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_quota_rescan_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_quota_rescan_args))
    );
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_quota_rescan_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_quota_rescan_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_progress() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_quota_rescan_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).progress) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_quota_rescan_args),
                "::",
                stringify!(progress)
            )
        );
    }
    test_field_progress();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_quota_rescan_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_quota_rescan_args),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_qgroup_assign_args {
    pub assign: __u64,
    pub src: __u64,
    pub dst: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_qgroup_assign_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_qgroup_assign_args>(),
        24usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_qgroup_assign_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_qgroup_assign_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_qgroup_assign_args))
    );
    fn test_field_assign() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_qgroup_assign_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).assign) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_qgroup_assign_args),
                "::",
                stringify!(assign)
            )
        );
    }
    test_field_assign();
    fn test_field_src() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_qgroup_assign_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).src) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_qgroup_assign_args),
                "::",
                stringify!(src)
            )
        );
    }
    test_field_src();
    fn test_field_dst() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_qgroup_assign_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).dst) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_qgroup_assign_args),
                "::",
                stringify!(dst)
            )
        );
    }
    test_field_dst();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_qgroup_create_args {
    pub create: __u64,
    pub qgroupid: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_qgroup_create_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_qgroup_create_args>(),
        16usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_qgroup_create_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_qgroup_create_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_qgroup_create_args))
    );
    fn test_field_create() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_qgroup_create_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).create) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_qgroup_create_args),
                "::",
                stringify!(create)
            )
        );
    }
    test_field_create();
    fn test_field_qgroupid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_qgroup_create_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).qgroupid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_qgroup_create_args),
                "::",
                stringify!(qgroupid)
            )
        );
    }
    test_field_qgroupid();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_timespec {
    pub sec: __u64,
    pub nsec: __u32,
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_timespec() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_timespec>(),
        16usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_timespec))
    );
    fn test_field_sec() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_timespec>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sec) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_timespec),
                "::",
                stringify!(sec)
            )
        );
    }
    test_field_sec();
    fn test_field_nsec() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_timespec>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).nsec) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_timespec),
                "::",
                stringify!(nsec)
            )
        );
    }
    test_field_nsec();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_received_subvol_args {
    pub uuid: [::std::os::raw::c_char; 16usize],
    pub stransid: __u64,
    pub rtransid: __u64,
    pub stime: btrfs_ioctl_timespec,
    pub rtime: btrfs_ioctl_timespec,
    pub flags: __u64,
    pub reserved: [__u64; 16usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_received_subvol_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_received_subvol_args>(),
        200usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_received_subvol_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_received_subvol_args>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_ioctl_received_subvol_args)
        )
    );
    fn test_field_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_received_subvol_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).uuid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_received_subvol_args),
                "::",
                stringify!(uuid)
            )
        );
    }
    test_field_uuid();
    fn test_field_stransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_received_subvol_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stransid) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_received_subvol_args),
                "::",
                stringify!(stransid)
            )
        );
    }
    test_field_stransid();
    fn test_field_rtransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_received_subvol_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rtransid) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_received_subvol_args),
                "::",
                stringify!(rtransid)
            )
        );
    }
    test_field_rtransid();
    fn test_field_stime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_received_subvol_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stime) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_received_subvol_args),
                "::",
                stringify!(stime)
            )
        );
    }
    test_field_stime();
    fn test_field_rtime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_received_subvol_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rtime) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_received_subvol_args),
                "::",
                stringify!(rtime)
            )
        );
    }
    test_field_rtime();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_received_subvol_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_received_subvol_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_received_subvol_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_received_subvol_args),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_send_args {
    pub send_fd: __s64,
    pub clone_sources_count: __u64,
    pub clone_sources: *mut __u64,
    pub parent_root: __u64,
    pub flags: __u64,
    pub reserved: [__u64; 4usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_send_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_send_args>(),
        72usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_send_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_send_args>(),
        8usize,
        concat!("Alignment of ", stringify!(btrfs_ioctl_send_args))
    );
    fn test_field_send_fd() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_send_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).send_fd) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_send_args),
                "::",
                stringify!(send_fd)
            )
        );
    }
    test_field_send_fd();
    fn test_field_clone_sources_count() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_send_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).clone_sources_count) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_send_args),
                "::",
                stringify!(clone_sources_count)
            )
        );
    }
    test_field_clone_sources_count();
    fn test_field_clone_sources() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_send_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).clone_sources) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_send_args),
                "::",
                stringify!(clone_sources)
            )
        );
    }
    test_field_clone_sources();
    fn test_field_parent_root() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_send_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).parent_root) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_send_args),
                "::",
                stringify!(parent_root)
            )
        );
    }
    test_field_parent_root();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_send_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_send_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_send_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_send_args),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_ioctl_get_subvol_info_args {
    pub treeid: __u64,
    pub name: [::std::os::raw::c_char; 256usize],
    pub parent_id: __u64,
    pub dirid: __u64,
    pub generation: __u64,
    pub flags: __u64,
    pub uuid: [__u8; 16usize],
    pub parent_uuid: [__u8; 16usize],
    pub received_uuid: [__u8; 16usize],
    pub ctransid: __u64,
    pub otransid: __u64,
    pub stransid: __u64,
    pub rtransid: __u64,
    pub ctime: btrfs_ioctl_timespec,
    pub otime: btrfs_ioctl_timespec,
    pub stime: btrfs_ioctl_timespec,
    pub rtime: btrfs_ioctl_timespec,
    pub reserved: [__u64; 8usize],
}
#[test]
fn bindgen_test_layout_btrfs_ioctl_get_subvol_info_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_ioctl_get_subvol_info_args>(),
        504usize,
        concat!("Size of: ", stringify!(btrfs_ioctl_get_subvol_info_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_ioctl_get_subvol_info_args>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_ioctl_get_subvol_info_args)
        )
    );
    fn test_field_treeid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).treeid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(treeid)
            )
        );
    }
    test_field_treeid();
    fn test_field_name() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(name)
            )
        );
    }
    test_field_name();
    fn test_field_parent_id() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).parent_id) as usize - ptr as usize
            },
            264usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(parent_id)
            )
        );
    }
    test_field_parent_id();
    fn test_field_dirid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).dirid) as usize - ptr as usize
            },
            272usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(dirid)
            )
        );
    }
    test_field_dirid();
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            280usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            288usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).uuid) as usize - ptr as usize
            },
            296usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(uuid)
            )
        );
    }
    test_field_uuid();
    fn test_field_parent_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).parent_uuid) as usize - ptr as usize
            },
            312usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(parent_uuid)
            )
        );
    }
    test_field_parent_uuid();
    fn test_field_received_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).received_uuid) as usize - ptr as usize
            },
            328usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(received_uuid)
            )
        );
    }
    test_field_received_uuid();
    fn test_field_ctransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).ctransid) as usize - ptr as usize
            },
            344usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(ctransid)
            )
        );
    }
    test_field_ctransid();
    fn test_field_otransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).otransid) as usize - ptr as usize
            },
            352usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(otransid)
            )
        );
    }
    test_field_otransid();
    fn test_field_stransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stransid) as usize - ptr as usize
            },
            360usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(stransid)
            )
        );
    }
    test_field_stransid();
    fn test_field_rtransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rtransid) as usize - ptr as usize
            },
            368usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(rtransid)
            )
        );
    }
    test_field_rtransid();
    fn test_field_ctime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).ctime) as usize - ptr as usize
            },
            376usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(ctime)
            )
        );
    }
    test_field_ctime();
    fn test_field_otime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).otime) as usize - ptr as usize
            },
            392usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(otime)
            )
        );
    }
    test_field_otime();
    fn test_field_stime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stime) as usize - ptr as usize
            },
            408usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(stime)
            )
        );
    }
    test_field_stime();
    fn test_field_rtime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rtime) as usize - ptr as usize
            },
            424usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(rtime)
            )
        );
    }
    test_field_rtime();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_ioctl_get_subvol_info_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            440usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_ioctl_get_subvol_info_args),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
}
pub const btrfs_err_code_BTRFS_ERROR_DEV_RAID1_MIN_NOT_MET: btrfs_err_code = 1;
pub const btrfs_err_code_BTRFS_ERROR_DEV_RAID10_MIN_NOT_MET: btrfs_err_code = 2;
pub const btrfs_err_code_BTRFS_ERROR_DEV_RAID5_MIN_NOT_MET: btrfs_err_code = 3;
pub const btrfs_err_code_BTRFS_ERROR_DEV_RAID6_MIN_NOT_MET: btrfs_err_code = 4;
pub const btrfs_err_code_BTRFS_ERROR_DEV_TGT_REPLACE: btrfs_err_code = 5;
pub const btrfs_err_code_BTRFS_ERROR_DEV_MISSING_NOT_FOUND: btrfs_err_code = 6;
pub const btrfs_err_code_BTRFS_ERROR_DEV_ONLY_WRITABLE: btrfs_err_code = 7;
pub const btrfs_err_code_BTRFS_ERROR_DEV_EXCL_RUN_IN_PROGRESS: btrfs_err_code = 8;
pub type btrfs_err_code = ::std::os::raw::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_disk_key {
    pub objectid: __le64,
    pub type_: __u8,
    pub offset: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_disk_key() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_disk_key>(),
        17usize,
        concat!("Size of: ", stringify!(btrfs_disk_key))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_disk_key>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_disk_key))
    );
    fn test_field_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).objectid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_key),
                "::",
                stringify!(objectid)
            )
        );
    }
    test_field_objectid();
    fn test_field_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_key),
                "::",
                stringify!(type_)
            )
        );
    }
    test_field_type();
    fn test_field_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize
            },
            9usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_key),
                "::",
                stringify!(offset)
            )
        );
    }
    test_field_offset();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_key {
    pub objectid: __u64,
    pub type_: __u8,
    pub offset: __u64,
}
#[test]
fn bindgen_test_layout_btrfs_key() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_key>(),
        17usize,
        concat!("Size of: ", stringify!(btrfs_key))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_key>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_key))
    );
    fn test_field_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).objectid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_key),
                "::",
                stringify!(objectid)
            )
        );
    }
    test_field_objectid();
    fn test_field_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_key),
                "::",
                stringify!(type_)
            )
        );
    }
    test_field_type();
    fn test_field_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_key>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize
            },
            9usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_key),
                "::",
                stringify!(offset)
            )
        );
    }
    test_field_offset();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_dev_item {
    pub devid: __le64,
    pub total_bytes: __le64,
    pub bytes_used: __le64,
    pub io_align: __le32,
    pub io_width: __le32,
    pub sector_size: __le32,
    pub type_: __le64,
    pub generation: __le64,
    pub start_offset: __le64,
    pub dev_group: __le32,
    pub seek_speed: __u8,
    pub bandwidth: __u8,
    pub uuid: [__u8; 16usize],
    pub fsid: [__u8; 16usize],
}
#[test]
fn bindgen_test_layout_btrfs_dev_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_dev_item>(),
        98usize,
        concat!("Size of: ", stringify!(btrfs_dev_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_dev_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_dev_item))
    );
    fn test_field_devid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(devid)
            )
        );
    }
    test_field_devid();
    fn test_field_total_bytes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).total_bytes) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(total_bytes)
            )
        );
    }
    test_field_total_bytes();
    fn test_field_bytes_used() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).bytes_used) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(bytes_used)
            )
        );
    }
    test_field_bytes_used();
    fn test_field_io_align() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).io_align) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(io_align)
            )
        );
    }
    test_field_io_align();
    fn test_field_io_width() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).io_width) as usize - ptr as usize
            },
            28usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(io_width)
            )
        );
    }
    test_field_io_width();
    fn test_field_sector_size() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sector_size) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(sector_size)
            )
        );
    }
    test_field_sector_size();
    fn test_field_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize
            },
            36usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(type_)
            )
        );
    }
    test_field_type();
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            44usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_start_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).start_offset) as usize - ptr as usize
            },
            52usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(start_offset)
            )
        );
    }
    test_field_start_offset();
    fn test_field_dev_group() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).dev_group) as usize - ptr as usize
            },
            60usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(dev_group)
            )
        );
    }
    test_field_dev_group();
    fn test_field_seek_speed() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).seek_speed) as usize - ptr as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(seek_speed)
            )
        );
    }
    test_field_seek_speed();
    fn test_field_bandwidth() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).bandwidth) as usize - ptr as usize
            },
            65usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(bandwidth)
            )
        );
    }
    test_field_bandwidth();
    fn test_field_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).uuid) as usize - ptr as usize
            },
            66usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(uuid)
            )
        );
    }
    test_field_uuid();
    fn test_field_fsid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).fsid) as usize - ptr as usize
            },
            82usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_item),
                "::",
                stringify!(fsid)
            )
        );
    }
    test_field_fsid();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_stripe {
    pub devid: __le64,
    pub offset: __le64,
    pub dev_uuid: [__u8; 16usize],
}
#[test]
fn bindgen_test_layout_btrfs_stripe() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_stripe>(),
        32usize,
        concat!("Size of: ", stringify!(btrfs_stripe))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_stripe>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_stripe))
    );
    fn test_field_devid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_stripe>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_stripe),
                "::",
                stringify!(devid)
            )
        );
    }
    test_field_devid();
    fn test_field_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_stripe>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_stripe),
                "::",
                stringify!(offset)
            )
        );
    }
    test_field_offset();
    fn test_field_dev_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_stripe>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).dev_uuid) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_stripe),
                "::",
                stringify!(dev_uuid)
            )
        );
    }
    test_field_dev_uuid();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_chunk {
    pub length: __le64,
    pub owner: __le64,
    pub stripe_len: __le64,
    pub type_: __le64,
    pub io_align: __le32,
    pub io_width: __le32,
    pub sector_size: __le32,
    pub num_stripes: __le16,
    pub sub_stripes: __le16,
    pub stripe: btrfs_stripe,
}
#[test]
fn bindgen_test_layout_btrfs_chunk() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_chunk>(),
        80usize,
        concat!("Size of: ", stringify!(btrfs_chunk))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_chunk>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_chunk))
    );
    fn test_field_length() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(length)
            )
        );
    }
    test_field_length();
    fn test_field_owner() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).owner) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(owner)
            )
        );
    }
    test_field_owner();
    fn test_field_stripe_len() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stripe_len) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(stripe_len)
            )
        );
    }
    test_field_stripe_len();
    fn test_field_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(type_)
            )
        );
    }
    test_field_type();
    fn test_field_io_align() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).io_align) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(io_align)
            )
        );
    }
    test_field_io_align();
    fn test_field_io_width() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).io_width) as usize - ptr as usize
            },
            36usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(io_width)
            )
        );
    }
    test_field_io_width();
    fn test_field_sector_size() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sector_size) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(sector_size)
            )
        );
    }
    test_field_sector_size();
    fn test_field_num_stripes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_stripes) as usize - ptr as usize
            },
            44usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(num_stripes)
            )
        );
    }
    test_field_num_stripes();
    fn test_field_sub_stripes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sub_stripes) as usize - ptr as usize
            },
            46usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(sub_stripes)
            )
        );
    }
    test_field_sub_stripes();
    fn test_field_stripe() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_chunk>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stripe) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_chunk),
                "::",
                stringify!(stripe)
            )
        );
    }
    test_field_stripe();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_free_space_entry {
    pub offset: __le64,
    pub bytes: __le64,
    pub type_: __u8,
}
#[test]
fn bindgen_test_layout_btrfs_free_space_entry() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_free_space_entry>(),
        17usize,
        concat!("Size of: ", stringify!(btrfs_free_space_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_free_space_entry>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_free_space_entry))
    );
    fn test_field_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_free_space_entry>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_free_space_entry),
                "::",
                stringify!(offset)
            )
        );
    }
    test_field_offset();
    fn test_field_bytes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_free_space_entry>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).bytes) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_free_space_entry),
                "::",
                stringify!(bytes)
            )
        );
    }
    test_field_bytes();
    fn test_field_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_free_space_entry>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_free_space_entry),
                "::",
                stringify!(type_)
            )
        );
    }
    test_field_type();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_free_space_header {
    pub location: btrfs_disk_key,
    pub generation: __le64,
    pub num_entries: __le64,
    pub num_bitmaps: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_free_space_header() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_free_space_header>(),
        41usize,
        concat!("Size of: ", stringify!(btrfs_free_space_header))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_free_space_header>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_free_space_header))
    );
    fn test_field_location() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_free_space_header>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).location) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_free_space_header),
                "::",
                stringify!(location)
            )
        );
    }
    test_field_location();
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_free_space_header>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            17usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_free_space_header),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_num_entries() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_free_space_header>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_entries) as usize - ptr as usize
            },
            25usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_free_space_header),
                "::",
                stringify!(num_entries)
            )
        );
    }
    test_field_num_entries();
    fn test_field_num_bitmaps() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_free_space_header>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_bitmaps) as usize - ptr as usize
            },
            33usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_free_space_header),
                "::",
                stringify!(num_bitmaps)
            )
        );
    }
    test_field_num_bitmaps();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_extent_item {
    pub refs: __le64,
    pub generation: __le64,
    pub flags: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_extent_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_extent_item>(),
        24usize,
        concat!("Size of: ", stringify!(btrfs_extent_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_extent_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_extent_item))
    );
    fn test_field_refs() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).refs) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_item),
                "::",
                stringify!(refs)
            )
        );
    }
    test_field_refs();
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_item),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_item),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_extent_item_v0 {
    pub refs: __le32,
}
#[test]
fn bindgen_test_layout_btrfs_extent_item_v0() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_extent_item_v0>(),
        4usize,
        concat!("Size of: ", stringify!(btrfs_extent_item_v0))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_extent_item_v0>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_extent_item_v0))
    );
    fn test_field_refs() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_item_v0>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).refs) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_item_v0),
                "::",
                stringify!(refs)
            )
        );
    }
    test_field_refs();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_tree_block_info {
    pub key: btrfs_disk_key,
    pub level: __u8,
}
#[test]
fn bindgen_test_layout_btrfs_tree_block_info() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_tree_block_info>(),
        18usize,
        concat!("Size of: ", stringify!(btrfs_tree_block_info))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_tree_block_info>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_tree_block_info))
    );
    fn test_field_key() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_tree_block_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_tree_block_info),
                "::",
                stringify!(key)
            )
        );
    }
    test_field_key();
    fn test_field_level() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_tree_block_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize
            },
            17usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_tree_block_info),
                "::",
                stringify!(level)
            )
        );
    }
    test_field_level();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_extent_data_ref {
    pub root: __le64,
    pub objectid: __le64,
    pub offset: __le64,
    pub count: __le32,
}
#[test]
fn bindgen_test_layout_btrfs_extent_data_ref() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_extent_data_ref>(),
        28usize,
        concat!("Size of: ", stringify!(btrfs_extent_data_ref))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_extent_data_ref>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_extent_data_ref))
    );
    fn test_field_root() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_data_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).root) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_data_ref),
                "::",
                stringify!(root)
            )
        );
    }
    test_field_root();
    fn test_field_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_data_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).objectid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_data_ref),
                "::",
                stringify!(objectid)
            )
        );
    }
    test_field_objectid();
    fn test_field_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_data_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_data_ref),
                "::",
                stringify!(offset)
            )
        );
    }
    test_field_offset();
    fn test_field_count() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_data_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_data_ref),
                "::",
                stringify!(count)
            )
        );
    }
    test_field_count();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_shared_data_ref {
    pub count: __le32,
}
#[test]
fn bindgen_test_layout_btrfs_shared_data_ref() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_shared_data_ref>(),
        4usize,
        concat!("Size of: ", stringify!(btrfs_shared_data_ref))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_shared_data_ref>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_shared_data_ref))
    );
    fn test_field_count() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_shared_data_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_shared_data_ref),
                "::",
                stringify!(count)
            )
        );
    }
    test_field_count();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_extent_inline_ref {
    pub type_: __u8,
    pub offset: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_extent_inline_ref() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_extent_inline_ref>(),
        9usize,
        concat!("Size of: ", stringify!(btrfs_extent_inline_ref))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_extent_inline_ref>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_extent_inline_ref))
    );
    fn test_field_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_inline_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_inline_ref),
                "::",
                stringify!(type_)
            )
        );
    }
    test_field_type();
    fn test_field_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_inline_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize
            },
            1usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_inline_ref),
                "::",
                stringify!(offset)
            )
        );
    }
    test_field_offset();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_extent_ref_v0 {
    pub root: __le64,
    pub generation: __le64,
    pub objectid: __le64,
    pub count: __le32,
}
#[test]
fn bindgen_test_layout_btrfs_extent_ref_v0() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_extent_ref_v0>(),
        28usize,
        concat!("Size of: ", stringify!(btrfs_extent_ref_v0))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_extent_ref_v0>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_extent_ref_v0))
    );
    fn test_field_root() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_ref_v0>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).root) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_ref_v0),
                "::",
                stringify!(root)
            )
        );
    }
    test_field_root();
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_ref_v0>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_ref_v0),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_ref_v0>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).objectid) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_ref_v0),
                "::",
                stringify!(objectid)
            )
        );
    }
    test_field_objectid();
    fn test_field_count() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_extent_ref_v0>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_extent_ref_v0),
                "::",
                stringify!(count)
            )
        );
    }
    test_field_count();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_dev_extent {
    pub chunk_tree: __le64,
    pub chunk_objectid: __le64,
    pub chunk_offset: __le64,
    pub length: __le64,
    pub chunk_tree_uuid: [__u8; 16usize],
}
#[test]
fn bindgen_test_layout_btrfs_dev_extent() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_dev_extent>(),
        48usize,
        concat!("Size of: ", stringify!(btrfs_dev_extent))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_dev_extent>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_dev_extent))
    );
    fn test_field_chunk_tree() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_extent>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).chunk_tree) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_extent),
                "::",
                stringify!(chunk_tree)
            )
        );
    }
    test_field_chunk_tree();
    fn test_field_chunk_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_extent>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).chunk_objectid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_extent),
                "::",
                stringify!(chunk_objectid)
            )
        );
    }
    test_field_chunk_objectid();
    fn test_field_chunk_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_extent>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).chunk_offset) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_extent),
                "::",
                stringify!(chunk_offset)
            )
        );
    }
    test_field_chunk_offset();
    fn test_field_length() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_extent>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_extent),
                "::",
                stringify!(length)
            )
        );
    }
    test_field_length();
    fn test_field_chunk_tree_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_extent>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).chunk_tree_uuid) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_extent),
                "::",
                stringify!(chunk_tree_uuid)
            )
        );
    }
    test_field_chunk_tree_uuid();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_inode_ref {
    pub index: __le64,
    pub name_len: __le16,
}
#[test]
fn bindgen_test_layout_btrfs_inode_ref() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_inode_ref>(),
        10usize,
        concat!("Size of: ", stringify!(btrfs_inode_ref))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_inode_ref>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_inode_ref))
    );
    fn test_field_index() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_ref),
                "::",
                stringify!(index)
            )
        );
    }
    test_field_index();
    fn test_field_name_len() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).name_len) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_ref),
                "::",
                stringify!(name_len)
            )
        );
    }
    test_field_name_len();
}
#[repr(C, packed)]
pub struct btrfs_inode_extref {
    pub parent_objectid: __le64,
    pub index: __le64,
    pub name_len: __le16,
    pub name: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_btrfs_inode_extref() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_inode_extref>(),
        18usize,
        concat!("Size of: ", stringify!(btrfs_inode_extref))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_inode_extref>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_inode_extref))
    );
    fn test_field_parent_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_extref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).parent_objectid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_extref),
                "::",
                stringify!(parent_objectid)
            )
        );
    }
    test_field_parent_objectid();
    fn test_field_index() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_extref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_extref),
                "::",
                stringify!(index)
            )
        );
    }
    test_field_index();
    fn test_field_name_len() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_extref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).name_len) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_extref),
                "::",
                stringify!(name_len)
            )
        );
    }
    test_field_name_len();
    fn test_field_name() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_extref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize
            },
            18usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_extref),
                "::",
                stringify!(name)
            )
        );
    }
    test_field_name();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_timespec {
    pub sec: __le64,
    pub nsec: __le32,
}
#[test]
fn bindgen_test_layout_btrfs_timespec() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_timespec>(),
        12usize,
        concat!("Size of: ", stringify!(btrfs_timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_timespec>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_timespec))
    );
    fn test_field_sec() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_timespec>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sec) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_timespec),
                "::",
                stringify!(sec)
            )
        );
    }
    test_field_sec();
    fn test_field_nsec() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_timespec>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).nsec) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_timespec),
                "::",
                stringify!(nsec)
            )
        );
    }
    test_field_nsec();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_inode_item {
    pub generation: __le64,
    pub transid: __le64,
    pub size: __le64,
    pub nbytes: __le64,
    pub block_group: __le64,
    pub nlink: __le32,
    pub uid: __le32,
    pub gid: __le32,
    pub mode: __le32,
    pub rdev: __le64,
    pub flags: __le64,
    pub sequence: __le64,
    pub reserved: [__le64; 4usize],
    pub atime: btrfs_timespec,
    pub ctime: btrfs_timespec,
    pub mtime: btrfs_timespec,
    pub otime: btrfs_timespec,
}
#[test]
fn bindgen_test_layout_btrfs_inode_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_inode_item>(),
        160usize,
        concat!("Size of: ", stringify!(btrfs_inode_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_inode_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_inode_item))
    );
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_transid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).transid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(transid)
            )
        );
    }
    test_field_transid();
    fn test_field_size() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(size)
            )
        );
    }
    test_field_size();
    fn test_field_nbytes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).nbytes) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(nbytes)
            )
        );
    }
    test_field_nbytes();
    fn test_field_block_group() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).block_group) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(block_group)
            )
        );
    }
    test_field_block_group();
    fn test_field_nlink() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).nlink) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(nlink)
            )
        );
    }
    test_field_nlink();
    fn test_field_uid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).uid) as usize - ptr as usize
            },
            44usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(uid)
            )
        );
    }
    test_field_uid();
    fn test_field_gid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).gid) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(gid)
            )
        );
    }
    test_field_gid();
    fn test_field_mode() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).mode) as usize - ptr as usize
            },
            52usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(mode)
            )
        );
    }
    test_field_mode();
    fn test_field_rdev() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rdev) as usize - ptr as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(rdev)
            )
        );
    }
    test_field_rdev();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_sequence() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sequence) as usize - ptr as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(sequence)
            )
        );
    }
    test_field_sequence();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
    fn test_field_atime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).atime) as usize - ptr as usize
            },
            112usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(atime)
            )
        );
    }
    test_field_atime();
    fn test_field_ctime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).ctime) as usize - ptr as usize
            },
            124usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(ctime)
            )
        );
    }
    test_field_ctime();
    fn test_field_mtime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).mtime) as usize - ptr as usize
            },
            136usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(mtime)
            )
        );
    }
    test_field_mtime();
    fn test_field_otime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_inode_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).otime) as usize - ptr as usize
            },
            148usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_inode_item),
                "::",
                stringify!(otime)
            )
        );
    }
    test_field_otime();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_dir_log_item {
    pub end: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_dir_log_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_dir_log_item>(),
        8usize,
        concat!("Size of: ", stringify!(btrfs_dir_log_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_dir_log_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_dir_log_item))
    );
    fn test_field_end() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dir_log_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dir_log_item),
                "::",
                stringify!(end)
            )
        );
    }
    test_field_end();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_dir_item {
    pub location: btrfs_disk_key,
    pub transid: __le64,
    pub data_len: __le16,
    pub name_len: __le16,
    pub type_: __u8,
}
#[test]
fn bindgen_test_layout_btrfs_dir_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_dir_item>(),
        30usize,
        concat!("Size of: ", stringify!(btrfs_dir_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_dir_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_dir_item))
    );
    fn test_field_location() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dir_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).location) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dir_item),
                "::",
                stringify!(location)
            )
        );
    }
    test_field_location();
    fn test_field_transid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dir_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).transid) as usize - ptr as usize
            },
            17usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dir_item),
                "::",
                stringify!(transid)
            )
        );
    }
    test_field_transid();
    fn test_field_data_len() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dir_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).data_len) as usize - ptr as usize
            },
            25usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dir_item),
                "::",
                stringify!(data_len)
            )
        );
    }
    test_field_data_len();
    fn test_field_name_len() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dir_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).name_len) as usize - ptr as usize
            },
            27usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dir_item),
                "::",
                stringify!(name_len)
            )
        );
    }
    test_field_name_len();
    fn test_field_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dir_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize
            },
            29usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dir_item),
                "::",
                stringify!(type_)
            )
        );
    }
    test_field_type();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_root_item {
    pub inode: btrfs_inode_item,
    pub generation: __le64,
    pub root_dirid: __le64,
    pub bytenr: __le64,
    pub byte_limit: __le64,
    pub bytes_used: __le64,
    pub last_snapshot: __le64,
    pub flags: __le64,
    pub refs: __le32,
    pub drop_progress: btrfs_disk_key,
    pub drop_level: __u8,
    pub level: __u8,
    pub generation_v2: __le64,
    pub uuid: [__u8; 16usize],
    pub parent_uuid: [__u8; 16usize],
    pub received_uuid: [__u8; 16usize],
    pub ctransid: __le64,
    pub otransid: __le64,
    pub stransid: __le64,
    pub rtransid: __le64,
    pub ctime: btrfs_timespec,
    pub otime: btrfs_timespec,
    pub stime: btrfs_timespec,
    pub rtime: btrfs_timespec,
    pub reserved: [__le64; 8usize],
}
#[test]
fn bindgen_test_layout_btrfs_root_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_root_item>(),
        439usize,
        concat!("Size of: ", stringify!(btrfs_root_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_root_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_root_item))
    );
    fn test_field_inode() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).inode) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(inode)
            )
        );
    }
    test_field_inode();
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            160usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_root_dirid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).root_dirid) as usize - ptr as usize
            },
            168usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(root_dirid)
            )
        );
    }
    test_field_root_dirid();
    fn test_field_bytenr() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).bytenr) as usize - ptr as usize
            },
            176usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(bytenr)
            )
        );
    }
    test_field_bytenr();
    fn test_field_byte_limit() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).byte_limit) as usize - ptr as usize
            },
            184usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(byte_limit)
            )
        );
    }
    test_field_byte_limit();
    fn test_field_bytes_used() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).bytes_used) as usize - ptr as usize
            },
            192usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(bytes_used)
            )
        );
    }
    test_field_bytes_used();
    fn test_field_last_snapshot() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).last_snapshot) as usize - ptr as usize
            },
            200usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(last_snapshot)
            )
        );
    }
    test_field_last_snapshot();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            208usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_refs() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).refs) as usize - ptr as usize
            },
            216usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(refs)
            )
        );
    }
    test_field_refs();
    fn test_field_drop_progress() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).drop_progress) as usize - ptr as usize
            },
            220usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(drop_progress)
            )
        );
    }
    test_field_drop_progress();
    fn test_field_drop_level() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).drop_level) as usize - ptr as usize
            },
            237usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(drop_level)
            )
        );
    }
    test_field_drop_level();
    fn test_field_level() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize
            },
            238usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(level)
            )
        );
    }
    test_field_level();
    fn test_field_generation_v2() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation_v2) as usize - ptr as usize
            },
            239usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(generation_v2)
            )
        );
    }
    test_field_generation_v2();
    fn test_field_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).uuid) as usize - ptr as usize
            },
            247usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(uuid)
            )
        );
    }
    test_field_uuid();
    fn test_field_parent_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).parent_uuid) as usize - ptr as usize
            },
            263usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(parent_uuid)
            )
        );
    }
    test_field_parent_uuid();
    fn test_field_received_uuid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).received_uuid) as usize - ptr as usize
            },
            279usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(received_uuid)
            )
        );
    }
    test_field_received_uuid();
    fn test_field_ctransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).ctransid) as usize - ptr as usize
            },
            295usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(ctransid)
            )
        );
    }
    test_field_ctransid();
    fn test_field_otransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).otransid) as usize - ptr as usize
            },
            303usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(otransid)
            )
        );
    }
    test_field_otransid();
    fn test_field_stransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stransid) as usize - ptr as usize
            },
            311usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(stransid)
            )
        );
    }
    test_field_stransid();
    fn test_field_rtransid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rtransid) as usize - ptr as usize
            },
            319usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(rtransid)
            )
        );
    }
    test_field_rtransid();
    fn test_field_ctime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).ctime) as usize - ptr as usize
            },
            327usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(ctime)
            )
        );
    }
    test_field_ctime();
    fn test_field_otime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).otime) as usize - ptr as usize
            },
            339usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(otime)
            )
        );
    }
    test_field_otime();
    fn test_field_stime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stime) as usize - ptr as usize
            },
            351usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(stime)
            )
        );
    }
    test_field_stime();
    fn test_field_rtime() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rtime) as usize - ptr as usize
            },
            363usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(rtime)
            )
        );
    }
    test_field_rtime();
    fn test_field_reserved() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize
            },
            375usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_item),
                "::",
                stringify!(reserved)
            )
        );
    }
    test_field_reserved();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_root_ref {
    pub dirid: __le64,
    pub sequence: __le64,
    pub name_len: __le16,
}
#[test]
fn bindgen_test_layout_btrfs_root_ref() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_root_ref>(),
        18usize,
        concat!("Size of: ", stringify!(btrfs_root_ref))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_root_ref>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_root_ref))
    );
    fn test_field_dirid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).dirid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_ref),
                "::",
                stringify!(dirid)
            )
        );
    }
    test_field_dirid();
    fn test_field_sequence() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sequence) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_ref),
                "::",
                stringify!(sequence)
            )
        );
    }
    test_field_sequence();
    fn test_field_name_len() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_root_ref>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).name_len) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_root_ref),
                "::",
                stringify!(name_len)
            )
        );
    }
    test_field_name_len();
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct btrfs_disk_balance_args {
    pub profiles: __le64,
    pub __bindgen_anon_1: btrfs_disk_balance_args__bindgen_ty_1,
    pub devid: __le64,
    pub pstart: __le64,
    pub pend: __le64,
    pub vstart: __le64,
    pub vend: __le64,
    pub target: __le64,
    pub flags: __le64,
    pub __bindgen_anon_2: btrfs_disk_balance_args__bindgen_ty_2,
    pub stripes_min: __le32,
    pub stripes_max: __le32,
    pub unused: [__le64; 6usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union btrfs_disk_balance_args__bindgen_ty_1 {
    pub usage: __le64,
    pub __bindgen_anon_1: btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1 {
    pub usage_min: __le32,
    pub usage_max: __le32,
}
#[test]
fn bindgen_test_layout_btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1)
        )
    );
    fn test_field_usage_min() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).usage_min) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1),
                "::",
                stringify!(usage_min)
            )
        );
    }
    test_field_usage_min();
    fn test_field_usage_max() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).usage_max) as usize - ptr as usize
            },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args__bindgen_ty_1__bindgen_ty_1),
                "::",
                stringify!(usage_max)
            )
        );
    }
    test_field_usage_max();
}
#[test]
fn bindgen_test_layout_btrfs_disk_balance_args__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_disk_balance_args__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_disk_balance_args__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_disk_balance_args__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_disk_balance_args__bindgen_ty_1)
        )
    );
    fn test_field_usage() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_disk_balance_args__bindgen_ty_1>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).usage) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args__bindgen_ty_1),
                "::",
                stringify!(usage)
            )
        );
    }
    test_field_usage();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union btrfs_disk_balance_args__bindgen_ty_2 {
    pub limit: __le64,
    pub __bindgen_anon_1: btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1 {
    pub limit_min: __le32,
    pub limit_max: __le32,
}
#[test]
fn bindgen_test_layout_btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1)
        )
    );
    fn test_field_limit_min() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).limit_min) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1),
                "::",
                stringify!(limit_min)
            )
        );
    }
    test_field_limit_min();
    fn test_field_limit_max() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<
                    btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1,
                >::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).limit_max) as usize - ptr as usize
            },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args__bindgen_ty_2__bindgen_ty_1),
                "::",
                stringify!(limit_max)
            )
        );
    }
    test_field_limit_max();
}
#[test]
fn bindgen_test_layout_btrfs_disk_balance_args__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_disk_balance_args__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(btrfs_disk_balance_args__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_disk_balance_args__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btrfs_disk_balance_args__bindgen_ty_2)
        )
    );
    fn test_field_limit() {
        assert_eq!(
            unsafe {
                let uninit =
                    ::std::mem::MaybeUninit::<btrfs_disk_balance_args__bindgen_ty_2>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).limit) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args__bindgen_ty_2),
                "::",
                stringify!(limit)
            )
        );
    }
    test_field_limit();
}
#[test]
fn bindgen_test_layout_btrfs_disk_balance_args() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_disk_balance_args>(),
        136usize,
        concat!("Size of: ", stringify!(btrfs_disk_balance_args))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_disk_balance_args>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_disk_balance_args))
    );
    fn test_field_profiles() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).profiles) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(profiles)
            )
        );
    }
    test_field_profiles();
    fn test_field_devid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).devid) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(devid)
            )
        );
    }
    test_field_devid();
    fn test_field_pstart() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).pstart) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(pstart)
            )
        );
    }
    test_field_pstart();
    fn test_field_pend() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).pend) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(pend)
            )
        );
    }
    test_field_pend();
    fn test_field_vstart() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).vstart) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(vstart)
            )
        );
    }
    test_field_vstart();
    fn test_field_vend() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).vend) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(vend)
            )
        );
    }
    test_field_vend();
    fn test_field_target() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).target) as usize - ptr as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(target)
            )
        );
    }
    test_field_target();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_stripes_min() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stripes_min) as usize - ptr as usize
            },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(stripes_min)
            )
        );
    }
    test_field_stripes_min();
    fn test_field_stripes_max() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).stripes_max) as usize - ptr as usize
            },
            84usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(stripes_max)
            )
        );
    }
    test_field_stripes_max();
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_disk_balance_args>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            88usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_disk_balance_args),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct btrfs_balance_item {
    pub flags: __le64,
    pub data: btrfs_disk_balance_args,
    pub meta: btrfs_disk_balance_args,
    pub sys: btrfs_disk_balance_args,
    pub unused: [__le64; 4usize],
}
#[test]
fn bindgen_test_layout_btrfs_balance_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_balance_item>(),
        448usize,
        concat!("Size of: ", stringify!(btrfs_balance_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_balance_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_balance_item))
    );
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_item),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_data() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_item),
                "::",
                stringify!(data)
            )
        );
    }
    test_field_data();
    fn test_field_meta() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).meta) as usize - ptr as usize
            },
            144usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_item),
                "::",
                stringify!(meta)
            )
        );
    }
    test_field_meta();
    fn test_field_sys() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).sys) as usize - ptr as usize
            },
            280usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_item),
                "::",
                stringify!(sys)
            )
        );
    }
    test_field_sys();
    fn test_field_unused() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_balance_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).unused) as usize - ptr as usize
            },
            416usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_balance_item),
                "::",
                stringify!(unused)
            )
        );
    }
    test_field_unused();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_file_extent_item {
    pub generation: __le64,
    pub ram_bytes: __le64,
    pub compression: __u8,
    pub encryption: __u8,
    pub other_encoding: __le16,
    pub type_: __u8,
    pub disk_bytenr: __le64,
    pub disk_num_bytes: __le64,
    pub offset: __le64,
    pub num_bytes: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_file_extent_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_file_extent_item>(),
        53usize,
        concat!("Size of: ", stringify!(btrfs_file_extent_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_file_extent_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_file_extent_item))
    );
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_ram_bytes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).ram_bytes) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(ram_bytes)
            )
        );
    }
    test_field_ram_bytes();
    fn test_field_compression() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).compression) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(compression)
            )
        );
    }
    test_field_compression();
    fn test_field_encryption() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).encryption) as usize - ptr as usize
            },
            17usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(encryption)
            )
        );
    }
    test_field_encryption();
    fn test_field_other_encoding() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).other_encoding) as usize - ptr as usize
            },
            18usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(other_encoding)
            )
        );
    }
    test_field_other_encoding();
    fn test_field_type() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize
            },
            20usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(type_)
            )
        );
    }
    test_field_type();
    fn test_field_disk_bytenr() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).disk_bytenr) as usize - ptr as usize
            },
            21usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(disk_bytenr)
            )
        );
    }
    test_field_disk_bytenr();
    fn test_field_disk_num_bytes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).disk_num_bytes) as usize - ptr as usize
            },
            29usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(disk_num_bytes)
            )
        );
    }
    test_field_disk_num_bytes();
    fn test_field_offset() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize
            },
            37usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(offset)
            )
        );
    }
    test_field_offset();
    fn test_field_num_bytes() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_file_extent_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_bytes) as usize - ptr as usize
            },
            45usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_file_extent_item),
                "::",
                stringify!(num_bytes)
            )
        );
    }
    test_field_num_bytes();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_csum_item {
    pub csum: __u8,
}
#[test]
fn bindgen_test_layout_btrfs_csum_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_csum_item>(),
        1usize,
        concat!("Size of: ", stringify!(btrfs_csum_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_csum_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_csum_item))
    );
    fn test_field_csum() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_csum_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).csum) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_csum_item),
                "::",
                stringify!(csum)
            )
        );
    }
    test_field_csum();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_dev_stats_item {
    pub values: [__le64; 5usize],
}
#[test]
fn bindgen_test_layout_btrfs_dev_stats_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_dev_stats_item>(),
        40usize,
        concat!("Size of: ", stringify!(btrfs_dev_stats_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_dev_stats_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_dev_stats_item))
    );
    fn test_field_values() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_stats_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).values) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_stats_item),
                "::",
                stringify!(values)
            )
        );
    }
    test_field_values();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_dev_replace_item {
    pub src_devid: __le64,
    pub cursor_left: __le64,
    pub cursor_right: __le64,
    pub cont_reading_from_srcdev_mode: __le64,
    pub replace_state: __le64,
    pub time_started: __le64,
    pub time_stopped: __le64,
    pub num_write_errors: __le64,
    pub num_uncorrectable_read_errors: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_dev_replace_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_dev_replace_item>(),
        72usize,
        concat!("Size of: ", stringify!(btrfs_dev_replace_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_dev_replace_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_dev_replace_item))
    );
    fn test_field_src_devid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_replace_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).src_devid) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_replace_item),
                "::",
                stringify!(src_devid)
            )
        );
    }
    test_field_src_devid();
    fn test_field_cursor_left() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_replace_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).cursor_left) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_replace_item),
                "::",
                stringify!(cursor_left)
            )
        );
    }
    test_field_cursor_left();
    fn test_field_cursor_right() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_replace_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).cursor_right) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_replace_item),
                "::",
                stringify!(cursor_right)
            )
        );
    }
    test_field_cursor_right();
    fn test_field_cont_reading_from_srcdev_mode() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_replace_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).cont_reading_from_srcdev_mode) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_replace_item),
                "::",
                stringify!(cont_reading_from_srcdev_mode)
            )
        );
    }
    test_field_cont_reading_from_srcdev_mode();
    fn test_field_replace_state() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_replace_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).replace_state) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_replace_item),
                "::",
                stringify!(replace_state)
            )
        );
    }
    test_field_replace_state();
    fn test_field_time_started() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_replace_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).time_started) as usize - ptr as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_replace_item),
                "::",
                stringify!(time_started)
            )
        );
    }
    test_field_time_started();
    fn test_field_time_stopped() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_replace_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).time_stopped) as usize - ptr as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_replace_item),
                "::",
                stringify!(time_stopped)
            )
        );
    }
    test_field_time_stopped();
    fn test_field_num_write_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_replace_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_write_errors) as usize - ptr as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_replace_item),
                "::",
                stringify!(num_write_errors)
            )
        );
    }
    test_field_num_write_errors();
    fn test_field_num_uncorrectable_read_errors() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_dev_replace_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).num_uncorrectable_read_errors) as usize - ptr as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_dev_replace_item),
                "::",
                stringify!(num_uncorrectable_read_errors)
            )
        );
    }
    test_field_num_uncorrectable_read_errors();
}
pub const btrfs_raid_types_BTRFS_RAID_RAID10: btrfs_raid_types = 0;
pub const btrfs_raid_types_BTRFS_RAID_RAID1: btrfs_raid_types = 1;
pub const btrfs_raid_types_BTRFS_RAID_DUP: btrfs_raid_types = 2;
pub const btrfs_raid_types_BTRFS_RAID_RAID0: btrfs_raid_types = 3;
pub const btrfs_raid_types_BTRFS_RAID_SINGLE: btrfs_raid_types = 4;
pub const btrfs_raid_types_BTRFS_RAID_RAID5: btrfs_raid_types = 5;
pub const btrfs_raid_types_BTRFS_RAID_RAID6: btrfs_raid_types = 6;
pub const btrfs_raid_types_BTRFS_NR_RAID_TYPES: btrfs_raid_types = 7;
pub type btrfs_raid_types = ::std::os::raw::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_block_group_item {
    pub used: __le64,
    pub chunk_objectid: __le64,
    pub flags: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_block_group_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_block_group_item>(),
        24usize,
        concat!("Size of: ", stringify!(btrfs_block_group_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_block_group_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_block_group_item))
    );
    fn test_field_used() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_block_group_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).used) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_block_group_item),
                "::",
                stringify!(used)
            )
        );
    }
    test_field_used();
    fn test_field_chunk_objectid() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_block_group_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).chunk_objectid) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_block_group_item),
                "::",
                stringify!(chunk_objectid)
            )
        );
    }
    test_field_chunk_objectid();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_block_group_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_block_group_item),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_free_space_info {
    pub extent_count: __le32,
    pub flags: __le32,
}
#[test]
fn bindgen_test_layout_btrfs_free_space_info() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_free_space_info>(),
        8usize,
        concat!("Size of: ", stringify!(btrfs_free_space_info))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_free_space_info>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_free_space_info))
    );
    fn test_field_extent_count() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_free_space_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).extent_count) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_free_space_info),
                "::",
                stringify!(extent_count)
            )
        );
    }
    test_field_extent_count();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_free_space_info>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_free_space_info),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_qgroup_status_item {
    pub version: __le64,
    pub generation: __le64,
    pub flags: __le64,
    pub rescan: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_qgroup_status_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_qgroup_status_item>(),
        32usize,
        concat!("Size of: ", stringify!(btrfs_qgroup_status_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_qgroup_status_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_qgroup_status_item))
    );
    fn test_field_version() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_status_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_status_item),
                "::",
                stringify!(version)
            )
        );
    }
    test_field_version();
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_status_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_status_item),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_status_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_status_item),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_rescan() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_status_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rescan) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_status_item),
                "::",
                stringify!(rescan)
            )
        );
    }
    test_field_rescan();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_qgroup_info_item {
    pub generation: __le64,
    pub rfer: __le64,
    pub rfer_cmpr: __le64,
    pub excl: __le64,
    pub excl_cmpr: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_qgroup_info_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_qgroup_info_item>(),
        40usize,
        concat!("Size of: ", stringify!(btrfs_qgroup_info_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_qgroup_info_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_qgroup_info_item))
    );
    fn test_field_generation() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_info_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_info_item),
                "::",
                stringify!(generation)
            )
        );
    }
    test_field_generation();
    fn test_field_rfer() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_info_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rfer) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_info_item),
                "::",
                stringify!(rfer)
            )
        );
    }
    test_field_rfer();
    fn test_field_rfer_cmpr() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_info_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rfer_cmpr) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_info_item),
                "::",
                stringify!(rfer_cmpr)
            )
        );
    }
    test_field_rfer_cmpr();
    fn test_field_excl() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_info_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).excl) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_info_item),
                "::",
                stringify!(excl)
            )
        );
    }
    test_field_excl();
    fn test_field_excl_cmpr() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_info_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).excl_cmpr) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_info_item),
                "::",
                stringify!(excl_cmpr)
            )
        );
    }
    test_field_excl_cmpr();
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct btrfs_qgroup_limit_item {
    pub flags: __le64,
    pub max_rfer: __le64,
    pub max_excl: __le64,
    pub rsv_rfer: __le64,
    pub rsv_excl: __le64,
}
#[test]
fn bindgen_test_layout_btrfs_qgroup_limit_item() {
    assert_eq!(
        ::std::mem::size_of::<btrfs_qgroup_limit_item>(),
        40usize,
        concat!("Size of: ", stringify!(btrfs_qgroup_limit_item))
    );
    assert_eq!(
        ::std::mem::align_of::<btrfs_qgroup_limit_item>(),
        1usize,
        concat!("Alignment of ", stringify!(btrfs_qgroup_limit_item))
    );
    fn test_field_flags() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit_item),
                "::",
                stringify!(flags)
            )
        );
    }
    test_field_flags();
    fn test_field_max_rfer() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).max_rfer) as usize - ptr as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit_item),
                "::",
                stringify!(max_rfer)
            )
        );
    }
    test_field_max_rfer();
    fn test_field_max_excl() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).max_excl) as usize - ptr as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit_item),
                "::",
                stringify!(max_excl)
            )
        );
    }
    test_field_max_excl();
    fn test_field_rsv_rfer() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rsv_rfer) as usize - ptr as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit_item),
                "::",
                stringify!(rsv_rfer)
            )
        );
    }
    test_field_rsv_rfer();
    fn test_field_rsv_excl() {
        assert_eq!(
            unsafe {
                let uninit = ::std::mem::MaybeUninit::<btrfs_qgroup_limit_item>::uninit();
                let ptr = uninit.as_ptr();
                ::std::ptr::addr_of!((*ptr).rsv_excl) as usize - ptr as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(btrfs_qgroup_limit_item),
                "::",
                stringify!(rsv_excl)
            )
        );
    }
    test_field_rsv_excl();
}
