// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package securitycenter aliases all exported identifiers in package
// "cloud.google.com/go/securitycenter/apiv1/securitycenterpb".
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package securitycenter

import (
	src "cloud.google.com/go/securitycenter/apiv1/securitycenterpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
const (
	Connection_ESP                                                       = src.Connection_ESP
	Connection_GRE                                                       = src.Connection_GRE
	Connection_ICMP                                                      = src.Connection_ICMP
	Connection_PROTOCOL_UNSPECIFIED                                      = src.Connection_PROTOCOL_UNSPECIFIED
	Connection_TCP                                                       = src.Connection_TCP
	Connection_UDP                                                       = src.Connection_UDP
	Cvssv3_ATTACK_COMPLEXITY_HIGH                                        = src.Cvssv3_ATTACK_COMPLEXITY_HIGH
	Cvssv3_ATTACK_COMPLEXITY_LOW                                         = src.Cvssv3_ATTACK_COMPLEXITY_LOW
	Cvssv3_ATTACK_COMPLEXITY_UNSPECIFIED                                 = src.Cvssv3_ATTACK_COMPLEXITY_UNSPECIFIED
	Cvssv3_ATTACK_VECTOR_ADJACENT                                        = src.Cvssv3_ATTACK_VECTOR_ADJACENT
	Cvssv3_ATTACK_VECTOR_LOCAL                                           = src.Cvssv3_ATTACK_VECTOR_LOCAL
	Cvssv3_ATTACK_VECTOR_NETWORK                                         = src.Cvssv3_ATTACK_VECTOR_NETWORK
	Cvssv3_ATTACK_VECTOR_PHYSICAL                                        = src.Cvssv3_ATTACK_VECTOR_PHYSICAL
	Cvssv3_ATTACK_VECTOR_UNSPECIFIED                                     = src.Cvssv3_ATTACK_VECTOR_UNSPECIFIED
	Cvssv3_IMPACT_HIGH                                                   = src.Cvssv3_IMPACT_HIGH
	Cvssv3_IMPACT_LOW                                                    = src.Cvssv3_IMPACT_LOW
	Cvssv3_IMPACT_NONE                                                   = src.Cvssv3_IMPACT_NONE
	Cvssv3_IMPACT_UNSPECIFIED                                            = src.Cvssv3_IMPACT_UNSPECIFIED
	Cvssv3_PRIVILEGES_REQUIRED_HIGH                                      = src.Cvssv3_PRIVILEGES_REQUIRED_HIGH
	Cvssv3_PRIVILEGES_REQUIRED_LOW                                       = src.Cvssv3_PRIVILEGES_REQUIRED_LOW
	Cvssv3_PRIVILEGES_REQUIRED_NONE                                      = src.Cvssv3_PRIVILEGES_REQUIRED_NONE
	Cvssv3_PRIVILEGES_REQUIRED_UNSPECIFIED                               = src.Cvssv3_PRIVILEGES_REQUIRED_UNSPECIFIED
	Cvssv3_SCOPE_CHANGED                                                 = src.Cvssv3_SCOPE_CHANGED
	Cvssv3_SCOPE_UNCHANGED                                               = src.Cvssv3_SCOPE_UNCHANGED
	Cvssv3_SCOPE_UNSPECIFIED                                             = src.Cvssv3_SCOPE_UNSPECIFIED
	Cvssv3_USER_INTERACTION_NONE                                         = src.Cvssv3_USER_INTERACTION_NONE
	Cvssv3_USER_INTERACTION_REQUIRED                                     = src.Cvssv3_USER_INTERACTION_REQUIRED
	Cvssv3_USER_INTERACTION_UNSPECIFIED                                  = src.Cvssv3_USER_INTERACTION_UNSPECIFIED
	Finding_ACTIVE                                                       = src.Finding_ACTIVE
	Finding_CRITICAL                                                     = src.Finding_CRITICAL
	Finding_FINDING_CLASS_UNSPECIFIED                                    = src.Finding_FINDING_CLASS_UNSPECIFIED
	Finding_HIGH                                                         = src.Finding_HIGH
	Finding_INACTIVE                                                     = src.Finding_INACTIVE
	Finding_LOW                                                          = src.Finding_LOW
	Finding_MEDIUM                                                       = src.Finding_MEDIUM
	Finding_MISCONFIGURATION                                             = src.Finding_MISCONFIGURATION
	Finding_MUTED                                                        = src.Finding_MUTED
	Finding_MUTE_UNSPECIFIED                                             = src.Finding_MUTE_UNSPECIFIED
	Finding_OBSERVATION                                                  = src.Finding_OBSERVATION
	Finding_SCC_ERROR                                                    = src.Finding_SCC_ERROR
	Finding_SEVERITY_UNSPECIFIED                                         = src.Finding_SEVERITY_UNSPECIFIED
	Finding_STATE_UNSPECIFIED                                            = src.Finding_STATE_UNSPECIFIED
	Finding_THREAT                                                       = src.Finding_THREAT
	Finding_UNDEFINED                                                    = src.Finding_UNDEFINED
	Finding_UNMUTED                                                      = src.Finding_UNMUTED
	Finding_VULNERABILITY                                                = src.Finding_VULNERABILITY
	IamBinding_ACTION_UNSPECIFIED                                        = src.IamBinding_ACTION_UNSPECIFIED
	IamBinding_ADD                                                       = src.IamBinding_ADD
	IamBinding_REMOVE                                                    = src.IamBinding_REMOVE
	Kubernetes_Role_CLUSTER_ROLE                                         = src.Kubernetes_Role_CLUSTER_ROLE
	Kubernetes_Role_KIND_UNSPECIFIED                                     = src.Kubernetes_Role_KIND_UNSPECIFIED
	Kubernetes_Role_ROLE                                                 = src.Kubernetes_Role_ROLE
	Kubernetes_Subject_AUTH_TYPE_UNSPECIFIED                             = src.Kubernetes_Subject_AUTH_TYPE_UNSPECIFIED
	Kubernetes_Subject_GROUP                                             = src.Kubernetes_Subject_GROUP
	Kubernetes_Subject_SERVICEACCOUNT                                    = src.Kubernetes_Subject_SERVICEACCOUNT
	Kubernetes_Subject_USER                                              = src.Kubernetes_Subject_USER
	ListAssetsResponse_ListAssetsResult_ACTIVE                           = src.ListAssetsResponse_ListAssetsResult_ACTIVE
	ListAssetsResponse_ListAssetsResult_ADDED                            = src.ListAssetsResponse_ListAssetsResult_ADDED
	ListAssetsResponse_ListAssetsResult_REMOVED                          = src.ListAssetsResponse_ListAssetsResult_REMOVED
	ListAssetsResponse_ListAssetsResult_UNUSED                           = src.ListAssetsResponse_ListAssetsResult_UNUSED
	ListFindingsResponse_ListFindingsResult_ADDED                        = src.ListFindingsResponse_ListFindingsResult_ADDED
	ListFindingsResponse_ListFindingsResult_CHANGED                      = src.ListFindingsResponse_ListFindingsResult_CHANGED
	ListFindingsResponse_ListFindingsResult_REMOVED                      = src.ListFindingsResponse_ListFindingsResult_REMOVED
	ListFindingsResponse_ListFindingsResult_UNCHANGED                    = src.ListFindingsResponse_ListFindingsResult_UNCHANGED
	ListFindingsResponse_ListFindingsResult_UNUSED                       = src.ListFindingsResponse_ListFindingsResult_UNUSED
	MitreAttack_ABUSE_ELEVATION_CONTROL_MECHANISM                        = src.MitreAttack_ABUSE_ELEVATION_CONTROL_MECHANISM
	MitreAttack_ACCESS_TOKEN_MANIPULATION                                = src.MitreAttack_ACCESS_TOKEN_MANIPULATION
	MitreAttack_ACCOUNT_MANIPULATION                                     = src.MitreAttack_ACCOUNT_MANIPULATION
	MitreAttack_ACTIVE_SCANNING                                          = src.MitreAttack_ACTIVE_SCANNING
	MitreAttack_CLOUD_ACCOUNTS                                           = src.MitreAttack_CLOUD_ACCOUNTS
	MitreAttack_CLOUD_GROUPS                                             = src.MitreAttack_CLOUD_GROUPS
	MitreAttack_COLLECTION                                               = src.MitreAttack_COLLECTION
	MitreAttack_COMMAND_AND_CONTROL                                      = src.MitreAttack_COMMAND_AND_CONTROL
	MitreAttack_COMMAND_AND_SCRIPTING_INTERPRETER                        = src.MitreAttack_COMMAND_AND_SCRIPTING_INTERPRETER
	MitreAttack_CREATE_OR_MODIFY_SYSTEM_PROCESS                          = src.MitreAttack_CREATE_OR_MODIFY_SYSTEM_PROCESS
	MitreAttack_CREDENTIAL_ACCESS                                        = src.MitreAttack_CREDENTIAL_ACCESS
	MitreAttack_DATA_DESTRUCTION                                         = src.MitreAttack_DATA_DESTRUCTION
	MitreAttack_DEFENSE_EVASION                                          = src.MitreAttack_DEFENSE_EVASION
	MitreAttack_DISCOVERY                                                = src.MitreAttack_DISCOVERY
	MitreAttack_DOMAIN_POLICY_MODIFICATION                               = src.MitreAttack_DOMAIN_POLICY_MODIFICATION
	MitreAttack_DYNAMIC_RESOLUTION                                       = src.MitreAttack_DYNAMIC_RESOLUTION
	MitreAttack_EXECUTION                                                = src.MitreAttack_EXECUTION
	MitreAttack_EXFILTRATION                                             = src.MitreAttack_EXFILTRATION
	MitreAttack_EXFILTRATION_OVER_WEB_SERVICE                            = src.MitreAttack_EXFILTRATION_OVER_WEB_SERVICE
	MitreAttack_EXFILTRATION_TO_CLOUD_STORAGE                            = src.MitreAttack_EXFILTRATION_TO_CLOUD_STORAGE
	MitreAttack_EXPLOIT_PUBLIC_FACING_APPLICATION                        = src.MitreAttack_EXPLOIT_PUBLIC_FACING_APPLICATION
	MitreAttack_EXTERNAL_PROXY                                           = src.MitreAttack_EXTERNAL_PROXY
	MitreAttack_IMPACT                                                   = src.MitreAttack_IMPACT
	MitreAttack_IMPAIR_DEFENSES                                          = src.MitreAttack_IMPAIR_DEFENSES
	MitreAttack_INGRESS_TOOL_TRANSFER                                    = src.MitreAttack_INGRESS_TOOL_TRANSFER
	MitreAttack_INITIAL_ACCESS                                           = src.MitreAttack_INITIAL_ACCESS
	MitreAttack_LATERAL_MOVEMENT                                         = src.MitreAttack_LATERAL_MOVEMENT
	MitreAttack_LOCAL_ACCOUNTS                                           = src.MitreAttack_LOCAL_ACCOUNTS
	MitreAttack_MODIFY_AUTHENTICATION_PROCESS                            = src.MitreAttack_MODIFY_AUTHENTICATION_PROCESS
	MitreAttack_MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE                      = src.MitreAttack_MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE
	MitreAttack_MULTI_HOP_PROXY                                          = src.MitreAttack_MULTI_HOP_PROXY
	MitreAttack_NATIVE_API                                               = src.MitreAttack_NATIVE_API
	MitreAttack_NETWORK_DENIAL_OF_SERVICE                                = src.MitreAttack_NETWORK_DENIAL_OF_SERVICE
	MitreAttack_NETWORK_SERVICE_DISCOVERY                                = src.MitreAttack_NETWORK_SERVICE_DISCOVERY
	MitreAttack_PERMISSION_GROUPS_DISCOVERY                              = src.MitreAttack_PERMISSION_GROUPS_DISCOVERY
	MitreAttack_PERSISTENCE                                              = src.MitreAttack_PERSISTENCE
	MitreAttack_PRIVILEGE_ESCALATION                                     = src.MitreAttack_PRIVILEGE_ESCALATION
	MitreAttack_PROXY                                                    = src.MitreAttack_PROXY
	MitreAttack_RECONNAISSANCE                                           = src.MitreAttack_RECONNAISSANCE
	MitreAttack_RESOURCE_DEVELOPMENT                                     = src.MitreAttack_RESOURCE_DEVELOPMENT
	MitreAttack_RESOURCE_HIJACKING                                       = src.MitreAttack_RESOURCE_HIJACKING
	MitreAttack_SCANNING_IP_BLOCKS                                       = src.MitreAttack_SCANNING_IP_BLOCKS
	MitreAttack_SHARED_MODULES                                           = src.MitreAttack_SHARED_MODULES
	MitreAttack_SSH_AUTHORIZED_KEYS                                      = src.MitreAttack_SSH_AUTHORIZED_KEYS
	MitreAttack_STEAL_WEB_SESSION_COOKIE                                 = src.MitreAttack_STEAL_WEB_SESSION_COOKIE
	MitreAttack_TACTIC_UNSPECIFIED                                       = src.MitreAttack_TACTIC_UNSPECIFIED
	MitreAttack_TECHNIQUE_UNSPECIFIED                                    = src.MitreAttack_TECHNIQUE_UNSPECIFIED
	MitreAttack_UNIX_SHELL                                               = src.MitreAttack_UNIX_SHELL
	MitreAttack_UNSECURED_CREDENTIALS                                    = src.MitreAttack_UNSECURED_CREDENTIALS
	MitreAttack_VALID_ACCOUNTS                                           = src.MitreAttack_VALID_ACCOUNTS
	OrganizationSettings_AssetDiscoveryConfig_EXCLUDE                    = src.OrganizationSettings_AssetDiscoveryConfig_EXCLUDE
	OrganizationSettings_AssetDiscoveryConfig_INCLUDE_ONLY               = src.OrganizationSettings_AssetDiscoveryConfig_INCLUDE_ONLY
	OrganizationSettings_AssetDiscoveryConfig_INCLUSION_MODE_UNSPECIFIED = src.OrganizationSettings_AssetDiscoveryConfig_INCLUSION_MODE_UNSPECIFIED
	RunAssetDiscoveryResponse_COMPLETED                                  = src.RunAssetDiscoveryResponse_COMPLETED
	RunAssetDiscoveryResponse_STATE_UNSPECIFIED                          = src.RunAssetDiscoveryResponse_STATE_UNSPECIFIED
	RunAssetDiscoveryResponse_SUPERSEDED                                 = src.RunAssetDiscoveryResponse_SUPERSEDED
	RunAssetDiscoveryResponse_TERMINATED                                 = src.RunAssetDiscoveryResponse_TERMINATED
)

// Deprecated: Please use vars in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
var (
	Connection_Protocol_name                                               = src.Connection_Protocol_name
	Connection_Protocol_value                                              = src.Connection_Protocol_value
	Cvssv3_AttackComplexity_name                                           = src.Cvssv3_AttackComplexity_name
	Cvssv3_AttackComplexity_value                                          = src.Cvssv3_AttackComplexity_value
	Cvssv3_AttackVector_name                                               = src.Cvssv3_AttackVector_name
	Cvssv3_AttackVector_value                                              = src.Cvssv3_AttackVector_value
	Cvssv3_Impact_name                                                     = src.Cvssv3_Impact_name
	Cvssv3_Impact_value                                                    = src.Cvssv3_Impact_value
	Cvssv3_PrivilegesRequired_name                                         = src.Cvssv3_PrivilegesRequired_name
	Cvssv3_PrivilegesRequired_value                                        = src.Cvssv3_PrivilegesRequired_value
	Cvssv3_Scope_name                                                      = src.Cvssv3_Scope_name
	Cvssv3_Scope_value                                                     = src.Cvssv3_Scope_value
	Cvssv3_UserInteraction_name                                            = src.Cvssv3_UserInteraction_name
	Cvssv3_UserInteraction_value                                           = src.Cvssv3_UserInteraction_value
	File_google_cloud_securitycenter_v1_access_proto                       = src.File_google_cloud_securitycenter_v1_access_proto
	File_google_cloud_securitycenter_v1_asset_proto                        = src.File_google_cloud_securitycenter_v1_asset_proto
	File_google_cloud_securitycenter_v1_bigquery_export_proto              = src.File_google_cloud_securitycenter_v1_bigquery_export_proto
	File_google_cloud_securitycenter_v1_compliance_proto                   = src.File_google_cloud_securitycenter_v1_compliance_proto
	File_google_cloud_securitycenter_v1_connection_proto                   = src.File_google_cloud_securitycenter_v1_connection_proto
	File_google_cloud_securitycenter_v1_contact_details_proto              = src.File_google_cloud_securitycenter_v1_contact_details_proto
	File_google_cloud_securitycenter_v1_container_proto                    = src.File_google_cloud_securitycenter_v1_container_proto
	File_google_cloud_securitycenter_v1_database_proto                     = src.File_google_cloud_securitycenter_v1_database_proto
	File_google_cloud_securitycenter_v1_exfiltration_proto                 = src.File_google_cloud_securitycenter_v1_exfiltration_proto
	File_google_cloud_securitycenter_v1_external_system_proto              = src.File_google_cloud_securitycenter_v1_external_system_proto
	File_google_cloud_securitycenter_v1_file_proto                         = src.File_google_cloud_securitycenter_v1_file_proto
	File_google_cloud_securitycenter_v1_finding_proto                      = src.File_google_cloud_securitycenter_v1_finding_proto
	File_google_cloud_securitycenter_v1_folder_proto                       = src.File_google_cloud_securitycenter_v1_folder_proto
	File_google_cloud_securitycenter_v1_iam_binding_proto                  = src.File_google_cloud_securitycenter_v1_iam_binding_proto
	File_google_cloud_securitycenter_v1_indicator_proto                    = src.File_google_cloud_securitycenter_v1_indicator_proto
	File_google_cloud_securitycenter_v1_kubernetes_proto                   = src.File_google_cloud_securitycenter_v1_kubernetes_proto
	File_google_cloud_securitycenter_v1_label_proto                        = src.File_google_cloud_securitycenter_v1_label_proto
	File_google_cloud_securitycenter_v1_mitre_attack_proto                 = src.File_google_cloud_securitycenter_v1_mitre_attack_proto
	File_google_cloud_securitycenter_v1_mute_config_proto                  = src.File_google_cloud_securitycenter_v1_mute_config_proto
	File_google_cloud_securitycenter_v1_notification_config_proto          = src.File_google_cloud_securitycenter_v1_notification_config_proto
	File_google_cloud_securitycenter_v1_notification_message_proto         = src.File_google_cloud_securitycenter_v1_notification_message_proto
	File_google_cloud_securitycenter_v1_organization_settings_proto        = src.File_google_cloud_securitycenter_v1_organization_settings_proto
	File_google_cloud_securitycenter_v1_process_proto                      = src.File_google_cloud_securitycenter_v1_process_proto
	File_google_cloud_securitycenter_v1_resource_proto                     = src.File_google_cloud_securitycenter_v1_resource_proto
	File_google_cloud_securitycenter_v1_run_asset_discovery_response_proto = src.File_google_cloud_securitycenter_v1_run_asset_discovery_response_proto
	File_google_cloud_securitycenter_v1_security_marks_proto               = src.File_google_cloud_securitycenter_v1_security_marks_proto
	File_google_cloud_securitycenter_v1_securitycenter_service_proto       = src.File_google_cloud_securitycenter_v1_securitycenter_service_proto
	File_google_cloud_securitycenter_v1_source_proto                       = src.File_google_cloud_securitycenter_v1_source_proto
	File_google_cloud_securitycenter_v1_vulnerability_proto                = src.File_google_cloud_securitycenter_v1_vulnerability_proto
	Finding_FindingClass_name                                              = src.Finding_FindingClass_name
	Finding_FindingClass_value                                             = src.Finding_FindingClass_value
	Finding_Mute_name                                                      = src.Finding_Mute_name
	Finding_Mute_value                                                     = src.Finding_Mute_value
	Finding_Severity_name                                                  = src.Finding_Severity_name
	Finding_Severity_value                                                 = src.Finding_Severity_value
	Finding_State_name                                                     = src.Finding_State_name
	Finding_State_value                                                    = src.Finding_State_value
	IamBinding_Action_name                                                 = src.IamBinding_Action_name
	IamBinding_Action_value                                                = src.IamBinding_Action_value
	Kubernetes_Role_Kind_name                                              = src.Kubernetes_Role_Kind_name
	Kubernetes_Role_Kind_value                                             = src.Kubernetes_Role_Kind_value
	Kubernetes_Subject_AuthType_name                                       = src.Kubernetes_Subject_AuthType_name
	Kubernetes_Subject_AuthType_value                                      = src.Kubernetes_Subject_AuthType_value
	ListAssetsResponse_ListAssetsResult_StateChange_name                   = src.ListAssetsResponse_ListAssetsResult_StateChange_name
	ListAssetsResponse_ListAssetsResult_StateChange_value                  = src.ListAssetsResponse_ListAssetsResult_StateChange_value
	ListFindingsResponse_ListFindingsResult_StateChange_name               = src.ListFindingsResponse_ListFindingsResult_StateChange_name
	ListFindingsResponse_ListFindingsResult_StateChange_value              = src.ListFindingsResponse_ListFindingsResult_StateChange_value
	MitreAttack_Tactic_name                                                = src.MitreAttack_Tactic_name
	MitreAttack_Tactic_value                                               = src.MitreAttack_Tactic_value
	MitreAttack_Technique_name                                             = src.MitreAttack_Technique_name
	MitreAttack_Technique_value                                            = src.MitreAttack_Technique_value
	OrganizationSettings_AssetDiscoveryConfig_InclusionMode_name           = src.OrganizationSettings_AssetDiscoveryConfig_InclusionMode_name
	OrganizationSettings_AssetDiscoveryConfig_InclusionMode_value          = src.OrganizationSettings_AssetDiscoveryConfig_InclusionMode_value
	RunAssetDiscoveryResponse_State_name                                   = src.RunAssetDiscoveryResponse_State_name
	RunAssetDiscoveryResponse_State_value                                  = src.RunAssetDiscoveryResponse_State_value
)

// Represents an access event.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Access = src.Access

// Security Command Center representation of a Google Cloud resource. The
// Asset is a Security Command Center resource that captures information about
// a single Google Cloud resource. All modifications to an Asset are only
// within the context of Security Command Center and don't affect the
// referenced Google Cloud resource.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Asset = src.Asset

// Cloud IAM Policy information associated with the Google Cloud resource
// described by the Security Command Center asset. This information is managed
// and defined by the Google Cloud resource and cannot be modified by the user.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Asset_IamPolicy = src.Asset_IamPolicy

// Security Command Center managed properties. These properties are managed by
// Security Command Center and cannot be modified by the user.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Asset_SecurityCenterProperties = src.Asset_SecurityCenterProperties

// Configures how to deliver Findings to BigQuery Instance.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type BigQueryExport = src.BigQueryExport

// Request message for bulk findings update. Note: 1. If multiple bulk update
// requests match the same resource, the order in which they get executed is
// not defined. 2. Once a bulk operation is started, there is no way to stop
// it.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type BulkMuteFindingsRequest = src.BulkMuteFindingsRequest

// The response to a BulkMute request. Contains the LRO information.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type BulkMuteFindingsResponse = src.BulkMuteFindingsResponse

// Contains compliance information about a security standard indicating unmet
// recommendations.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Compliance = src.Compliance

// Contains information about the IP connection associated with the finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Connection = src.Connection

// IANA Internet Protocol Number such as TCP(6) and UDP(17).
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Connection_Protocol = src.Connection_Protocol

// Representa a single contact's email address
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Contact = src.Contact

// The details pertaining to specific contacts
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ContactDetails = src.ContactDetails

// Container associated with the finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Container = src.Container

// Request message for creating a big query export.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type CreateBigQueryExportRequest = src.CreateBigQueryExportRequest

// Request message for creating a finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type CreateFindingRequest = src.CreateFindingRequest

// Request message for creating a mute config.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type CreateMuteConfigRequest = src.CreateMuteConfigRequest

// Request message for creating a notification config.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type CreateNotificationConfigRequest = src.CreateNotificationConfigRequest

// Request message for creating a source.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type CreateSourceRequest = src.CreateSourceRequest

// CVE stands for Common Vulnerabilities and Exposures. More information:
// https://cve.mitre.org
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Cve = src.Cve

// Common Vulnerability Scoring System version 3.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Cvssv3 = src.Cvssv3

// This metric describes the conditions beyond the attacker's control that
// must exist in order to exploit the vulnerability.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Cvssv3_AttackComplexity = src.Cvssv3_AttackComplexity

// This metric reflects the context by which vulnerability exploitation is
// possible.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Cvssv3_AttackVector = src.Cvssv3_AttackVector

// The Impact metrics capture the effects of a successfully exploited
// vulnerability on the component that suffers the worst outcome that is most
// directly and predictably associated with the attack.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Cvssv3_Impact = src.Cvssv3_Impact

// This metric describes the level of privileges an attacker must possess
// before successfully exploiting the vulnerability.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Cvssv3_PrivilegesRequired = src.Cvssv3_PrivilegesRequired

// The Scope metric captures whether a vulnerability in one vulnerable
// component impacts resources in components beyond its security scope.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Cvssv3_Scope = src.Cvssv3_Scope

// This metric captures the requirement for a human user, other than the
// attacker, to participate in the successful compromise of the vulnerable
// component.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Cvssv3_UserInteraction = src.Cvssv3_UserInteraction

// Represents database access information, such as queries. A database may be
// a sub-resource of an instance (as in the case of CloudSQL instances or Cloud
// Spanner instances), or the database instance itself. Some database resources
// may not have the full resource name populated because these resource types
// are not yet supported by Cloud Asset Inventory (e.g. CloudSQL databases). In
// these cases only the display name will be provided.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Database = src.Database

// Request message for deleting a big query export.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type DeleteBigQueryExportRequest = src.DeleteBigQueryExportRequest

// Request message for deleting a mute config.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type DeleteMuteConfigRequest = src.DeleteMuteConfigRequest

// Request message for deleting a notification config.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type DeleteNotificationConfigRequest = src.DeleteNotificationConfigRequest

// EnvironmentVariable is a name-value pair to store environment variables for
// Process.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type EnvironmentVariable = src.EnvironmentVariable

// Resource that has been exfiltrated or exfiltrated_to.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ExfilResource = src.ExfilResource

// Exfiltration represents a data exfiltration attempt of one or more sources
// to one or more targets. Sources represent the source of data that is
// exfiltrated, and Targets represents the destination the data was copied to.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Exfiltration = src.Exfiltration

// Representation of third party SIEM/SOAR fields within SCC.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ExternalSystem = src.ExternalSystem

// File information about the related binary/library used by an executable, or
// the script used by a script interpreter
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type File = src.File

// Security Command Center finding. A finding is a record of assessment data
// like security, risk, health, or privacy, that is ingested into Security
// Command Center for presentation, notification, analysis, policy testing, and
// enforcement. For example, a cross-site scripting (XSS) vulnerability in an
// App Engine application is a finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Finding = src.Finding

// Represents what kind of Finding it is.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Finding_FindingClass = src.Finding_FindingClass

// Mute state a finding can be in.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Finding_Mute = src.Finding_Mute

// The severity of the finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Finding_Severity = src.Finding_Severity

// The state of the finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Finding_State = src.Finding_State

// Message that contains the resource name and display name of a folder
// resource.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Folder = src.Folder

// Represents a geographical location for a given access.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Geolocation = src.Geolocation

// Request message for retrieving a big query export.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GetBigQueryExportRequest = src.GetBigQueryExportRequest

// Request message for retrieving a mute config.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GetMuteConfigRequest = src.GetMuteConfigRequest

// Request message for getting a notification config.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GetNotificationConfigRequest = src.GetNotificationConfigRequest

// Request message for getting organization settings.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GetOrganizationSettingsRequest = src.GetOrganizationSettingsRequest

// Request message for getting a source.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GetSourceRequest = src.GetSourceRequest

// Request message for grouping by assets.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GroupAssetsRequest = src.GroupAssetsRequest

// Response message for grouping by assets.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GroupAssetsResponse = src.GroupAssetsResponse

// Request message for grouping by findings.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GroupFindingsRequest = src.GroupFindingsRequest

// Response message for group by findings.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GroupFindingsResponse = src.GroupFindingsResponse

// Result containing the properties and count of a groupBy request.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type GroupResult = src.GroupResult

// Represents a particular IAM binding, which captures a member's role
// addition, removal, or state.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type IamBinding = src.IamBinding

// The type of action performed on a Binding in a policy.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type IamBinding_Action = src.IamBinding_Action

// Represents what's commonly known as an Indicator of compromise (IoC) in
// computer forensics. This is an artifact observed on a network or in an
// operating system that, with high confidence, indicates a computer intrusion.
// Reference: https://en.wikipedia.org/wiki/Indicator_of_compromise
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Indicator = src.Indicator

// Indicates what signature matched this process.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Indicator_ProcessSignature = src.Indicator_ProcessSignature

// A signature corresponding to memory page hashes.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Indicator_ProcessSignature_MemoryHashSignature = src.Indicator_ProcessSignature_MemoryHashSignature
type Indicator_ProcessSignature_MemoryHashSignature_ = src.Indicator_ProcessSignature_MemoryHashSignature_

// Memory hash detection contributing to the binary family match.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Indicator_ProcessSignature_MemoryHashSignature_Detection = src.Indicator_ProcessSignature_MemoryHashSignature_Detection

// A signature corresponding to a YARA rule.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Indicator_ProcessSignature_YaraRuleSignature = src.Indicator_ProcessSignature_YaraRuleSignature
type Indicator_ProcessSignature_YaraRuleSignature_ = src.Indicator_ProcessSignature_YaraRuleSignature_

// Kubernetes related attributes.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes = src.Kubernetes

// Conveys information about a Kubernetes access review (e.g. kubectl auth
// can-i ...) that was involved in a finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes_AccessReview = src.Kubernetes_AccessReview

// Represents a Kubernetes RoleBinding or ClusterRoleBinding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes_Binding = src.Kubernetes_Binding

// Kubernetes Nodes associated with the finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes_Node = src.Kubernetes_Node

// Provides GKE Node Pool information.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes_NodePool = src.Kubernetes_NodePool

// Kubernetes Pod.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes_Pod = src.Kubernetes_Pod

// Kubernetes Role or ClusterRole.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes_Role = src.Kubernetes_Role

// Types of Kubernetes roles.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes_Role_Kind = src.Kubernetes_Role_Kind

// Represents a Kubernetes Subject.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes_Subject = src.Kubernetes_Subject

// Auth types that can be used for Subject's kind field.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Kubernetes_Subject_AuthType = src.Kubernetes_Subject_AuthType

// Label represents a generic name=value label. Label has separate name and
// value fields to support filtering with contains().
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Label = src.Label

// Request message for listing assets.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListAssetsRequest = src.ListAssetsRequest

// Response message for listing assets.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListAssetsResponse = src.ListAssetsResponse

// Result containing the Asset and its State.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListAssetsResponse_ListAssetsResult = src.ListAssetsResponse_ListAssetsResult

// The change in state of the asset. When querying across two points in time
// this describes the change between the two points: ADDED, REMOVED, or ACTIVE.
// If there was no compare_duration supplied in the request the state change
// will be: UNUSED
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListAssetsResponse_ListAssetsResult_StateChange = src.ListAssetsResponse_ListAssetsResult_StateChange

// Request message for listing BigQuery exports at a given scope e.g.
// organization, folder or project.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListBigQueryExportsRequest = src.ListBigQueryExportsRequest

// Response message for listing BigQuery exports.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListBigQueryExportsResponse = src.ListBigQueryExportsResponse

// Request message for listing findings.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListFindingsRequest = src.ListFindingsRequest

// Response message for listing findings.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListFindingsResponse = src.ListFindingsResponse

// Result containing the Finding and its StateChange.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListFindingsResponse_ListFindingsResult = src.ListFindingsResponse_ListFindingsResult

// Information related to the Google Cloud resource that is associated with
// this finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListFindingsResponse_ListFindingsResult_Resource = src.ListFindingsResponse_ListFindingsResult_Resource

// The change in state of the finding. When querying across two points in time
// this describes the change in the finding between the two points: CHANGED,
// UNCHANGED, ADDED, or REMOVED. Findings can not be deleted, so REMOVED
// implies that the finding at timestamp does not match the filter specified,
// but it did at timestamp - compare_duration. If there was no compare_duration
// supplied in the request the state change will be: UNUSED
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListFindingsResponse_ListFindingsResult_StateChange = src.ListFindingsResponse_ListFindingsResult_StateChange

// Request message for listing mute configs at a given scope e.g.
// organization, folder or project.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListMuteConfigsRequest = src.ListMuteConfigsRequest

// Response message for listing mute configs.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListMuteConfigsResponse = src.ListMuteConfigsResponse

// Request message for listing notification configs.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListNotificationConfigsRequest = src.ListNotificationConfigsRequest

// Response message for listing notification configs.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListNotificationConfigsResponse = src.ListNotificationConfigsResponse

// Request message for listing sources.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListSourcesRequest = src.ListSourcesRequest

// Response message for listing sources.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ListSourcesResponse = src.ListSourcesResponse

// MITRE ATT&CK tactics and techniques related to this finding. See:
// https://attack.mitre.org
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type MitreAttack = src.MitreAttack

// MITRE ATT&CK tactics that can be referenced by SCC findings. See:
// https://attack.mitre.org/tactics/enterprise/
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type MitreAttack_Tactic = src.MitreAttack_Tactic

// MITRE ATT&CK techniques that can be referenced by SCC findings. See:
// https://attack.mitre.org/techniques/enterprise/
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type MitreAttack_Technique = src.MitreAttack_Technique

// A mute config is a Cloud SCC resource that contains the configuration to
// mute create/update events of findings.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type MuteConfig = src.MuteConfig

// Cloud Security Command Center (Cloud SCC) notification configs. A
// notification config is a Cloud SCC resource that contains the configuration
// to send notifications for create/update events of findings, assets and etc.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type NotificationConfig = src.NotificationConfig

// The config for streaming-based notifications, which send each event as soon
// as it is detected.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type NotificationConfig_StreamingConfig = src.NotificationConfig_StreamingConfig
type NotificationConfig_StreamingConfig_ = src.NotificationConfig_StreamingConfig_

// Cloud SCC's Notification
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type NotificationMessage = src.NotificationMessage
type NotificationMessage_Finding = src.NotificationMessage_Finding

// User specified settings that are attached to the Security Command Center
// organization.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type OrganizationSettings = src.OrganizationSettings

// The configuration used for Asset Discovery runs.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type OrganizationSettings_AssetDiscoveryConfig = src.OrganizationSettings_AssetDiscoveryConfig

// The mode of inclusion when running Asset Discovery. Asset discovery can be
// limited by explicitly identifying projects to be included or excluded. If
// INCLUDE_ONLY is set, then only those projects within the organization and
// their children are discovered during asset discovery. If EXCLUDE is set,
// then projects that don't match those projects are discovered during asset
// discovery. If neither are set, then all projects within the organization are
// discovered during asset discovery.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type OrganizationSettings_AssetDiscoveryConfig_InclusionMode = src.OrganizationSettings_AssetDiscoveryConfig_InclusionMode

// Represents an operating system process.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Process = src.Process

// Additional Links
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Reference = src.Reference

// Information related to the Google Cloud resource.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Resource = src.Resource

// Request message for running asset discovery for an organization.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type RunAssetDiscoveryRequest = src.RunAssetDiscoveryRequest

// Response of asset discovery run
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type RunAssetDiscoveryResponse = src.RunAssetDiscoveryResponse

// The state of an asset discovery run.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type RunAssetDiscoveryResponse_State = src.RunAssetDiscoveryResponse_State

// SecurityCenterClient is the client API for SecurityCenter service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type SecurityCenterClient = src.SecurityCenterClient

// SecurityCenterServer is the server API for SecurityCenter service.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type SecurityCenterServer = src.SecurityCenterServer

// User specified security marks that are attached to the parent Security
// Command Center resource. Security marks are scoped within a Security Command
// Center organization -- they can be modified and viewed by all users who have
// proper permissions on the organization.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type SecurityMarks = src.SecurityMarks

// Identity delegation history of an authenticated service account.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type ServiceAccountDelegationInfo = src.ServiceAccountDelegationInfo

// Request message for updating a finding's state.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type SetFindingStateRequest = src.SetFindingStateRequest

// Request message for updating a finding's mute status.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type SetMuteRequest = src.SetMuteRequest

// Security Command Center finding source. A finding source is an entity or a
// mechanism that can produce a finding. A source is like a container of
// findings that come from the same scanner, logger, monitor, and other tools.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Source = src.Source

// UnimplementedSecurityCenterServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type UnimplementedSecurityCenterServer = src.UnimplementedSecurityCenterServer

// Request message for updating a BigQuery export.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type UpdateBigQueryExportRequest = src.UpdateBigQueryExportRequest

// Request message for updating a ExternalSystem resource.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type UpdateExternalSystemRequest = src.UpdateExternalSystemRequest

// Request message for updating or creating a finding.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type UpdateFindingRequest = src.UpdateFindingRequest

// Request message for updating a mute config.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type UpdateMuteConfigRequest = src.UpdateMuteConfigRequest

// Request message for updating a notification config.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type UpdateNotificationConfigRequest = src.UpdateNotificationConfigRequest

// Request message for updating an organization's settings.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type UpdateOrganizationSettingsRequest = src.UpdateOrganizationSettingsRequest

// Request message for updating a SecurityMarks resource.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type UpdateSecurityMarksRequest = src.UpdateSecurityMarksRequest

// Request message for updating a source.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type UpdateSourceRequest = src.UpdateSourceRequest

// Refers to common vulnerability fields e.g. cve, cvss, cwe etc.
//
// Deprecated: Please use types in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
type Vulnerability = src.Vulnerability

// Deprecated: Please use funcs in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
func NewSecurityCenterClient(cc grpc.ClientConnInterface) SecurityCenterClient {
	return src.NewSecurityCenterClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/securitycenter/apiv1/securitycenterpb
func RegisterSecurityCenterServer(s *grpc.Server, srv SecurityCenterServer) {
	src.RegisterSecurityCenterServer(s, srv)
}
