package bluetoothemulation

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// CentralState indicates the various states of Central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-CentralState
type CentralState string

// String returns the CentralState as string value.
func (t CentralState) String() string {
	return string(t)
}

// CentralState values.
const (
	CentralStateAbsent     CentralState = "absent"
	CentralStatePoweredOff CentralState = "powered-off"
	CentralStatePoweredOn  CentralState = "powered-on"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t CentralState) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t CentralState) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *CentralState) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch CentralState(v) {
	case CentralStateAbsent:
		*t = CentralStateAbsent
	case CentralStatePoweredOff:
		*t = CentralStatePoweredOff
	case CentralStatePoweredOn:
		*t = CentralStatePoweredOn

	default:
		in.AddError(fmt.Errorf("unknown CentralState value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *CentralState) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// ManufacturerData stores the manufacturer data.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-ManufacturerData
type ManufacturerData struct {
	Key  int64  `json:"key"`  // Company identifier https://bitbucket.org/bluetooth-SIG/public/src/main/assigned_numbers/company_identifiers/company_identifiers.yaml https://usb.org/developers
	Data string `json:"data"` // Manufacturer-specific data
}

// ScanRecord stores the byte data of the advertisement packet sent by a
// Bluetooth device.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-ScanRecord
type ScanRecord struct {
	Name             string              `json:"name,omitempty"`
	Uuids            []string            `json:"uuids,omitempty"`
	Appearance       int64               `json:"appearance,omitempty"`       // Stores the external appearance description of the device.
	TxPower          int64               `json:"txPower,omitempty"`          // Stores the transmission power of a broadcasting device.
	ManufacturerData []*ManufacturerData `json:"manufacturerData,omitempty"` // Key is the company identifier and the value is an array of bytes of manufacturer specific data.
}

// ScanEntry stores the advertisement packet information that is sent by a
// Bluetooth device.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-ScanEntry
type ScanEntry struct {
	DeviceAddress string      `json:"deviceAddress"`
	Rssi          int64       `json:"rssi"`
	ScanRecord    *ScanRecord `json:"scanRecord"`
}
