## RabbitMQ 4.2.2

RabbitMQ `4.2.2` is a maintenance release in the `4.2.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.2.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.2.0)
in detail if upgrading from a version prior to `4.2.0`.

### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.2.x/release-notes).

### Core Server

#### Bug Fixes

 * Fixes a binding deletion-related memory leak in Khepri.

   This leak primarily affected systems with high binding churn.

   GitHub issue: [#15024](https://github.com/rabbitmq/rabbitmq-server/issues/15024)

 * Corrected a performance regression around metric collection that could have a meaningful impact on quorum queues.

   GitHub issue: [rabbitmq/seshat#16](https://github.com/rabbitmq/seshat/pull/16)

 * AMQP 1.0 link error frames did not have settlement set in certain failure scenarios,
   namely when attaching a link failed due to a missing source (queue or stream).

   GitHub issue: [#15004](https://github.com/rabbitmq/rabbitmq-server/pull/15004)

 * AMQP 1.0 clients that publish messages without a body now get a clearer error message.
   Messages without a body explicitly violate the AMQP 1.0 specification.

   GitHub issue: [#15048](https://github.com/rabbitmq/rabbitmq-server/pull/15048)

 * Default operator policy pre-configuration in `rabbitmq.conf` were unintentionally missing a key,
   `default_policies.operator.$id.apply_to`, for controlling what objects the policy applies to.

   GitHub issue: [#14988](https://github.com/rabbitmq/rabbitmq-server/pull/14988)

 * Definition import is now more defensive when importing exchanges.

   GitHub issue: [#15128](https://github.com/rabbitmq/rabbitmq-server/issues/15128)

#### Enhancements

 * More efficient Khepri (metadata store) querying.

   GitHub issue: [rabbitmq/khepri#349](https://github.com/rabbitmq/khepri/pull/349)

 * Removed a cool down delay between stream chunk redelivery attempts.

   GitHub issue: [#14766](https://github.com/rabbitmq/rabbitmq-server/pull/14766)

 * Stream data directory can now be configured via `rabbitmq.conf`.

   GitHub issue: [#15014](https://github.com/rabbitmq/rabbitmq-server/pull/15014)

 * Stream replication: IP address family (IPv4 or IPv6) can now be configured via `rabbitmq.conf`.

   GitHub issue: [#15012](https://github.com/rabbitmq/rabbitmq-server/pull/15012)


### OAuth 2 Plugin

#### Bug Fixes

 * When multiple resource server IDs are configured, management UI login screen now provides a way to pre-select a specific resource ID
   before logging in.

   As part of this change, when multiple resource server IDs are configured, their order stored internally now reflects
   that in `rabbitmq.conf`.

   GitHub issue: [#15044](https://github.com/rabbitmq/rabbitmq-server/pull/15044)


### Management Plugin

#### Bug Fixes

 * `GET /api/deprecated-features/used` no longer returns an empty `state` field.

   GitHub issue: [#14340](https://github.com/rabbitmq/rabbitmq-server/issues/14340)

 * Feature flag icons now contrast well when the dark mode is used in the UI.

   GitHub issue: [#14620](https://github.com/rabbitmq/rabbitmq-server/issues/14620)

 * Corrected an invalid `apply_to` value (`classic_queue` instead of `classic_queues`)
   on the policy declaration form.

   Declaring a policy "directly" via the HTTP API was not affected.

   GitHub issue: [#15054](https://github.com/rabbitmq/rabbitmq-server/pull/15054)

#### Enhancements

 * Queue declaration form fields were reordered so that the queue type dropdown comes before
   the virtual host.

   GitHub issue: [#15017](https://github.com/rabbitmq/rabbitmq-server/pull/15017)

 * The order of configured OAuth 2 resource servers is now preserved in the management UI.
   Additionally, a resource server ID can now be pre-selected during service-provider-initiated logons.

   GitHub issue: [#15044](https://github.com/rabbitmq/rabbitmq-server/pull/15044)


### Prometheus Plugin

#### Enhancements

 * `GET /metrics/per-object` responses on systems with thousands of objections now takes 20-30% less time.

   GitHub issue: [#15035](https://github.com/rabbitmq/rabbitmq-server/pull/15035)

 * Prometheus scraping endpoint responses are now streamed instead of being fully buffered before transmission.
   This reduces memory peak footprint and improves response times for nodes with a larger number of objects.

   GitHub issue: [#15018](https://github.com/rabbitmq/rabbitmq-server/pull/15018)

#### Bug Fixes

 * Fixed a dependency loading issue with `ddskerl` (a Prometheus library dependency)
   that could cause `stop_app` to fail.

   GitHub issue: [#15027](https://github.com/rabbitmq/rabbitmq-server/pull/15027)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-queues quorum_status` could run into an exception when a quorum queue member dies before recording any metrics.

   GitHub issue: [#15003](https://github.com/rabbitmq/rabbitmq-server/pull/15003)


### Web MQTT Plugin

#### Bug Fixes

 * The plugin now supports the `mqttv3.1` WebSocket subprotocol in addition to `mqtt`,
   improving compatibility with older MQTT clients.

   GitHub issue: [#15009](https://github.com/rabbitmq/rabbitmq-server/pull/15009)


### AWS Peer Discovery Plugin

#### Bug Fixes

 * The plugin now uses IPv6 discovery endpoints in IPv6-only environments.

   GitHub issue: [#14974](https://github.com/rabbitmq/rabbitmq-server/issues/14974)


### Tracing Plugin

#### Bug Fixes

 * Trace files served via the management UI now include proper UTF-8 charset specification.

   GitHub issue: [#14970](https://github.com/rabbitmq/rabbitmq-server/pull/14970)


### Trust Store Plugin

#### Bug Fixes

 * The plugin now merges user-provided TLS options with the options it needs in a safer manner.

   GitHub issue: [#15116](https://github.com/rabbitmq/rabbitmq-server/pull/15116)


### Dependency Changes

 * `khepri` was upgraded to [`0.17.3`](https://github.com/rabbitmq/khepri/releases/tag/v0.17.3)
 * `seshat` was upgraded to [`1.0.1`](https://github.com/rabbitmq/seshat/releases/tag/v1.0.1)
