// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A Regex filter configured in a guardrail.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailRegexFilter {
    /// <p>The regex filter name.</p>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>The regesx filter match.</p>
    pub r#match: ::std::option::Option<::std::string::String>,
    /// <p>The regex query.</p>
    pub regex: ::std::option::Option<::std::string::String>,
    /// <p>The region filter action.</p>
    pub action: crate::types::GuardrailSensitiveInformationPolicyAction,
    /// <p>Indicates whether custom regex entities that breach the guardrail configuration are detected.</p>
    pub detected: ::std::option::Option<bool>,
}
impl GuardrailRegexFilter {
    /// <p>The regex filter name.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The regesx filter match.</p>
    pub fn r#match(&self) -> ::std::option::Option<&str> {
        self.r#match.as_deref()
    }
    /// <p>The regex query.</p>
    pub fn regex(&self) -> ::std::option::Option<&str> {
        self.regex.as_deref()
    }
    /// <p>The region filter action.</p>
    pub fn action(&self) -> &crate::types::GuardrailSensitiveInformationPolicyAction {
        &self.action
    }
    /// <p>Indicates whether custom regex entities that breach the guardrail configuration are detected.</p>
    pub fn detected(&self) -> ::std::option::Option<bool> {
        self.detected
    }
}
impl GuardrailRegexFilter {
    /// Creates a new builder-style object to manufacture [`GuardrailRegexFilter`](crate::types::GuardrailRegexFilter).
    pub fn builder() -> crate::types::builders::GuardrailRegexFilterBuilder {
        crate::types::builders::GuardrailRegexFilterBuilder::default()
    }
}

/// A builder for [`GuardrailRegexFilter`](crate::types::GuardrailRegexFilter).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailRegexFilterBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) r#match: ::std::option::Option<::std::string::String>,
    pub(crate) regex: ::std::option::Option<::std::string::String>,
    pub(crate) action: ::std::option::Option<crate::types::GuardrailSensitiveInformationPolicyAction>,
    pub(crate) detected: ::std::option::Option<bool>,
}
impl GuardrailRegexFilterBuilder {
    /// <p>The regex filter name.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The regex filter name.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The regex filter name.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The regesx filter match.</p>
    pub fn r#match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.r#match = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The regesx filter match.</p>
    pub fn set_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.r#match = input;
        self
    }
    /// <p>The regesx filter match.</p>
    pub fn get_match(&self) -> &::std::option::Option<::std::string::String> {
        &self.r#match
    }
    /// <p>The regex query.</p>
    pub fn regex(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.regex = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The regex query.</p>
    pub fn set_regex(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.regex = input;
        self
    }
    /// <p>The regex query.</p>
    pub fn get_regex(&self) -> &::std::option::Option<::std::string::String> {
        &self.regex
    }
    /// <p>The region filter action.</p>
    /// This field is required.
    pub fn action(mut self, input: crate::types::GuardrailSensitiveInformationPolicyAction) -> Self {
        self.action = ::std::option::Option::Some(input);
        self
    }
    /// <p>The region filter action.</p>
    pub fn set_action(mut self, input: ::std::option::Option<crate::types::GuardrailSensitiveInformationPolicyAction>) -> Self {
        self.action = input;
        self
    }
    /// <p>The region filter action.</p>
    pub fn get_action(&self) -> &::std::option::Option<crate::types::GuardrailSensitiveInformationPolicyAction> {
        &self.action
    }
    /// <p>Indicates whether custom regex entities that breach the guardrail configuration are detected.</p>
    pub fn detected(mut self, input: bool) -> Self {
        self.detected = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether custom regex entities that breach the guardrail configuration are detected.</p>
    pub fn set_detected(mut self, input: ::std::option::Option<bool>) -> Self {
        self.detected = input;
        self
    }
    /// <p>Indicates whether custom regex entities that breach the guardrail configuration are detected.</p>
    pub fn get_detected(&self) -> &::std::option::Option<bool> {
        &self.detected
    }
    /// Consumes the builder and constructs a [`GuardrailRegexFilter`](crate::types::GuardrailRegexFilter).
    /// This method will fail if any of the following fields are not set:
    /// - [`action`](crate::types::builders::GuardrailRegexFilterBuilder::action)
    pub fn build(self) -> ::std::result::Result<crate::types::GuardrailRegexFilter, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GuardrailRegexFilter {
            name: self.name,
            r#match: self.r#match,
            regex: self.regex,
            action: self.action.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "action",
                    "action was not specified but it is required when building GuardrailRegexFilter",
                )
            })?,
            detected: self.detected,
        })
    }
}
