/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_PW = "Palau";
        final String metaValue_ar = "Arabesch";
        final String metaValue_hy = "Armenesch";
        final String metaValue_ae = "Avestesch";
        final String metaValue_ban = "Balinesesch";
        final String metaValue_bn = "Bengalesch";
        final String metaValue_zbl = "Bliss-Symboler";
        final String metaValue_bug = "Buginesesch";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptesch";
        final String metaValue_ka = "Georgesch";
        final String metaValue_got = "Gotesch";
        final String metaValue_el = "Griichesch";
        final String metaValue_gu = "Gujarati";
        final String metaValue_zh = "Chinesesch";
        final String metaValue_he = "Hebräesch";
        final String metaValue_ja = "Japanesch";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreanesch";
        final String metaValue_lo = "Laotesch";
        final String metaValue_mn = "Mongolesch";
        final String metaValue_my = "Birmanesch";
        final String metaValue_nqo = "N’Ko";
        final String metaValue_ota = "Osmanesch";
        final String metaValue_sam = "Samaritanesch";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_si = "Singhalesesch";
        final String metaValue_su = "Sundanesesch";
        final String metaValue_syr = "Syresch";
        final String metaValue_ta = "Tamilesch";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Dagalog";
        final String metaValue_bo = "Tibetesch";
        final String metaValue_uga = "Ugaritesch";
        final String metaValue_peo = "Alpersesch";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "Welt" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "005", "Südamerika" },
            { "009", "Ozeanien" },
            { "011", "Westafrika" },
            { "013", "Mëttelamerika" },
            { "014", "Ostafrika" },
            { "015", "Nordafrika" },
            { "017", "Zentralafrika" },
            { "018", "Südlecht Afrika" },
            { "019", "Amerika" },
            { "021", "Nërdlecht Amerika" },
            { "029", "Karibik" },
            { "030", "Ostasien" },
            { "034", "Südasien" },
            { "035", "Südostasien" },
            { "039", "Südeuropa" },
            { "053", "Australien an Neiséiland" },
            { "054", "Melanesien" },
            { "057", "Mikronesescht Inselgebitt" },
            { "061", "Polynesien" },
            { "142", "Asien" },
            { "143", "Zentralasien" },
            { "145", "Westasien" },
            { "150", "Europa" },
            { "151", "Osteuropa" },
            { "154", "Nordeuropa" },
            { "155", "Westeuropa" },
            { "419", "Latäinamerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Vereenegt Arabesch Emirater" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua a Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentinien" },
            { "AS", "Amerikanesch-Samoa" },
            { "AT", "Éisträich" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "AX", "Ålandinselen" },
            { "AZ", "Aserbaidschan" },
            { "BA", "Bosnien an Herzegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesch" },
            { "BE", "Belsch" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivien" },
            { "BQ", "Karibescht Holland" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetinsel" },
            { "BW", "Botsuana" },
            { "BY", "Wäissrussland" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosinselen" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Zentralafrikanesch Republik" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schwäiz" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Cookinselen" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbien" },
            { "CP", "Clipperton-Insel" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Curaçao" },
            { "CX", "Chrëschtdagsinsel" },
            { "CY", "Zypern" },
            { "CZ", "Tschechien" },
            { "DE", "Däitschland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dschibuti" },
            { "DK", "Dänemark" },
            { "DM", "Dominica" },
            { "DO", "Dominikanesch Republik" },
            { "DZ", "Algerien" },
            { "EA", "Ceuta a Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "Egypten" },
            { "EH", "Westsahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "Ethiopien" },
            { "EU", "Europäesch Unioun" },
            { "FI", "Finnland" },
            { "FJ", "Fidschi" },
            { "FK", "Falklandinselen" },
            { "FM", "Mikronesien" },
            { "FO", "Färöer" },
            { "FR", "Frankräich" },
            { "GA", "Gabun" },
            { "GB", "Groussbritannien" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Guayane" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grönland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorialguinea" },
            { "GR", "Griicheland" },
            { "GS", "Südgeorgien an déi Südlech Sandwichinselen" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Spezialverwaltungszon Hong Kong" },
            { "HM", "Heard- a McDonald-Inselen" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "IC", "Kanaresch Inselen" },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordanien" },
            { "JP", "Japan" },
            { "KE", "Kenia" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodscha" },
            { "KI", "Kiribati" },
            { "KM", "Komoren" },
            { "KN", "St. Kitts an Nevis" },
            { "KP", "Nordkorea" },
            { "KR", "Südkorea" },
            { "KW", "Kuwait" },
            { "KY", "Kaimaninselen" },
            { "KZ", "Kasachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Lëtzebuerg" },
            { "LV", "Lettland" },
            { "LY", "Libyen" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldawien" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinselen" },
            { "MK", "Nordmazedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolei" },
            { "MO", "Spezialverwaltungszon Macau" },
            { "MP", "Nërdlech Marianen" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiven" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Neikaledonien" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsel" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Holland" },
            { "NO", "Norwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Neiséiland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franséisch-Polynesien" },
            { "PG", "Papua-Neiguinea" },
            { "PH", "Philippinnen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "St. Pierre a Miquelon" },
            { "PN", "Pitcairninselen" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinensesch Autonomiegebidder" },
            { "PT", "Portugal" },
            { "PW", metaValue_PW },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Baussecht Ozeanien" },
            { "RE", "Réunion" },
            { "RO", "Rumänien" },
            { "RS", "Serbien" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "SA", "Saudi-Arabien" },
            { "SB", "Salomonen" },
            { "SC", "Seychellen" },
            { "SD", "Sudan" },
            { "SE", "Schweden" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "SI", "Slowenien" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "SK", "Slowakei" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Südsudan" },
            { "ST", "São Tomé a Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "SZ", "Swasiland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- a Caicosinselen" },
            { "TD", "Tschad" },
            { "TF", "Franséisch Süd- an Antarktisgebidder" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadschikistan" },
            { "TK", "Tokelau" },
            { "TL", "Osttimor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesien" },
            { "TO", "Tonga" },
            { "TR", "Tierkei" },
            { "TT", "Trinidad an Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukrain" },
            { "UG", "Uganda" },
            { "UM", "Amerikanesch-Ozeanien" },
            { "US", "Vereenegt Staaten" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "VA", "Vatikanstad" },
            { "VC", "St. Vincent an d’Grenadinnen" },
            { "VE", "Venezuela" },
            { "VG", "Britesch Joffereninselen" },
            { "VI", "Amerikanesch Joffereninselen" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis a Futuna" },
            { "WS", "Samoa" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Südafrika" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Onbekannt Regioun" },
            { "aa", "Afar" },
            { "ab", "Abchasesch" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharesch" },
            { "an", "Aragonesesch" },
            { "ar", metaValue_ar },
            { "as", "Assamesesch" },
            { "av", "Awaresch" },
            { "ay", "Aymara" },
            { "az", "Aserbaidschanesch" },
            { "ba", "Baschkiresch" },
            { "be", "Wäissrussesch" },
            { "bg", "Bulgaresch" },
            { "bi", "Bislama" },
            { "bm", "Bambara-Sprooch" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Bretonesch" },
            { "bs", "Bosnesch" },
            { "ca", "Katalanesch" },
            { "ce", "Tschetschenesch" },
            { "ch", "Chamorro-Sprooch" },
            { "co", "Korsesch" },
            { "cr", "Cree" },
            { "cs", "Tschechesch" },
            { "cu", "Kiercheslawesch" },
            { "cv", "Tschuwaschesch" },
            { "cy", "Walisesch" },
            { "da", "Dänesch" },
            { "de", "Däitsch" },
            { "dv", "Maldivesch" },
            { "dz", "Bhutanesch" },
            { "ee", "Ewe-Sprooch" },
            { "el", metaValue_el },
            { "en", "Englesch" },
            { "eo", "Esperanto" },
            { "es", "Spuenesch" },
            { "et", "Estnesch" },
            { "eu", "Baskesch" },
            { "fa", "Persesch" },
            { "ff", "Ful" },
            { "fi", "Finnesch" },
            { "fj", "Fidschianesch" },
            { "fo", "Färöesch" },
            { "fr", "Franséisch" },
            { "fy", "Westfriesesch" },
            { "ga", "Iresch" },
            { "gd", "Schottescht Gällesch" },
            { "gl", "Galizesch" },
            { "gn", "Guarani" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "ho", "Hiri-Motu" },
            { "hr", "Kroatesch" },
            { "ht", "Haitianesch" },
            { "hu", "Ungaresch" },
            { "hy", metaValue_hy },
            { "hz", "Herero-Sprooch" },
            { "ia", "Interlingua" },
            { "id", "Indonesesch" },
            { "ie", "Interlingue" },
            { "ig", "Igbo-Sprooch" },
            { "ii", "Sichuan Yi" },
            { "ik", "Inupiak" },
            { "io", "Ido-Sprooch" },
            { "is", "Islännesch" },
            { "it", "Italienesch" },
            { "iu", "Inukitut" },
            { "ja", metaValue_ja },
            { "jv", "Javanesch" },
            { "ka", metaValue_ka },
            { "kg", "Kongolesesch" },
            { "ki", "Kikuyu-Sprooch" },
            { "kj", "Kwanyama" },
            { "kk", "Kasachesch" },
            { "kl", "Grönlännesch" },
            { "km", "Kambodschanesch" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri-Sprooch" },
            { "ks", "Kaschmiresch" },
            { "ku", "Kurdesch" },
            { "kv", "Komi-Sprooch" },
            { "kw", "Kornesch" },
            { "ky", "Kirgisesch" },
            { "la", "Latäin" },
            { "lb", "Lëtzebuergesch" },
            { "lg", "Ganda-Sprooch" },
            { "li", "Limburgesch" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Litauesch" },
            { "lu", "Luba-Katanga" },
            { "lv", "Lettesch" },
            { "mg", "Malagassi-Sprooch" },
            { "mh", "Marschallesesch" },
            { "mi", "Maori" },
            { "mk", "Mazedonesch" },
            { "ml", "Malayalam" },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaiesch" },
            { "mt", "Maltesesch" },
            { "my", metaValue_my },
            { "na", "Nauruesch" },
            { "nb", "Norwegesch Bokmål" },
            { "nd", "Nord-Ndebele-Sprooch" },
            { "ne", "Nepalesesch" },
            { "ng", "Ndonga" },
            { "nl", "Hollännesch" },
            { "nn", "Norwegesch Nynorsk" },
            { "no", "Norwegesch" },
            { "nr", "Süd-Ndebele-Sprooch" },
            { "nv", "Navajo" },
            { "ny", "Nyanja-Sprooch" },
            { "oc", "Okzitanesch" },
            { "oj", "Ojibwa-Sprooch" },
            { "om", "Oromo" },
            { "or", "Orija" },
            { "os", "Ossetesch" },
            { "pa", "Pandschabesch" },
            { "pi", "Pali" },
            { "pl", "Polnesch" },
            { "ps", "Paschtu" },
            { "pt", "Portugisesch" },
            { "qu", "Quechua" },
            { "rm", "Rätoromanesch" },
            { "rn", "Rundi-Sprooch" },
            { "ro", "Rumänesch" },
            { "ru", "Russesch" },
            { "rw", "Ruandesch" },
            { "sa", "Sanskrit" },
            { "sc", "Sardesch" },
            { "sd", "Sindhi" },
            { "se", "Nordsamesch" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroatesch" },
            { "si", metaValue_si },
            { "sk", "Slowakesch" },
            { "sl", "Slowenesch" },
            { "sm", "Samoanesch" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albanesch" },
            { "sr", "Serbesch" },
            { "ss", "Swazi" },
            { "st", "Süd-Sotho-Sprooch" },
            { "su", metaValue_su },
            { "sv", "Schwedesch" },
            { "sw", "Suaheli" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tadschikesch" },
            { "th", "Thailännesch" },
            { "ti", "Tigrinja" },
            { "tk", "Turkmenesch" },
            { "tl", metaValue_tl },
            { "tn", "Tswana-Sprooch" },
            { "to", "Tongaesch" },
            { "tr", "Tierkesch" },
            { "ts", "Tsonga" },
            { "tt", "Tataresch" },
            { "tw", "Twi" },
            { "ty", "Tahitesch" },
            { "ug", "Uiguresch" },
            { "uk", "Ukrainesch" },
            { "ur", "Urdu" },
            { "uz", "Usbekesch" },
            { "ve", "Venda-Sprooch" },
            { "vi", "Vietnamesesch" },
            { "vo", "Volapük" },
            { "wa", "Wallounesch" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Jiddesch" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", metaValue_zh },
            { "zu", "Zulu" },
            { "ace", "Aceh-Sprooch" },
            { "ach", "Acholi-Sprooch" },
            { "ada", "Adangme" },
            { "ady", "Adygéiesch" },
            { "aeb", "Tunesescht Arabesch" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Ainu-Sprooch" },
            { "akk", "Akkadesch" },
            { "akz", "Alabama" },
            { "ale", "Aleutesch" },
            { "aln", "Gegesch" },
            { "alt", "Süd-Alaesch" },
            { "ang", "Alenglesch" },
            { "anp", "Angika" },
            { "arc", "Aramäesch" },
            { "arn", "Mapudungun" },
            { "aro", "Araona" },
            { "arp", "Arapaho-Sprooch" },
            { "arq", "Algerescht Arabesch" },
            { "arw", "Arawak-Sprooch" },
            { "ary", "Marokkanescht Arabesch" },
            { "arz", "Egyptescht Arabesch" },
            { "asa", "Asu (Tanzania)" },
            { "ase", "Amerikanesch Zeechesprooch" },
            { "ast", "Asturianesch" },
            { "avk", "Kotava" },
            { "awa", "Awadhi" },
            { "bal", "Belutschesch" },
            { "ban", metaValue_ban },
            { "bar", "Bairesch" },
            { "bas", "Basaa-Sprooch" },
            { "bax", "Bamun" },
            { "bbc", "Batak Toba" },
            { "bbj", "Ghomálá’" },
            { "bej", "Bedauye" },
            { "bem", "Bemba-Sprooch" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bfq", "Badaga" },
            { "bho", "Bhodschpuri" },
            { "bik", "Bikol-Sprooch" },
            { "bin", "Bini-Sprooch" },
            { "bjn", "Banjaresesch" },
            { "bkm", "Kom" },
            { "bla", "Blackfoot-Sprooch" },
            { "bpy", "Bishnupriya" },
            { "bqi", "Bachtiaresch" },
            { "bra", "Braj-Bhakha" },
            { "brh", "Brahui" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Burjatesch" },
            { "bug", metaValue_bug },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Caddo" },
            { "car", "Karibesch" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ceb", "Cebuano" },
            { "cgg", "Kiga" },
            { "chb", "Chibcha-Sprooch" },
            { "chg", "Tschagataesch" },
            { "chk", "Trukesesch" },
            { "chm", "Mari" },
            { "chn", "Chinook" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "ckb", "Sorani" },
            { "cop", metaValue_cop },
            { "cps", "Capiznon" },
            { "crh", "Krimtataresch" },
            { "csb", "Kaschubesch" },
            { "dak", "Dakota-Sprooch" },
            { "dar", "Darginesch" },
            { "dav", "Taita" },
            { "del", "Delaware-Sprooch" },
            { "den", "Slave" },
            { "dgr", "Dogrib" },
            { "din", "Dinka-Sprooch" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Niddersorbesch" },
            { "dtp", "Zentral-Dusun" },
            { "dua", "Duala" },
            { "dum", "Mëttelhollännesch" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula-Sprooch" },
            { "dzg", "Dazaga" },
            { "ebu", "Kiembu" },
            { "efi", "Efik" },
            { "egl", "Emilianesch" },
            { "egy", "Egyptesch" },
            { "eka", "Ekajuk" },
            { "elx", "Elamesch" },
            { "enm", "Mëttelenglesch" },
            { "esu", "Yup’ik" },
            { "ewo", "Ewondo" },
            { "ext", "Extremaduresch" },
            { "fan", "Pangwe-Sprooch" },
            { "fat", "Fanti-Sprooch" },
            { "fil", "Filipino" },
            { "fit", "Meänkieli" },
            { "fon", "Fon-Sprooch" },
            { "frc", "Cajun" },
            { "frm", "Mëttelfranséisch" },
            { "fro", "Alfranséisch" },
            { "frp", "Frankoprovenzalesch" },
            { "frr", "Nordfriesesch" },
            { "frs", "Ostfriesesch" },
            { "fur", "Friulesch" },
            { "gaa", "Ga-Sprooch" },
            { "gag", "Gagausesch" },
            { "gan", "Gan-Chinesesch" },
            { "gay", "Gayo" },
            { "gba", "Gbaya-Sprooch" },
            { "gbz", "Zoroastrianescht Dari" },
            { "gez", "Geez" },
            { "gil", "Gilbertesesch" },
            { "glk", "Gilaki" },
            { "gmh", "Mëttelhéichdäitsch" },
            { "goh", "Alhéichdäitsch" },
            { "gon", "Gondi-Sprooch" },
            { "gor", "Mongondou" },
            { "got", metaValue_got },
            { "grb", "Grebo-Sprooch" },
            { "grc", "Algriichesch" },
            { "gsw", "Schwäizerdäitsch" },
            { "guc", "Wayuu" },
            { "gur", "Farefare" },
            { "guz", "Gusii-Sprooch" },
            { "gwi", "Kutchin-Sprooch" },
            { "hai", "Haida-Sprooch" },
            { "hak", "Hakka-Chinesesch" },
            { "haw", "Hawaiesch" },
            { "hif", "Fidschi-Hindi" },
            { "hil", "Hiligaynon-Sprooch" },
            { "hit", "Hethitesch" },
            { "hmn", "Miao-Sprooch" },
            { "hsb", "Uewersorbesch" },
            { "hsn", "Xiang-Chinesesch" },
            { "hup", "Hupa" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ilo", "Ilokano-Sprooch" },
            { "inh", "Inguschesch" },
            { "izh", "Ischoresch" },
            { "jam", "Jamaikanesch-Kreolesch" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Jiddesch-Persesch" },
            { "jrb", "Jiddesch-Arabesch" },
            { "jut", "Jütesch" },
            { "kaa", "Karakalpakesch" },
            { "kab", "Kabylesch" },
            { "kac", "Kachin-Sprooch" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardinesch" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi-Sprooch" },
            { "kho", "Sakesch" },
            { "khq", "Koyra Chiini" },
            { "khw", "Khowar" },
            { "kiu", "Kirmanjki" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu-Sprooch" },
            { "koi", "Komi-Permiak" },
            { "kok", "Konkani" },
            { "kos", "Kosraeanesch" },
            { "kpe", "Kpelle-Sprooch" },
            { "krc", "Karatschaiesch-Balkaresch" },
            { "kri", "Krio" },
            { "krj", "Kinaray-a" },
            { "krl", "Karelesch" },
            { "kru", "Oraon-Sprooch" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Kölsch" },
            { "kum", "Kumükesch" },
            { "kut", "Kutenai-Sprooch" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba-Sprooch" },
            { "lez", "Lesgesch" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "Liguresch" },
            { "liv", "Livesch" },
            { "lkt", "Lakota-Sprooch" },
            { "lmo", "Lombardesch" },
            { "lol", "Mongo" },
            { "loz", "Rotse-Sprooch" },
            { "ltg", "Lettgallesch" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno-Sprooch" },
            { "lun", "Lunda-Sprooch" },
            { "luo", "Luo-Sprooch" },
            { "lus", "Lushai-Sprooch" },
            { "luy", "Olulujia" },
            { "lzh", "Klassescht Chinesesch" },
            { "lzz", "Lasesch Sprooch" },
            { "mad", "Maduresesch" },
            { "maf", "Mafa" },
            { "mag", "Khotta" },
            { "mai", "Maithili" },
            { "mak", "Makassaresch" },
            { "man", "Manding-Sprooch" },
            { "mas", "Massai-Sprooch" },
            { "mde", "Maba" },
            { "mdf", "Moksha" },
            { "mdr", "Mandaresesch" },
            { "men", "Mende-Sprooch" },
            { "mer", "Meru-Sprooch" },
            { "mfe", "Morisyen" },
            { "mga", "Mëtteliresch" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta’" },
            { "mic", "Micmac-Sprooch" },
            { "min", "Minangkabau-Sprooch" },
            { "mnc", "Mandschuresch" },
            { "mni", "Meithei-Sprooch" },
            { "moh", "Mohawk-Sprooch" },
            { "mos", "Mossi-Sprooch" },
            { "mrj", "West-Mari" },
            { "mua", "Mundang" },
            { "mul", "Méisproocheg" },
            { "mus", "Muskogee-Sprooch" },
            { "mwl", "Mirandesesch" },
            { "mwr", "Marwari" },
            { "mwv", "Mentawai" },
            { "mye", "Myene" },
            { "myv", "Ersja-Mordwinesch" },
            { "mzn", "Mazandarani" },
            { "nan", "Min-Nan-Chinesesch" },
            { "nap", "Neapolitanesch" },
            { "naq", "Nama" },
            { "nds", "Nidderdäitsch" },
            { "new", "Newari" },
            { "nia", "Nias-Sprooch" },
            { "niu", "Niue-Sprooch" },
            { "njo", "Ao Naga" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Alnordesch" },
            { "nov", "Novial" },
            { "nqo", metaValue_nqo },
            { "nso", "Nord-Sotho-Sprooch" },
            { "nus", "Nuer" },
            { "nwc", "Al-Newari" },
            { "nym", "Nyamwezi-Sprooch" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "osa", "Osage-Sprooch" },
            { "ota", metaValue_ota },
            { "pag", "Pangasinan-Sprooch" },
            { "pal", "Mëttelpersesch" },
            { "pam", "Pampanggan-Sprooch" },
            { "pap", "Papiamento" },
            { "pau", metaValue_PW },
            { "pcd", "Picardesch" },
            { "pdc", "Pennsylvaniadäitsch" },
            { "pdt", "Plattdäitsch" },
            { "peo", metaValue_peo },
            { "pfl", "Pfälzesch Däitsch" },
            { "phn", "Phönikesch" },
            { "pms", "Piemontesesch" },
            { "pnt", "Pontesch" },
            { "pon", "Ponapeanesch" },
            { "prg", "Preisesch" },
            { "pro", "Alprovenzalesch" },
            { "quc", "Quiché-Sprooch" },
            { "qug", "Kichwa (Chimborazo-Gebidder)" },
            { "raj", "Rajasthani" },
            { "rap", "Ouschterinsel-Sprooch" },
            { "rar", "Rarotonganesch" },
            { "rgn", "Romagnol" },
            { "rif", "Tarifit" },
            { "rof", "Rombo" },
            { "rom", "Romani" },
            { "rtm", "Rotumanesch" },
            { "rue", "Russinesch" },
            { "rug", "Roviana" },
            { "rup", "Aromunesch" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe-Sprooch" },
            { "sah", "Jakutesch" },
            { "sam", metaValue_sam },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "saz", metaValue_saz },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sizilianesch" },
            { "sco", "Schottesch" },
            { "sdc", "Sassaresesch" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selkupesch" },
            { "ses", "Koyra Senni" },
            { "sga", "Aliresch" },
            { "sgs", "Samogitesch" },
            { "shi", "Taschelhit" },
            { "shn", "Schan-Sprooch" },
            { "shu", "Tschadesch-Arabesch" },
            { "sid", "Sidamo" },
            { "sli", "Nidderschlesesch" },
            { "sly", "Selayar" },
            { "sma", "Südsamesch" },
            { "smj", "Lule-Lappesch" },
            { "smn", "Inari-Lappesch" },
            { "sms", "Skolt-Lappesch" },
            { "snk", "Soninke-Sprooch" },
            { "sog", "Sogdesch" },
            { "srn", "Srananesch" },
            { "srr", "Serer-Sprooch" },
            { "ssy", metaValue_ssy },
            { "stq", "Saterfriesesch" },
            { "suk", "Sukuma-Sprooch" },
            { "sus", "Susu" },
            { "sux", "Sumeresch" },
            { "swb", "Komoresch" },
            { "syc", "Alsyresch" },
            { "syr", metaValue_syr },
            { "szl", "Schlesesch" },
            { "tcy", "Tulu" },
            { "tem", "Temne" },
            { "teo", "Teso" },
            { "ter", "Tereno-Sprooch" },
            { "tet", "Tetum-Sprooch" },
            { "tig", "Tigre" },
            { "tiv", "Tiv-Sprooch" },
            { "tkl", "Tokelauanesch" },
            { "tkr", "Tsachuresch" },
            { "tlh", "Klingonesch" },
            { "tli", "Tlingit-Sprooch" },
            { "tly", "Talesch" },
            { "tmh", "Tamaseq" },
            { "tog", "Tsonga-Sprooch" },
            { "tpi", "Neimelanesesch" },
            { "tru", "Turoyo" },
            { "trv", "Seediq" },
            { "tsd", "Tsakonesch" },
            { "tsi", "Tsimshian-Sprooch" },
            { "ttt", "Tatesch" },
            { "tum", "Tumbuka-Sprooch" },
            { "tvl", "Elliceanesch" },
            { "twq", "Tasawaq" },
            { "tyv", "Tuwinesch" },
            { "tzm", "Mëttlert-Atlas-Tamazight" },
            { "udm", "Udmurtesch" },
            { "uga", metaValue_uga },
            { "umb", "Mbundu-Sprooch" },
            { "und", "Onbestëmmt Sprooch" },
            { "vai", "Vai-Sprooch" },
            { "vec", "Venezesch" },
            { "vep", "Wepsesch" },
            { "vls", "Westflämesch" },
            { "vmf", "Mainfränkesch" },
            { "vot", "Wotesch" },
            { "vro", "Voro" },
            { "vun", "Vunjo" },
            { "wae", "Walliserdäitsch" },
            { "wal", "Walamo-Sprooch" },
            { "war", "Waray" },
            { "was", "Washo-Sprooch" },
            { "wuu", "Wu-Chinesesch" },
            { "xal", "Kalmückesch" },
            { "xmf", "Mingrelesch Sprooch" },
            { "xog", "Soga" },
            { "yao", "Yao-Sprooch" },
            { "yap", "Yapesesch" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kantonesesch" },
            { "zap", "Zapotekesch" },
            { "zbl", metaValue_zbl },
            { "zea", "Seelännesch" },
            { "zen", "Zenaga" },
            { "zgh", "Marokkanescht Standard-Tamazight" },
            { "zun", "Zuni-Sprooch" },
            { "zxx", "Keng Sproochinhalter" },
            { "zza", "Zaza" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "Battakesch" },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Blanneschrëft" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cans", "UCAS" },
            { "Cari", "Karesch" },
            { "Cher", metaValue_chr },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "Zypriotesch" },
            { "Cyrl", "Kyrillesch" },
            { "Cyrs", "Alkiercheslawesch" },
            { "Deva", "Devanagari" },
            { "Dsrt", "Deseret" },
            { "Egyd", "Egyptesch-Demotesch" },
            { "Egyh", "Egyptesch-Hieratesch" },
            { "Egyp", "Egyptesch Hieroglyphen" },
            { "Ethi", "Ethiopesch" },
            { "Geok", "Khutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "Glagolitesch" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hang", "Hangul" },
            { "Hani", metaValue_zh },
            { "Hano", "Hanunoo" },
            { "Hans", "Vereinfacht" },
            { "Hant", "Traditionell" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hmng", "Pahawh Hmong" },
            { "Hrkt", "Katakana oder Hiragana" },
            { "Hung", "Alungaresch" },
            { "Inds", "Indus-Schrëft" },
            { "Ital", "Alitalesch" },
            { "Java", "Javanesesch" },
            { "Jpan", metaValue_ja },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Khmer" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Lana", "Lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "Laténgesch-Fraktur-Variant" },
            { "Latg", "Laténgesch-Gällesch Variant" },
            { "Latn", "Laténgesch" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lyci", "Lykesch" },
            { "Lydi", "Lydesch" },
            { "Mand", "Mandäesch" },
            { "Mani", "Manichäesch" },
            { "Maya", "Maya-Hieroglyphen" },
            { "Mero", "Meroitesch" },
            { "Mlym", "Malaysesch" },
            { "Mong", metaValue_mn },
            { "Moon", "Moon" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orchon-Runen" },
            { "Orya", "Oriya" },
            { "Osma", metaValue_ota },
            { "Perm", "Alpermesch" },
            { "Phag", "Phags-pa" },
            { "Phlv", "Pahlavi" },
            { "Phnx", "Phönizesch" },
            { "Plrd", "Pollard Phonetesch" },
            { "Rjng", "Rejang" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runeschrëft" },
            { "Samr", metaValue_sam },
            { "Sara", "Sarati" },
            { "Saur", metaValue_saz },
            { "Sgnw", "Zeechesprooch" },
            { "Shaw", "Shaw-Alphabet" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "Syresch-Estrangelo-Variant" },
            { "Syrj", "Westsyresch" },
            { "Syrn", "Ostsyresch" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Thai", "Thai" },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", "Vai" },
            { "Visp", "Siichtbar Sprooch" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "Sumeresch-akkadesch Keilschrëft" },
            { "Yiii", "Yi" },
            { "Zinh", "Geierfte Schrëftwäert" },
            { "Zsym", "Symboler" },
            { "Zxxx", "Ouni Schrëft" },
            { "Zyyy", "Onbestëmmt" },
            { "Zzzz", "Oncodéiert Schrëft" },
            { "de_AT", "Éisträichescht Däitsch" },
            { "de_CH", "Schwäizer Héichdäitsch" },
            { "en_AU", "Australescht Englesch" },
            { "en_CA", "Kanadescht Englesch" },
            { "en_GB", "Britescht Englesch" },
            { "en_US", "Amerikanescht Englesch" },
            { "es_ES", "Europäescht Spuenesch" },
            { "es_MX", "Mexikanescht Spuenesch" },
            { "fr_CA", "Kanadescht Franséisch" },
            { "fr_CH", "Schwäizer Franséisch" },
            { "nl_BE", "Flämesch" },
            { "pt_BR", "Brasilianescht Portugisesch" },
            { "pt_PT", "Europäescht Portugisesch" },
            { "ro_MD", "Moldawesch" },
            { "sw_CD", "Kongo-Swahili" },
            { "%%1901", "Al Däitsch Rechtschreiwung" },
            { "%%1994", "Standardiséiert Resianesch Rechtschreiwung" },
            { "%%1996", "Nei Däitsch Rechtschreiwung" },
            { "ar_001", "Modernt Héicharabesch" },
            { "es_419", "Latäinamerikanescht Spuenesch" },
            { "key.ca", "Kalenner" },
            { "key.co", "Zortéierung" },
            { "key.cu", "Währung" },
            { "key.nu", "Zuelen" },
            { "%%ALUKU", "Aluku-Dialekt" },
            { "%%BARLA", "Barlavento-Dialektgrupp vu Kabuverdianu" },
            { "%%BISKE", "Bela-Dialekt" },
            { "%%BOONT", "Boontling" },
            { "%%KKCOR", "Allgemeng Rechtschreiwung" },
            { "%%KSCOR", "Standard-Rechtschreiwung" },
            { "%%LIPAW", "Lipovaz-Dialekt" },
            { "%%NEDIS", "Natisone-Dialekt" },
            { "%%NJIVA", "Njiva-Dialekt" },
            { "%%NULIK", "Modernt Volapük" },
            { "%%OSOJS", "Osojane-Dialekt" },
            { "%%POSIX", "Computer" },
            { "%%ROZAJ", "Resianesch" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Solbica-Dialekt" },
            { "%%SOTAV", "Sotavento-Dialekt-Grupp vu Kabuverdianu" },
            { "%%UCCOR", "Vereenheetlecht Rechtschreiwung" },
            { "zh_Hans", "Chinesesch (vereinfacht)" },
            { "zh_Hant", "Chinesesch (traditionell)" },
            { "%%DAJNKO", "Dajnko-Alphabet" },
            { "%%EKAVSK", "Serbesch mat Ekavian-Aussprooch" },
            { "%%FONIPA", "Phonetesch (IPA)" },
            { "%%FONUPA", "Phonetesch (UPA)" },
            { "%%NDYUKA", "Ndyuka-Dialekt" },
            { "%%PAMAKA", "Pamaka-Dialekt" },
            { "%%PINYIN", "Pinyin" },
            { "%%SCOUSE", "Scouse-Dialekt" },
            { "%%TARASK", "Taraskievica-Orthographie" },
            { "%%UCRCOR", "Vereenheetlecht iwwerschafft Rechtschreiwung" },
            { "%%UNIFON", "Phonetescht Unifon-Alphabet" },
            { "%%ALALC97", "ALA-LC-Romaniséierung, Editioun vun 1997" },
            { "%%AREVELA", "Ostarmenesch" },
            { "%%AREVMDA", "Westarmenesch" },
            { "%%BALANKA", "Balanka-Dialekt vun Anii" },
            { "%%BOHORIC", "Bohorič-Alphabet" },
            { "%%EMODENG", "Fréit Modernt Englesch" },
            { "%%HEPBURN", "Hepburn-Romaniséierung" },
            { "%%METELKO", "Metelko-Alphabet" },
            { "%%MONOTON", "Monotonesch" },
            { "%%POLYTON", "Polytonesch" },
            { "%%REVISED", "Revidéiert Rechtschreiwung" },
            { "%%1606NICT", "Spéit Mëttelfranséisch" },
            { "%%1694ACAD", "Klassescht Franséisch" },
            { "%%1959ACAD", "Akademesch" },
            { "%%BAKU1926", "Eenheetlecht Tierkescht Alphabet" },
            { "%%IJEKAVSK", "Serbesch mat Ijekavian-Aussprooch" },
            { "%%SCOTLAND", "Schottescht Standardenglesch" },
            { "%%VALENCIA", "Valencianesch" },
            { "%%WADEGILE", "Wade-Giles" },
            { "type.ca.roc", "Kalenner vun der Republik China" },
            { "type.co.eor", "Europäesch Zortéierregelen" },
            { "type.nu.arab", "Arabesch-indesch Zifferen" },
            { "type.nu.armn", "Armenesch Zifferen" },
            { "type.nu.beng", "Bengalesch Zifferen" },
            { "type.nu.deva", "Devanagari-Zifferen" },
            { "type.nu.ethi", "Ethiopesch Zifferen" },
            { "type.nu.geor", "Georgesch Zifferen" },
            { "type.nu.grek", "Griichesch Zifferen" },
            { "type.nu.gujr", "Gujarati-Zifferen" },
            { "type.nu.guru", "Gurmukhi-Zifferen" },
            { "type.nu.hans", "Vereinfacht-Chinesesch Zifferen" },
            { "type.nu.hant", "Traditionell-Chinesesch Zifferen" },
            { "type.nu.hebr", "Hebräesch Zifferen" },
            { "type.nu.jpan", "Japanesch Zifferen" },
            { "type.nu.khmr", "Khmer-Zifferen" },
            { "type.nu.knda", "Kannada-Zifferen" },
            { "type.nu.laoo", "Laotesch Zifferen" },
            { "type.nu.latn", "Westlech Zifferen" },
            { "type.nu.mlym", "Malayalam-Zifferen" },
            { "type.nu.mong", "Mongolesch Zifferen" },
            { "type.nu.mymr", "Myanmar-Zifferen" },
            { "type.nu.orya", "Oriya-Zifferen" },
            { "type.nu.taml", "Tamilesch Zifferen" },
            { "type.nu.telu", "Telugu-Zifferen" },
            { "type.nu.thai", "Thai-Zifferen" },
            { "type.nu.tibt", "Tibetesch Zifferen" },
            { "type.nu.vaii", "Vai-Zifferen" },
            { "type.ca.dangi", "Dangi-Kalenner" },
            { "type.co.ducet", "Unicode-Zortéierung" },
            { "type.nu.roman", "Réimesch Zifferen" },
            { "type.ca.coptic", "Koptesche Kalenner" },
            { "type.ca.hebrew", "Hebräesche Kalenner" },
            { "type.ca.indian", "Indeschen Nationalkalenner" },
            { "type.co.pinyin", "Pinyin-Zortéierregelen" },
            { "type.co.search", "Allgemeng Sich" },
            { "type.co.stroke", "Stréchfolleg" },
            { "type.co.unihan", "Radikal-Stréch-Zortéierregelen" },
            { "type.co.zhuyin", "Zhuyin-Zortéierregelen" },
            { "type.ca.chinese", "Chinesesche Kalenner" },
            { "type.ca.iso8601", "ISO-8601-Kalenner" },
            { "type.ca.persian", "Persesche Kalenner" },
            { "type.nu.arabext", "Erweidert arabesch-indesch Zifferen" },
            { "type.nu.armnlow", "Armenesch Zifferen a Klengschrëft" },
            { "type.nu.greklow", "Griichesch Zifferen a Klengschrëft" },
            { "type.nu.hanidec", "Chinesesch Dezimalzuelen" },
            { "type.nu.hansfin", "Vereinfacht-Chinesesch Finanzzifferen" },
            { "type.nu.hantfin", "Traditionell-Chinesesch Finanzzifferen" },
            { "type.nu.jpanfin", "Japanesch Finanzzifferen" },
            { "type.nu.tamldec", "Tamil-Zifferen" },
            { "type.ca.buddhist", "Buddhistesche Kalenner" },
            { "type.ca.ethiopic", "Ethiopesche Kalenner" },
            { "type.ca.japanese", "Japanesche Kalenner" },
            { "type.co.searchjl", "Sich no Ufanksbuschtawen aus dem koreaneschen Alphabet" },
            { "type.co.standard", "Standard Zortéierreiefolleg" },
            { "type.nu.fullwide", "Vollbreet Zifferen" },
            { "type.nu.romanlow", "Réimesch Zifferen a Klengschrëft" },
            { "type.ca.gregorian", "Gregorianesche Kalenner" },
            { "type.co.phonebook", "Telefonsbuch-Zortéierung" },
            { "type.co.dictionary", "Lexikographesch Zortéierreiefolleg" },
            { "type.co.traditional", "Traditionell Zortéierregelen" },
            { "type.ca.ethiopic-amete-alem", "Ethiopesche Kalenner \"Amete Alem\"" },
        };
        return data;
    }
}
