// Code generated by go-swagger; DO NOT EDIT.

package consul_telemetry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-consul-telemetry-gateway/preview/2023-04-14/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// AgentTelemetryConfigReader is a Reader for the AgentTelemetryConfig structure.
type AgentTelemetryConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AgentTelemetryConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAgentTelemetryConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAgentTelemetryConfigDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAgentTelemetryConfigOK creates a AgentTelemetryConfigOK with default headers values
func NewAgentTelemetryConfigOK() *AgentTelemetryConfigOK {
	return &AgentTelemetryConfigOK{}
}

/*
AgentTelemetryConfigOK describes a response with status code 200, with default header values.

A successful response.
*/
type AgentTelemetryConfigOK struct {
	Payload *models.HashicorpCloudConsulTelemetry20230414AgentTelemetryConfigResponse
}

// IsSuccess returns true when this agent telemetry config o k response has a 2xx status code
func (o *AgentTelemetryConfigOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this agent telemetry config o k response has a 3xx status code
func (o *AgentTelemetryConfigOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this agent telemetry config o k response has a 4xx status code
func (o *AgentTelemetryConfigOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this agent telemetry config o k response has a 5xx status code
func (o *AgentTelemetryConfigOK) IsServerError() bool {
	return false
}

// IsCode returns true when this agent telemetry config o k response a status code equal to that given
func (o *AgentTelemetryConfigOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the agent telemetry config o k response
func (o *AgentTelemetryConfigOK) Code() int {
	return 200
}

func (o *AgentTelemetryConfigOK) Error() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/agent/telemetry_config][%d] agentTelemetryConfigOK  %+v", 200, o.Payload)
}

func (o *AgentTelemetryConfigOK) String() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/agent/telemetry_config][%d] agentTelemetryConfigOK  %+v", 200, o.Payload)
}

func (o *AgentTelemetryConfigOK) GetPayload() *models.HashicorpCloudConsulTelemetry20230414AgentTelemetryConfigResponse {
	return o.Payload
}

func (o *AgentTelemetryConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulTelemetry20230414AgentTelemetryConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAgentTelemetryConfigDefault creates a AgentTelemetryConfigDefault with default headers values
func NewAgentTelemetryConfigDefault(code int) *AgentTelemetryConfigDefault {
	return &AgentTelemetryConfigDefault{
		_statusCode: code,
	}
}

/*
AgentTelemetryConfigDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type AgentTelemetryConfigDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this agent telemetry config default response has a 2xx status code
func (o *AgentTelemetryConfigDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this agent telemetry config default response has a 3xx status code
func (o *AgentTelemetryConfigDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this agent telemetry config default response has a 4xx status code
func (o *AgentTelemetryConfigDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this agent telemetry config default response has a 5xx status code
func (o *AgentTelemetryConfigDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this agent telemetry config default response a status code equal to that given
func (o *AgentTelemetryConfigDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the agent telemetry config default response
func (o *AgentTelemetryConfigDefault) Code() int {
	return o._statusCode
}

func (o *AgentTelemetryConfigDefault) Error() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/agent/telemetry_config][%d] AgentTelemetryConfig default  %+v", o._statusCode, o.Payload)
}

func (o *AgentTelemetryConfigDefault) String() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/agent/telemetry_config][%d] AgentTelemetryConfig default  %+v", o._statusCode, o.Payload)
}

func (o *AgentTelemetryConfigDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *AgentTelemetryConfigDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AgentTelemetryConfigBody agent telemetry config body
swagger:model AgentTelemetryConfigBody
*/
type AgentTelemetryConfigBody struct {

	// location
	Location *AgentTelemetryConfigParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this agent telemetry config body
func (o *AgentTelemetryConfigBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AgentTelemetryConfigBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this agent telemetry config body based on the context it is used
func (o *AgentTelemetryConfigBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AgentTelemetryConfigBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AgentTelemetryConfigBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AgentTelemetryConfigBody) UnmarshalBinary(b []byte) error {
	var res AgentTelemetryConfigBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AgentTelemetryConfigParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model AgentTelemetryConfigParamsBodyLocation
*/
type AgentTelemetryConfigParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this agent telemetry config params body location
func (o *AgentTelemetryConfigParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AgentTelemetryConfigParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this agent telemetry config params body location based on the context it is used
func (o *AgentTelemetryConfigParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AgentTelemetryConfigParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AgentTelemetryConfigParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AgentTelemetryConfigParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res AgentTelemetryConfigParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
