//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntdirectoryentry?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntDirectoryEntry {
    pub tableTag: FourCharCode,
    pub checkSum: u32,
    pub offset: u32,
    pub length: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntDirectoryEntry {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntDirectoryEntry",
        &[
            <FourCharCode>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntDirectoryEntry {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntdirectory?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntDirectory {
    pub format: FourCharCode,
    pub numOffsets: u16,
    pub searchRange: u16,
    pub entrySelector: u16,
    pub rangeShift: u16,
    pub table: [sfntDirectoryEntry; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntDirectory {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntDirectory",
        &[
            <FourCharCode>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <[sfntDirectoryEntry; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntDirectory {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntdirectory?language=objc)
pub const sizeof_sfntDirectory: c_uint = 12;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/cmapfonttabletag?language=objc)
pub const cmapFontTableTag: c_uint = 0x636D6170;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontunicodeplatform?language=objc)
pub const kFontUnicodePlatform: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmacintoshplatform?language=objc)
pub const kFontMacintoshPlatform: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontreservedplatform?language=objc)
pub const kFontReservedPlatform: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmicrosoftplatform?language=objc)
pub const kFontMicrosoftPlatform: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontcustomplatform?language=objc)
pub const kFontCustomPlatform: c_uint = 4;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontunicodedefaultsemantics?language=objc)
pub const kFontUnicodeDefaultSemantics: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontunicodev1_1semantics?language=objc)
pub const kFontUnicodeV1_1Semantics: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontiso10646_1993semantics?language=objc)
pub const kFontISO10646_1993Semantics: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontunicodev2_0bmponlysemantics?language=objc)
pub const kFontUnicodeV2_0BMPOnlySemantics: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontunicodev2_0fullcoveragesemantics?language=objc)
pub const kFontUnicodeV2_0FullCoverageSemantics: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontunicodev4_0variationsequencesemantics?language=objc)
pub const kFontUnicodeV4_0VariationSequenceSemantics: c_uint = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontunicode_fullrepertoire?language=objc)
pub const kFontUnicode_FullRepertoire: c_uint = 6;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontromanscript?language=objc)
pub const kFontRomanScript: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontjapanesescript?language=objc)
pub const kFontJapaneseScript: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttraditionalchinesescript?language=objc)
pub const kFontTraditionalChineseScript: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontchinesescript?language=objc)
pub const kFontChineseScript: c_uint = kFontTraditionalChineseScript;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkoreanscript?language=objc)
pub const kFontKoreanScript: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontarabicscript?language=objc)
pub const kFontArabicScript: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonthebrewscript?language=objc)
pub const kFontHebrewScript: c_uint = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgreekscript?language=objc)
pub const kFontGreekScript: c_uint = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontcyrillicscript?language=objc)
pub const kFontCyrillicScript: c_uint = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontrussian?language=objc)
pub const kFontRussian: c_uint = kFontCyrillicScript;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontrsymbolscript?language=objc)
pub const kFontRSymbolScript: c_uint = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontdevanagariscript?language=objc)
pub const kFontDevanagariScript: c_uint = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgurmukhiscript?language=objc)
pub const kFontGurmukhiScript: c_uint = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgujaratiscript?language=objc)
pub const kFontGujaratiScript: c_uint = 11;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontoriyascript?language=objc)
pub const kFontOriyaScript: c_uint = 12;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontbengaliscript?language=objc)
pub const kFontBengaliScript: c_uint = 13;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttamilscript?language=objc)
pub const kFontTamilScript: c_uint = 14;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontteluguscript?language=objc)
pub const kFontTeluguScript: c_uint = 15;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkannadascript?language=objc)
pub const kFontKannadaScript: c_uint = 16;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmalayalamscript?language=objc)
pub const kFontMalayalamScript: c_uint = 17;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsinhalesescript?language=objc)
pub const kFontSinhaleseScript: c_uint = 18;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontburmesescript?language=objc)
pub const kFontBurmeseScript: c_uint = 19;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkhmerscript?language=objc)
pub const kFontKhmerScript: c_uint = 20;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontthaiscript?language=objc)
pub const kFontThaiScript: c_uint = 21;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlaotianscript?language=objc)
pub const kFontLaotianScript: c_uint = 22;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgeorgianscript?language=objc)
pub const kFontGeorgianScript: c_uint = 23;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontarmenianscript?language=objc)
pub const kFontArmenianScript: c_uint = 24;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsimplechinesescript?language=objc)
pub const kFontSimpleChineseScript: c_uint = 25;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttibetanscript?language=objc)
pub const kFontTibetanScript: c_uint = 26;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmongolianscript?language=objc)
pub const kFontMongolianScript: c_uint = 27;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgeezscript?language=objc)
pub const kFontGeezScript: c_uint = 28;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontethiopicscript?language=objc)
pub const kFontEthiopicScript: c_uint = kFontGeezScript;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontamharicscript?language=objc)
pub const kFontAmharicScript: c_uint = kFontGeezScript;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontslavicscript?language=objc)
pub const kFontSlavicScript: c_uint = 29;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonteasteuropeanromanscript?language=objc)
pub const kFontEastEuropeanRomanScript: c_uint = kFontSlavicScript;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontvietnamesescript?language=objc)
pub const kFontVietnameseScript: c_uint = 30;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontextendedarabicscript?language=objc)
pub const kFontExtendedArabicScript: c_uint = 31;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsindhiscript?language=objc)
pub const kFontSindhiScript: c_uint = kFontExtendedArabicScript;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontuninterpretedscript?language=objc)
pub const kFontUninterpretedScript: c_uint = 32;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmicrosoftsymbolscript?language=objc)
pub const kFontMicrosoftSymbolScript: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmicrosoftstandardscript?language=objc)
pub const kFontMicrosoftStandardScript: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmicrosoftucs4script?language=objc)
pub const kFontMicrosoftUCS4Script: c_uint = 10;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontcustom8bitscript?language=objc)
pub const kFontCustom8BitScript: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontcustom816bitscript?language=objc)
pub const kFontCustom816BitScript: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontcustom16bitscript?language=objc)
pub const kFontCustom16BitScript: c_uint = 2;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontenglishlanguage?language=objc)
pub const kFontEnglishLanguage: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontfrenchlanguage?language=objc)
pub const kFontFrenchLanguage: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgermanlanguage?language=objc)
pub const kFontGermanLanguage: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontitalianlanguage?language=objc)
pub const kFontItalianLanguage: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontdutchlanguage?language=objc)
pub const kFontDutchLanguage: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontswedishlanguage?language=objc)
pub const kFontSwedishLanguage: c_uint = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontspanishlanguage?language=objc)
pub const kFontSpanishLanguage: c_uint = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontdanishlanguage?language=objc)
pub const kFontDanishLanguage: c_uint = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontportugueselanguage?language=objc)
pub const kFontPortugueseLanguage: c_uint = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontnorwegianlanguage?language=objc)
pub const kFontNorwegianLanguage: c_uint = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonthebrewlanguage?language=objc)
pub const kFontHebrewLanguage: c_uint = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontjapaneselanguage?language=objc)
pub const kFontJapaneseLanguage: c_uint = 11;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontarabiclanguage?language=objc)
pub const kFontArabicLanguage: c_uint = 12;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontfinnishlanguage?language=objc)
pub const kFontFinnishLanguage: c_uint = 13;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgreeklanguage?language=objc)
pub const kFontGreekLanguage: c_uint = 14;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonticelandiclanguage?language=objc)
pub const kFontIcelandicLanguage: c_uint = 15;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmalteselanguage?language=objc)
pub const kFontMalteseLanguage: c_uint = 16;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontturkishlanguage?language=objc)
pub const kFontTurkishLanguage: c_uint = 17;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontcroatianlanguage?language=objc)
pub const kFontCroatianLanguage: c_uint = 18;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttradchineselanguage?language=objc)
pub const kFontTradChineseLanguage: c_uint = 19;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonturdulanguage?language=objc)
pub const kFontUrduLanguage: c_uint = 20;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonthindilanguage?language=objc)
pub const kFontHindiLanguage: c_uint = 21;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontthailanguage?language=objc)
pub const kFontThaiLanguage: c_uint = 22;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkoreanlanguage?language=objc)
pub const kFontKoreanLanguage: c_uint = 23;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlithuanianlanguage?language=objc)
pub const kFontLithuanianLanguage: c_uint = 24;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontpolishlanguage?language=objc)
pub const kFontPolishLanguage: c_uint = 25;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonthungarianlanguage?language=objc)
pub const kFontHungarianLanguage: c_uint = 26;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontestonianlanguage?language=objc)
pub const kFontEstonianLanguage: c_uint = 27;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlettishlanguage?language=objc)
pub const kFontLettishLanguage: c_uint = 28;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlatvianlanguage?language=objc)
pub const kFontLatvianLanguage: c_uint = kFontLettishLanguage;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsaamisklanguage?language=objc)
pub const kFontSaamiskLanguage: c_uint = 29;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlappishlanguage?language=objc)
pub const kFontLappishLanguage: c_uint = kFontSaamiskLanguage;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontfaeroeselanguage?language=objc)
pub const kFontFaeroeseLanguage: c_uint = 30;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontfarsilanguage?language=objc)
pub const kFontFarsiLanguage: c_uint = 31;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontpersianlanguage?language=objc)
pub const kFontPersianLanguage: c_uint = kFontFarsiLanguage;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontrussianlanguage?language=objc)
pub const kFontRussianLanguage: c_uint = 32;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsimpchineselanguage?language=objc)
pub const kFontSimpChineseLanguage: c_uint = 33;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontflemishlanguage?language=objc)
pub const kFontFlemishLanguage: c_uint = 34;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontirishlanguage?language=objc)
pub const kFontIrishLanguage: c_uint = 35;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontalbanianlanguage?language=objc)
pub const kFontAlbanianLanguage: c_uint = 36;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontromanianlanguage?language=objc)
pub const kFontRomanianLanguage: c_uint = 37;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontczechlanguage?language=objc)
pub const kFontCzechLanguage: c_uint = 38;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontslovaklanguage?language=objc)
pub const kFontSlovakLanguage: c_uint = 39;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontslovenianlanguage?language=objc)
pub const kFontSlovenianLanguage: c_uint = 40;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontyiddishlanguage?language=objc)
pub const kFontYiddishLanguage: c_uint = 41;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontserbianlanguage?language=objc)
pub const kFontSerbianLanguage: c_uint = 42;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmacedonianlanguage?language=objc)
pub const kFontMacedonianLanguage: c_uint = 43;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontbulgarianlanguage?language=objc)
pub const kFontBulgarianLanguage: c_uint = 44;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontukrainianlanguage?language=objc)
pub const kFontUkrainianLanguage: c_uint = 45;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontbyelorussianlanguage?language=objc)
pub const kFontByelorussianLanguage: c_uint = 46;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontuzbeklanguage?language=objc)
pub const kFontUzbekLanguage: c_uint = 47;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkazakhlanguage?language=objc)
pub const kFontKazakhLanguage: c_uint = 48;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontazerbaijanilanguage?language=objc)
pub const kFontAzerbaijaniLanguage: c_uint = 49;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontazerbaijanarlanguage?language=objc)
pub const kFontAzerbaijanArLanguage: c_uint = 50;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontarmenianlanguage?language=objc)
pub const kFontArmenianLanguage: c_uint = 51;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgeorgianlanguage?language=objc)
pub const kFontGeorgianLanguage: c_uint = 52;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmoldavianlanguage?language=objc)
pub const kFontMoldavianLanguage: c_uint = 53;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkirghizlanguage?language=objc)
pub const kFontKirghizLanguage: c_uint = 54;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttajikilanguage?language=objc)
pub const kFontTajikiLanguage: c_uint = 55;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontturkmenlanguage?language=objc)
pub const kFontTurkmenLanguage: c_uint = 56;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmongolianlanguage?language=objc)
pub const kFontMongolianLanguage: c_uint = 57;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmongoliancyrlanguage?language=objc)
pub const kFontMongolianCyrLanguage: c_uint = 58;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontpashtolanguage?language=objc)
pub const kFontPashtoLanguage: c_uint = 59;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkurdishlanguage?language=objc)
pub const kFontKurdishLanguage: c_uint = 60;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkashmirilanguage?language=objc)
pub const kFontKashmiriLanguage: c_uint = 61;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsindhilanguage?language=objc)
pub const kFontSindhiLanguage: c_uint = 62;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttibetanlanguage?language=objc)
pub const kFontTibetanLanguage: c_uint = 63;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontnepalilanguage?language=objc)
pub const kFontNepaliLanguage: c_uint = 64;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsanskritlanguage?language=objc)
pub const kFontSanskritLanguage: c_uint = 65;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmarathilanguage?language=objc)
pub const kFontMarathiLanguage: c_uint = 66;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontbengalilanguage?language=objc)
pub const kFontBengaliLanguage: c_uint = 67;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontassameselanguage?language=objc)
pub const kFontAssameseLanguage: c_uint = 68;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgujaratilanguage?language=objc)
pub const kFontGujaratiLanguage: c_uint = 69;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontpunjabilanguage?language=objc)
pub const kFontPunjabiLanguage: c_uint = 70;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontoriyalanguage?language=objc)
pub const kFontOriyaLanguage: c_uint = 71;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmalayalamlanguage?language=objc)
pub const kFontMalayalamLanguage: c_uint = 72;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkannadalanguage?language=objc)
pub const kFontKannadaLanguage: c_uint = 73;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttamillanguage?language=objc)
pub const kFontTamilLanguage: c_uint = 74;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttelugulanguage?language=objc)
pub const kFontTeluguLanguage: c_uint = 75;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsinhaleselanguage?language=objc)
pub const kFontSinhaleseLanguage: c_uint = 76;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontburmeselanguage?language=objc)
pub const kFontBurmeseLanguage: c_uint = 77;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontkhmerlanguage?language=objc)
pub const kFontKhmerLanguage: c_uint = 78;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlaolanguage?language=objc)
pub const kFontLaoLanguage: c_uint = 79;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontvietnameselanguage?language=objc)
pub const kFontVietnameseLanguage: c_uint = 80;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontindonesianlanguage?language=objc)
pub const kFontIndonesianLanguage: c_uint = 81;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttagaloglanguage?language=objc)
pub const kFontTagalogLanguage: c_uint = 82;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmalayromanlanguage?language=objc)
pub const kFontMalayRomanLanguage: c_uint = 83;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmalayarabiclanguage?language=objc)
pub const kFontMalayArabicLanguage: c_uint = 84;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontamhariclanguage?language=objc)
pub const kFontAmharicLanguage: c_uint = 85;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttigrinyalanguage?language=objc)
pub const kFontTigrinyaLanguage: c_uint = 86;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontgallalanguage?language=objc)
pub const kFontGallaLanguage: c_uint = 87;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontoromolanguage?language=objc)
pub const kFontOromoLanguage: c_uint = kFontGallaLanguage;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsomalilanguage?language=objc)
pub const kFontSomaliLanguage: c_uint = 88;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontswahililanguage?language=objc)
pub const kFontSwahiliLanguage: c_uint = 89;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontruandalanguage?language=objc)
pub const kFontRuandaLanguage: c_uint = 90;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontrundilanguage?language=objc)
pub const kFontRundiLanguage: c_uint = 91;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontchewalanguage?language=objc)
pub const kFontChewaLanguage: c_uint = 92;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmalagasylanguage?language=objc)
pub const kFontMalagasyLanguage: c_uint = 93;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontesperantolanguage?language=objc)
pub const kFontEsperantoLanguage: c_uint = 94;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontwelshlanguage?language=objc)
pub const kFontWelshLanguage: c_uint = 128;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontbasquelanguage?language=objc)
pub const kFontBasqueLanguage: c_uint = 129;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontcatalanlanguage?language=objc)
pub const kFontCatalanLanguage: c_uint = 130;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlatinlanguage?language=objc)
pub const kFontLatinLanguage: c_uint = 131;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontquechualanguage?language=objc)
pub const kFontQuechuaLanguage: c_uint = 132;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontguaranilanguage?language=objc)
pub const kFontGuaraniLanguage: c_uint = 133;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontaymaralanguage?language=objc)
pub const kFontAymaraLanguage: c_uint = 134;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttatarlanguage?language=objc)
pub const kFontTatarLanguage: c_uint = 135;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontuighurlanguage?language=objc)
pub const kFontUighurLanguage: c_uint = 136;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontdzongkhalanguage?language=objc)
pub const kFontDzongkhaLanguage: c_uint = 137;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontjavaneseromlanguage?language=objc)
pub const kFontJavaneseRomLanguage: c_uint = 138;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsundaneseromlanguage?language=objc)
pub const kFontSundaneseRomLanguage: c_uint = 139;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontnoplatformcode?language=objc)
pub const kFontNoPlatformCode: c_uint = !0;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontnoscriptcode?language=objc)
pub const kFontNoScriptCode: c_uint = !0;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontnolanguagecode?language=objc)
pub const kFontNoLanguageCode: c_uint = !0;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntcmapsubheader?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntCMapSubHeader {
    pub format: u16,
    pub length: u16,
    pub languageID: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntCMapSubHeader {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntCMapSubHeader",
        &[<u16>::ENCODING, <u16>::ENCODING, <u16>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntCMapSubHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntcmapsubheader?language=objc)
pub const sizeof_sfntCMapSubHeader: c_uint = 6;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntcmapextendedsubheader?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntCMapExtendedSubHeader {
    pub format: u16,
    pub reserved: u16,
    pub length: u32,
    pub language: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntCMapExtendedSubHeader {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntCMapExtendedSubHeader",
        &[
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntCMapExtendedSubHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntcmapextendedsubheader?language=objc)
pub const sizeof_sfntCMapExtendedSubHeader: c_uint = 12;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntcmapencoding?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntCMapEncoding {
    pub platformID: u16,
    pub scriptID: u16,
    pub offset: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntCMapEncoding {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntCMapEncoding",
        &[<u16>::ENCODING, <u16>::ENCODING, <u32>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntCMapEncoding {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntcmapencoding?language=objc)
pub const sizeof_sfntCMapEncoding: c_uint = 8;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntcmapheader?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntCMapHeader {
    pub version: u16,
    pub numTables: u16,
    pub encoding: [sfntCMapEncoding; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntCMapHeader {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntCMapHeader",
        &[
            <u16>::ENCODING,
            <u16>::ENCODING,
            <[sfntCMapEncoding; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntCMapHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntcmapheader?language=objc)
pub const sizeof_sfntCMapHeader: c_uint = 4;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/namefonttabletag?language=objc)
pub const nameFontTableTag: c_uint = 0x6E616D65;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontcopyrightname?language=objc)
pub const kFontCopyrightName: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontfamilyname?language=objc)
pub const kFontFamilyName: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontstylename?language=objc)
pub const kFontStyleName: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontuniquename?language=objc)
pub const kFontUniqueName: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontfullname?language=objc)
pub const kFontFullName: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontversionname?language=objc)
pub const kFontVersionName: c_uint = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontpostscriptname?language=objc)
pub const kFontPostscriptName: c_uint = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfonttrademarkname?language=objc)
pub const kFontTrademarkName: c_uint = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmanufacturername?language=objc)
pub const kFontManufacturerName: c_uint = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontdesignername?language=objc)
pub const kFontDesignerName: c_uint = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontdescriptionname?language=objc)
pub const kFontDescriptionName: c_uint = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontvendorurlname?language=objc)
pub const kFontVendorURLName: c_uint = 11;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontdesignerurlname?language=objc)
pub const kFontDesignerURLName: c_uint = 12;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlicensedescriptionname?language=objc)
pub const kFontLicenseDescriptionName: c_uint = 13;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlicenseinfourlname?language=objc)
pub const kFontLicenseInfoURLName: c_uint = 14;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontpreferredfamilyname?language=objc)
pub const kFontPreferredFamilyName: c_uint = 16;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontpreferredsubfamilyname?language=objc)
pub const kFontPreferredSubfamilyName: c_uint = 17;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontmaccompatiblefullname?language=objc)
pub const kFontMacCompatibleFullName: c_uint = 18;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontsampletextname?language=objc)
pub const kFontSampleTextName: c_uint = 19;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontpostscriptcidname?language=objc)
pub const kFontPostScriptCIDName: c_uint = 20;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontlastreservedname?language=objc)
pub const kFontLastReservedName: c_uint = 255;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kfontnonamecode?language=objc)
pub const kFontNoNameCode: c_uint = !0;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntnamerecord?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntNameRecord {
    pub platformID: u16,
    pub scriptID: u16,
    pub languageID: u16,
    pub nameID: u16,
    pub length: u16,
    pub offset: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntNameRecord {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntNameRecord",
        &[
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntNameRecord {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntnamerecord?language=objc)
pub const sizeof_sfntNameRecord: c_uint = 12;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntnameheader?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntNameHeader {
    pub format: u16,
    pub count: u16,
    pub stringOffset: u16,
    pub rec: [sfntNameRecord; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntNameHeader {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntNameHeader",
        &[
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <[sfntNameRecord; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntNameHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntnameheader?language=objc)
pub const sizeof_sfntNameHeader: c_uint = 6;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/variationfonttabletag?language=objc)
pub const variationFontTableTag: c_uint = 0x66766172;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntvariationaxis?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntVariationAxis {
    pub axisTag: FourCharCode,
    pub minValue: Fixed,
    pub defaultValue: Fixed,
    pub maxValue: Fixed,
    pub flags: i16,
    pub nameID: i16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntVariationAxis {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntVariationAxis",
        &[
            <FourCharCode>::ENCODING,
            <Fixed>::ENCODING,
            <Fixed>::ENCODING,
            <Fixed>::ENCODING,
            <i16>::ENCODING,
            <i16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntVariationAxis {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntvariationaxis?language=objc)
pub const sizeof_sfntVariationAxis: c_uint = 20;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntinstance?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntInstance {
    pub nameID: i16,
    pub flags: i16,
    pub coord: [Fixed; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntInstance {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntInstance",
        &[<i16>::ENCODING, <i16>::ENCODING, <[Fixed; 1]>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntInstance {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntinstance?language=objc)
pub const sizeof_sfntInstance: c_uint = 4;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntvariationheader?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntVariationHeader {
    pub version: Fixed,
    pub offsetToData: u16,
    pub countSizePairs: u16,
    pub axisCount: u16,
    pub axisSize: u16,
    pub instanceCount: u16,
    pub instanceSize: u16,
    pub axis: [sfntVariationAxis; 1],
    pub instance: [sfntInstance; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntVariationHeader {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntVariationHeader",
        &[
            <Fixed>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <[sfntVariationAxis; 1]>::ENCODING,
            <[sfntInstance; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntVariationHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntvariationheader?language=objc)
pub const sizeof_sfntVariationHeader: c_uint = 16;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/descriptorfonttabletag?language=objc)
pub const descriptorFontTableTag: c_uint = 0x66647363;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntfontdescriptor?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntFontDescriptor {
    pub name: FourCharCode,
    pub value: Fixed,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntFontDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntFontDescriptor",
        &[<FourCharCode>::ENCODING, <Fixed>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntFontDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntdescriptorheader?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntDescriptorHeader {
    pub version: Fixed,
    pub descriptorCount: i32,
    pub descriptor: [sfntFontDescriptor; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntDescriptorHeader {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntDescriptorHeader",
        &[
            <Fixed>::ENCODING,
            <i32>::ENCODING,
            <[sfntFontDescriptor; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntDescriptorHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sizeof_sfntdescriptorheader?language=objc)
pub const sizeof_sfntDescriptorHeader: c_uint = 8;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/featurefonttabletag?language=objc)
pub const featureFontTableTag: c_uint = 0x66656174;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntfeaturename?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntFeatureName {
    pub featureType: u16,
    pub settingCount: u16,
    pub offsetToSettings: i32,
    pub featureFlags: u16,
    pub nameID: i16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntFeatureName {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntFeatureName",
        &[
            <u16>::ENCODING,
            <u16>::ENCODING,
            <i32>::ENCODING,
            <u16>::ENCODING,
            <i16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntFeatureName {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntfontfeaturesetting?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntFontFeatureSetting {
    pub setting: u16,
    pub nameID: i16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntFontFeatureSetting {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntFontFeatureSetting",
        &[<u16>::ENCODING, <i16>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntFontFeatureSetting {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntfontrunfeature?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntFontRunFeature {
    pub featureType: u16,
    pub setting: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntFontRunFeature {
    const ENCODING: Encoding =
        Encoding::Struct("sfntFontRunFeature", &[<u16>::ENCODING, <u16>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntFontRunFeature {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/sfntfeatureheader?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct sfntFeatureHeader {
    pub version: i32,
    pub featureNameCount: u16,
    pub featureSetCount: u16,
    pub reserved: i32,
    pub names: [sfntFeatureName; 1],
    pub settings: [sfntFontFeatureSetting; 1],
    pub runs: [sfntFontRunFeature; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for sfntFeatureHeader {
    const ENCODING: Encoding = Encoding::Struct(
        "sfntFeatureHeader",
        &[
            <i32>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <i32>::ENCODING,
            <[sfntFeatureName; 1]>::ENCODING,
            <[sfntFontFeatureSetting; 1]>::ENCODING,
            <[sfntFontRunFeature; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for sfntFeatureHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/os2fonttabletag?language=objc)
pub const os2FontTableTag: c_uint = 0x4F532F32;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/nonglyphid?language=objc)
pub const nonGlyphID: c_uint = 65535;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/fontnamecode?language=objc)
pub type FontNameCode = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/fontplatformcode?language=objc)
pub type FontPlatformCode = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/fontscriptcode?language=objc)
pub type FontScriptCode = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/fontlanguagecode?language=objc)
pub type FontLanguageCode = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/fontvariation?language=objc)
#[repr(C, packed(2))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FontVariation {
    pub name: FourCharCode,
    pub value: Fixed,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for FontVariation {
    const ENCODING: Encoding = Encoding::Struct(
        "FontVariation",
        &[<FourCharCode>::ENCODING, <Fixed>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for FontVariation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
