"use strict";

exports.__esModule = true;
exports.default = LinkRadialCurve;
exports.pathRadialCurve = pathRadialCurve;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _d3Path = require("d3-path");
var _accessors = require("../../../util/accessors");
var _excluded = ["className", "children", "data", "innerRef", "path", "percent", "x", "y", "source", "target"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function pathRadialCurve(_ref) {
  var source = _ref.source,
    target = _ref.target,
    x = _ref.x,
    y = _ref.y,
    percent = _ref.percent;
  return function (link) {
    var sourceData = source(link);
    var targetData = target(link);
    var sa = x(sourceData) - Math.PI / 2;
    var sr = y(sourceData);
    var ta = x(targetData) - Math.PI / 2;
    var tr = y(targetData);
    var sc = Math.cos(sa);
    var ss = Math.sin(sa);
    var tc = Math.cos(ta);
    var ts = Math.sin(ta);
    var sx = sr * sc;
    var sy = sr * ss;
    var tx = tr * tc;
    var ty = tr * ts;
    var dx = tx - sx;
    var dy = ty - sy;
    var ix = percent * (dx + dy);
    var iy = percent * (dy - dx);
    var path = (0, _d3Path.path)();
    path.moveTo(sx, sy);
    path.bezierCurveTo(sx + ix, sy + iy, tx + iy, ty - ix, tx, ty);
    return path.toString();
  };
}
function LinkRadialCurve(_ref2) {
  var className = _ref2.className,
    children = _ref2.children,
    data = _ref2.data,
    innerRef = _ref2.innerRef,
    path = _ref2.path,
    _ref2$percent = _ref2.percent,
    percent = _ref2$percent === void 0 ? 0.2 : _ref2$percent,
    _ref2$x = _ref2.x,
    x = _ref2$x === void 0 ? _accessors.getX : _ref2$x,
    _ref2$y = _ref2.y,
    y = _ref2$y === void 0 ? _accessors.getY : _ref2$y,
    _ref2$source = _ref2.source,
    source = _ref2$source === void 0 ? _accessors.getSource : _ref2$source,
    _ref2$target = _ref2.target,
    target = _ref2$target === void 0 ? _accessors.getTarget : _ref2$target,
    restProps = _objectWithoutPropertiesLoose(_ref2, _excluded);
  var pathGen = path || pathRadialCurve({
    source: source,
    target: target,
    x: x,
    y: y,
    percent: percent
  });
  if (children) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children({
    path: pathGen
  }));
  return /*#__PURE__*/_react.default.createElement("path", _extends({
    ref: innerRef,
    className: (0, _classnames.default)('visx-link visx-link-radial-curve', className),
    d: pathGen(data) || ''
  }, restProps));
}