"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isServerEnvironment = void 0;
/**
 * @see https://github.com/jsdom/jsdom/releases/tag/12.0.0
 * @see https://github.com/jsdom/jsdom/issues/1537
 */
const isJsDomEnvironment = () => window.name === 'nodejs' ||
    (navigator === null || navigator === void 0 ? void 0 : navigator.userAgent.includes('Node.js')) ||
    (navigator === null || navigator === void 0 ? void 0 : navigator.userAgent.includes('jsdom'));
/**
 * Returns `true` when inside a node environment,
 * else `false`.
 *
 * When using this it will remove any node code from the browser bundle - for example:
 *
 * ```js
 * if (isServerEnvironment()) {
 *   // This code will be removed from the browser bundle
 * }
 * ```
 */
const isServerEnvironment = () => {
    if (typeof window === 'undefined' ||
        (typeof process !== 'undefined' && process.versions != null && process.versions.node != null)) {
        return true;
    }
    if (isJsDomEnvironment()) {
        return true;
    }
    return false;
};
exports.isServerEnvironment = isServerEnvironment;
//# sourceMappingURL=is-server-environment.js.map