"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _xcss = require("../xcss/xcss");
var _flex = _interopRequireDefault(require("./flex"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * @jsxRuntime classic
 * @jsx jsx
 */

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766

var flexGrowMap = {
  hug: (0, _xcss.xcss)({
    flexGrow: 0
  }),
  fill: (0, _xcss.xcss)({
    width: '100%',
    flexGrow: 1
  })
};
var separatorStyles = (0, _react2.css)({
  color: "var(--ds-text-subtle, #42526E)",
  marginBlock: "var(--ds-space-0, 0px)",
  marginInline: "var(--ds-space-negative-025, -2px)",
  pointerEvents: 'none',
  userSelect: 'none'
});
var Separator = function Separator(_ref) {
  var children = _ref.children;
  return (0, _react2.jsx)("span", {
    css: separatorStyles
  }, children);
};

/**
 * __Inline__
 *
 * Inline is a primitive component based on CSS Flexbox that manages the horizontal layout of direct children.
 *
 * @example
 * ```tsx
 *  <Inline>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Inline>
 * ```
 *
 */
var Inline = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
  var as = _ref2.as,
    alignInline = _ref2.alignInline,
    _ref2$alignBlock = _ref2.alignBlock,
    alignItems = _ref2$alignBlock === void 0 ? 'start' : _ref2$alignBlock,
    _ref2$shouldWrap = _ref2.shouldWrap,
    shouldWrap = _ref2$shouldWrap === void 0 ? false : _ref2$shouldWrap,
    spread = _ref2.spread,
    grow = _ref2.grow,
    space = _ref2.space,
    rowSpace = _ref2.rowSpace,
    separator = _ref2.separator,
    xcss = _ref2.xcss,
    testId = _ref2.testId,
    role = _ref2.role,
    rawChildren = _ref2.children;
  var separatorComponent = typeof separator === 'string' ? (0, _react2.jsx)(Separator, null, separator) : separator;
  var children = separatorComponent ? _react.Children.toArray(rawChildren).filter(Boolean).map(function (child, index) {
    return (0, _react2.jsx)(_react.Fragment, {
      key: index
    }, separator && index > 0 ? separatorComponent : null, child);
  }) : rawChildren;
  var justifyContent = spread || alignInline;

  // We're type coercing this as Compiled styles in an array isn't supported by the types
  // But the runtime accepts it none-the-wiser. We can remove this entire block and replace
  // it with cx(defaultStyles, focusRingStyles, xcssStyles) when we've moved away from Emotion.
  var styles = grow ? [flexGrowMap[grow]].concat((0, _toConsumableArray2.default)(Array.isArray(xcss) ? xcss : [xcss])) : xcss;
  return (0, _react2.jsx)(_flex.default, {
    as: as,
    role: role,
    alignItems: alignItems,
    justifyContent: justifyContent,
    direction: "row",
    gap: space,
    rowGap: rowSpace,
    wrap: shouldWrap ? 'wrap' : undefined
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    xcss: styles,
    testId: testId,
    ref: ref
  }, children);
}));
Inline.displayName = 'Inline';
var _default = exports.default = Inline;