"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Box = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _surfaceProvider = require("../utils/surface-provider");
var _styleMaps = require("../xcss/style-maps.partial");
var _xcss = require("../xcss/xcss");
var _excluded = ["as", "children", "backgroundColor", "padding", "paddingBlock", "paddingBlockStart", "paddingBlockEnd", "paddingInline", "paddingInlineStart", "paddingInlineEnd", "style", "testId", "xcss"],
  _excluded2 = ["className"];
/**
 * @jsxRuntime classic
 * @jsx jsx
 */
// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
// Can either Exclude or Extract - here we're excluding all SVG-related elements, <button> elements (handled by Pressable), and <a> elements (handled by Anchor)

// Basically just ElementType but without ComponentType, it makes sense to keep the "Type" suffix
// eslint-disable-next-line @repo/internal/react/consistent-types-definitions

/**
 * __Box__
 *
 * A Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * - [Examples](https://atlassian.design/components/primitives/box/examples)
 * - [Code](https://atlassian.design/components/primitives/box/code)
 * - [Usage](https://atlassian.design/components/primitives/box/usage)
 */
var Box = exports.Box = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$as = _ref.as,
    Component = _ref$as === void 0 ? 'div' : _ref$as,
    children = _ref.children,
    backgroundColor = _ref.backgroundColor,
    padding = _ref.padding,
    paddingBlock = _ref.paddingBlock,
    paddingBlockStart = _ref.paddingBlockStart,
    paddingBlockEnd = _ref.paddingBlockEnd,
    paddingInline = _ref.paddingInline,
    paddingInlineStart = _ref.paddingInlineStart,
    paddingInlineEnd = _ref.paddingInlineEnd,
    style = _ref.style,
    testId = _ref.testId,
    xcss = _ref.xcss,
    htmlAttributes = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  var _spreadClass = htmlAttributes.className,
    safeHtmlAttributes = (0, _objectWithoutProperties2.default)(htmlAttributes, _excluded2);
  var resolvedStyles = (0, _xcss.parseXcss)(xcss);
  var node =
  // @ts-expect-error Expression produces a union type that is too complex to represent. I think this is unavoidable
  (0, _react2.jsx)(Component
  // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
  , (0, _extends2.default)({
    style: style
    // @ts-ignore Expression produces a union type that is too complex to represent. We may be able to narrow the type here but unsure.
    ,
    ref: ref
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
    ,
    className: resolvedStyles.static
  }, safeHtmlAttributes, {
    css: [baseStyles,
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    backgroundColor && _styleMaps.backgroundColorStylesMap[backgroundColor],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    (0, _styleMaps.isSurfaceColorToken)(backgroundColor) && _styleMaps.surfaceColorStylesMap[backgroundColor],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    padding && _styleMaps.paddingStylesMap.padding[padding],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlock && _styleMaps.paddingStylesMap.paddingBlock[paddingBlock],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlockStart && _styleMaps.paddingStylesMap.paddingBlockStart[paddingBlockStart],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlockEnd && _styleMaps.paddingStylesMap.paddingBlockEnd[paddingBlockEnd],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInline && _styleMaps.paddingStylesMap.paddingInline[paddingInline],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInlineStart && _styleMaps.paddingStylesMap.paddingInlineStart[paddingInlineStart],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInlineEnd && _styleMaps.paddingStylesMap.paddingInlineEnd[paddingInlineEnd], resolvedStyles.emotion],
    "data-testid": testId
  }), children);
  return backgroundColor ? (0, _react2.jsx)(_surfaceProvider.SurfaceContext.Provider, {
    value: backgroundColor
  }, node) : node;
}
// @ts-ignore This typescript error has been surpessed while locally enrolling `@atlaskit/primitives` into Jira
// The return type of `BoxComponent` does not match the return type of `forwardRef` in React 18
);
var _default = exports.default = Box;
var baseStyles = (0, _react2.css)({
  boxSizing: 'border-box',
  appearance: 'none',
  border: 'none'
});