/**
 * Each fragment consists of an attribute name, with an optional value.
 */
type SelectorFragment = {
    attribute: string;
    value?: string;
};
/**
 * Queries an element based on the provided selector fragments.
 */
export declare function findElement(...fragments: SelectorFragment[]): HTMLElement | null;
export declare function findElementAll(...fragments: SelectorFragment[]): HTMLElement[];
/**
 * Queries an element, ensuring it exists.
 */
export declare function getElement(...fragments: SelectorFragment[]): HTMLElement;
export {};
