import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _wrapNativeSuper from "@babel/runtime/helpers/wrapNativeSuper";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var isProduction = process.env.NODE_ENV === 'production';
var prefix = 'Invariant failed';
export var RbdInvariant = /*#__PURE__*/function (_Error) {
  function RbdInvariant(message) {
    var _this;
    _classCallCheck(this, RbdInvariant);
    _this = _callSuper(this, RbdInvariant);
    _this.message = message;
    return _this;
  }
  _inherits(RbdInvariant, _Error);
  return _createClass(RbdInvariant, [{
    key: "toString",
    value: function toString() {
      return this.message;
    }
  }]);
}( /*#__PURE__*/_wrapNativeSuper(Error));

// A copy-paste of tiny-invariant but with a custom error type
// Throw an error if the condition fails
export function rbdInvariant(condition, message) {
  if (condition) {
    return;
  }
  if (isProduction) {
    // In production we strip the message but still throw
    throw new RbdInvariant(prefix);
  } else {
    // When not in production we allow the message to pass through
    // *This block will be removed in production builds*
    throw new RbdInvariant("".concat(prefix, ": ").concat(message || ''));
  }
}