"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.batchUpdatesForReact16 = batchUpdatesForReact16;
var _reactDom = require("react-dom");
var schedule = function () {
  /**
   * We only want to do this manual batching for version 16 of React.
   *
   * Version 18 will automatically batch updates.
   */
  if (
  // `unstable_batchedUpdates` is defined in all currently supported versions
  // but could be removed in the future.
  // This check is defensive and not currently necessary.
  typeof _reactDom.unstable_batchedUpdates === 'function' && (
  // The version export was only introduced in `react-dom@16.13.0`
  // but we need to support `react-dom@^16.8.0`
  // so we need to handle when the version is `undefined`
  typeof _reactDom.version === 'undefined' || _reactDom.version.startsWith('16'))) {
    return _reactDom.unstable_batchedUpdates;
  }
  // Relying on react@18 to do automatic batching
  return function (callback) {
    return callback();
  };
}();
function batchUpdatesForReact16(callback) {
  schedule(callback);
}