"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDraggableData = isDraggableData;
exports.useDraggableData = useDraggableData;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
/**
 * Private symbol that is intentionally not exported from this file.
 */
var privateKey = Symbol('DraggableData');

/**
 * Data that is attached to drags. The same data is used for the `draggable()`
 * and `dropTargetForElements()` calls related to a `<Draggable>` instance.
 */

/**
 * Checks if the passed data satisfies `DraggableData` using the private symbol.
 */
function isDraggableData(data) {
  return data[privateKey] === true;
}

/**
 * Adds the private symbol to the passed data.
 *
 * The symbol allows us to quickly check if an object satisfies `DraggableData`.
 */
function useDraggableData(_ref) {
  var draggableId = _ref.draggableId,
    droppableId = _ref.droppableId,
    getIndex = _ref.getIndex,
    contextId = _ref.contextId,
    type = _ref.type;
  return (0, _react.useMemo)(function () {
    return (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, privateKey, true), "draggableId", draggableId), "droppableId", droppableId), "getIndex", getIndex), "contextId", contextId), "type", type);
  }, [draggableId, droppableId, getIndex, contextId, type]);
}