"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../constants");
var _position = require("../position");
var _getScrollOnAxis = _interopRequireDefault(require("./get-scroll-on-axis"));
// Source: https://github.com/atlassian/react-beautiful-dnd

// will replace -0 and replace with +0
var clean = (0, _position.apply)(function (value) {
  return value === 0 ? 0 : value;
});
var _default = exports.default = function _default(_ref) {
  var dragStartTime = _ref.dragStartTime,
    container = _ref.container,
    center = _ref.center,
    shouldUseTimeDampening = _ref.shouldUseTimeDampening;
  // get distance to each edge
  var distanceToEdges = {
    top: center.y - container.top,
    right: container.right - center.x,
    bottom: container.bottom - center.y,
    left: center.x - container.left
  };

  // 1. Figure out which x,y values are the best target
  // 2. Can the container scroll in that direction at all?
  // If no for both directions, then return null
  // 3. Is the center close enough to a edge to start a drag?
  // 4. Based on the distance, calculate the speed at which a scroll should occur
  // The lower distance value the faster the scroll should be.
  // Maximum speed value should be hit before the distance is 0
  // Negative values to not continue to increase the speed
  var y = (0, _getScrollOnAxis.default)({
    container: container,
    distanceToEdges: distanceToEdges,
    dragStartTime: dragStartTime,
    axis: _constants.vertical,
    shouldUseTimeDampening: shouldUseTimeDampening
  });
  var x = (0, _getScrollOnAxis.default)({
    container: container,
    distanceToEdges: distanceToEdges,
    dragStartTime: dragStartTime,
    axis: _constants.horizontal,
    shouldUseTimeDampening: shouldUseTimeDampening
  });
  var required = clean({
    x: x,
    y: y
  });

  // nothing required
  if ((0, _position.isEqual)(required, _position.origin)) {
    return null;
  }
  return required;
};