/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type AnchorHTMLAttributes, type Ref } from 'react';
import type { RouterLinkComponentProps } from '@atlaskit/app-provider';
import { type AnchorProps } from '@atlaskit/primitives/compiled';
export type LinkProps<RouterLinkConfig extends Record<string, any> = never> = Omit<AnchorHTMLAttributes<HTMLAnchorElement>, 'href' | 'onClick' | 'style' | 'children' | 'className'> & Pick<AnchorProps<RouterLinkConfig>, 'interactionName' | 'analyticsContext' | 'onClick' | 'testId' | 'newWindowLabel'> & RouterLinkComponentProps<RouterLinkConfig> & {
    /**
     * The appearance of the link. Defaults to `default`. A `subtle` appearance will render the link with a lighter color and no underline in resting state. Use `inverse` when rendering on bold backgrounds to ensure that the link is easily visible.
     */
    appearance?: 'default' | 'subtle' | 'inverse';
};
declare const LinkWithoutRef: <RouterLinkConfig extends Record<string, any> = never>({ children, testId, appearance, newWindowLabel, target, className: preventedClassName, style: preventedStyle, ...htmlAttributes }: LinkProps<RouterLinkConfig>, ref: Ref<HTMLAnchorElement>) => JSX.Element;
/**
 * __Link__
 *
 * A link is an inline text element that navigates to a new location when clicked.
 *
 * - [Examples](https://atlassian.design/components/primitives/link/examples)
 * - [Code](https://atlassian.design/components/primitives/link/code)
 * - [Usage](https://atlassian.design/components/primitives/link/usage)
 */
declare const Link: <RouterLinkConfig extends Record<string, any> = never>(props: LinkProps<RouterLinkConfig> & {
    ref?: Ref<HTMLAnchorElement>;
}) => ReturnType<typeof LinkWithoutRef>;
export default Link;
