"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLayoutEffect = void 0;
var _react = require("react");
/**
 * **useLayoutEffect**
 *
 * Before React 19 when running layout effects on the server they log an error. To prevent our
 * SSR tests from failing we check the environment and replace it with an effect when in SSR.
 * This effectively suppresses the error log. When on React 19 we can remove this altogether.
 */
var useLayoutEffect = exports.useLayoutEffect = typeof window === 'undefined' ? _react.useEffect : _react.useLayoutEffect;