import AnalyticsEvent, { type AnalyticsEventPayload, type AnalyticsEventProps } from './AnalyticsEvent';
type ChannelIdentifier = string;
type Context = Record<string, any>[];
export type UIAnalyticsEventHandler = (event: UIAnalyticsEvent, channel?: ChannelIdentifier) => void;
export type UIAnalyticsEventProps = AnalyticsEventProps & {
    context?: Context;
    handlers?: UIAnalyticsEventHandler[];
};
export declare const isUIAnalyticsEvent: (obj: any) => boolean;
export default class UIAnalyticsEvent extends AnalyticsEvent {
    context: Context;
    handlers: UIAnalyticsEventHandler[];
    hasFired: boolean;
    _isUIAnalyticsEvent: boolean;
    constructor(props: UIAnalyticsEventProps);
    clone: () => UIAnalyticsEvent | null;
    fire: (channel?: string) => void;
    update(updater: Record<string, any> | ((payload: AnalyticsEventPayload) => AnalyticsEventPayload)): this;
}
export {};
