import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import index from '../matchEvent';
export const ContextTypes = {
  onAnalyticsEvent: PropTypes.func,
  getParentAnalyticsData: PropTypes.func
};

/**
 * The Decorator component extends analytics event data
 * for any events fired by its descendents,
 * then passes the event up the hierarchy
 */
// eslint-disable-next-line @repo/internal/react/no-class-components
export class AnalyticsDecorator extends Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getDecoratedAnalyticsData", (name, srcData, isPrivate) => {
      const {
        data,
        getData,
        match,
        matchPrivate
      } = this.props;
      const decoratedData = {
        ...srcData
      };
      if (matchPrivate === isPrivate && index(match, name)) {
        if (typeof data === 'object') {
          Object.assign(decoratedData, data);
        }
        if (typeof getData === 'function') {
          Object.assign(decoratedData, getData(name, decoratedData));
        }
      }
      return decoratedData;
    });
    _defineProperty(this, "onAnalyticsEvent", (name, srcData, isPrivate) => {
      const {
        onAnalyticsEvent
      } = this.context;
      if (typeof onAnalyticsEvent !== 'function') {
        return;
      }
      const decoratedData = this.getDecoratedAnalyticsData(name, srcData, isPrivate);
      onAnalyticsEvent(name, decoratedData, isPrivate);
    });
    _defineProperty(this, "getParentAnalyticsData", (name, isPrivate) => {
      const parentData = this.getDecoratedAnalyticsData(name, {}, isPrivate);
      const {
        getParentAnalyticsData
      } = this.context;
      if (typeof getParentAnalyticsData === 'function') {
        Object.assign(parentData, getParentAnalyticsData(name, isPrivate));
      }
      return parentData;
    });
  }
  getChildContext() {
    return {
      onAnalyticsEvent: this.onAnalyticsEvent,
      getParentAnalyticsData: this.getParentAnalyticsData
    };
  }
  render() {
    const {
      children
    } = this.props;
    return React.Children.only(children);
  }
}
_defineProperty(AnalyticsDecorator, "defaultProps", {
  match: '*',
  matchPrivate: false
});
_defineProperty(AnalyticsDecorator, "contextTypes", ContextTypes);
_defineProperty(AnalyticsDecorator, "childContextTypes", ContextTypes);
export default AnalyticsDecorator;