// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#ifndef CS_MIPMAP_3D_P_H
#define CS_MIPMAP_3D_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/private/qglobal_p.h>

#ifdef Q_OS_WIN

#include <qt_windows.h>

#if 0
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions:
//
// cbuffer cbuf
// {
//
//   float3 texelSize;                  // Offset:    0 Size:    12
//   uint srcMipLevel;                  // Offset:   12 Size:     4
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// samp                              sampler      NA          NA             s0      1
// srcMip                            texture  float4          3d             t0      1
// dstMip                                UAV  float4          3d             u0      1
// cbuf                              cbuffer      NA          NA            cb0      1
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// no Input
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// no Output
cs_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[1], immediateIndexed
dcl_sampler s0, mode_default
dcl_resource_texture3d (float,float,float,float) t0
dcl_uav_typed_texture3d (float,float,float,float) u0
dcl_input vThreadID.xyz
dcl_temps 1
dcl_thread_group 8, 8, 8
utof r0.xyz, vThreadID.xyzx
add r0.xyz, r0.xyzx, l(0.500000, 0.500000, 0.500000, 0.000000)
mul r0.xyz, r0.xyzx, cb0[0].xyzx
utof r0.w, cb0[0].w
sample_l_indexable(texture3d)(float,float,float,float) r0.xyzw, r0.xyzx, t0.xyzw, s0, r0.w
store_uav_typed u0.xyzw, vThreadID.xyzz, r0.xyzw
ret
// Approximately 7 instruction slots used
#endif

const BYTE g_csMipmap3D[] =
{
     68,  88,  66,  67,  85, 215,
    143,  22,  58,  22, 102,  67,
    246, 112, 181,  48, 159,  52,
     24,   6,   1,   0,   0,   0,
    252,   3,   0,   0,   5,   0,
      0,   0,  52,   0,   0,   0,
     16,   2,   0,   0,  32,   2,
      0,   0,  48,   2,   0,   0,
     96,   3,   0,   0,  82,  68,
     69,  70, 212,   1,   0,   0,
      1,   0,   0,   0, 212,   0,
      0,   0,   4,   0,   0,   0,
     60,   0,   0,   0,   0,   5,
     83,  67,   0,   1,   0,   0,
    172,   1,   0,   0,  82,  68,
     49,  49,  60,   0,   0,   0,
     24,   0,   0,   0,  32,   0,
      0,   0,  40,   0,   0,   0,
     36,   0,   0,   0,  12,   0,
      0,   0,   0,   0,   0,   0,
    188,   0,   0,   0,   3,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      1,   0,   0,   0,   1,   0,
      0,   0, 193,   0,   0,   0,
      2,   0,   0,   0,   5,   0,
      0,   0,   8,   0,   0,   0,
    255, 255, 255, 255,   0,   0,
      0,   0,   1,   0,   0,   0,
     13,   0,   0,   0, 200,   0,
      0,   0,   4,   0,   0,   0,
      5,   0,   0,   0,   8,   0,
      0,   0, 255, 255, 255, 255,
      0,   0,   0,   0,   1,   0,
      0,   0,  13,   0,   0,   0,
    207,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      1,   0,   0,   0,   1,   0,
      0,   0, 115,  97, 109, 112,
      0, 115, 114,  99,  77, 105,
    112,   0, 100, 115, 116,  77,
    105, 112,   0,  99,  98, 117,
    102,   0, 207,   0,   0,   0,
      2,   0,   0,   0, 236,   0,
      0,   0,  16,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,  60,   1,   0,   0,
      0,   0,   0,   0,  12,   0,
      0,   0,   2,   0,   0,   0,
     80,   1,   0,   0,   0,   0,
      0,   0, 255, 255, 255, 255,
      0,   0,   0,   0, 255, 255,
    255, 255,   0,   0,   0,   0,
    116,   1,   0,   0,  12,   0,
      0,   0,   4,   0,   0,   0,
      2,   0,   0,   0, 136,   1,
      0,   0,   0,   0,   0,   0,
    255, 255, 255, 255,   0,   0,
      0,   0, 255, 255, 255, 255,
      0,   0,   0,   0, 116, 101,
    120, 101, 108,  83, 105, 122,
    101,   0, 102, 108, 111,  97,
    116,  51,   0, 171, 171, 171,
      1,   0,   3,   0,   1,   0,
      3,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,  70,   1,   0,   0,
    115, 114,  99,  77, 105, 112,
     76, 101, 118, 101, 108,   0,
    100, 119, 111, 114, 100,   0,
    171, 171,   0,   0,  19,   0,
      1,   0,   1,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 128,   1,
      0,   0,  77, 105,  99, 114,
    111, 115, 111, 102, 116,  32,
     40,  82,  41,  32,  72,  76,
     83,  76,  32,  83, 104,  97,
    100, 101, 114,  32,  67, 111,
    109, 112, 105, 108, 101, 114,
     32,  49,  48,  46,  49,   0,
     73,  83,  71,  78,   8,   0,
      0,   0,   0,   0,   0,   0,
      8,   0,   0,   0,  79,  83,
     71,  78,   8,   0,   0,   0,
      0,   0,   0,   0,   8,   0,
      0,   0,  83,  72,  69,  88,
     40,   1,   0,   0,  80,   0,
      5,   0,  74,   0,   0,   0,
    106,   8,   0,   1,  89,   0,
      0,   4,  70, 142,  32,   0,
      0,   0,   0,   0,   1,   0,
      0,   0,  90,   0,   0,   3,
      0,  96,  16,   0,   0,   0,
      0,   0,  88,  40,   0,   4,
      0, 112,  16,   0,   0,   0,
      0,   0,  85,  85,   0,   0,
    156,  40,   0,   4,   0, 224,
     17,   0,   0,   0,   0,   0,
     85,  85,   0,   0,  95,   0,
      0,   2, 114,   0,   2,   0,
    104,   0,   0,   2,   1,   0,
      0,   0, 155,   0,   0,   4,
      8,   0,   0,   0,   8,   0,
      0,   0,   8,   0,   0,   0,
     86,   0,   0,   4, 114,   0,
     16,   0,   0,   0,   0,   0,
     70,   2,   2,   0,   0,   0,
      0,  10, 114,   0,  16,   0,
      0,   0,   0,   0,  70,   2,
     16,   0,   0,   0,   0,   0,
      2,  64,   0,   0,   0,   0,
      0,  63,   0,   0,   0,  63,
      0,   0,   0,  63,   0,   0,
      0,   0,  56,   0,   0,   8,
    114,   0,  16,   0,   0,   0,
      0,   0,  70,   2,  16,   0,
      0,   0,   0,   0,  70, 130,
     32,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  86,   0,
      0,   6, 130,   0,  16,   0,
      0,   0,   0,   0,  58, 128,
     32,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  72,   0,
      0, 141,  66,   1,   0, 128,
     67,  85,  21,   0, 242,   0,
     16,   0,   0,   0,   0,   0,
     70,   2,  16,   0,   0,   0,
      0,   0,  70, 126,  16,   0,
      0,   0,   0,   0,   0,  96,
     16,   0,   0,   0,   0,   0,
     58,   0,  16,   0,   0,   0,
      0,   0, 164,   0,   0,   6,
    242, 224,  17,   0,   0,   0,
      0,   0,  70,  10,   2,   0,
     70,  14,  16,   0,   0,   0,
      0,   0,  62,   0,   0,   1,
     83,  84,  65,  84, 148,   0,
      0,   0,   7,   0,   0,   0,
      1,   0,   0,   0,   0,   0,
      0,   0,   1,   0,   0,   0,
      2,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      1,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   1,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   2,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   1,   0,   0,   0
};

#endif // Q_OS_WIN

#endif // CS_MIPMAP_3D_P_H
