/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicRootPaneUI
extends RootPaneUI
implements PropertyChangeListener {
    private static RootPaneUI rootPaneUI = new BasicRootPaneUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return rootPaneUI;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults((JRootPane)jComponent);
        this.installComponents((JRootPane)jComponent);
        this.installListeners((JRootPane)jComponent);
        this.installKeyboardActions((JRootPane)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JRootPane)jComponent);
        this.uninstallComponents((JRootPane)jComponent);
        this.uninstallListeners((JRootPane)jComponent);
        this.uninstallKeyboardActions((JRootPane)jComponent);
    }

    protected void installDefaults(JRootPane jRootPane) {
        LookAndFeel.installProperty(jRootPane, "opaque", Boolean.FALSE);
    }

    protected void installComponents(JRootPane jRootPane) {
    }

    protected void installListeners(JRootPane jRootPane) {
        jRootPane.addPropertyChangeListener(this);
    }

    protected void installKeyboardActions(JRootPane jRootPane) {
        InputMap inputMap = this.getInputMap(2, jRootPane);
        SwingUtilities.replaceUIInputMap(jRootPane, 2, inputMap);
        inputMap = this.getInputMap(1, jRootPane);
        SwingUtilities.replaceUIInputMap(jRootPane, 1, inputMap);
        LazyActionMap.installLazyActionMap(jRootPane, BasicRootPaneUI.class, "RootPane.actionMap");
        this.updateDefaultButtonBindings(jRootPane);
    }

    protected void uninstallDefaults(JRootPane jRootPane) {
    }

    protected void uninstallComponents(JRootPane jRootPane) {
    }

    protected void uninstallListeners(JRootPane jRootPane) {
        jRootPane.removePropertyChangeListener(this);
    }

    protected void uninstallKeyboardActions(JRootPane jRootPane) {
        SwingUtilities.replaceUIInputMap(jRootPane, 2, null);
        SwingUtilities.replaceUIActionMap(jRootPane, null);
    }

    InputMap getInputMap(int n, JComponent jComponent) {
        if (n == 1) {
            return (InputMap)DefaultLookup.get(jComponent, this, "RootPane.ancestorInputMap");
        }
        if (n == 2) {
            return this.createInputMap(n, jComponent);
        }
        return null;
    }

    ComponentInputMap createInputMap(int n, JComponent jComponent) {
        return new RootPaneInputMap(jComponent);
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("press"));
        lazyActionMap.put(new Actions("release"));
        lazyActionMap.put(new Actions("postPopup"));
    }

    void updateDefaultButtonBindings(JRootPane jRootPane) {
        InputMap inputMap;
        for (inputMap = SwingUtilities.getUIInputMap(jRootPane, 2); inputMap != null && !(inputMap instanceof RootPaneInputMap); inputMap = inputMap.getParent()) {
        }
        if (inputMap != null) {
            Object[] objectArray;
            inputMap.clear();
            if (jRootPane.getDefaultButton() != null && (objectArray = (Object[])DefaultLookup.get(jRootPane, this, "RootPane.defaultButtonWindowKeyBindings")) != null) {
                LookAndFeel.loadKeyBindings(inputMap, objectArray);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("defaultButton")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            this.updateDefaultButtonBindings(jRootPane);
            if (jRootPane.getClientProperty("temporaryDefaultButton") == null) {
                jRootPane.putClientProperty("initialDefaultButton", propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class RootPaneInputMap
    extends ComponentInputMapUIResource {
        public RootPaneInputMap(JComponent jComponent) {
            super(jComponent);
        }
    }

    static class Actions
    extends UIAction {
        public static final String PRESS = "press";
        public static final String RELEASE = "release";
        public static final String POST_POPUP = "postPopup";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRootPane jRootPane = (JRootPane)actionEvent.getSource();
            JButton jButton = jRootPane.getDefaultButton();
            String string = this.getName();
            if (string == POST_POPUP) {
                JComponent jComponent;
                JPopupMenu jPopupMenu;
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component instanceof JComponent && (jPopupMenu = (jComponent = (JComponent)component).getComponentPopupMenu()) != null) {
                    Point point = jComponent.getPopupLocation(null);
                    if (point == null) {
                        Rectangle rectangle = jComponent.getVisibleRect();
                        point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                    }
                    jPopupMenu.show(component, point.x, point.y);
                }
            } else if (jButton != null && SwingUtilities.getRootPane(jButton) == jRootPane && string == PRESS) {
                jButton.doClick(20);
            }
        }

        @Override
        public boolean isEnabled(Object object) {
            String string = this.getName();
            if (string == POST_POPUP) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray != null && menuElementArray.length != 0) {
                    return false;
                }
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    return jComponent.getComponentPopupMenu() != null;
                }
                return false;
            }
            if (object != null && object instanceof JRootPane) {
                JButton jButton = ((JRootPane)object).getDefaultButton();
                return jButton != null && jButton.getModel().isEnabled();
            }
            return true;
        }
    }
}

