/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.lang.reflect.InvocationTargetException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceMap;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractScriptExecuteSettings;
import org.jkiss.utils.CommonUtils;

public class PostgreScriptExecuteSettings
extends AbstractScriptExecuteSettings<DBSObject> {
    private static final Log log = Log.getLog(PostgreScriptExecuteSettings.class);
    private PostgreDatabase database;

    public PostgreDatabase getDatabase() {
        return this.database;
    }

    public PostgreScriptExecuteSettings() {
    }

    public PostgreScriptExecuteSettings(@NotNull DBPProject project) {
        super(project);
    }

    public void setDatabase(PostgreDatabase database) {
        this.database = database;
    }

    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) throws DBException {
        super.loadSettings(runnableContext, store);
        String databaseId = null;
        if (store instanceof DBPPreferenceMap) {
            databaseId = store.getString("pg.script.database");
        }
        if (!CommonUtils.isEmpty(databaseId)) {
            try {
                String finalDatabaseId = databaseId;
                runnableContext.run(true, true, monitor -> {
                    try {
                        this.database = (PostgreDatabase)DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)this.getProject(), (String)finalDatabaseId);
                        if (this.database == null) {
                            throw new DBException("Database " + finalDatabaseId + " not found");
                        }
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Error loading objects configuration", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.findDatabase();
        }
        if (this.database == null) {
            throw new DBException("Cannot find database for script execution");
        }
    }

    private void findDatabase() {
        for (DBSObject object : this.getDatabaseObjects()) {
            if (!(object instanceof PostgreDatabase)) continue;
            this.database = (PostgreDatabase)object;
            break;
        }
    }

    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) {
        super.saveSettings(runnableContext, store);
        if (this.database == null) {
            this.findDatabase();
        }
        store.setValue("pg.script.database", DBUtils.getObjectFullId((DBSObject)this.database));
    }
}

