/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.manager.api.TypingAction;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.SendMessageResultUtils;

public class SendTypingCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "sendTyping";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Send typing message to trigger a typing indicator for the recipient. Indicator will be shown for 15seconds unless a typing STOP message is sent first.");
        subparser.addArgument(new String[]{"-g", "--group-id", "--group"}).help("Specify the recipient group ID.").nargs("*");
        subparser.addArgument(new String[]{"recipient"}).help("Specify the recipients' phone number.").nargs("*");
        subparser.addArgument(new String[]{"-s", "--stop"}).help("Send a typing STOP message.").action((ArgumentAction)Arguments.storeTrue());
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        List recipientStrings = ns.getList("recipient");
        List groupIdStrings = ns.getList("group-id");
        TypingAction action = Boolean.TRUE.equals(ns.getBoolean("stop")) ? TypingAction.STOP : TypingAction.START;
        HashSet<Object> recipientIdentifiers = new HashSet<Object>();
        if (recipientStrings != null) {
            String localNumber = m.getSelfNumber();
            recipientIdentifiers.addAll(CommandUtil.getSingleRecipientIdentifiers(recipientStrings, localNumber));
        }
        if (groupIdStrings != null) {
            recipientIdentifiers.addAll(CommandUtil.getGroupIdentifiers(groupIdStrings));
        }
        if (recipientIdentifiers.isEmpty()) {
            throw new UserErrorException("No recipients given");
        }
        try {
            SendMessageResults results = m.sendTypingMessage(action, recipientIdentifiers);
            SendMessageResultUtils.outputResult(outputWriter, results);
        }
        catch (IOException e) {
            throw new UserErrorException("Failed to send message: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")");
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new UserErrorException("Failed to send to group: " + e.getMessage());
        }
    }
}

