/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state.impl;

import java.util.HashMap;
import java.util.Map;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.state.IdentityKeyStore;

public class InMemoryIdentityKeyStore
implements IdentityKeyStore {
    private final Map<SignalProtocolAddress, IdentityKey> trustedKeys = new HashMap<SignalProtocolAddress, IdentityKey>();
    private final IdentityKeyPair identityKeyPair;
    private final int localRegistrationId;

    public InMemoryIdentityKeyStore(IdentityKeyPair identityKeyPair, int localRegistrationId) {
        this.identityKeyPair = identityKeyPair;
        this.localRegistrationId = localRegistrationId;
    }

    @Override
    public IdentityKeyPair getIdentityKeyPair() {
        return this.identityKeyPair;
    }

    @Override
    public int getLocalRegistrationId() {
        return this.localRegistrationId;
    }

    @Override
    public IdentityKeyStore.IdentityChange saveIdentity(SignalProtocolAddress address, IdentityKey identityKey) {
        IdentityKey existing = this.trustedKeys.get(address);
        this.trustedKeys.put(address, identityKey);
        if (existing == null || identityKey.equals(existing)) {
            return IdentityKeyStore.IdentityChange.NEW_OR_UNCHANGED;
        }
        return IdentityKeyStore.IdentityChange.REPLACED_EXISTING;
    }

    @Override
    public boolean isTrustedIdentity(SignalProtocolAddress address, IdentityKey identityKey, IdentityKeyStore.Direction direction) {
        IdentityKey trusted = this.trustedKeys.get(address);
        return trusted == null || trusted.equals(identityKey);
    }

    @Override
    public IdentityKey getIdentity(SignalProtocolAddress address) {
        return this.trustedKeys.get(address);
    }
}

