/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.util.function.Consumer;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.snapshot.ValueSnapshot;

@ServiceScope(value={Scope.BuildSession.class})
public interface InputFingerprinter {
    public Result fingerprintInputProperties(ImmutableSortedMap<String, ValueSnapshot> var1, ImmutableSortedMap<String, ? extends FileCollectionFingerprint> var2, ImmutableSortedMap<String, ValueSnapshot> var3, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> var4, Consumer<UnitOfWork.InputVisitor> var5) throws InputFingerprintingException, InputFileFingerprintingException;

    public static class InputFileFingerprintingException
    extends RuntimeException {
        private final String propertyName;

        public InputFileFingerprintingException(String propertyName, Throwable cause) {
            super(String.format("Cannot fingerprint input file property '%s': %s", propertyName, cause.getMessage()), cause);
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class InputFingerprintingException
    extends RuntimeException {
        private final String propertyName;

        public InputFingerprintingException(String propertyName, String message, Throwable cause) {
            super(String.format("Cannot fingerprint input property '%s': %s.", propertyName, message), cause);
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static interface Result {
        public ImmutableSortedMap<String, ValueSnapshot> getValueSnapshots();

        public ImmutableSortedMap<String, ValueSnapshot> getAllValueSnapshots();

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFileFingerprints();

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getAllFileFingerprints();

        public ImmutableSet<String> getPropertiesRequiringIsEmptyCheck();
    }
}

