// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// [DSIG (Digital Signature Table)](https://docs.microsoft.com/en-us/typography/opentype/spec/dsig#table-structure) table
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct DsigMarker {
    signature_records_byte_len: usize,
}

impl DsigMarker {
    pub fn version_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u32::RAW_BYTE_LEN
    }

    pub fn num_signatures_byte_range(&self) -> Range<usize> {
        let start = self.version_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn flags_byte_range(&self) -> Range<usize> {
        let start = self.num_signatures_byte_range().end;
        start..start + PermissionFlags::RAW_BYTE_LEN
    }

    pub fn signature_records_byte_range(&self) -> Range<usize> {
        let start = self.flags_byte_range().end;
        start..start + self.signature_records_byte_len
    }
}

impl MinByteRange for DsigMarker {
    fn min_byte_range(&self) -> Range<usize> {
        0..self.signature_records_byte_range().end
    }
}

impl TopLevelTable for Dsig<'_> {
    /// `DSIG`
    const TAG: Tag = Tag::new(b"DSIG");
}

impl<'a> FontRead<'a> for Dsig<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u32>();
        let num_signatures: u16 = cursor.read()?;
        cursor.advance::<PermissionFlags>();
        let signature_records_byte_len = (num_signatures as usize)
            .checked_mul(SignatureRecord::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        cursor.advance_by(signature_records_byte_len);
        cursor.finish(DsigMarker {
            signature_records_byte_len,
        })
    }
}

/// [DSIG (Digital Signature Table)](https://docs.microsoft.com/en-us/typography/opentype/spec/dsig#table-structure) table
pub type Dsig<'a> = TableRef<'a, DsigMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> Dsig<'a> {
    /// Version number of the DSIG table (0x00000001)
    pub fn version(&self) -> u32 {
        let range = self.shape.version_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Number of signatures in the table
    pub fn num_signatures(&self) -> u16 {
        let range = self.shape.num_signatures_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Permission flags
    pub fn flags(&self) -> PermissionFlags {
        let range = self.shape.flags_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Array of signature records
    pub fn signature_records(&self) -> &'a [SignatureRecord] {
        let range = self.shape.signature_records_byte_range();
        self.data.read_array(range).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Dsig<'a> {
    fn type_name(&self) -> &str {
        "Dsig"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("version", self.version())),
            1usize => Some(Field::new("num_signatures", self.num_signatures())),
            2usize => Some(Field::new("flags", self.flags())),
            3usize => Some(Field::new(
                "signature_records",
                traversal::FieldType::array_of_records(
                    stringify!(SignatureRecord),
                    self.signature_records(),
                    self.offset_data(),
                ),
            )),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for Dsig<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

/// [Permission flags](https://learn.microsoft.com/en-us/typography/opentype/spec/dsig#table-structure)
#[derive(Clone, Copy, Default, PartialEq, Eq, PartialOrd, Ord, Hash, bytemuck :: AnyBitPattern)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
#[repr(transparent)]
pub struct PermissionFlags {
    bits: u16,
}

impl PermissionFlags {
    /// Bit 0: Cannot be resigned
    pub const CANNOT_BE_RESIGNED: Self = Self {
        bits: 0b0000_0000_0000_0001,
    };
}

impl PermissionFlags {
    ///  Returns an empty set of flags.
    #[inline]
    pub const fn empty() -> Self {
        Self { bits: 0 }
    }

    /// Returns the set containing all flags.
    #[inline]
    pub const fn all() -> Self {
        Self {
            bits: Self::CANNOT_BE_RESIGNED.bits,
        }
    }

    /// Returns the raw value of the flags currently stored.
    #[inline]
    pub const fn bits(&self) -> u16 {
        self.bits
    }

    /// Convert from underlying bit representation, unless that
    /// representation contains bits that do not correspond to a flag.
    #[inline]
    pub const fn from_bits(bits: u16) -> Option<Self> {
        if (bits & !Self::all().bits()) == 0 {
            Some(Self { bits })
        } else {
            None
        }
    }

    /// Convert from underlying bit representation, dropping any bits
    /// that do not correspond to flags.
    #[inline]
    pub const fn from_bits_truncate(bits: u16) -> Self {
        Self {
            bits: bits & Self::all().bits,
        }
    }

    /// Returns `true` if no flags are currently stored.
    #[inline]
    pub const fn is_empty(&self) -> bool {
        self.bits() == Self::empty().bits()
    }

    /// Returns `true` if there are flags common to both `self` and `other`.
    #[inline]
    pub const fn intersects(&self, other: Self) -> bool {
        !(Self {
            bits: self.bits & other.bits,
        })
        .is_empty()
    }

    /// Returns `true` if all of the flags in `other` are contained within `self`.
    #[inline]
    pub const fn contains(&self, other: Self) -> bool {
        (self.bits & other.bits) == other.bits
    }

    /// Inserts the specified flags in-place.
    #[inline]
    pub fn insert(&mut self, other: Self) {
        self.bits |= other.bits;
    }

    /// Removes the specified flags in-place.
    #[inline]
    pub fn remove(&mut self, other: Self) {
        self.bits &= !other.bits;
    }

    /// Toggles the specified flags in-place.
    #[inline]
    pub fn toggle(&mut self, other: Self) {
        self.bits ^= other.bits;
    }

    /// Returns the intersection between the flags in `self` and
    /// `other`.
    ///
    /// Specifically, the returned set contains only the flags which are
    /// present in *both* `self` *and* `other`.
    ///
    /// This is equivalent to using the `&` operator (e.g.
    /// [`ops::BitAnd`]), as in `flags & other`.
    ///
    /// [`ops::BitAnd`]: https://doc.rust-lang.org/std/ops/trait.BitAnd.html
    #[inline]
    #[must_use]
    pub const fn intersection(self, other: Self) -> Self {
        Self {
            bits: self.bits & other.bits,
        }
    }

    /// Returns the union of between the flags in `self` and `other`.
    ///
    /// Specifically, the returned set contains all flags which are
    /// present in *either* `self` *or* `other`, including any which are
    /// present in both.
    ///
    /// This is equivalent to using the `|` operator (e.g.
    /// [`ops::BitOr`]), as in `flags | other`.
    ///
    /// [`ops::BitOr`]: https://doc.rust-lang.org/std/ops/trait.BitOr.html
    #[inline]
    #[must_use]
    pub const fn union(self, other: Self) -> Self {
        Self {
            bits: self.bits | other.bits,
        }
    }

    /// Returns the difference between the flags in `self` and `other`.
    ///
    /// Specifically, the returned set contains all flags present in
    /// `self`, except for the ones present in `other`.
    ///
    /// It is also conceptually equivalent to the "bit-clear" operation:
    /// `flags & !other` (and this syntax is also supported).
    ///
    /// This is equivalent to using the `-` operator (e.g.
    /// [`ops::Sub`]), as in `flags - other`.
    ///
    /// [`ops::Sub`]: https://doc.rust-lang.org/std/ops/trait.Sub.html
    #[inline]
    #[must_use]
    pub const fn difference(self, other: Self) -> Self {
        Self {
            bits: self.bits & !other.bits,
        }
    }
}

impl std::ops::BitOr for PermissionFlags {
    type Output = Self;

    /// Returns the union of the two sets of flags.
    #[inline]
    fn bitor(self, other: PermissionFlags) -> Self {
        Self {
            bits: self.bits | other.bits,
        }
    }
}

impl std::ops::BitOrAssign for PermissionFlags {
    /// Adds the set of flags.
    #[inline]
    fn bitor_assign(&mut self, other: Self) {
        self.bits |= other.bits;
    }
}

impl std::ops::BitXor for PermissionFlags {
    type Output = Self;

    /// Returns the left flags, but with all the right flags toggled.
    #[inline]
    fn bitxor(self, other: Self) -> Self {
        Self {
            bits: self.bits ^ other.bits,
        }
    }
}

impl std::ops::BitXorAssign for PermissionFlags {
    /// Toggles the set of flags.
    #[inline]
    fn bitxor_assign(&mut self, other: Self) {
        self.bits ^= other.bits;
    }
}

impl std::ops::BitAnd for PermissionFlags {
    type Output = Self;

    /// Returns the intersection between the two sets of flags.
    #[inline]
    fn bitand(self, other: Self) -> Self {
        Self {
            bits: self.bits & other.bits,
        }
    }
}

impl std::ops::BitAndAssign for PermissionFlags {
    /// Disables all flags disabled in the set.
    #[inline]
    fn bitand_assign(&mut self, other: Self) {
        self.bits &= other.bits;
    }
}

impl std::ops::Sub for PermissionFlags {
    type Output = Self;

    /// Returns the set difference of the two sets of flags.
    #[inline]
    fn sub(self, other: Self) -> Self {
        Self {
            bits: self.bits & !other.bits,
        }
    }
}

impl std::ops::SubAssign for PermissionFlags {
    /// Disables all flags enabled in the set.
    #[inline]
    fn sub_assign(&mut self, other: Self) {
        self.bits &= !other.bits;
    }
}

impl std::ops::Not for PermissionFlags {
    type Output = Self;

    /// Returns the complement of this set of flags.
    #[inline]
    fn not(self) -> Self {
        Self { bits: !self.bits } & Self::all()
    }
}

impl std::fmt::Debug for PermissionFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        let members: &[(&str, Self)] = &[("CANNOT_BE_RESIGNED", Self::CANNOT_BE_RESIGNED)];
        let mut first = true;
        for (name, value) in members {
            if self.contains(*value) {
                if !first {
                    f.write_str(" | ")?;
                }
                first = false;
                f.write_str(name)?;
            }
        }
        if first {
            f.write_str("(empty)")?;
        }
        Ok(())
    }
}

impl std::fmt::Binary for PermissionFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        std::fmt::Binary::fmt(&self.bits, f)
    }
}

impl std::fmt::Octal for PermissionFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        std::fmt::Octal::fmt(&self.bits, f)
    }
}

impl std::fmt::LowerHex for PermissionFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        std::fmt::LowerHex::fmt(&self.bits, f)
    }
}

impl std::fmt::UpperHex for PermissionFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        std::fmt::UpperHex::fmt(&self.bits, f)
    }
}

impl font_types::Scalar for PermissionFlags {
    type Raw = <u16 as font_types::Scalar>::Raw;
    fn to_raw(self) -> Self::Raw {
        self.bits().to_raw()
    }
    fn from_raw(raw: Self::Raw) -> Self {
        let t = <u16>::from_raw(raw);
        Self::from_bits_truncate(t)
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> From<PermissionFlags> for FieldType<'a> {
    fn from(src: PermissionFlags) -> FieldType<'a> {
        src.bits().into()
    }
}

/// [Signature Record](https://learn.microsoft.com/en-us/typography/opentype/spec/dsig#table-structure)
#[derive(Clone, Debug, Copy, bytemuck :: AnyBitPattern)]
#[repr(C)]
#[repr(packed)]
pub struct SignatureRecord {
    /// Format of the signature
    pub format: BigEndian<u32>,
    /// Length of signature in bytes
    pub length: BigEndian<u32>,
    /// Offset to the signature block from the beginning of the table
    pub signature_block_offset: BigEndian<Offset32>,
}

impl SignatureRecord {
    /// Format of the signature
    pub fn format(&self) -> u32 {
        self.format.get()
    }

    /// Length of signature in bytes
    pub fn length(&self) -> u32 {
        self.length.get()
    }

    /// Offset to the signature block from the beginning of the table
    pub fn signature_block_offset(&self) -> Offset32 {
        self.signature_block_offset.get()
    }
}

impl FixedSize for SignatureRecord {
    const RAW_BYTE_LEN: usize = u32::RAW_BYTE_LEN + u32::RAW_BYTE_LEN + Offset32::RAW_BYTE_LEN;
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeRecord<'a> for SignatureRecord {
    fn traverse(self, data: FontData<'a>) -> RecordResolver<'a> {
        RecordResolver {
            name: "SignatureRecord",
            get_field: Box::new(move |idx, _data| match idx {
                0usize => Some(Field::new("format", self.format())),
                1usize => Some(Field::new("length", self.length())),
                2usize => Some(Field::new(
                    "signature_block_offset",
                    FieldType::offset(self.signature_block_offset(), self.signature_block(_data)),
                )),
                _ => None,
            }),
            data,
        }
    }
}

/// [Signature Block Format 1](https://learn.microsoft.com/en-us/typography/opentype/spec/dsig#table-structure)
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct SignatureBlockFormat1Marker {
    signature_byte_len: usize,
}

impl SignatureBlockFormat1Marker {
    pub fn _reserved1_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn _reserved2_byte_range(&self) -> Range<usize> {
        let start = self._reserved1_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn signature_length_byte_range(&self) -> Range<usize> {
        let start = self._reserved2_byte_range().end;
        start..start + u32::RAW_BYTE_LEN
    }

    pub fn signature_byte_range(&self) -> Range<usize> {
        let start = self.signature_length_byte_range().end;
        start..start + self.signature_byte_len
    }
}

impl MinByteRange for SignatureBlockFormat1Marker {
    fn min_byte_range(&self) -> Range<usize> {
        0..self.signature_byte_range().end
    }
}

impl<'a> FontRead<'a> for SignatureBlockFormat1<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        cursor.advance::<u16>();
        let signature_length: u32 = cursor.read()?;
        let signature_byte_len = (signature_length as usize)
            .checked_mul(u8::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        cursor.advance_by(signature_byte_len);
        cursor.finish(SignatureBlockFormat1Marker { signature_byte_len })
    }
}

/// [Signature Block Format 1](https://learn.microsoft.com/en-us/typography/opentype/spec/dsig#table-structure)
pub type SignatureBlockFormat1<'a> = TableRef<'a, SignatureBlockFormat1Marker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> SignatureBlockFormat1<'a> {
    /// Length (in bytes) of the PKCS#7 packet in the signature field.
    pub fn signature_length(&self) -> u32 {
        let range = self.shape.signature_length_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// PKCS#7 packet
    pub fn signature(&self) -> &'a [u8] {
        let range = self.shape.signature_byte_range();
        self.data.read_array(range).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for SignatureBlockFormat1<'a> {
    fn type_name(&self) -> &str {
        "SignatureBlockFormat1"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("signature_length", self.signature_length())),
            1usize => Some(Field::new("signature", self.signature())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for SignatureBlockFormat1<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}
