/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mso.generator.utils.Choice;
import mso.generator.utils.Limitation;
import mso.generator.utils.MSO;
import mso.generator.utils.Member;
import mso.generator.utils.Stream;
import mso.generator.utils.Struct;
import mso.generator.utils.Type;
import mso.generator.utils.TypeRegistry;

public class JavaParserGenerator {
    void generate(MSO mSO, String string, String string2, String string3) throws IOException {
        FileWriter fileWriter = new FileWriter(string + "/" + string2.replace('.', '/') + "/" + string3 + ".java");
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("package " + string2 + ";");
        printWriter.println("import java.io.IOException;");
        printWriter.println("public class " + string3 + " {");
        printWriter.println("    Object parse(String key, LEInputStream in) throws IOException {");
        boolean bl = true;
        for (Stream object : mSO.streams) {
            printWriter.print("        ");
            if (bl) {
                bl = false;
            } else {
                printWriter.print("} else ");
            }
            printWriter.println("if (\"" + object.key + "\".equals(key)) {");
            printWriter.println("            return parse" + object.type + "(in);");
        }
        printWriter.println("        } else {");
        printWriter.println("            return parseTODOS(in);");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println("    void serialize(String key, Object o, LEOutputStream out) throws IOException {");
        bl = true;
        for (Stream stream : mSO.streams) {
            printWriter.print("        ");
            if (bl) {
                bl = false;
            } else {
                printWriter.print("} else ");
            }
            printWriter.println("if (\"" + stream.key + "\".equals(key)) {");
            printWriter.println("            write((" + stream.type + ")o, out);");
        }
        printWriter.println("        } else {");
        printWriter.println("            write((TODOS)o, out);");
        printWriter.println("        }");
        printWriter.println("    }");
        for (Struct struct : mSO.structs) {
            JavaParserGenerator.printStructureParser(printWriter, struct);
            JavaParserGenerator.printStructureWriter(printWriter, struct);
        }
        printWriter.println("}");
        for (Struct struct : mSO.structs) {
            JavaParserGenerator.printStructureClass(printWriter, struct);
        }
        printWriter.close();
        fileWriter.close();
    }

    private static void printStructureParser(PrintWriter printWriter, Struct struct) {
        printWriter.println("    " + struct.name + " parse" + struct.name + "(LEInputStream in) throws IOException  {");
        printWriter.println("        " + struct.name + " _s = new " + struct.name + "();");
        if (struct.containsKnownLengthArrayMember) {
            printWriter.println("        int _c;");
        }
        boolean bl = false;
        for (Member member : struct.members) {
            if (!member.isArray || member.count != null || member.size != null) continue;
            bl = struct.containsUnknownLengthArrayMember;
        }
        if (struct.containsOptionalMember || bl || struct.containsChoice) {
            printWriter.println("        Object _m;");
        }
        if (bl) {
            printWriter.println("        boolean _atend;");
        }
        for (Member member : struct.members) {
            JavaParserGenerator.printStructureMemberParser(printWriter, member);
        }
        if (struct.name.contains("RecordHeader")) {
            printWriter.println("System.out.println(in.getPosition()+\" \"+_s);");
        }
        printWriter.println("        return _s;");
        printWriter.println("    }");
    }

    private static void printStructureWriter(PrintWriter printWriter, Struct struct) {
        printWriter.println("    void write(" + struct.name + " _s, LEOutputStream out) throws IOException  {");
        for (Member member : struct.members) {
            JavaParserGenerator.printStructureMemberWriter(printWriter, member);
        }
        printWriter.println("    }");
    }

    private static void printStructureMemberWriter(PrintWriter printWriter, Member member) {
        Object object = "        ";
        if (member.condition != null) {
            printWriter.println("        if (" + JavaParserGenerator.getExpression("_s", member.condition) + ") {");
            object = (String)object + "    ";
        }
        if (member.isChoice) {
            boolean bl = true;
            Choice choice = (Choice)member.type();
            for (String string : choice.getChoiceNames()) {
                printWriter.print((String)object);
                if (!bl) {
                    printWriter.print("} else ");
                }
                bl = false;
                printWriter.println("if (_s." + member.name + " instanceof " + string + ") {");
                printWriter.println((String)object + "    write((" + string + ")_s." + member.name + ", out);");
            }
            printWriter.println((String)object + "}");
        } else if (member.isArray) {
            String string = JavaParserGenerator.getTypeName(member);
            printWriter.println((String)object + "for (" + string + " _i: _s." + member.name + ") {");
            if (member.isStruct) {
                printWriter.println((String)object + "    write(_i, out);");
            } else {
                printWriter.println((String)object + "    out.write" + member.type().name + "(_i);");
            }
            printWriter.println((String)object + "}");
        } else if (member.isStruct) {
            printWriter.print((String)object);
            if (member.isOptional) {
                printWriter.print("if (_s." + member.name + " != null) ");
            }
            printWriter.println("write(_s." + member.name + ", out);");
        } else {
            printWriter.println((String)object + "out.write" + member.type().name + "(_s." + member.name + ");");
        }
        if (member.condition != null) {
            printWriter.println("        }");
        }
    }

    private static String getTypeName(Member member) {
        Type type = member.type();
        TypeRegistry typeRegistry = member.registry;
        if (type instanceof Struct) {
            return member.type().name;
        }
        if (type instanceof Choice) {
            return "Object";
        }
        if (type == typeRegistry.bit) {
            return "boolean";
        }
        if (type == typeRegistry.uint2 || type == typeRegistry.uint3 || type == typeRegistry.uint4 || type == typeRegistry.uint5 || type == typeRegistry.uint6 || type == typeRegistry.uint7 || type == typeRegistry.uint8) {
            return "byte";
        }
        if (type == typeRegistry.uint9 || type == typeRegistry.uint12 || type == typeRegistry.uint13 || type == typeRegistry.uint14 || type == typeRegistry.uint15 || type == typeRegistry.int16) {
            return "short";
        }
        if (type == typeRegistry.uint16 || type == typeRegistry.uint20 || type == typeRegistry.uint30 || type == typeRegistry.uint32 || type == typeRegistry.int32) {
            return "int";
        }
        return type.name;
    }

    private static String getMemberDeclaration(Member member) {
        if (member.isArray) {
            if (member.count == null) {
                return "final java.util.List<" + member.type().name + "> " + member.name + " = new java.util.ArrayList<" + member.type().name + ">()";
            }
            return JavaParserGenerator.getTypeName(member) + "[] " + member.name;
        }
        return JavaParserGenerator.getTypeName(member) + " " + member.name;
    }

    private static void printStructureClass(PrintWriter printWriter, Struct struct) {
        printWriter.println("class " + struct.name + " {");
        for (Member member : struct.members) {
            String string = JavaParserGenerator.getMemberDeclaration(member);
            printWriter.println("    " + string + ";");
        }
        printWriter.println("    public String toString() {");
        printWriter.println("        String _s = \"" + struct.name + ":\";");
        for (Member member : struct.members) {
            printWriter.print("        _s = _s + \"" + member.name + ": \" + String.valueOf(" + member.name + ") + \"");
            if (member.isInteger && !member.isArray) {
                printWriter.print("(\" + Integer.toHexString(" + member.name + ").toUpperCase() + \")");
            }
            printWriter.println(", \";");
        }
        printWriter.println("        return _s;");
        printWriter.println("    }");
        printWriter.println("}");
    }

    private static String prependStructureToExpression(String string, String string2) {
        if (string.length() > 0) {
            Pattern pattern = Pattern.compile("([^.\\w])([.a-zA-Z])");
            Matcher matcher = pattern.matcher(string);
            string = matcher.replaceAll("$1" + string2 + ".$2");
            pattern = Pattern.compile("^([a-zA-Z])");
            matcher = pattern.matcher(string);
            string = matcher.replaceAll(string2 + ".$1");
        }
        return string;
    }

    private static void printStructureMemberParser(PrintWriter printWriter, Member member) {
        Object object = "        ";
        String string = null;
        if (member.condition != null) {
            string = JavaParserGenerator.prependStructureToExpression(member.condition, "_s");
            object = (String)object + "    ";
            printWriter.println("        if (" + string + ") {");
        }
        String string2 = null;
        if (member.count != null) {
            string2 = JavaParserGenerator.prependStructureToExpression(member.count, "_s");
        }
        String string3 = member.isStruct ? "parse" + member.type().name + "(in);" : "in.read" + member.type().name + "();";
        if (member.isChoice) {
            JavaParserGenerator.printChoiceParser(printWriter, (String)object, member);
            return;
        }
        if (member.isArray && member.count == null) {
            if (member.size != null) {
                JavaParserGenerator.printFixedSizeArrayParser(printWriter, (String)object, member, member.size);
            } else {
                JavaParserGenerator.printVariableArrayParser(printWriter, (String)object, member);
            }
            return;
        }
        if (member.isOptional) {
            JavaParserGenerator.printOptionalMemberParser(printWriter, (String)object, member);
            return;
        }
        if (string2 != null) {
            printWriter.println((String)object + "_c = " + string2 + ";");
        }
        printWriter.print((String)object + "_s." + member.name + " = ");
        if (string2 != null) {
            if (member.type() == member.registry.uint8) {
                printWriter.println("in.readBytes(_c);");
            } else {
                printWriter.println("new " + JavaParserGenerator.getTypeName(member) + "[_c];");
                printWriter.println((String)object + "for (int _j=0; _j<_c; ++_j) {");
                printWriter.println((String)object + "    _s." + member.name + "[_j] = " + string3);
                JavaParserGenerator.printLimitationCheck(printWriter, "            ", "_s." + member.name + "[_j]", member);
                printWriter.println((String)object + "}");
            }
        } else {
            printWriter.println(string3);
            JavaParserGenerator.printLimitationCheck(printWriter, "        ", "_s." + member.name, member);
        }
        if (string != null) {
            printWriter.println("        }");
        }
    }

    private static void printChoiceParser(PrintWriter printWriter, String string, Member member) {
        Object object = "";
        Object object2 = "_x";
        printWriter.println(string + "_m = in.setMark();");
        Choice choice = (Choice)member.type();
        String[] stringArray = choice.getChoiceNames();
        int n = member.isOptional ? stringArray.length : stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            printWriter.println(string + "try {");
            printWriter.println(string + "    _s." + member.name + " = parse" + stringArray[i] + "(in);");
            printWriter.println(string + "} catch (IOException " + (String)object2 + ") {");
            printWriter.println(string + "    if (!(" + (String)object2 + " instanceof IncorrectValueException) && !(" + (String)object2 + " instanceof java.io.EOFException)) throw " + (String)object2 + ";");
            printWriter.println(string + "    in.rewind(_m);");
            object2 = (String)object2 + "x";
            object = (String)object + "}";
        }
        if (!member.isOptional) {
            printWriter.println(string + "    _s." + member.name + " = parse" + stringArray[stringArray.length - 1] + "(in);");
        }
        printWriter.println(string + (String)object + " finally {");
        printWriter.println(string + "    in.releaseMark(_m);");
        printWriter.println(string + "}");
    }

    private static void printFixedSizeArrayParser(PrintWriter printWriter, String string, Member member, String string2) {
        printWriter.println(string + "int _startPos = in.getPosition();");
        printWriter.println(string + "while (in.getPosition() - _startPos < " + JavaParserGenerator.getExpression("_s", string2) + ") {");
        printWriter.println(string + "    " + member.type().name + " _t = parse" + member.type().name + "(in);");
        printWriter.println(string + "    _s." + member.name + ".add(_t);");
        printWriter.println(string + "}");
    }

    private static void printVariableArrayParser(PrintWriter printWriter, String string, Member member) {
        printWriter.println(string + "_atend = false;");
        printWriter.println(string + "while (!_atend) {");
        printWriter.println(string + "    _m = in.setMark();");
        printWriter.println(string + "    try {");
        printWriter.println(string + "        " + member.type().name + " _t = parse" + member.type().name + "(in);");
        printWriter.println(string + "        _s." + member.name + ".add(_t);");
        printWriter.println(string + "    } catch(IncorrectValueException _e) {");
        printWriter.println(string + "        _atend = true;");
        printWriter.println(string + "        in.rewind(_m);");
        printWriter.println(string + "    } catch(java.io.EOFException _e) {");
        printWriter.println(string + "        _atend = true;");
        printWriter.println(string + "        in.rewind(_m);");
        printWriter.println(string + "    } finally {");
        printWriter.println(string + "        in.releaseMark(_m);");
        printWriter.println(string + "   }");
        printWriter.println(string + "}");
    }

    private static void printOptionalMemberParser(PrintWriter printWriter, String string, Member member) {
        printWriter.println(string + "_m = in.setMark();");
        printWriter.println(string + "try {");
        printWriter.println(string + "    _s." + member.name + " = parse" + member.type().name + "(in);");
        printWriter.println(string + "} catch(IncorrectValueException _e) {");
        printWriter.println(string + "    if (in.distanceFromMark(_m) > 16) throw new IOException(_e);//onlyfordebug");
        printWriter.println(string + "    in.rewind(_m);");
        printWriter.println(string + "} catch(java.io.EOFException _e) {");
        printWriter.println(string + "    in.rewind(_m);");
        printWriter.println(string + "} finally {");
        printWriter.println(string + "    in.releaseMark(_m);");
        printWriter.println(string + "}");
    }

    private static void printLimitationCheck(PrintWriter printWriter, String string, String string2, Member member) {
        for (Limitation limitation : member.limitations) {
            Object object = limitation.name;
            object = !"".equals(object) ? string2 + "." + (String)object : string2;
            String string3 = JavaParserGenerator.getCondition((String)object, limitation);
            printWriter.println(string + "if (!(" + string3 + ")) {");
            String string4 = "IncorrectValueException";
            printWriter.println(string + "    throw new " + string4 + "(in.getPosition() + \"" + string3 + " for value \" + String.valueOf(" + string2 + ") );");
            printWriter.println(string + "}");
        }
    }

    private static String getExpression(String string, String string2) {
        if (Pattern.matches(".*[A-Za-z].*", string2)) {
            return JavaParserGenerator.prependStructureToExpression(string2, string);
        }
        return string + string2;
    }

    private static String getCondition(String string, Limitation limitation) {
        String string2 = limitation.value;
        String string3 = limitation.expression;
        if (string2 != null) {
            return JavaParserGenerator.getCondition(string, string2);
        }
        if (string3 != null) {
            return JavaParserGenerator.getExpression(string, string3);
        }
        throw new Error("Either expression or value should be set.");
    }

    private static String getCondition(String string, String string2) {
        String string3 = " == ";
        String string4 = " || ";
        if (string2.startsWith("!")) {
            string2 = string2.substring(1);
            string3 = " != ";
            string4 = " && ";
        }
        if (string2.contains("|")) {
            String[] stringArray = string2.split("\\|");
            String string5 = string + string3 + stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string5 = string5 + string4 + string + string3 + stringArray[i];
            }
            return string5;
        }
        return string + string3 + string2;
    }
}

