//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspasteboarditem?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSPasteboardItem;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSPasteboardItem {}
);

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardReading for NSPasteboardItem {}
);

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardWriting for NSPasteboardItem {}
);

impl NSPasteboardItem {
    extern_methods!(
        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(types))]
        #[unsafe(method_family = none)]
        pub fn types(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(availableTypeFromArray:))]
        #[unsafe(method_family = none)]
        pub fn availableTypeFromArray(
            &self,
            types: &NSArray<NSPasteboardType>,
        ) -> Option<Retained<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(setDataProvider:forTypes:))]
        #[unsafe(method_family = none)]
        pub fn setDataProvider_forTypes(
            &self,
            data_provider: &ProtocolObject<dyn NSPasteboardItemDataProvider>,
            types: &NSArray<NSPasteboardType>,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(setData:forType:))]
        #[unsafe(method_family = none)]
        pub fn setData_forType(&self, data: &NSData, r#type: &NSPasteboardType) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(setString:forType:))]
        #[unsafe(method_family = none)]
        pub fn setString_forType(&self, string: &NSString, r#type: &NSPasteboardType) -> bool;

        #[cfg(feature = "NSPasteboard")]
        /// # Safety
        ///
        /// `property_list` should be of the correct type.
        #[unsafe(method(setPropertyList:forType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPropertyList_forType(
            &self,
            property_list: &AnyObject,
            r#type: &NSPasteboardType,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(dataForType:))]
        #[unsafe(method_family = none)]
        pub fn dataForType(&self, r#type: &NSPasteboardType) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(stringForType:))]
        #[unsafe(method_family = none)]
        pub fn stringForType(&self, r#type: &NSPasteboardType) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(propertyListForType:))]
        #[unsafe(method_family = none)]
        pub fn propertyListForType(&self, r#type: &NSPasteboardType)
            -> Option<Retained<AnyObject>>;

        #[cfg(all(feature = "NSPasteboard", feature = "block2"))]
        /// Determines whether this pasteboard item matches the specified patterns, without notifying the person using the app.
        ///
        /// This method only gives an indication of whether a pasteboard item matches a particular pattern and doesn’t allow the app to access the item's contents. As a result, the system doesn’t notify the person using the app about reading the contents of the pasteboard.
        ///
        /// The following example shows how to use this method to find email and postal addresses in each item on the pasteboard:
        ///
        /// ```obj-c
        /// NSArray
        /// <NSPasteboardItem
        /// *> *items = NSPasteboard.generalPasteboard.pasteboardItems;
        /// __block NSUInteger idx = 0;
        /// for (NSPasteboardItem *item in items) {
        /// NSUInteger itemIndex = idx++;
        /// [item
        /// detectPatternsForPatterns:[NSSet setWithArray:
        /// @
        /// [NSPasteboardDetectionPatternEmailAddress,
        /// NSPasteboardDetectionPatternPostalAddress]]
        /// completionHandler:^(NSSet
        /// <NSPasteboardDetectionPattern
        /// > *matchedPatterns, NSError *error) {
        /// if (error) {
        /// NSLog(
        /// "
        /// Item %lu: Error: %
        /// "
        /// , itemIndex, error);
        /// return;
        /// }
        /// BOOL matchedEmail = [matchedPatterns containsObject:NSPasteboardDetectionPatternEmailAddress];
        /// BOOL matchedPostal = [matchedPatterns containsObject: NSPasteboardDetectionPatternPostalAddress];
        /// if (matchedEmail) {
        /// NSLog(
        /// "
        /// Item %lu - Email address(es) detected", itemIndex);
        /// }
        /// if (matchedPostal) {
        /// NSLog(
        /// "
        /// Item %lu - Postal address(es) detected", itemIndex);
        /// }
        /// if (!matchedEmail
        /// &
        /// &
        /// !matchedPostal) {
        /// NSLog(
        /// "
        /// Item %lu - Matched neither email nor postal addresses.", itemIndex);
        /// }
        /// }];
        /// }
        /// ```
        ///
        /// - Parameters:
        /// - patterns: The patterns to detect on the pasteboard item.
        /// - completionHandler: A block that the system invokes after detecting patterns on the pasteboard item. The block receives either a set with the patterns the system finds on the pasteboard item or an error if detection fails.
        #[unsafe(method(detectPatternsForPatterns:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn detectPatternsForPatterns_completionHandler(
            &self,
            patterns: &NSSet<NSPasteboardDetectionPattern>,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSSet<NSPasteboardDetectionPattern>, *mut NSError),
            >,
        );

        #[cfg(all(feature = "NSPasteboard", feature = "block2"))]
        /// Determines whether this pasteboard item matches the specified patterns, reading the contents if it finds a match.
        ///
        /// For details about the types returned for each pattern, see ``NSPasteboardDetectionPattern``.
        ///
        /// The following example shows how to use this method to find web URLs and web search terms in each item on the pasteboard:
        ///
        /// ```obj-c
        /// NSArray
        /// <NSPasteboardItem
        /// *> *items = NSPasteboard.generalPasteboard.pasteboardItems;
        /// __block NSUInteger idx = 0;
        /// for (NSPasteboardItem *item in items) {
        /// NSUInteger itemIndex = idx++;
        /// [item
        /// detectValuesForPatterns:[NSSet setWithArray:
        /// @
        /// [NSPasteboardDetectionPatternProbableWebSearch,
        /// NSPasteboardDetectionPatternProbableWebURL]]
        /// completionHandler:^(NSDictionary
        /// <NSPasteboardDetectionPattern
        /// , id> *patternValues, NSError *error) {
        /// if (error) {
        /// NSLog(
        /// "
        /// Item %lu: Error: %
        /// "
        /// , itemIndex, error);
        /// return;
        /// }
        /// NSString *searchString = (NSString*)patternValues[NSPasteboardDetectionPatternProbableWebSearch];
        /// NSString *urlString = (NSString*)patternValues[NSPasteboardDetectionPatternProbableWebURL] ;
        /// if (searchString != nil) {
        /// NSLog(
        /// "
        /// Item %lu - Web search retrieved: %
        /// "
        /// , itemIndex, searchString);
        /// }
        /// if (urlString != nil) {
        /// NSLog(
        /// "
        /// Item %lu - Web URL retrieved: %
        /// "
        /// , itemIndex, urlString);
        /// }
        /// if (searchString == nil
        /// &
        /// &
        /// urlString == nil) {
        /// NSLog(
        /// "
        /// Item %lu - No web patterns retrieved.", itemIndex);
        /// }
        /// }];
        /// }
        /// ```
        ///
        /// > Important: If the system finds a match when calling this method, the system informs the person using the app that the app is trying to read the contents of the pasteboard. If the person denies access to the pasteboard, the completion handler receives an error.
        ///
        /// - Parameters:
        /// - patterns: The patterns to detect on the pasteboard item.
        /// - completionHandler: A block the system invokes after detecting patterns on the pasteboard item. The block returns either a dictionary with the patterns the system finds on the pasteboard item or an error if detection fails. The dictionary keys specify the matched patterns, and the values specify the corresponding content of the pasteboard.
        #[unsafe(method(detectValuesForPatterns:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn detectValuesForPatterns_completionHandler(
            &self,
            patterns: &NSSet<NSPasteboardDetectionPattern>,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSDictionary<NSPasteboardDetectionPattern, AnyObject>, *mut NSError),
            >,
        );

        #[cfg(all(feature = "NSPasteboard", feature = "block2"))]
        /// Determines available metadata from the specified metadata types for this pasteboard item, without notifying the person using the app.
        ///
        /// This method only gives access to limited types of metadata and doesn’t allow the app to access the contents. As a result, the system doesn’t notify the person using the app about reading the contents of the pasteboard.
        ///
        /// For details about the metadata returned for each type, see ``NSPasteboardMetadataType``.
        ///
        /// The following example shows how to iterate over each pasteboard item and, if the item is a URL that points to a file, get its content type with this method:
        ///
        /// ```obj-c
        /// NSArray
        /// <NSPasteboardItem
        /// *> *items = NSPasteboard.generalPasteboard.pasteboardItems;
        /// __block NSUInteger idx = 0;
        /// for (NSPasteboardItem *item in items) {
        /// NSUInteger itemIndex = idx++;
        /// [item
        /// detectMetadataForTypes:[NSSet setWithArray:
        /// @
        /// [NSPasteboardMetadataTypeContentType]]
        /// completionHandler:^(NSDictionary
        /// <NSPasteboardMetadataType
        /// , id> *metadata, NSError *error) {
        /// if (error) {
        /// NSLog(
        /// "
        /// Item %lu - Error: %
        /// "
        /// , itemIndex, error);
        /// return;
        /// }
        /// UTType *contentType = (UTType*)metadata[NSPasteboardMetadataTypeContentType];
        /// if (contentType) {
        /// NSLog(
        /// "
        /// Item %lu - Content type is: %
        /// "
        /// , itemIndex, contentType.identifier);
        /// } else {
        /// NSLog(
        /// "
        /// Item %lu - Couldn't get content type", itemIndex);
        /// }
        /// }];
        /// }
        /// ```
        ///
        /// - Parameters:
        /// - types: The metadata types to detect on the pasteboard item.
        /// - completionHandler: A block the system invokes after detecting metadata on the pasteboard item. The block receives either a dictionary with the metadata types the system finds on the pasteboard item or an error if detection fails. The dictionary keys specify the matched metadata types, and the values specify the corresponding metadata.
        #[unsafe(method(detectMetadataForTypes:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn detectMetadataForTypes_completionHandler(
            &self,
            types: &NSSet<NSPasteboardMetadataType>,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSDictionary<NSPasteboardMetadataType, AnyObject>, *mut NSError),
            >,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl NSPasteboardItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSPasteboardItem {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspasteboarditemdataprovider?language=objc)
    pub unsafe trait NSPasteboardItemDataProvider: NSObjectProtocol {
        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(pasteboard:item:provideDataForType:))]
        #[unsafe(method_family = none)]
        fn pasteboard_item_provideDataForType(
            &self,
            pasteboard: Option<&NSPasteboard>,
            item: &NSPasteboardItem,
            r#type: &NSPasteboardType,
        );

        #[cfg(feature = "NSPasteboard")]
        #[optional]
        #[unsafe(method(pasteboardFinishedWithDataProvider:))]
        #[unsafe(method_family = none)]
        fn pasteboardFinishedWithDataProvider(&self, pasteboard: &NSPasteboard);
    }
);
