# Vaultwarden Audits

Vaultwarden has been audited by security companies which helps us in keeping Vaultwarden secure.

Some audits were done without publishing any data publicly because the companies which requested the audits with those security companies didn't allow it, but those researchers did provide the results.

Some audits are publicly published and can be accessed by everyone.

## Audit by BSI

> [!NOTE]
> The site and report are both in German

[BSI (Bundesamt für Sicherheit in der Informationstechnik)](https://www.bsi.bund.de/EN/Home/home_node.html), a German institute performed an audit on [Vaultwarden v1.30.3](https://github.com/dani-garcia/vaultwarden/releases/tag/1.30.3) under their [CAOS (Codeanalyse von Open Source Software) project](https://www.bsi.bund.de/DE/Service-Navi/Publikationen/Studien/Projekt_P486/projekt_P486_node.html).

The press release, including the PDF with the results for Vaultwarden can be found here: https://www.bsi.bund.de/DE/Service-Navi/Presse/Alle-Meldungen-News/Meldungen/Codeanalyse-KeePass-Vaultwarden_241014.html

They even have a more detailed ZIP file with all raw information located here: https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Downloadserver/P486/CAOS_Vaultwarden.html

<br>

As a reference you can download the report here:
 - [Original - German - Vaultwarden-Passwortmanager.pdf](https://github.com/user-attachments/files/17805671/Vaultwarden-Passwortmanager.pdf)
 - [Translated - English - Vaultwarden-Passwortmanager.en.pdf](https://github.com/user-attachments/files/17805672/Vaultwarden-Passwortmanager.en.pdf)

## Penetration Test by ERNW Enno Rey Netzwerke GmbH

[ERNW Enno Rey Netzwerke GmbH](https://ernw.de) assessed Vaultwarden during a penetration test for a customer in October 2024. In June 2024, the German Federal Office for Information Security (BSI) published results of a static and dynamic test of the Vaultwarden server component. Therefore, only a partial source code audit was performed during the assessment which also focussed on other software and infrastructure. ERNW identified 3 vulnerabilities, including an authentication bypass, that were responsibly disclosed to Vaultwarden. A writeup of the vulnerabilities is described in ERNW's blog Insinuator: 

- https://insinuator.net/2024/11/vulnerability-disclosure-authentication-bypass-in-vaultwarden-versions-1-32-5/

