/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.VMRegImpl;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public abstract class RegisterMap
implements Cloneable {
    protected Address[] location;
    protected long[] locationValid;
    protected boolean includeArgumentOops;
    protected JavaThread thread;
    protected boolean updateMap;
    protected static int regCount;
    protected static int locationValidTypeSize;
    protected static int locationValidSize;

    private static void initialize(TypeDataBase db) {
        regCount = db.lookupIntConstant("ConcreteRegisterImpl::number_of_registers");
        locationValidTypeSize = (int)db.lookupType("julong").getSize() * 8;
        locationValidSize = (regCount + locationValidTypeSize - 1) / locationValidTypeSize;
    }

    protected RegisterMap(JavaThread thread, boolean updateMap) {
        this.thread = thread;
        this.updateMap = updateMap;
        this.location = new Address[regCount];
        this.locationValid = new long[locationValidSize];
        this.clear();
    }

    protected RegisterMap(RegisterMap map) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "RegisterMap must be present");
        }
        this.thread = map.getThread();
        this.updateMap = map.getUpdateMap();
        this.includeArgumentOops = map.getIncludeArgumentOops();
        this.location = new Address[map.location.length];
        this.locationValid = new long[map.locationValid.length];
        this.initializeFromPD(map);
        if (this.updateMap) {
            for (int i = 0; i < locationValidSize; ++i) {
                long bits;
                this.locationValid[i] = bits = !this.getUpdateMap() ? 0L : map.locationValid[i];
                int j = i * locationValidTypeSize;
                while (bits != 0L) {
                    if ((bits & 1L) != 0L) {
                        if (Assert.ASSERTS_ENABLED) {
                            Assert.that(0 <= j && j < regCount, "range check");
                        }
                        this.location[j] = map.location[j];
                    }
                    bits >>>= 1;
                    ++j;
                }
            }
        }
    }

    public abstract Object clone();

    public RegisterMap copy() {
        return (RegisterMap)this.clone();
    }

    public void clear() {
        this.setIncludeArgumentOops(true);
        if (!VM.getVM().isCore()) {
            if (this.updateMap) {
                for (int i = 0; i < this.locationValid.length; ++i) {
                    this.locationValid[i] = 0L;
                }
                this.clearPD();
            } else {
                this.initializePD();
            }
        }
    }

    public Address getLocation(VMReg reg) {
        int i = reg.getValue();
        int index = i / locationValidTypeSize;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(0 <= i && i < regCount, "sanity check");
            Assert.that(0 <= index && index < locationValidSize, "sanity check");
        }
        if ((this.locationValid[index] & (long)(1 << i % locationValidTypeSize)) != 0L) {
            return this.location[i];
        }
        return this.getLocationPD(reg);
    }

    public void setLocation(VMReg reg, Address loc) {
        int i = reg.getValue();
        int index = i / locationValidTypeSize;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(0 <= i && i < regCount, "sanity check");
            Assert.that(0 <= index && index < locationValidSize, "sanity check");
            Assert.that(this.updateMap, "updating map that does not need updating");
        }
        this.location[i] = loc;
        int n = index;
        this.locationValid[n] = this.locationValid[n] | (long)(1 << i % locationValidTypeSize);
    }

    public boolean getIncludeArgumentOops() {
        return this.includeArgumentOops;
    }

    public void setIncludeArgumentOops(boolean f) {
        this.includeArgumentOops = f;
    }

    public JavaThread getThread() {
        return this.thread;
    }

    public boolean getUpdateMap() {
        return this.updateMap;
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        tty.println("Register map");
        for (int i = 0; i < this.location.length; ++i) {
            Address src = this.getLocation(new VMReg(i));
            if (src == null) continue;
            tty.print("  " + VMRegImpl.getRegisterName(i) + " [" + src + "] = ");
            if (src.andWithMask(VM.getVM().getAddressSize() - 1L) != null) {
                tty.print("<misaligned>");
                continue;
            }
            tty.print(src.getAddressAt(0L));
        }
    }

    protected abstract void clearPD();

    protected abstract void initializePD();

    protected abstract void initializeFromPD(RegisterMap var1);

    protected abstract Address getLocationPD(VMReg var1);

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                RegisterMap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

