#ifndef serde_benchmark_ffi_h
#define serde_benchmark_ffi_h

/* Generated with cbindgen:0.28.0 */

/* Warning, this file is autogenerated by cbindgen. Don't modify this manually. */
/* Note: FfiOverheadResult and measurement functions added manually */

#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

namespace serde_benchmark {

struct CitmCatalog;

struct TwitterData;

/// Result structure for FFI overhead measurement
struct FfiOverheadResult {
    /// Time in nanoseconds for pure serde_json::to_string() (no FFI overhead)
    uint64_t pure_serde_ns;
    /// Time in nanoseconds for serde + CString conversion
    uint64_t serde_plus_cstring_ns;
    /// Number of iterations performed
    uint64_t iterations;
    /// Output size in bytes (for verification)
    uint64_t output_size;
};

extern "C" {

TwitterData *twitter_from_str(const char *raw_input, size_t raw_input_length);

void set_twitter_data(TwitterData *raw);

size_t serialize_twitter_to_string();

void free_twitter(TwitterData *raw);

void free_string(const char *ptr);

/// Creates a CitmCatalog from a JSON string (UTF-8 encoded).
CitmCatalog *citm_from_str(const char *raw_input, uintptr_t raw_input_length);

void set_citm_data(CitmCatalog *raw);

size_t serialize_citm_to_string();

/// Frees the CitmCatalog pointer.
void free_citm(CitmCatalog *raw_catalog);

void free_str(char *ptr);

/// Measures FFI overhead for Twitter serialization.
/// Performs `iterations` serializations entirely in Rust and returns timing data.
FfiOverheadResult measure_twitter_ffi_overhead(TwitterData *raw, uint64_t iterations);

/// Measures FFI overhead for CITM serialization.
FfiOverheadResult measure_citm_ffi_overhead(CitmCatalog *raw, uint64_t iterations);

}  // extern "C"

}  // namespace serde_benchmark

#endif  // serde_benchmark_ffi_h
