cmake_minimum_required(VERSION 3.23)


if(NOT APPLE)
    set(CMAKE_INSTALL_RPATH $ORIGIN)
endif()


math(EXPR JKQtPlotter_BIT_DEPTH ${CMAKE_SIZEOF_VOID_P}*8)

find_package( CImg QUIET )
find_package( OpenCV QUIET )

include(CheckFunctionExists)

set(CMAKE_REQUIRED_INCLUDES "cmath")
CHECK_FUNCTION_EXISTS(j0 JKQtPlotter_HAS_j0)
CHECK_FUNCTION_EXISTS(_j0 JKQtPlotter_HAS__j0)
CHECK_FUNCTION_EXISTS(y0 JKQtPlotter_HAS_y0)
CHECK_FUNCTION_EXISTS(_y0 JKQtPlotter_HAS__y0)
CHECK_FUNCTION_EXISTS(jn JKQtPlotter_HAS_jn)
CHECK_FUNCTION_EXISTS(_jn JKQtPlotter_HAS__jn)
CHECK_FUNCTION_EXISTS(yn JKQtPlotter_HAS_yn)
CHECK_FUNCTION_EXISTS(_yn JKQtPlotter_HAS__yn)

