#
# spec file for quilt - patch management scripts
#

Name:		quilt
Summary:	Scripts for working with series of patches
License:	GPL
Group:		Productivity/Text/Utilities
Version:	0.69
Release:	1
Requires:	coreutils diffutils findutils patch gzip bzip2 perl mktemp gettext
Autoreqprov:	off
Source:		quilt-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
The scripts allow to manage a series of patches by keeping
track of the changes each patch makes. Patches can be
applied, un-applied, refreshed, etc.

The scripts are heavily based on Andrew Morton's patch scripts
found at http://userweb.kernel.org/~akpm/stuff/patch-scripts.tar.gz.

Authors:
--------
    Andrew Morton <akpm@digeo.com>
    Andreas Gruenbacher <agruen@suse.de>

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" \
./configure --prefix=/usr \
	--mandir=%_mandir \
	--docdir=%_docdir/%{name}-%{version}
make RELEASE=%release

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT
%{find_lang} %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-, root, root)
/usr/bin/guards
/usr/bin/quilt
/usr/share/quilt/
/usr/share/emacs/
/etc/bash_completion.d/quilt
%config(noreplace) /etc/quilt.quiltrc
%doc %{_mandir}/man1/guards.1*
%doc %{_mandir}/man1/quilt.1*
%doc %{_docdir}/%{name}-%{version}/README
%doc %{_docdir}/%{name}-%{version}/README.MAIL
%doc %{_docdir}/%{name}-%{version}/quilt.pdf

%changelog
* Sat Apr 26 2025 - upstream
- Update to version 0.69
  + Fix escaping of % and backslash in patch names
  + Fix exit operator precedence error in perl scripts
  + new: Stop claiming support of option -p ab
  + patches: Several performance optimizations
  + series: Simplify the code
  + setup: Fix compatibility with rpm version 4.20
  + setup: New option --spec-filter

* Wed Mar 27 2024 - upstream
- Update to version 0.68
  + Add support for zstd archives
  + Documentation: Massive formatting update of the manual page
  + Documentation: Reword some sections of the manual page
  + Fix compatibility with BSD awk
  + Fix compatibility with GNU awk version 5.0.0 and later
  + Fix compatibility with GNU grep version 3.8 and later
  + Fix compatibility with Solaris ln (#63451)
  + Installation: Fix multiple issues in install-sh (#64430)
  + Test suite: Fix various race conditions (#63651)
  + patches: Find file name with a space in unapplied patches (#41708)
  + pop: Hint at diff -z on failure
  + setup: Document the limitation of spec file support

* Tue Feb 15 2022 - upstream
- Update to version 0.67
  + Call pager with original LANG environment variable
  + Consistently complain early if no series file is found
  + Fix handling of symbolic links by several commands
  + Tighten the patch format parsing
  + Reuse the shell (performance)
  + Document the series file format further
  + Document that quilt loads /etc/quilt.quiltrc
  + configure: Make stat configurable
  + series: Minor optimizations
  + setup: Don't obey the settings of any englobing .pc
  + setup: Default to fast mode
  + quilt.el: Fix documentation of quilt-pc-directory
  + quilt.el: Load /etc/quilt.quiltrc if ~/.quiltrc doesn't exist
  + quilt.el: Fix quilt-editable when QUILT_PATCHES_PREFIX is set

* Thu Mar 28 2019 - upstream
- Update to version 0.66
  + Add support for lzip archives and patches (#54570)
  + Document QUILT_PC as user-settable
  + configure: Don't require md5sum
  + Test suite: Allow keeping the working directory on failure
  + Test suite: Fix regex for recent versions of perl
  + Test suite: Fix /bin/sh filtering
  + Test suite: Run tests again if test.quiltrc changes
  + Test suite: Handle alternative QUILT_PATCHES values
  + Test suite: Increase code path coverage
  + Test suite: Be verbose on directory error
  + Test suite: Clean up when interrupted
  + Test suite: Prevent test cases from escaping
  + fold: Fix German translation
  + diff: Add missing quotes in basename call (#50862)
  + header: Fix corruption when trailing newline is missing (#50841)
  + mail: Fix patch set threading (#50775)
  + mail: Fix French translation
  + mail: Remove Content-Disposition headers
  + mail: Complain when a patch doesn't exist
  + new: Fix corruption when trailing newline is missing (#54295)
  + refresh: Add missing quotes in basename call (#50862)
  + setup: Add basic support for p7zip (.7z) archives (#49754)
  + setup: Align --fast on --slow for series files
  + quilt.el: Define quilt-edit-top-only before it's used
  + quilt.el: Stop using deprecated toggle-read-only
  + quilt.el: Don't strip directory in quilt-top-patch
  + quilt.el: Fix emacs compatibility issue (#51977)
  + quilt.el: Read QUILT_PC from config file
  + quiltrc: Support all patch formats by default
  + guards: Mention it in quilt manual page
  + compat/getopt: Handle a second separator (#54772)
  + compat/getopt: Allow non-digit parameter embedded in short option (#54772)

* Wed Oct 09 2016 - upstream
- Update to version 0.65
  + Translation fixes
  + Project settings have priority
  + Reject binary files in patches
  + Fix a race condition in diff_file
  + Performance: Optimizations to the setup command
  + Performance: Optimizations to the bash completion script
  + Test suite: Improve the edit test case
  + Test suite: Make the symlink test more robust
  + Test suite: Test backup failure
  + Test suite: Test the header command with hard links
  + diff: Report diff failures
  + edit: Fix a corner case bug
  + mail: Fix the help text
  + push: Fix the synopsis
  + refresh: Do not remove symlinks
  + refresh: Break links to read-only patch files
  + refresh: Always preserve modification time
  + setup: Report failed look-ups in inspect-wrapper
  + quilt.el: Fix quilt-editable when patches are stored in subdirs
  + bash_completion: Handle spaces in file names
  + bash_completion: Update the list of commands
  + bash_completion: Add new command options
  + bash_completion: Fix handling of mail, new, push options
  + guards: Simplify the help text
  + guards: Include the file name also in the "Not found" case
  + guards: Add support for an external filelist in --check mode
  + guards: Report which config file has problem in --check mode
  + guards: Documentation update
  + guards: Clarify a user message

* Mon Feb 09 2015 - upstream
- Update to version 0.64
  + Check for series file consistency
  + Performance: Several optimizations
  + Test suite: Several fixes and coverage improvements
  + Test suite: Run the tests in predictable order
  + files: Add support for unapplied patches
  + graph: Check for graphviz availability
  + mail: Remove procmail dependency
  + mail: Don't include the release number in User-Agent
  + pop: Add --refresh option
  + push: Add --refresh option
  + push: Do not use interactive mode with -f
  + setup: Skip version check
  + setup: Check for rpmbuild availability
  + setup: Handle long options passed to tar
  + setup: Several cleanups and minor fixes
  + setup: Major performance optimizations
  + setup: Fix path to extra patches in series file
  + setup: Trace calls earlier
  + setup: Add --fast option
  + setup: Fix link creation
  + quilt.el: Fix tramp support
  + quilt.el: Fix patch select completion

* Sun May 25 2014 - upstream
- Update to version 0.63
  + New NEWS file, containing a human-readable changelog
  + Option -E is no longer passed to patch by default
  + Huge performance improvement (e.g., for commands series, applied and
    unapplied)
  + configure: Add compat symlinks for md5sum
  + Return 2 when there is nothing to do, contrasting with errors (ret=1)
  + Exit with an error when diff's retcode=2 (error) on patch refresh
  + bash_completion: cleanups and performance improvement (Savannah's #27111)
  + test/run: Use perl module Text::ParseWords (+ performance improvement)
  + Add some tests to our testsuite, for a better coverage
  + Fix heuristic for unapplied patches with timestamps
  + Bug fix: Patches emptying files should work now
  + Bug fix: Check for duplicate patch in series (Savannah's #20628)
  + Portability fixes for older Bash and GNU patch

* Wed May 07 2014 - upstream
- Update to version 0.62
  + Was a buggy release, with an incomplete tarfile

* Sun Dec 08 2013 - upstream
- Update to version 0.61
  + Almost two years of fixes and minor improvements
  + Fix support for ./configure --with-xargs
  + Parameter quoting fixes to many commands
  + Various fixes to the pop, push, refresh and patches commands
  + Translation fixes
  + setup: Many fixes and improvements
  + remove-trailing-ws: Several fixes and improvements
  + remove-trailing-ws: Add a dedicated test case
  + quilt.el: Many fixes and improvements (emacs integration)

* Wed Feb 29 2012 - upstream
- Update to version 0.60
  + BSD compatibility improvements
  + grep: Support file names which include spaces
  + import: Fix import of relative patches
  + mail: Several fixes
  + setup: Support directory and archive names which include spaces
  + backup-files: rewritten from C to bash
  + backup-files: Add a dedicated test case

* Sat Jan 28 2012 - upstream
- Update to version 0.51
  + Fix support for ./configure --docdir
  + Various $TMPDIR fixes
  + mail: Fix delivery address checking
  + mail: CC people in more common patch headers
  + push: Fix bash completion
  + inspect: Complain if wrapper script can't be executed

* Mon Dec 5 2011 - upstream
- Update to version 0.50
  + 34 months of fixes and improvements, too many to list them all
  + Fix detection of the patch version
  + Avoid error messages when building due to missing git-desc file
  + Add support for lzma and xz compression formats
  + import: Fix confusing French translation
  + mail: Stop using =~ for older versions of bash
  + mail: Fix a temporary directory leak
  + revert: Stop using cp -l
  + revert: Add bash completion support
  + setup: Add --fuzz parameter
  + setup: Add support for reverse patches
  + inspect: Fix shell syntax errors
  + Fix error in test case create-delete

* Thu Jan 29 2009 - upstream
- Update to version 0.48
  + fold: Fix bash completion
  + mail: Don't use GNU awk extensions
  + mail: Check for formail
  + setup: Fix for rpm 4.6
  + Fix error in test case import

* Thu Aug 21 2008 - upstream
- Update to version 0.47
  + Change summary not available

* Thu Oct 19 2006 - upstream
- Update to version 0.46
  + Change summary not available

* Mon Apr 24 2006 - upstream
- Update to version 0.45
  + Change summary not available

* Tue Feb 14 2006 - upstream
- Update to version 0.44
  + Change summary not available

* Wed Feb 01 2006 - upstream
- Update to version 0.43
  + Change summary not available

* Tue Jul 26 2005 - upstream
- Update to version 0.42
  + Change summary not available

* Fri Apr 29 2005 - upstream
- Update to version 0.40
  + Change summary not available

* Thu Feb 10 2005 - upstream
- Update to version 0.39
  + Change summary not available

* Sun Oct 17 2004 - upstream
- Update to version 0.37
  + Change summary not available

* Wed Sep 22 2004 - upstream
- Update to version 0.36
  + Change summary not available

* Thu Jul 15 2004 - upstream
- Update to version 0.35
  + Change summary not available

* Thu Jun 10 2004 - upstream
- Update to version 0.34
  + Change summary not available

* Sun Jun 06 2004 - upstream
- Update to version 0.33
  + Change summary not available

* Sat Mar 13 2004 - upstream
- Update to version 0.32
  + Change summary not available

* Wed Jan 28 2004 - upstream
- Update to version 0.30
  + Change summary not available

* Wed Nov 12 2003 - upstream
- Update to version 0.29
  + Change summary not available

* Fri Oct 31 2003 - upstream
- Update to version 0.28
  + Change summary not available

* Tue Oct 28 2003 - upstream
- Update to version 0.27
  + Change summary not available

* Tue Oct 21 2003 - upstream
- Update to version 0.26
  + Change summary not available
