/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.DafnyMultiset;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DafnySet<T> {
    private Set<T> innerSet;
    private static final DafnySet<Object> EMPTY = DafnySet.of(new Object[0]);

    public DafnySet() {
        this.innerSet = new HashSet<T>();
    }

    public DafnySet(Set<T> s) {
        assert (s != null) : "Precondition Violation";
        this.innerSet = new HashSet<T>(s);
    }

    public DafnySet(Collection<T> c) {
        assert (c != null) : "Precondition Violation";
        this.innerSet = new HashSet<T>(c);
    }

    public DafnySet(DafnySet<T> other) {
        assert (other != null) : "Precondition Violation";
        this.innerSet = new HashSet<T>(other.innerSet);
    }

    public DafnySet(List<T> l) {
        assert (l != null) : "Precondition Violation";
        this.innerSet = new HashSet<T>(l);
    }

    @SafeVarargs
    public static <T> DafnySet<T> of(T ... elements) {
        return new DafnySet<T>(Arrays.asList(elements));
    }

    public static <T> DafnySet<T> empty() {
        return EMPTY;
    }

    public static <T> TypeDescriptor<DafnySet<? extends T>> _typeDescriptor(TypeDescriptor<T> elementType) {
        return TypeDescriptor.referenceWithDefault(DafnySet.class, DafnySet.empty());
    }

    public boolean isSubsetOf(DafnySet other) {
        assert (other != null) : "Precondition Violation";
        return other.containsAll(this);
    }

    public boolean isProperSubsetOf(DafnySet other) {
        assert (other != null) : "Precondition Violation";
        return this.isSubsetOf(other) && this.size() < other.size();
    }

    public boolean contains(Object t) {
        assert (t != null) : "Precondition Violation";
        return this.innerSet.contains(t);
    }

    public <U> boolean disjoint(DafnySet<? extends U> other) {
        assert (other != null) : "Precondition Violation";
        for (T u : other.innerSet) {
            if (!this.contains(u)) continue;
            return false;
        }
        return true;
    }

    public static <T> DafnySet<T> union(DafnySet<? extends T> th, DafnySet<? extends T> other) {
        assert (th != null) : "Precondition Violation";
        assert (other != null) : "Precondition Violation";
        if (th.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return th;
        }
        DafnySet<T> u = new DafnySet<T>(other);
        u.addAll(th);
        return u;
    }

    public static <T> DafnySet<T> difference(DafnySet<? extends T> th, DafnySet<? extends T> other) {
        assert (th != null) : "Precondition Violation";
        assert (other != null) : "Precondition Violation";
        DafnySet<? extends T> u = new DafnySet<T>(th);
        u.removeAll(other);
        return u;
    }

    public static <T> DafnySet<T> intersection(DafnySet<? extends T> th, DafnySet<? extends T> other) {
        assert (th != null) : "Precondition Violation";
        assert (other != null) : "Precondition Violation";
        DafnySet<T> u = new DafnySet<T>();
        for (T ele : th.innerSet) {
            if (!other.contains(ele)) continue;
            u.add(ele);
        }
        return u;
    }

    public boolean containsAll(DafnySet other) {
        assert (other != null) : "Precondition Violation";
        return this.innerSet.containsAll(other.innerSet);
    }

    public int size() {
        return this.innerSet.size();
    }

    public int cardinalityInt() {
        return this.size();
    }

    public boolean isEmpty() {
        return this.innerSet.isEmpty();
    }

    public boolean add(T t) {
        assert (t != null) : "Precondition Violation";
        return this.innerSet.add(t);
    }

    public boolean remove(T t) {
        assert (t != null) : "Precondition Violation";
        return this.innerSet.remove(t);
    }

    public boolean removeAll(DafnySet<T> other) {
        assert (other != null) : "Precondition Violation";
        return this.innerSet.removeAll(other.innerSet);
    }

    public boolean addAll(DafnySet<T> other) {
        assert (other != null) : "Precondition Violation";
        return this.innerSet.addAll(other.innerSet);
    }

    public Collection<DafnySet<T>> AllSubsets() {
        ArrayList<T> elmts = new ArrayList<T>();
        elmts.addAll(this.innerSet);
        int n = elmts.size();
        HashSet<DafnySet<T>> r = new HashSet<DafnySet<T>>();
        for (int i = 0; i < 1 << n; ++i) {
            DafnySet s = new DafnySet();
            int m = 1;
            int j = 0;
            while (j < n) {
                if ((i & m) > 0) {
                    s.add(elmts.get(j));
                }
                ++j;
                m <<= 1;
            }
            r.add(s);
        }
        return r;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DafnySet o = (DafnySet)obj;
        return this.containsAll(o) && o.containsAll(this);
    }

    public int hashCode() {
        return this.innerSet.hashCode();
    }

    public String toString() {
        String s = "{";
        String sep = "";
        for (T elem : this.innerSet) {
            s = s + sep + Helpers.toString(elem);
            sep = ", ";
        }
        return s + "}";
    }

    public DafnyMultiset<T> asDafnyMultiset() {
        return new DafnyMultiset<T>(this.innerSet);
    }

    public Set<T> Elements() {
        return this.innerSet;
    }
}

