const std = @import("std");
const fs = std.fs;

/// Generates a compressed file of all the ghostty frames
pub fn main() !void {
    var gpa = std.heap.GeneralPurposeAllocator(.{}){};

    var arg_iter = try std.process.argsWithAllocator(gpa.allocator());
    // Skip the exe name
    _ = arg_iter.skip();

    const output_path = arg_iter.next() orelse return error.MissingOutputPath;

    const out_dir_path = fs.path.dirname(output_path) orelse return error.InvalidOutputPath;
    const out_dir = try fs.cwd().openDir(out_dir_path, .{});

    const compressed_file = try out_dir.createFile(fs.path.basename(output_path), .{});

    // Join the frames with a null byte. We'll split on this later
    const all_frames = try std.mem.join(gpa.allocator(), "\x01", &frames);
    var fbs = std.io.fixedBufferStream(all_frames);

    const reader = fbs.reader();
    try std.compress.flate.compress(reader, compressed_file.writer(), .{});

    const stdout = std.io.getStdOut().writer();

    try stdout.print(
        \\//! This file is auto-generated. Do not edit.
        \\
        \\pub const compressed = @embedFile("{s}");
    , .{output_path});
}

const frames = [_][]const u8{
    @embedFile("frames/frame_001.txt"),
    @embedFile("frames/frame_002.txt"),
    @embedFile("frames/frame_003.txt"),
    @embedFile("frames/frame_004.txt"),
    @embedFile("frames/frame_005.txt"),
    @embedFile("frames/frame_006.txt"),
    @embedFile("frames/frame_007.txt"),
    @embedFile("frames/frame_008.txt"),
    @embedFile("frames/frame_009.txt"),
    @embedFile("frames/frame_010.txt"),
    @embedFile("frames/frame_011.txt"),
    @embedFile("frames/frame_012.txt"),
    @embedFile("frames/frame_013.txt"),
    @embedFile("frames/frame_014.txt"),
    @embedFile("frames/frame_015.txt"),
    @embedFile("frames/frame_016.txt"),
    @embedFile("frames/frame_017.txt"),
    @embedFile("frames/frame_018.txt"),
    @embedFile("frames/frame_019.txt"),
    @embedFile("frames/frame_020.txt"),
    @embedFile("frames/frame_021.txt"),
    @embedFile("frames/frame_022.txt"),
    @embedFile("frames/frame_023.txt"),
    @embedFile("frames/frame_024.txt"),
    @embedFile("frames/frame_025.txt"),
    @embedFile("frames/frame_026.txt"),
    @embedFile("frames/frame_027.txt"),
    @embedFile("frames/frame_028.txt"),
    @embedFile("frames/frame_029.txt"),
    @embedFile("frames/frame_030.txt"),
    @embedFile("frames/frame_031.txt"),
    @embedFile("frames/frame_032.txt"),
    @embedFile("frames/frame_033.txt"),
    @embedFile("frames/frame_034.txt"),
    @embedFile("frames/frame_035.txt"),
    @embedFile("frames/frame_036.txt"),
    @embedFile("frames/frame_037.txt"),
    @embedFile("frames/frame_038.txt"),
    @embedFile("frames/frame_039.txt"),
    @embedFile("frames/frame_040.txt"),
    @embedFile("frames/frame_041.txt"),
    @embedFile("frames/frame_042.txt"),
    @embedFile("frames/frame_043.txt"),
    @embedFile("frames/frame_044.txt"),
    @embedFile("frames/frame_045.txt"),
    @embedFile("frames/frame_046.txt"),
    @embedFile("frames/frame_047.txt"),
    @embedFile("frames/frame_048.txt"),
    @embedFile("frames/frame_049.txt"),
    @embedFile("frames/frame_050.txt"),
    @embedFile("frames/frame_051.txt"),
    @embedFile("frames/frame_052.txt"),
    @embedFile("frames/frame_053.txt"),
    @embedFile("frames/frame_054.txt"),
    @embedFile("frames/frame_055.txt"),
    @embedFile("frames/frame_056.txt"),
    @embedFile("frames/frame_057.txt"),
    @embedFile("frames/frame_058.txt"),
    @embedFile("frames/frame_059.txt"),
    @embedFile("frames/frame_060.txt"),
    @embedFile("frames/frame_061.txt"),
    @embedFile("frames/frame_062.txt"),
    @embedFile("frames/frame_063.txt"),
    @embedFile("frames/frame_064.txt"),
    @embedFile("frames/frame_065.txt"),
    @embedFile("frames/frame_066.txt"),
    @embedFile("frames/frame_067.txt"),
    @embedFile("frames/frame_068.txt"),
    @embedFile("frames/frame_069.txt"),
    @embedFile("frames/frame_070.txt"),
    @embedFile("frames/frame_071.txt"),
    @embedFile("frames/frame_072.txt"),
    @embedFile("frames/frame_073.txt"),
    @embedFile("frames/frame_074.txt"),
    @embedFile("frames/frame_075.txt"),
    @embedFile("frames/frame_076.txt"),
    @embedFile("frames/frame_077.txt"),
    @embedFile("frames/frame_078.txt"),
    @embedFile("frames/frame_079.txt"),
    @embedFile("frames/frame_080.txt"),
    @embedFile("frames/frame_081.txt"),
    @embedFile("frames/frame_082.txt"),
    @embedFile("frames/frame_083.txt"),
    @embedFile("frames/frame_084.txt"),
    @embedFile("frames/frame_085.txt"),
    @embedFile("frames/frame_086.txt"),
    @embedFile("frames/frame_087.txt"),
    @embedFile("frames/frame_088.txt"),
    @embedFile("frames/frame_089.txt"),
    @embedFile("frames/frame_090.txt"),
    @embedFile("frames/frame_091.txt"),
    @embedFile("frames/frame_092.txt"),
    @embedFile("frames/frame_093.txt"),
    @embedFile("frames/frame_094.txt"),
    @embedFile("frames/frame_095.txt"),
    @embedFile("frames/frame_096.txt"),
    @embedFile("frames/frame_097.txt"),
    @embedFile("frames/frame_098.txt"),
    @embedFile("frames/frame_099.txt"),
    @embedFile("frames/frame_100.txt"),
    @embedFile("frames/frame_101.txt"),
    @embedFile("frames/frame_102.txt"),
    @embedFile("frames/frame_103.txt"),
    @embedFile("frames/frame_104.txt"),
    @embedFile("frames/frame_105.txt"),
    @embedFile("frames/frame_106.txt"),
    @embedFile("frames/frame_107.txt"),
    @embedFile("frames/frame_108.txt"),
    @embedFile("frames/frame_109.txt"),
    @embedFile("frames/frame_110.txt"),
    @embedFile("frames/frame_111.txt"),
    @embedFile("frames/frame_112.txt"),
    @embedFile("frames/frame_113.txt"),
    @embedFile("frames/frame_114.txt"),
    @embedFile("frames/frame_115.txt"),
    @embedFile("frames/frame_116.txt"),
    @embedFile("frames/frame_117.txt"),
    @embedFile("frames/frame_118.txt"),
    @embedFile("frames/frame_119.txt"),
    @embedFile("frames/frame_120.txt"),
    @embedFile("frames/frame_121.txt"),
    @embedFile("frames/frame_122.txt"),
    @embedFile("frames/frame_123.txt"),
    @embedFile("frames/frame_124.txt"),
    @embedFile("frames/frame_125.txt"),
    @embedFile("frames/frame_126.txt"),
    @embedFile("frames/frame_127.txt"),
    @embedFile("frames/frame_128.txt"),
    @embedFile("frames/frame_129.txt"),
    @embedFile("frames/frame_130.txt"),
    @embedFile("frames/frame_131.txt"),
    @embedFile("frames/frame_132.txt"),
    @embedFile("frames/frame_133.txt"),
    @embedFile("frames/frame_134.txt"),
    @embedFile("frames/frame_135.txt"),
    @embedFile("frames/frame_136.txt"),
    @embedFile("frames/frame_137.txt"),
    @embedFile("frames/frame_138.txt"),
    @embedFile("frames/frame_139.txt"),
    @embedFile("frames/frame_140.txt"),
    @embedFile("frames/frame_141.txt"),
    @embedFile("frames/frame_142.txt"),
    @embedFile("frames/frame_143.txt"),
    @embedFile("frames/frame_144.txt"),
    @embedFile("frames/frame_145.txt"),
    @embedFile("frames/frame_146.txt"),
    @embedFile("frames/frame_147.txt"),
    @embedFile("frames/frame_148.txt"),
    @embedFile("frames/frame_149.txt"),
    @embedFile("frames/frame_150.txt"),
    @embedFile("frames/frame_151.txt"),
    @embedFile("frames/frame_152.txt"),
    @embedFile("frames/frame_153.txt"),
    @embedFile("frames/frame_154.txt"),
    @embedFile("frames/frame_155.txt"),
    @embedFile("frames/frame_156.txt"),
    @embedFile("frames/frame_157.txt"),
    @embedFile("frames/frame_158.txt"),
    @embedFile("frames/frame_159.txt"),
    @embedFile("frames/frame_160.txt"),
    @embedFile("frames/frame_161.txt"),
    @embedFile("frames/frame_162.txt"),
    @embedFile("frames/frame_163.txt"),
    @embedFile("frames/frame_164.txt"),
    @embedFile("frames/frame_165.txt"),
    @embedFile("frames/frame_166.txt"),
    @embedFile("frames/frame_167.txt"),
    @embedFile("frames/frame_168.txt"),
    @embedFile("frames/frame_169.txt"),
    @embedFile("frames/frame_170.txt"),
    @embedFile("frames/frame_171.txt"),
    @embedFile("frames/frame_172.txt"),
    @embedFile("frames/frame_173.txt"),
    @embedFile("frames/frame_174.txt"),
    @embedFile("frames/frame_175.txt"),
    @embedFile("frames/frame_176.txt"),
    @embedFile("frames/frame_177.txt"),
    @embedFile("frames/frame_178.txt"),
    @embedFile("frames/frame_179.txt"),
    @embedFile("frames/frame_180.txt"),
    @embedFile("frames/frame_181.txt"),
    @embedFile("frames/frame_182.txt"),
    @embedFile("frames/frame_183.txt"),
    @embedFile("frames/frame_184.txt"),
    @embedFile("frames/frame_185.txt"),
    @embedFile("frames/frame_186.txt"),
    @embedFile("frames/frame_187.txt"),
    @embedFile("frames/frame_188.txt"),
    @embedFile("frames/frame_189.txt"),
    @embedFile("frames/frame_190.txt"),
    @embedFile("frames/frame_191.txt"),
    @embedFile("frames/frame_192.txt"),
    @embedFile("frames/frame_193.txt"),
    @embedFile("frames/frame_194.txt"),
    @embedFile("frames/frame_195.txt"),
    @embedFile("frames/frame_196.txt"),
    @embedFile("frames/frame_197.txt"),
    @embedFile("frames/frame_198.txt"),
    @embedFile("frames/frame_199.txt"),
    @embedFile("frames/frame_200.txt"),
    @embedFile("frames/frame_201.txt"),
    @embedFile("frames/frame_202.txt"),
    @embedFile("frames/frame_203.txt"),
    @embedFile("frames/frame_204.txt"),
    @embedFile("frames/frame_205.txt"),
    @embedFile("frames/frame_206.txt"),
    @embedFile("frames/frame_207.txt"),
    @embedFile("frames/frame_208.txt"),
    @embedFile("frames/frame_209.txt"),
    @embedFile("frames/frame_210.txt"),
    @embedFile("frames/frame_211.txt"),
    @embedFile("frames/frame_212.txt"),
    @embedFile("frames/frame_213.txt"),
    @embedFile("frames/frame_214.txt"),
    @embedFile("frames/frame_215.txt"),
    @embedFile("frames/frame_216.txt"),
    @embedFile("frames/frame_217.txt"),
    @embedFile("frames/frame_218.txt"),
    @embedFile("frames/frame_219.txt"),
    @embedFile("frames/frame_220.txt"),
    @embedFile("frames/frame_221.txt"),
    @embedFile("frames/frame_222.txt"),
    @embedFile("frames/frame_223.txt"),
    @embedFile("frames/frame_224.txt"),
    @embedFile("frames/frame_225.txt"),
    @embedFile("frames/frame_226.txt"),
    @embedFile("frames/frame_227.txt"),
    @embedFile("frames/frame_228.txt"),
    @embedFile("frames/frame_229.txt"),
    @embedFile("frames/frame_230.txt"),
    @embedFile("frames/frame_231.txt"),
    @embedFile("frames/frame_232.txt"),
    @embedFile("frames/frame_233.txt"),
    @embedFile("frames/frame_234.txt"),
    @embedFile("frames/frame_235.txt"),
};
