/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;

public class NamespaceDefinitionNode
extends DefinitionNode {
    public IdentifierNode name;
    public Node value;
    public ReferenceValue ref;
    public String debug_name;
    public QName qualifiedname;
    public boolean needs_init;
    public BitSet gen_bits;

    public NamespaceDefinitionNode(PackageDefinitionNode pkgdef, AttributeListNode attrs, IdentifierNode name, Node value) {
        super(pkgdef, attrs, -1);
        this.name = name;
        this.value = value;
        this.ref = null;
        this.qualifiedname = null;
        this.gen_bits = null;
        this.needs_init = false;
    }

    @Override
    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public boolean isConst() {
        return true;
    }

    @Override
    public ReferenceValue getRef(Context cx) {
        return this.ref;
    }

    @Override
    public Node initializerStatement(Context cx) {
        this.needs_init = true;
        return this;
    }

    @Override
    public BitSet getGenBits() {
        return this.gen_bits;
    }

    @Override
    public BitSet getKillBits() {
        if (this.ref != null && this.ref.slot != null) {
            if (this.ref.slot.getDefBits() != null) {
                return BitSet.xor(this.ref.slot.getDefBits(), this.gen_bits);
            }
            return this.gen_bits;
        }
        return null;
    }

    @Override
    public String toString() {
        return "NamespaceDefinition";
    }
}

