/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;

public class ExpressionStatementNode
extends Node {
    public Node expr;
    public BitSet gen_bits;
    public ReferenceValue ref;
    public TypeValue expected_type;
    public boolean is_var_stmt;
    private boolean skip = false;

    public ExpressionStatementNode(Node expr) {
        this.expr = expr;
        this.gen_bits = null;
        this.ref = null;
        this.expected_type = null;
        this.is_var_stmt = false;
    }

    @Override
    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public BitSet getGenBits() {
        return BitSet.or(this.expr.getGenBits(), this.gen_bits);
    }

    @Override
    public BitSet getKillBits() {
        BitSet kb = this.expr.getKillBits();
        if (this.ref != null && this.ref.slot != null) {
            if (this.ref.slot.getDefBits() != null) {
                return BitSet.or(kb, BitSet.xor(this.ref.slot.getDefBits(), this.gen_bits));
            }
            return BitSet.or(kb, this.gen_bits);
        }
        return kb;
    }

    @Override
    public String toString() {
        return "ExpressionStatement";
    }

    @Override
    public ReferenceValue getRef(Context cx) {
        if (this.ref == null) {
            this.ref = new ReferenceValue(cx, null, "_cv", ObjectValue.internalNamespace);
        }
        return this.ref;
    }

    @Override
    public void expectedType(TypeValue type) {
        this.expected_type = type;
        this.expr.expectedType(type);
    }

    public void isVarStatement(boolean b) {
        this.is_var_stmt = b;
    }

    public boolean isVarStatement() {
        return this.is_var_stmt;
    }

    @Override
    public boolean isExpressionStatement() {
        return true;
    }

    @Override
    public boolean isAttribute() {
        return this.expr.isAttribute();
    }

    @Override
    public void voidResult() {
        this.expr.voidResult();
    }

    @Override
    public boolean isConfigurationName() {
        return this.expr.isConfigurationName();
    }

    public void skipNode(boolean b) {
        this.skip = b;
    }

    public boolean skip() {
        return this.skip;
    }
}

