/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.Decoder;
import macromedia.abc.DecoderException;
import macromedia.abc.DefaultVisitor;
import macromedia.abc.MultiName;
import macromedia.abc.Opcodes;
import macromedia.abc.QName;

public class Printer {
    private static Decoder decoder;
    private static String fileName;
    private static boolean showOpcodes;
    private static String className;
    private static String methodName;
    private static int startLine;
    private static int endLine;
    private static String currentClass;
    private static String currentMethod;
    private static int currentLine;

    public static void main(String[] args) throws Throwable {
        if (args.length == 0) {
            System.err.println("Usage: abcdump [-b] [-c mx.core:UIObject] [-m setColor] [-l 10-15] foo.abc");
            System.err.println();
            System.err.println("  -b:                     include opcodes in the output");
            System.err.println("  -c className:           restrict output to the specified class");
            System.err.println("  -m methodName:          restrict output to the specified method");
            System.err.println("  -l startLine[-endLine]: restrict output to the specified line(s)");
            return;
        }
        int argc = args.length;
        for (int i = 0; i < argc; ++i) {
            if ("-c".equals(args[i])) {
                className = args[i + 1].intern();
                ++i;
                continue;
            }
            if ("-m".equals(args[i])) {
                methodName = args[i + 1].intern();
                ++i;
                continue;
            }
            if ("-l".equals(args[i])) {
                String lineRange = args[i + 1];
                int index = lineRange.indexOf("-");
                if (index != -1) {
                    startLine = Integer.parseInt(lineRange.substring(0, index));
                    endLine = Integer.parseInt(lineRange.substring(index + 1));
                } else {
                    startLine = Integer.parseInt(lineRange);
                    endLine = startLine + 1;
                }
                ++i;
                continue;
            }
            if ("-b".equals(args[i])) {
                showOpcodes = true;
                continue;
            }
            if (i != argc - 1) continue;
            fileName = args[i];
        }
        byte[] bytecodes = Printer.readBytes(new File(fileName));
        BytecodeBuffer in = new BytecodeBuffer(bytecodes);
        decoder = new Decoder(in);
        Printer.processScripts();
    }

    private static void processScripts() throws DecoderException {
        Decoder.ScriptInfo scriptInfo = Printer.decoder.scriptInfo;
        ABCVisitor v = new ABCVisitor(decoder);
        int size = scriptInfo.size();
        for (int i = 0; i < size; ++i) {
            scriptInfo.decode(i, v);
        }
    }

    private static void print(String s) {
        if (currentClass == className && currentMethod == methodName) {
            System.out.print(s);
        }
    }

    private static void println(String s) {
        if (currentClass == className && currentMethod == methodName) {
            System.out.println(s);
        }
    }

    private static void printOpcode(String s) {
        if (currentClass == className && currentMethod == methodName && (startLine == 0 && endLine == 0 || currentLine >= startLine && currentLine < endLine) && showOpcodes) {
            System.out.println(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytes(File path) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(path));
            byte[] a = new byte[in.available()];
            in.read(a);
            byte[] byArray = a;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class ABCVisitor
    extends DefaultVisitor {
        ABCVisitor(Decoder decoder) {
            super(decoder);
        }

        @Override
        public void methodInfo(QName returnType, QName[] paramTypes, String nativeName, int flags, Object[] values, String[] param_names) {
            int i;
            int length;
            Printer.print("<info name='" + nativeName + "' paramTypes='");
            int n = length = paramTypes != null ? paramTypes.length : 0;
            for (i = 0; i < length; ++i) {
                Printer.print(paramTypes[i] + " ");
            }
            Printer.print("'");
            if (returnType != null) {
                Printer.print(" returnType='" + returnType + "'");
            }
            Printer.print(" paramNames='");
            int n2 = length = param_names != null ? param_names.length : 0;
            for (i = 0; i < length; ++i) {
                Printer.print(param_names[i] + " ");
            }
            Printer.print("'");
            Printer.println("/>");
        }

        @Override
        public void metadata(String name, String[] keys, String[] values) {
            Printer.println("<metadata/>");
        }

        @Override
        public void beginVar(QName name, int slotID, QName type, Object value) {
            Printer.print("<var name='" + name + "'");
            if (type != null) {
                Printer.print(" type='" + type + "'");
            }
            Printer.println(">");
            if (value != null) {
                Printer.println("<value>" + value + "</value>");
            }
        }

        @Override
        public void endVar(QName name) {
            Printer.println("</var>");
        }

        @Override
        public void beginConst(QName name, int slotID, QName type, Object value) {
            Printer.print("<const name='" + name + "'");
            if (type != null) {
                Printer.print(" type='" + type + "'");
            }
            Printer.println(">");
            if (value != null) {
                Printer.println("<value>" + value + "</value>");
            }
        }

        @Override
        public void endConst(QName name) {
            Printer.println("</const>");
        }

        @Override
        public void beginGetter(int methodInfo, QName name, int dispID, int attr) {
            if (methodName != null) {
                currentMethod = name.toString().intern();
            }
            Printer.println("<getter name='" + name + "' dispID='" + dispID + "' attr='" + attr + "'>");
        }

        @Override
        public void endGetter(QName name) {
            Printer.println("</getter>");
            if (methodName != null) {
                currentMethod = null;
            }
        }

        @Override
        public void beginSetter(int methodInfo, QName name, int dispID, int attr) {
            if (methodName != null) {
                currentMethod = name.toString().intern();
            }
            Printer.println("<setter name='" + name + "' dispID='" + dispID + "' attr='" + attr + "'>");
        }

        @Override
        public void endSetter(QName name) {
            Printer.println("</setter>");
            if (methodName != null) {
                currentMethod = null;
            }
        }

        @Override
        public void beginMethod(int methodInfo, QName name, int dispID, int attr) {
            if (methodName != null) {
                currentMethod = name.toString().intern();
            }
            Printer.println("<method name='" + name + "' dispID='" + dispID + "' attr='" + attr + "'>");
        }

        @Override
        public void endMethod(QName name) {
            Printer.println("</method>");
            if (methodName != null) {
                currentMethod = null;
            }
        }

        @Override
        public void beginClass(QName name, int slotID) {
            if (className != null) {
                currentClass = name.toString().intern();
            }
            Printer.println("<class name='" + name + "' slot='" + slotID + "'>");
        }

        @Override
        public void endClass(QName name) {
            Printer.println("</class>");
            if (className != null) {
                currentClass = null;
            }
        }

        @Override
        public void beginIInit(int methodInfo) {
            Printer.println("<iinit>");
        }

        @Override
        public void endIInit() {
            Printer.println("</iinit>");
        }

        @Override
        public void beginCInit(int methodInfo) {
            Printer.println("<cinit>");
        }

        @Override
        public void endCInit() {
            Printer.println("</cinit>");
        }

        @Override
        public void beginFunction(int methodInfo, QName name, int slotID) {
            Printer.println("<function name='" + name + "'>");
        }

        @Override
        public void endFunction(QName name) {
            Printer.println("</function>");
        }

        @Override
        public void instanceInfo(QName name, QName superName, MultiName[] interfaces) {
            Printer.print("<info type='" + name + "'");
            if (superName != null) {
                Printer.print(" superType='" + superName + "'");
            }
            Printer.println("/>");
        }

        @Override
        public void classInfo(QName name) {
        }

        @Override
        public void beginABC() {
            Printer.println("<abc>");
        }

        @Override
        public void endABC() {
            Printer.println("</abc>");
        }

        @Override
        public void beginBody(int methodID, int codeStart, long codeLength) {
            Printer.println("<![CDATA[");
        }

        @Override
        public void endBody() {
            Printer.println("]]>");
        }

        private Object getConstantStringValue(int index) {
            try {
                return this.decoder.constantPool.getString(index);
            }
            catch (DecoderException ex) {
                return "decoder exception...";
            }
        }

        private Object getConstantNamespaceValue(int index) {
            try {
                return this.decoder.constantPool.getNamespaceName(index);
            }
            catch (DecoderException ex) {
                return "decoder exception...";
            }
        }

        private Object getConstantIntValue(int index) {
            return this.decoder.constantPool.getInt(index);
        }

        private Object getConstantUIntValue(int index) {
            return this.decoder.constantPool.getLong(index);
        }

        private Object getConstantMultinameValue(int index) {
            try {
                return this.decoder.constantPool.getGeneralMultiname(index);
            }
            catch (DecoderException ex) {
                return "decoder exception...";
            }
        }

        @Override
        public void target(int pos) {
            System.out.println("target " + pos);
        }

        @Override
        public void OP_returnvoid() {
            Printer.printOpcode(Opcodes.opNames[71]);
        }

        @Override
        public void OP_returnvalue() {
            Printer.printOpcode(Opcodes.opNames[72]);
        }

        @Override
        public void OP_nop() {
            Printer.printOpcode(Opcodes.opNames[2]);
        }

        @Override
        public void OP_bkpt() {
            Printer.printOpcode(Opcodes.opNames[1]);
        }

        @Override
        public void OP_timestamp() {
            Printer.printOpcode(Opcodes.opNames[243]);
        }

        @Override
        public void OP_debugline(int linenum) {
            if (startLine != 0 && endLine != 0) {
                currentLine = linenum;
            }
            Printer.printOpcode(System.getProperty("line.separator") + Opcodes.opNames[240] + " linenum=" + linenum);
        }

        @Override
        public void OP_bkptline() {
            Printer.printOpcode(Opcodes.opNames[242]);
        }

        @Override
        public void OP_debug(int di_local, int index, int slot, int linenum) {
            Printer.printOpcode(Opcodes.opNames[239] + " di_local=" + di_local + " index=" + index + " slot=" + slot + " linenum=" + linenum);
        }

        @Override
        public void OP_debugfile(int index) {
            Printer.printOpcode(Opcodes.opNames[241] + " cpool[" + index + "] = " + this.getConstantStringValue(index));
        }

        @Override
        public void OP_jump(int jump, int pos) {
            Printer.printOpcode(Opcodes.opNames[16] + " " + jump);
        }

        @Override
        public void OP_pushnull() {
            Printer.printOpcode(Opcodes.opNames[32]);
        }

        @Override
        public void OP_pushundefined() {
            Printer.printOpcode(Opcodes.opNames[33]);
        }

        @Override
        public void OP_pushstring(int index) {
            Printer.printOpcode(Opcodes.opNames[44] + " cpool_string[" + index + "] = " + this.getConstantStringValue(index));
        }

        @Override
        public void OP_pushnamespace(int index) {
            Printer.printOpcode(Opcodes.opNames[49] + " cpool_namespace[" + index + "] = " + this.getConstantNamespaceValue(index));
        }

        @Override
        public void OP_pushint(int index) {
            Printer.printOpcode(Opcodes.opNames[45] + " cpool_int[" + index + "] = " + this.getConstantIntValue(index));
        }

        @Override
        public void OP_pushuint(int index) {
            Printer.printOpcode(Opcodes.opNames[46] + " cpool_uint[" + index + "] = " + this.getConstantUIntValue(index));
        }

        @Override
        public void OP_pushdouble(int index) {
            Printer.printOpcode(Opcodes.opNames[47] + " cpool_double[" + index + "]");
        }

        @Override
        public void OP_pushdecimal(int index) {
            Printer.printOpcode(Opcodes.opNames[47] + " cpool_decimal[" + index + "]");
        }

        @Override
        public void OP_getlocal(int index) {
            Printer.printOpcode(Opcodes.opNames[98] + " r" + index);
        }

        @Override
        public void OP_pushtrue() {
            Printer.printOpcode(Opcodes.opNames[38]);
        }

        @Override
        public void OP_pushfalse() {
            Printer.printOpcode(Opcodes.opNames[39]);
        }

        @Override
        public void OP_pushnan() {
            Printer.printOpcode(Opcodes.opNames[40]);
        }

        @Override
        public void OP_pushdnan() {
            Printer.printOpcode(Opcodes.opNames[52]);
        }

        @Override
        public void OP_pop() {
            Printer.printOpcode(Opcodes.opNames[41]);
        }

        @Override
        public void OP_dup() {
            Printer.printOpcode(Opcodes.opNames[42]);
        }

        @Override
        public void OP_swap() {
            Printer.printOpcode(Opcodes.opNames[43]);
        }

        @Override
        public void OP_convert_s() {
            Printer.printOpcode(Opcodes.opNames[112]);
        }

        @Override
        public void OP_esc_xelem() {
            Printer.printOpcode(Opcodes.opNames[113]);
        }

        @Override
        public void OP_esc_xattr() {
            Printer.printOpcode(Opcodes.opNames[114]);
        }

        @Override
        public void OP_checkfilter() {
            Printer.printOpcode(Opcodes.opNames[120]);
        }

        @Override
        public void OP_convert_d() {
            Printer.printOpcode(Opcodes.opNames[117]);
        }

        @Override
        public void OP_convert_b() {
            Printer.printOpcode(Opcodes.opNames[118]);
        }

        @Override
        public void OP_convert_o() {
            Printer.printOpcode(Opcodes.opNames[119]);
        }

        @Override
        public void OP_convert_m() {
            Printer.printOpcode(Opcodes.opNames[121]);
        }

        @Override
        public void OP_convert_m_p(int param) {
            Printer.printOpcode(Opcodes.opNames[122] + " p" + param);
        }

        @Override
        public void OP_negate() {
            Printer.printOpcode(Opcodes.opNames[144]);
        }

        @Override
        public void OP_negate_p(int param) {
            Printer.printOpcode(Opcodes.opNames[143] + " p" + param);
        }

        @Override
        public void OP_negate_i() {
            Printer.printOpcode(Opcodes.opNames[196]);
        }

        @Override
        public void OP_increment() {
            Printer.printOpcode(Opcodes.opNames[145]);
        }

        @Override
        public void OP_increment_p(int param) {
            Printer.printOpcode(Opcodes.opNames[156] + " p" + param);
        }

        @Override
        public void OP_increment_i() {
            Printer.printOpcode(Opcodes.opNames[192]);
        }

        @Override
        public void OP_inclocal(int index) {
            Printer.printOpcode(Opcodes.opNames[146] + " r" + index);
        }

        @Override
        public void OP_inclocal_p(int param, int index) {
            Printer.printOpcode(Opcodes.opNames[146] + " p" + param + " r" + index);
        }

        @Override
        public void OP_kill(int index) {
            Printer.printOpcode(Opcodes.opNames[8] + " r" + index);
        }

        @Override
        public void OP_inclocal_i(int index) {
            Printer.printOpcode(Opcodes.opNames[194] + " r" + index);
        }

        @Override
        public void OP_decrement() {
            Printer.printOpcode(Opcodes.opNames[147]);
        }

        @Override
        public void OP_decrement_p(int param) {
            Printer.printOpcode(Opcodes.opNames[158] + " p" + param);
        }

        @Override
        public void OP_decrement_i() {
            Printer.printOpcode(Opcodes.opNames[193]);
        }

        @Override
        public void OP_declocal(int index) {
            Printer.printOpcode(Opcodes.opNames[148] + " r" + index);
        }

        @Override
        public void OP_declocal_p(int param, int index) {
            Printer.printOpcode(Opcodes.opNames[159] + " p" + param + " r" + index);
        }

        @Override
        public void OP_declocal_i(int index) {
            Printer.printOpcode(Opcodes.opNames[195] + " r" + index);
        }

        @Override
        public void OP_typeof() {
            Printer.printOpcode(Opcodes.opNames[149]);
        }

        @Override
        public void OP_not() {
            Printer.printOpcode(Opcodes.opNames[150]);
        }

        @Override
        public void OP_bitnot() {
            Printer.printOpcode(Opcodes.opNames[151]);
        }

        @Override
        public void OP_setlocal(int index) {
            Printer.printOpcode(Opcodes.opNames[99] + " r" + index);
        }

        @Override
        public void OP_add() {
            Printer.printOpcode(Opcodes.opNames[160]);
        }

        @Override
        public void OP_add_p(int param) {
            Printer.printOpcode(Opcodes.opNames[160] + " p" + param);
        }

        @Override
        public void OP_add_i() {
            Printer.printOpcode(Opcodes.opNames[197]);
        }

        @Override
        public void OP_subtract() {
            Printer.printOpcode(Opcodes.opNames[161]);
        }

        @Override
        public void OP_subtract_p(int param) {
            Printer.printOpcode(Opcodes.opNames[182] + " p" + param);
        }

        @Override
        public void OP_subtract_i() {
            Printer.printOpcode(Opcodes.opNames[198]);
        }

        @Override
        public void OP_multiply() {
            Printer.printOpcode(Opcodes.opNames[162]);
        }

        @Override
        public void OP_multiply_p(int param) {
            Printer.printOpcode(Opcodes.opNames[183] + " p" + param);
        }

        @Override
        public void OP_multiply_i() {
            Printer.printOpcode(Opcodes.opNames[199]);
        }

        @Override
        public void OP_divide() {
            Printer.printOpcode(Opcodes.opNames[163]);
        }

        @Override
        public void OP_divide_p(int param) {
            Printer.printOpcode(Opcodes.opNames[184] + " p" + param);
        }

        @Override
        public void OP_modulo() {
            Printer.printOpcode(Opcodes.opNames[164]);
        }

        @Override
        public void OP_modulo_p(int param) {
            Printer.printOpcode(Opcodes.opNames[185] + " p" + param);
        }

        @Override
        public void OP_lshift() {
            Printer.printOpcode(Opcodes.opNames[165]);
        }

        @Override
        public void OP_rshift() {
            Printer.printOpcode(Opcodes.opNames[166]);
        }

        @Override
        public void OP_urshift() {
            Printer.printOpcode(Opcodes.opNames[167]);
        }

        @Override
        public void OP_bitand() {
            Printer.printOpcode(Opcodes.opNames[168]);
        }

        @Override
        public void OP_bitor() {
            Printer.printOpcode(Opcodes.opNames[169]);
        }

        @Override
        public void OP_bitxor() {
            Printer.printOpcode(Opcodes.opNames[170]);
        }

        @Override
        public void OP_equals() {
            Printer.printOpcode(Opcodes.opNames[171]);
        }

        @Override
        public void OP_strictequals() {
            Printer.printOpcode(Opcodes.opNames[172]);
        }

        @Override
        public void OP_lookupswitch(int defaultPos, int[] casePos, int pos, int p2) {
            String caseList = "";
            int len = casePos.length;
            for (int i = 0; i < len; ++i) {
                caseList = caseList + casePos[i] + ",";
            }
            Printer.printOpcode(Opcodes.opNames[27] + " defaultPos=" + defaultPos + " casePos=" + caseList);
        }

        @Override
        public void OP_iftrue(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[17] + " " + offset);
        }

        @Override
        public void OP_iffalse(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[18] + " " + offset);
        }

        @Override
        public void OP_ifeq(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[19] + " " + offset);
        }

        @Override
        public void OP_ifne(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[20] + " " + offset);
        }

        @Override
        public void OP_ifstricteq(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[25] + " " + offset);
        }

        @Override
        public void OP_ifstrictne(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[26] + " " + offset);
        }

        @Override
        public void OP_iflt(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[21] + " " + offset);
        }

        @Override
        public void OP_ifle(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[22] + " " + offset);
        }

        @Override
        public void OP_ifgt(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[23] + " " + offset);
        }

        @Override
        public void OP_ifge(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[24] + " " + offset);
        }

        @Override
        public void OP_lessthan() {
            Printer.printOpcode(Opcodes.opNames[173]);
        }

        @Override
        public void OP_lessequals() {
            Printer.printOpcode(Opcodes.opNames[174]);
        }

        @Override
        public void OP_greaterthan() {
            Printer.printOpcode(Opcodes.opNames[175]);
        }

        @Override
        public void OP_greaterequals() {
            Printer.printOpcode(Opcodes.opNames[176]);
        }

        @Override
        public void OP_newobject(int size) {
            Printer.printOpcode(Opcodes.opNames[85] + " size=" + size);
        }

        @Override
        public void OP_newarray(int size) {
            Printer.printOpcode(Opcodes.opNames[86] + " size=" + size);
        }

        @Override
        public void OP_getproperty(int index) {
            Printer.printOpcode(Opcodes.opNames[102] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_setproperty(int index) {
            Printer.printOpcode(Opcodes.opNames[97] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_initproperty(int index) {
            Printer.printOpcode(Opcodes.opNames[104] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_getdescendants(int index) {
            Printer.printOpcode(Opcodes.opNames[89] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_findpropstrict(int index) {
            Printer.printOpcode(Opcodes.opNames[93] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_findproperty(int index) {
            Printer.printOpcode(Opcodes.opNames[94] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_finddef(int index) {
            Printer.printOpcode(Opcodes.opNames[95] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_getlex(int index) {
            Printer.printOpcode(Opcodes.opNames[96] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_nextname() {
            Printer.printOpcode(Opcodes.opNames[30]);
        }

        @Override
        public void OP_nextvalue() {
            Printer.printOpcode(Opcodes.opNames[35]);
        }

        @Override
        public void OP_hasnext() {
            Printer.printOpcode(Opcodes.opNames[31]);
        }

        @Override
        public void OP_hasnext2(int objectRegister, int indexRegister) {
            Printer.printOpcode(Opcodes.opNames[50] + " " + objectRegister + " " + indexRegister);
        }

        @Override
        public void OP_deleteproperty(int index) {
            Printer.printOpcode(Opcodes.opNames[106] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_setslot(int index) {
            Printer.printOpcode(Opcodes.opNames[109] + " " + index);
        }

        @Override
        public void OP_getslot(int index) {
            Printer.printOpcode(Opcodes.opNames[108] + " " + index);
        }

        @Override
        public void OP_setglobalslot(int index) {
            Printer.printOpcode(Opcodes.opNames[111] + " " + index);
        }

        @Override
        public void OP_getglobalslot(int index) {
            Printer.printOpcode(Opcodes.opNames[110] + " " + index);
        }

        @Override
        public void OP_call(int size) {
            Printer.printOpcode(Opcodes.opNames[65] + " size=" + size);
        }

        @Override
        public void OP_construct(int size) {
            Printer.printOpcode(Opcodes.opNames[66] + " size=" + size);
        }

        @Override
        public void OP_applytype(int size) {
            Printer.printOpcode(Opcodes.opNames[83] + " size=" + size);
        }

        @Override
        public void OP_newfunction(int id) {
            Printer.printOpcode(Opcodes.opNames[64] + " function=" + id);
        }

        @Override
        public void OP_newclass(int id) {
            Printer.printOpcode(Opcodes.opNames[88] + " class=" + id);
        }

        @Override
        public void OP_callstatic(int id, int argc) {
            Printer.printOpcode(Opcodes.opNames[68] + " method=" + id + " argc=" + argc);
        }

        @Override
        public void OP_callmethod(int id, int argc) {
            Printer.printOpcode(Opcodes.opNames[67] + " dispid=" + id + " argc=" + argc);
        }

        @Override
        public void OP_callproperty(int index, int argc) {
            Printer.printOpcode(Opcodes.opNames[70] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index) + " argc=" + argc);
        }

        @Override
        public void OP_callproplex(int index, int argc) {
            Printer.printOpcode(Opcodes.opNames[76] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index) + " argc=" + argc);
        }

        @Override
        public void OP_constructprop(int index, int argc) {
            Printer.printOpcode(Opcodes.opNames[74] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index) + " argc=" + argc);
        }

        @Override
        public void OP_callsuper(int index, int argc) {
            Printer.printOpcode(Opcodes.opNames[69] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index) + " argc=" + argc);
        }

        @Override
        public void OP_getsuper(int index) {
            Printer.printOpcode(Opcodes.opNames[4] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_setsuper(int index) {
            Printer.printOpcode(Opcodes.opNames[5] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_constructsuper(int argc) {
            Printer.printOpcode(Opcodes.opNames[73] + " argc=" + argc);
        }

        @Override
        public void OP_pushshort(int n) {
            Printer.printOpcode(Opcodes.opNames[37] + " " + n);
        }

        @Override
        public void OP_astype(int index) {
            Printer.printOpcode(Opcodes.opNames[134] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_astypelate() {
            Printer.printOpcode(Opcodes.opNames[135]);
        }

        @Override
        public void OP_coerce(int index) {
            Printer.printOpcode(Opcodes.opNames[128] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_coerce_b() {
            Printer.printOpcode(Opcodes.opNames[129]);
        }

        @Override
        public void OP_coerce_o() {
            Printer.printOpcode(Opcodes.opNames[137]);
        }

        @Override
        public void OP_coerce_a() {
            Printer.printOpcode(Opcodes.opNames[130]);
        }

        @Override
        public void OP_coerce_i() {
            Printer.printOpcode(Opcodes.opNames[131]);
        }

        @Override
        public void OP_coerce_u() {
            Printer.printOpcode(Opcodes.opNames[136]);
        }

        @Override
        public void OP_coerce_d() {
            Printer.printOpcode(Opcodes.opNames[132]);
        }

        @Override
        public void OP_coerce_s() {
            Printer.printOpcode(Opcodes.opNames[133]);
        }

        @Override
        public void OP_istype(int index) {
            Printer.printOpcode(Opcodes.opNames[178] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_istypelate() {
            Printer.printOpcode(Opcodes.opNames[179]);
        }

        @Override
        public void OP_pushbyte(int n) {
            Printer.printOpcode(Opcodes.opNames[36] + " " + n);
        }

        @Override
        public void OP_getscopeobject(int index) {
            Printer.printOpcode(Opcodes.opNames[101] + " index=" + index);
        }

        @Override
        public void OP_pushscope() {
            Printer.printOpcode(Opcodes.opNames[48]);
        }

        @Override
        public void OP_popscope() {
            Printer.printOpcode(Opcodes.opNames[29]);
        }

        @Override
        public void OP_convert_i() {
            Printer.printOpcode(Opcodes.opNames[115]);
        }

        @Override
        public void OP_convert_u() {
            Printer.printOpcode(Opcodes.opNames[116]);
        }

        @Override
        public void OP_throw() {
            Printer.printOpcode(Opcodes.opNames[3]);
        }

        @Override
        public void OP_instanceof() {
            Printer.printOpcode(Opcodes.opNames[177]);
        }

        @Override
        public void OP_in() {
            Printer.printOpcode(Opcodes.opNames[180]);
        }

        @Override
        public void OP_dxns(int index) {
            Printer.printOpcode(Opcodes.opNames[6] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index));
        }

        @Override
        public void OP_dxnslate() {
            Printer.printOpcode(Opcodes.opNames[7]);
        }

        @Override
        public void OP_ifnlt(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[12] + " " + offset);
        }

        @Override
        public void OP_ifnle(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[13] + " " + offset);
        }

        @Override
        public void OP_ifngt(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[14] + " " + offset);
        }

        @Override
        public void OP_ifnge(int offset, int pos) {
            Printer.printOpcode(Opcodes.opNames[15] + " " + offset);
        }

        @Override
        public void OP_pushwith() {
            Printer.printOpcode(Opcodes.opNames[28]);
        }

        @Override
        public void OP_newactivation() {
            Printer.printOpcode(Opcodes.opNames[87]);
        }

        @Override
        public void OP_newcatch(int index) {
            Printer.printOpcode(Opcodes.opNames[90] + " " + index);
        }

        @Override
        public void OP_deldescendants() {
            Printer.printOpcode(Opcodes.opNames[91]);
        }

        @Override
        public void OP_getglobalscope() {
            Printer.printOpcode(Opcodes.opNames[100]);
        }

        @Override
        public void OP_getlocal0() {
            Printer.printOpcode(Opcodes.opNames[208]);
        }

        @Override
        public void OP_getlocal1() {
            Printer.printOpcode(Opcodes.opNames[209]);
        }

        @Override
        public void OP_getlocal2() {
            Printer.printOpcode(Opcodes.opNames[210]);
        }

        @Override
        public void OP_getlocal3() {
            Printer.printOpcode(Opcodes.opNames[211]);
        }

        @Override
        public void OP_setlocal0() {
            Printer.printOpcode(Opcodes.opNames[212]);
        }

        @Override
        public void OP_setlocal1() {
            Printer.printOpcode(Opcodes.opNames[213]);
        }

        @Override
        public void OP_setlocal2() {
            Printer.printOpcode(Opcodes.opNames[214]);
        }

        @Override
        public void OP_setlocal3() {
            Printer.printOpcode(Opcodes.opNames[215]);
        }

        @Override
        public void OP_label() {
            Printer.printOpcode(Opcodes.opNames[9]);
        }

        @Override
        public void OP_pushconstant(int id) {
            Printer.printOpcode(Opcodes.opNames[34] + " " + id);
        }

        @Override
        public void OP_callsupervoid(int index, int argc) {
            Printer.printOpcode(Opcodes.opNames[78] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index) + " argc=" + argc);
        }

        @Override
        public void OP_callpropvoid(int index, int argc) {
            Printer.printOpcode(Opcodes.opNames[79] + " cpool[" + index + "] = " + this.getConstantMultinameValue(index) + " argc=" + argc);
        }

        @Override
        public void OP_li8() {
            Printer.printOpcode(Opcodes.opNames[53]);
        }

        @Override
        public void OP_li16() {
            Printer.printOpcode(Opcodes.opNames[54]);
        }

        @Override
        public void OP_li32() {
            Printer.printOpcode(Opcodes.opNames[55]);
        }

        @Override
        public void OP_lf32() {
            Printer.printOpcode(Opcodes.opNames[56]);
        }

        @Override
        public void OP_lf64() {
            Printer.printOpcode(Opcodes.opNames[57]);
        }

        @Override
        public void OP_si8() {
            Printer.printOpcode(Opcodes.opNames[58]);
        }

        @Override
        public void OP_si16() {
            Printer.printOpcode(Opcodes.opNames[59]);
        }

        @Override
        public void OP_si32() {
            Printer.printOpcode(Opcodes.opNames[60]);
        }

        @Override
        public void OP_sf32() {
            Printer.printOpcode(Opcodes.opNames[61]);
        }

        @Override
        public void OP_sf64() {
            Printer.printOpcode(Opcodes.opNames[62]);
        }

        @Override
        public void OP_sxi1() {
            Printer.printOpcode(Opcodes.opNames[80]);
        }

        @Override
        public void OP_sxi8() {
            Printer.printOpcode(Opcodes.opNames[81]);
        }

        @Override
        public void OP_sxi16() {
            Printer.printOpcode(Opcodes.opNames[82]);
        }
    }
}

