#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 541
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 108
#define ALIAS_COUNT 0
#define TOKEN_COUNT 62
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 41

enum ts_symbol_identifiers {
  sym_keyword = 1,
  sym_identifier = 2,
  sym_integer_expression = 3,
  sym_float_expression = 4,
  sym__hpath_start = 5,
  sym_spath_expression = 6,
  sym_uri_expression = 7,
  anon_sym_COLON = 8,
  anon_sym_AT = 9,
  anon_sym_LBRACE = 10,
  anon_sym_RBRACE = 11,
  anon_sym_COMMA = 12,
  anon_sym_QMARK = 13,
  sym_ellipses = 14,
  anon_sym_assert = 15,
  anon_sym_SEMI = 16,
  anon_sym_with = 17,
  anon_sym_let = 18,
  anon_sym_in = 19,
  anon_sym_if = 20,
  anon_sym_then = 21,
  anon_sym_else = 22,
  anon_sym_BANG = 23,
  anon_sym_DASH = 24,
  anon_sym_EQ_EQ = 25,
  anon_sym_BANG_EQ = 26,
  anon_sym_LT = 27,
  anon_sym_LT_EQ = 28,
  anon_sym_GT = 29,
  anon_sym_GT_EQ = 30,
  anon_sym_AMP_AMP = 31,
  anon_sym_PIPE_PIPE = 32,
  anon_sym_PLUS = 33,
  anon_sym_STAR = 34,
  anon_sym_SLASH = 35,
  anon_sym_DASH_GT = 36,
  anon_sym_SLASH_SLASH = 37,
  anon_sym_PLUS_PLUS = 38,
  anon_sym_DOT = 39,
  anon_sym_or = 40,
  anon_sym_LPAREN = 41,
  anon_sym_RPAREN = 42,
  anon_sym_rec = 43,
  anon_sym_DQUOTE = 44,
  anon_sym_DOLLAR = 45,
  sym_escape_sequence = 46,
  anon_sym_SQUOTE_SQUOTE = 47,
  sym__indented_escape_sequence = 48,
  anon_sym_EQ = 49,
  anon_sym_inherit = 50,
  anon_sym_DOLLAR_LBRACE = 51,
  anon_sym_DOLLAR_LBRACE2 = 52,
  anon_sym_LBRACK = 53,
  anon_sym_RBRACK = 54,
  sym_comment = 55,
  sym_string_fragment = 56,
  sym__indented_string_fragment = 57,
  sym__path_start = 58,
  sym_path_fragment = 59,
  sym_dollar_escape = 60,
  sym__indented_dollar_escape = 61,
  sym_source_code = 62,
  sym__expression = 63,
  sym_variable_expression = 64,
  sym_path_expression = 65,
  sym_hpath_expression = 66,
  sym__expr_function_expression = 67,
  sym_function_expression = 68,
  sym_formals = 69,
  sym_formal = 70,
  sym_assert_expression = 71,
  sym_with_expression = 72,
  sym_let_expression = 73,
  sym__expr_if = 74,
  sym_if_expression = 75,
  sym__expr_op = 76,
  sym_has_attr_expression = 77,
  sym_unary_expression = 78,
  sym_binary_expression = 79,
  sym__expr_apply_expression = 80,
  sym_apply_expression = 81,
  sym__expr_select_expression = 82,
  sym_select_expression = 83,
  sym__expr_simple = 84,
  sym_parenthesized_expression = 85,
  sym_attrset_expression = 86,
  sym_let_attrset_expression = 87,
  sym_rec_attrset_expression = 88,
  sym_string_expression = 89,
  sym_indented_string_expression = 90,
  sym_binding_set = 91,
  sym_binding = 92,
  sym_inherit = 93,
  sym_inherit_from = 94,
  sym_attrpath = 95,
  sym_inherited_attrs = 96,
  sym__immediate_interpolation = 97,
  sym_interpolation = 98,
  sym_list_expression = 99,
  aux_sym_path_expression_repeat1 = 100,
  aux_sym_formals_repeat1 = 101,
  aux_sym_string_expression_repeat1 = 102,
  aux_sym_indented_string_expression_repeat1 = 103,
  aux_sym_binding_set_repeat1 = 104,
  aux_sym_attrpath_repeat1 = 105,
  aux_sym_inherited_attrs_repeat1 = 106,
  aux_sym_list_expression_repeat1 = 107,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_keyword] = "keyword",
  [sym_identifier] = "identifier",
  [sym_integer_expression] = "integer_expression",
  [sym_float_expression] = "float_expression",
  [sym__hpath_start] = "path_fragment",
  [sym_spath_expression] = "spath_expression",
  [sym_uri_expression] = "uri_expression",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "\?",
  [sym_ellipses] = "ellipses",
  [anon_sym_assert] = "assert",
  [anon_sym_SEMI] = ";",
  [anon_sym_with] = "with",
  [anon_sym_let] = "let",
  [anon_sym_in] = "in",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_BANG] = "!",
  [anon_sym_DASH] = "-",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DOT] = ".",
  [anon_sym_or] = "or",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_rec] = "rec",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DOLLAR] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_SQUOTE_SQUOTE] = "''",
  [sym__indented_escape_sequence] = "escape_sequence",
  [anon_sym_EQ] = "=",
  [anon_sym_inherit] = "inherit",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_DOLLAR_LBRACE2] = "${",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_comment] = "comment",
  [sym_string_fragment] = "string_fragment",
  [sym__indented_string_fragment] = "string_fragment",
  [sym__path_start] = "path_fragment",
  [sym_path_fragment] = "path_fragment",
  [sym_dollar_escape] = "dollar_escape",
  [sym__indented_dollar_escape] = "dollar_escape",
  [sym_source_code] = "source_code",
  [sym__expression] = "_expression",
  [sym_variable_expression] = "variable_expression",
  [sym_path_expression] = "path_expression",
  [sym_hpath_expression] = "hpath_expression",
  [sym__expr_function_expression] = "_expr_function_expression",
  [sym_function_expression] = "function_expression",
  [sym_formals] = "formals",
  [sym_formal] = "formal",
  [sym_assert_expression] = "assert_expression",
  [sym_with_expression] = "with_expression",
  [sym_let_expression] = "let_expression",
  [sym__expr_if] = "_expr_if",
  [sym_if_expression] = "if_expression",
  [sym__expr_op] = "_expr_op",
  [sym_has_attr_expression] = "has_attr_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expr_apply_expression] = "_expr_apply_expression",
  [sym_apply_expression] = "apply_expression",
  [sym__expr_select_expression] = "_expr_select_expression",
  [sym_select_expression] = "select_expression",
  [sym__expr_simple] = "_expr_simple",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_attrset_expression] = "attrset_expression",
  [sym_let_attrset_expression] = "let_attrset_expression",
  [sym_rec_attrset_expression] = "rec_attrset_expression",
  [sym_string_expression] = "string_expression",
  [sym_indented_string_expression] = "indented_string_expression",
  [sym_binding_set] = "binding_set",
  [sym_binding] = "binding",
  [sym_inherit] = "inherit",
  [sym_inherit_from] = "inherit_from",
  [sym_attrpath] = "attrpath",
  [sym_inherited_attrs] = "inherited_attrs",
  [sym__immediate_interpolation] = "interpolation",
  [sym_interpolation] = "interpolation",
  [sym_list_expression] = "list_expression",
  [aux_sym_path_expression_repeat1] = "path_expression_repeat1",
  [aux_sym_formals_repeat1] = "formals_repeat1",
  [aux_sym_string_expression_repeat1] = "string_expression_repeat1",
  [aux_sym_indented_string_expression_repeat1] = "indented_string_expression_repeat1",
  [aux_sym_binding_set_repeat1] = "binding_set_repeat1",
  [aux_sym_attrpath_repeat1] = "attrpath_repeat1",
  [aux_sym_inherited_attrs_repeat1] = "inherited_attrs_repeat1",
  [aux_sym_list_expression_repeat1] = "list_expression_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_keyword] = sym_keyword,
  [sym_identifier] = sym_identifier,
  [sym_integer_expression] = sym_integer_expression,
  [sym_float_expression] = sym_float_expression,
  [sym__hpath_start] = sym_path_fragment,
  [sym_spath_expression] = sym_spath_expression,
  [sym_uri_expression] = sym_uri_expression,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_ellipses] = sym_ellipses,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_rec] = anon_sym_rec,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DOLLAR] = sym_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE,
  [sym__indented_escape_sequence] = sym_escape_sequence,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_inherit] = anon_sym_inherit,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_DOLLAR_LBRACE2] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_comment] = sym_comment,
  [sym_string_fragment] = sym_string_fragment,
  [sym__indented_string_fragment] = sym_string_fragment,
  [sym__path_start] = sym_path_fragment,
  [sym_path_fragment] = sym_path_fragment,
  [sym_dollar_escape] = sym_dollar_escape,
  [sym__indented_dollar_escape] = sym_dollar_escape,
  [sym_source_code] = sym_source_code,
  [sym__expression] = sym__expression,
  [sym_variable_expression] = sym_variable_expression,
  [sym_path_expression] = sym_path_expression,
  [sym_hpath_expression] = sym_hpath_expression,
  [sym__expr_function_expression] = sym__expr_function_expression,
  [sym_function_expression] = sym_function_expression,
  [sym_formals] = sym_formals,
  [sym_formal] = sym_formal,
  [sym_assert_expression] = sym_assert_expression,
  [sym_with_expression] = sym_with_expression,
  [sym_let_expression] = sym_let_expression,
  [sym__expr_if] = sym__expr_if,
  [sym_if_expression] = sym_if_expression,
  [sym__expr_op] = sym__expr_op,
  [sym_has_attr_expression] = sym_has_attr_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expr_apply_expression] = sym__expr_apply_expression,
  [sym_apply_expression] = sym_apply_expression,
  [sym__expr_select_expression] = sym__expr_select_expression,
  [sym_select_expression] = sym_select_expression,
  [sym__expr_simple] = sym__expr_simple,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_attrset_expression] = sym_attrset_expression,
  [sym_let_attrset_expression] = sym_let_attrset_expression,
  [sym_rec_attrset_expression] = sym_rec_attrset_expression,
  [sym_string_expression] = sym_string_expression,
  [sym_indented_string_expression] = sym_indented_string_expression,
  [sym_binding_set] = sym_binding_set,
  [sym_binding] = sym_binding,
  [sym_inherit] = sym_inherit,
  [sym_inherit_from] = sym_inherit_from,
  [sym_attrpath] = sym_attrpath,
  [sym_inherited_attrs] = sym_inherited_attrs,
  [sym__immediate_interpolation] = sym_interpolation,
  [sym_interpolation] = sym_interpolation,
  [sym_list_expression] = sym_list_expression,
  [aux_sym_path_expression_repeat1] = aux_sym_path_expression_repeat1,
  [aux_sym_formals_repeat1] = aux_sym_formals_repeat1,
  [aux_sym_string_expression_repeat1] = aux_sym_string_expression_repeat1,
  [aux_sym_indented_string_expression_repeat1] = aux_sym_indented_string_expression_repeat1,
  [aux_sym_binding_set_repeat1] = aux_sym_binding_set_repeat1,
  [aux_sym_attrpath_repeat1] = aux_sym_attrpath_repeat1,
  [aux_sym_inherited_attrs_repeat1] = aux_sym_inherited_attrs_repeat1,
  [aux_sym_list_expression_repeat1] = aux_sym_list_expression_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_float_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__hpath_start] = {
    .visible = true,
    .named = true,
  },
  [sym_spath_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_uri_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipses] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__indented_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inherit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym__indented_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym__path_start] = {
    .visible = true,
    .named = true,
  },
  [sym_path_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_dollar_escape] = {
    .visible = true,
    .named = true,
  },
  [sym__indented_dollar_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_source_code] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_variable_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_path_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_hpath_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_formals] = {
    .visible = true,
    .named = true,
  },
  [sym_formal] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_with_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_if] = {
    .visible = false,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_op] = {
    .visible = false,
    .named = true,
  },
  [sym_has_attr_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_apply_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_apply_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_select_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_select_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_simple] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_attrset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_let_attrset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_rec_attrset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_indented_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binding_set] = {
    .visible = true,
    .named = true,
  },
  [sym_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_inherit] = {
    .visible = true,
    .named = true,
  },
  [sym_inherit_from] = {
    .visible = true,
    .named = true,
  },
  [sym_attrpath] = {
    .visible = true,
    .named = true,
  },
  [sym_inherited_attrs] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_list_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_path_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formals_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_indented_string_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_binding_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attrpath_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inherited_attrs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_attr = 3,
  field_attrpath = 4,
  field_attrs = 5,
  field_binding = 6,
  field_body = 7,
  field_condition = 8,
  field_consequence = 9,
  field_default = 10,
  field_element = 11,
  field_ellipses = 12,
  field_environment = 13,
  field_expression = 14,
  field_formal = 15,
  field_formals = 16,
  field_function = 17,
  field_left = 18,
  field_name = 19,
  field_operator = 20,
  field_right = 21,
  field_universal = 22,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_attr] = "attr",
  [field_attrpath] = "attrpath",
  [field_attrs] = "attrs",
  [field_binding] = "binding",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_default] = "default",
  [field_element] = "element",
  [field_ellipses] = "ellipses",
  [field_environment] = "environment",
  [field_expression] = "expression",
  [field_formal] = "formal",
  [field_formals] = "formals",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_universal] = "universal",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 1},
  [9] = {.index = 9, .length = 2},
  [10] = {.index = 11, .length = 2},
  [11] = {.index = 13, .length = 2},
  [12] = {.index = 15, .length = 1},
  [13] = {.index = 16, .length = 1},
  [14] = {.index = 17, .length = 1},
  [15] = {.index = 18, .length = 2},
  [16] = {.index = 20, .length = 1},
  [17] = {.index = 21, .length = 1},
  [18] = {.index = 22, .length = 1},
  [19] = {.index = 23, .length = 2},
  [20] = {.index = 25, .length = 2},
  [21] = {.index = 27, .length = 3},
  [22] = {.index = 30, .length = 3},
  [23] = {.index = 33, .length = 2},
  [24] = {.index = 35, .length = 2},
  [25] = {.index = 37, .length = 1},
  [26] = {.index = 38, .length = 2},
  [27] = {.index = 40, .length = 1},
  [28] = {.index = 41, .length = 2},
  [29] = {.index = 43, .length = 2},
  [30] = {.index = 45, .length = 2},
  [31] = {.index = 47, .length = 2},
  [32] = {.index = 49, .length = 1},
  [33] = {.index = 50, .length = 3},
  [34] = {.index = 53, .length = 2},
  [35] = {.index = 55, .length = 2},
  [36] = {.index = 57, .length = 3},
  [37] = {.index = 60, .length = 3},
  [38] = {.index = 63, .length = 3},
  [39] = {.index = 66, .length = 3},
  [40] = {.index = 69, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_expression, 0},
  [2] =
    {field_expression, 0, .inherited = true},
  [3] =
    {field_attr, 0},
  [4] =
    {field_binding, 0},
  [5] =
    {field_binding, 0, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_element, 0},
  [9] =
    {field_argument, 1},
    {field_function, 0},
  [11] =
    {field_body, 2},
    {field_universal, 0},
  [13] =
    {field_attr, 0},
    {field_attr, 1, .inherited = true},
  [15] =
    {field_ellipses, 1},
  [16] =
    {field_attr, 0, .inherited = true},
  [17] =
    {field_formal, 1},
  [18] =
    {field_binding, 0, .inherited = true},
    {field_binding, 1, .inherited = true},
  [20] =
    {field_body, 2},
  [21] =
    {field_expression, 1},
  [22] =
    {field_element, 1, .inherited = true},
  [23] =
    {field_element, 0, .inherited = true},
    {field_element, 1, .inherited = true},
  [25] =
    {field_body, 2},
    {field_formals, 0},
  [27] =
    {field_attrpath, 2},
    {field_expression, 0},
    {field_operator, 1},
  [30] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [33] =
    {field_attrpath, 2},
    {field_expression, 0},
  [35] =
    {field_default, 2},
    {field_name, 0},
  [37] =
    {field_attr, 1},
  [38] =
    {field_attr, 0, .inherited = true},
    {field_attr, 1, .inherited = true},
  [40] =
    {field_attrs, 1},
  [41] =
    {field_formal, 1},
    {field_formal, 2, .inherited = true},
  [43] =
    {field_formal, 0, .inherited = true},
    {field_formal, 1, .inherited = true},
  [45] =
    {field_body, 3},
    {field_condition, 1},
  [47] =
    {field_body, 3},
    {field_environment, 1},
  [49] =
    {field_body, 3},
  [50] =
    {field_body, 4},
    {field_formals, 2},
    {field_universal, 0},
  [53] =
    {field_ellipses, 3},
    {field_formal, 1},
  [55] =
    {field_attrpath, 0},
    {field_expression, 2},
  [57] =
    {field_body, 4},
    {field_formals, 0},
    {field_universal, 2},
  [60] =
    {field_attrpath, 2},
    {field_default, 4},
    {field_expression, 0},
  [63] =
    {field_ellipses, 4},
    {field_formal, 1},
    {field_formal, 2, .inherited = true},
  [66] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [69] =
    {field_attrs, 4},
    {field_expression, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(128);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(155);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == 'o') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'w') ADVANCE(99);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'w') ADVANCE(99);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(138);
      END_STATE();
    case 6:
      if (lookahead == '\'') ADVANCE(159);
      END_STATE();
    case 7:
      if (lookahead == '\'') ADVANCE(158);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(10);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(125);
      END_STATE();
    case 13:
      if (lookahead == '/') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == '/') ADVANCE(45);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 17:
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 18:
      if (lookahead == 'c') ADVANCE(59);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(59);
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 26:
      if (lookahead == 'h') ADVANCE(59);
      END_STATE();
    case 27:
      if (lookahead == 'h') ADVANCE(22);
      END_STATE();
    case 28:
      if (lookahead == 'i') ADVANCE(37);
      END_STATE();
    case 29:
      if (lookahead == 'i') ADVANCE(38);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(36);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(59);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 35:
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 36:
      if (lookahead == 's') ADVANCE(19);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(26);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(163);
      END_STATE();
    case 40:
      if (lookahead == '{') ADVANCE(164);
      END_STATE();
    case 41:
      if (lookahead == '|') ADVANCE(139);
      END_STATE();
    case 42:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 45:
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(14);
      END_STATE();
    case 46:
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 47:
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          ('*' <= lookahead && lookahead <= ':') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '~') ADVANCE(118);
      END_STATE();
    case 48:
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(157);
      END_STATE();
    case 49:
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(160);
      END_STATE();
    case 50:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(128);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(156);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == 'o') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'w') ADVANCE(99);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 51:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(129);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '=') ADVANCE(161);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 52:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(129);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '=') ADVANCE(161);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 53:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(154);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(17);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'o') ADVANCE(80);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 54:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(17);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 55:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(17);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 56:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(20);
      if (lookahead == 'r') ADVANCE(21);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(29);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56)
      END_STATE();
    case 57:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(17);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(20);
      if (lookahead == 'r') ADVANCE(21);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(29);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57)
      END_STATE();
    case 58:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_keyword);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(71);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(94);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(24);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'c') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(65);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(79);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(81);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'i') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'i') ADVANCE(86);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'l') ADVANCE(84);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(149);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(75);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 's') ADVANCE(66);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 't') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 't') ADVANCE(73);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(102);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(104);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(64);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(92);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(150);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(93);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(89);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(96);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_integer_expression);
      if (lookahead == '.') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_integer_expression);
      if (lookahead == '.') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(113);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_integer_expression);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(113);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_float_expression);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_float_expression);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym__hpath_start);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_spath_expression);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_uri_expression);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          ('*' <= lookahead && lookahead <= ':') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '~') ADVANCE(118);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_ellipses);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(143);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(135);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(14);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(145);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(163);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(164);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(49);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym__indented_escape_sequence);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE2);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(168);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(2);
      if (lookahead == 'i') ADVANCE(3);
      if (lookahead == 'l') ADVANCE(4);
      if (lookahead == 'r') ADVANCE(5);
      if (lookahead == 't') ADVANCE(6);
      if (lookahead == 'w') ADVANCE(7);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(8);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(9);
      END_STATE();
    case 3:
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(12);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(13);
      END_STATE();
    case 6:
      if (lookahead == 'h') ADVANCE(14);
      END_STATE();
    case 7:
      if (lookahead == 'i') ADVANCE(15);
      END_STATE();
    case 8:
      if (lookahead == 's') ADVANCE(16);
      END_STATE();
    case 9:
      if (lookahead == 's') ADVANCE(17);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'h') ADVANCE(18);
      END_STATE();
    case 12:
      if (lookahead == 't') ADVANCE(19);
      END_STATE();
    case 13:
      if (lookahead == 'c') ADVANCE(20);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 15:
      if (lookahead == 't') ADVANCE(22);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_rec);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 22:
      if (lookahead == 'h') ADVANCE(27);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 25:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(30);
      END_STATE();
    case 29:
      if (lookahead == 'i') ADVANCE(31);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 31:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_inherit);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 51, .external_lex_state = 2},
  [2] = {.lex_state = 51, .external_lex_state = 2},
  [3] = {.lex_state = 51, .external_lex_state = 2},
  [4] = {.lex_state = 51, .external_lex_state = 2},
  [5] = {.lex_state = 51, .external_lex_state = 2},
  [6] = {.lex_state = 51, .external_lex_state = 2},
  [7] = {.lex_state = 51, .external_lex_state = 2},
  [8] = {.lex_state = 51, .external_lex_state = 2},
  [9] = {.lex_state = 51, .external_lex_state = 2},
  [10] = {.lex_state = 51, .external_lex_state = 2},
  [11] = {.lex_state = 51, .external_lex_state = 2},
  [12] = {.lex_state = 51, .external_lex_state = 2},
  [13] = {.lex_state = 51, .external_lex_state = 2},
  [14] = {.lex_state = 51, .external_lex_state = 2},
  [15] = {.lex_state = 51, .external_lex_state = 2},
  [16] = {.lex_state = 51, .external_lex_state = 2},
  [17] = {.lex_state = 51, .external_lex_state = 2},
  [18] = {.lex_state = 51, .external_lex_state = 2},
  [19] = {.lex_state = 51, .external_lex_state = 2},
  [20] = {.lex_state = 51, .external_lex_state = 2},
  [21] = {.lex_state = 51, .external_lex_state = 2},
  [22] = {.lex_state = 51, .external_lex_state = 2},
  [23] = {.lex_state = 51, .external_lex_state = 2},
  [24] = {.lex_state = 54, .external_lex_state = 2},
  [25] = {.lex_state = 51, .external_lex_state = 2},
  [26] = {.lex_state = 51, .external_lex_state = 2},
  [27] = {.lex_state = 51, .external_lex_state = 2},
  [28] = {.lex_state = 51, .external_lex_state = 2},
  [29] = {.lex_state = 51, .external_lex_state = 2},
  [30] = {.lex_state = 51, .external_lex_state = 2},
  [31] = {.lex_state = 51, .external_lex_state = 2},
  [32] = {.lex_state = 51, .external_lex_state = 2},
  [33] = {.lex_state = 51, .external_lex_state = 2},
  [34] = {.lex_state = 51, .external_lex_state = 2},
  [35] = {.lex_state = 51, .external_lex_state = 2},
  [36] = {.lex_state = 51, .external_lex_state = 2},
  [37] = {.lex_state = 51, .external_lex_state = 2},
  [38] = {.lex_state = 51, .external_lex_state = 2},
  [39] = {.lex_state = 51, .external_lex_state = 2},
  [40] = {.lex_state = 51, .external_lex_state = 2},
  [41] = {.lex_state = 51, .external_lex_state = 2},
  [42] = {.lex_state = 51, .external_lex_state = 2},
  [43] = {.lex_state = 51, .external_lex_state = 2},
  [44] = {.lex_state = 51, .external_lex_state = 2},
  [45] = {.lex_state = 51, .external_lex_state = 2},
  [46] = {.lex_state = 51, .external_lex_state = 2},
  [47] = {.lex_state = 51, .external_lex_state = 2},
  [48] = {.lex_state = 51, .external_lex_state = 2},
  [49] = {.lex_state = 51, .external_lex_state = 2},
  [50] = {.lex_state = 51, .external_lex_state = 2},
  [51] = {.lex_state = 51, .external_lex_state = 2},
  [52] = {.lex_state = 51, .external_lex_state = 2},
  [53] = {.lex_state = 51, .external_lex_state = 2},
  [54] = {.lex_state = 51, .external_lex_state = 2},
  [55] = {.lex_state = 51, .external_lex_state = 2},
  [56] = {.lex_state = 51, .external_lex_state = 2},
  [57] = {.lex_state = 51, .external_lex_state = 2},
  [58] = {.lex_state = 51, .external_lex_state = 2},
  [59] = {.lex_state = 51, .external_lex_state = 2},
  [60] = {.lex_state = 51, .external_lex_state = 2},
  [61] = {.lex_state = 51, .external_lex_state = 2},
  [62] = {.lex_state = 51, .external_lex_state = 2},
  [63] = {.lex_state = 51, .external_lex_state = 2},
  [64] = {.lex_state = 51, .external_lex_state = 2},
  [65] = {.lex_state = 51, .external_lex_state = 2},
  [66] = {.lex_state = 51, .external_lex_state = 2},
  [67] = {.lex_state = 51, .external_lex_state = 2},
  [68] = {.lex_state = 51, .external_lex_state = 2},
  [69] = {.lex_state = 51, .external_lex_state = 2},
  [70] = {.lex_state = 51, .external_lex_state = 2},
  [71] = {.lex_state = 51, .external_lex_state = 2},
  [72] = {.lex_state = 51, .external_lex_state = 2},
  [73] = {.lex_state = 51, .external_lex_state = 2},
  [74] = {.lex_state = 51, .external_lex_state = 2},
  [75] = {.lex_state = 51, .external_lex_state = 2},
  [76] = {.lex_state = 54, .external_lex_state = 2},
  [77] = {.lex_state = 54, .external_lex_state = 2},
  [78] = {.lex_state = 54, .external_lex_state = 2},
  [79] = {.lex_state = 54, .external_lex_state = 3},
  [80] = {.lex_state = 54, .external_lex_state = 3},
  [81] = {.lex_state = 54, .external_lex_state = 3},
  [82] = {.lex_state = 54, .external_lex_state = 3},
  [83] = {.lex_state = 54, .external_lex_state = 3},
  [84] = {.lex_state = 54, .external_lex_state = 3},
  [85] = {.lex_state = 53, .external_lex_state = 2},
  [86] = {.lex_state = 53, .external_lex_state = 2},
  [87] = {.lex_state = 54, .external_lex_state = 3},
  [88] = {.lex_state = 53, .external_lex_state = 2},
  [89] = {.lex_state = 54, .external_lex_state = 2},
  [90] = {.lex_state = 54, .external_lex_state = 2},
  [91] = {.lex_state = 53, .external_lex_state = 2},
  [92] = {.lex_state = 53, .external_lex_state = 2},
  [93] = {.lex_state = 53, .external_lex_state = 2},
  [94] = {.lex_state = 53, .external_lex_state = 2},
  [95] = {.lex_state = 54, .external_lex_state = 3},
  [96] = {.lex_state = 53, .external_lex_state = 2},
  [97] = {.lex_state = 54, .external_lex_state = 2},
  [98] = {.lex_state = 54, .external_lex_state = 3},
  [99] = {.lex_state = 54, .external_lex_state = 2},
  [100] = {.lex_state = 54, .external_lex_state = 2},
  [101] = {.lex_state = 54, .external_lex_state = 2},
  [102] = {.lex_state = 54, .external_lex_state = 2},
  [103] = {.lex_state = 54, .external_lex_state = 2},
  [104] = {.lex_state = 54, .external_lex_state = 2},
  [105] = {.lex_state = 54, .external_lex_state = 3},
  [106] = {.lex_state = 54, .external_lex_state = 2},
  [107] = {.lex_state = 54, .external_lex_state = 2},
  [108] = {.lex_state = 54, .external_lex_state = 2},
  [109] = {.lex_state = 54, .external_lex_state = 2},
  [110] = {.lex_state = 54, .external_lex_state = 3},
  [111] = {.lex_state = 54, .external_lex_state = 3},
  [112] = {.lex_state = 54, .external_lex_state = 3},
  [113] = {.lex_state = 54, .external_lex_state = 2},
  [114] = {.lex_state = 54, .external_lex_state = 3},
  [115] = {.lex_state = 54, .external_lex_state = 3},
  [116] = {.lex_state = 54, .external_lex_state = 2},
  [117] = {.lex_state = 54, .external_lex_state = 3},
  [118] = {.lex_state = 54, .external_lex_state = 2},
  [119] = {.lex_state = 54, .external_lex_state = 3},
  [120] = {.lex_state = 54, .external_lex_state = 3},
  [121] = {.lex_state = 54, .external_lex_state = 3},
  [122] = {.lex_state = 54, .external_lex_state = 3},
  [123] = {.lex_state = 54, .external_lex_state = 3},
  [124] = {.lex_state = 54, .external_lex_state = 3},
  [125] = {.lex_state = 54, .external_lex_state = 2},
  [126] = {.lex_state = 51, .external_lex_state = 2},
  [127] = {.lex_state = 54, .external_lex_state = 2},
  [128] = {.lex_state = 51, .external_lex_state = 2},
  [129] = {.lex_state = 51, .external_lex_state = 2},
  [130] = {.lex_state = 51, .external_lex_state = 2},
  [131] = {.lex_state = 51, .external_lex_state = 2},
  [132] = {.lex_state = 51, .external_lex_state = 2},
  [133] = {.lex_state = 51, .external_lex_state = 2},
  [134] = {.lex_state = 51, .external_lex_state = 2},
  [135] = {.lex_state = 51, .external_lex_state = 2},
  [136] = {.lex_state = 51, .external_lex_state = 2},
  [137] = {.lex_state = 51, .external_lex_state = 2},
  [138] = {.lex_state = 51, .external_lex_state = 2},
  [139] = {.lex_state = 51, .external_lex_state = 2},
  [140] = {.lex_state = 51, .external_lex_state = 2},
  [141] = {.lex_state = 51, .external_lex_state = 2},
  [142] = {.lex_state = 51, .external_lex_state = 2},
  [143] = {.lex_state = 51, .external_lex_state = 2},
  [144] = {.lex_state = 51, .external_lex_state = 2},
  [145] = {.lex_state = 51, .external_lex_state = 2},
  [146] = {.lex_state = 51, .external_lex_state = 2},
  [147] = {.lex_state = 51, .external_lex_state = 2},
  [148] = {.lex_state = 51, .external_lex_state = 2},
  [149] = {.lex_state = 51, .external_lex_state = 2},
  [150] = {.lex_state = 51, .external_lex_state = 2},
  [151] = {.lex_state = 51, .external_lex_state = 2},
  [152] = {.lex_state = 51, .external_lex_state = 2},
  [153] = {.lex_state = 51, .external_lex_state = 2},
  [154] = {.lex_state = 51, .external_lex_state = 2},
  [155] = {.lex_state = 51, .external_lex_state = 2},
  [156] = {.lex_state = 51, .external_lex_state = 2},
  [157] = {.lex_state = 51, .external_lex_state = 2},
  [158] = {.lex_state = 51, .external_lex_state = 2},
  [159] = {.lex_state = 51, .external_lex_state = 2},
  [160] = {.lex_state = 51, .external_lex_state = 2},
  [161] = {.lex_state = 51, .external_lex_state = 2},
  [162] = {.lex_state = 51, .external_lex_state = 2},
  [163] = {.lex_state = 51, .external_lex_state = 2},
  [164] = {.lex_state = 51, .external_lex_state = 2},
  [165] = {.lex_state = 51, .external_lex_state = 2},
  [166] = {.lex_state = 51, .external_lex_state = 2},
  [167] = {.lex_state = 51, .external_lex_state = 2},
  [168] = {.lex_state = 51, .external_lex_state = 2},
  [169] = {.lex_state = 51, .external_lex_state = 2},
  [170] = {.lex_state = 51, .external_lex_state = 2},
  [171] = {.lex_state = 54, .external_lex_state = 3},
  [172] = {.lex_state = 54, .external_lex_state = 2},
  [173] = {.lex_state = 54, .external_lex_state = 3},
  [174] = {.lex_state = 53, .external_lex_state = 2},
  [175] = {.lex_state = 53, .external_lex_state = 2},
  [176] = {.lex_state = 54, .external_lex_state = 3},
  [177] = {.lex_state = 54, .external_lex_state = 2},
  [178] = {.lex_state = 54, .external_lex_state = 2},
  [179] = {.lex_state = 53, .external_lex_state = 2},
  [180] = {.lex_state = 53, .external_lex_state = 2},
  [181] = {.lex_state = 53, .external_lex_state = 2},
  [182] = {.lex_state = 53, .external_lex_state = 2},
  [183] = {.lex_state = 54, .external_lex_state = 3},
  [184] = {.lex_state = 54, .external_lex_state = 2},
  [185] = {.lex_state = 54, .external_lex_state = 2},
  [186] = {.lex_state = 54, .external_lex_state = 2},
  [187] = {.lex_state = 54, .external_lex_state = 3},
  [188] = {.lex_state = 54, .external_lex_state = 2},
  [189] = {.lex_state = 53, .external_lex_state = 2},
  [190] = {.lex_state = 53, .external_lex_state = 2},
  [191] = {.lex_state = 54, .external_lex_state = 3},
  [192] = {.lex_state = 53, .external_lex_state = 2},
  [193] = {.lex_state = 53, .external_lex_state = 2},
  [194] = {.lex_state = 53, .external_lex_state = 2},
  [195] = {.lex_state = 53, .external_lex_state = 2},
  [196] = {.lex_state = 53, .external_lex_state = 2},
  [197] = {.lex_state = 53, .external_lex_state = 2},
  [198] = {.lex_state = 53, .external_lex_state = 2},
  [199] = {.lex_state = 53, .external_lex_state = 2},
  [200] = {.lex_state = 53, .external_lex_state = 2},
  [201] = {.lex_state = 53, .external_lex_state = 2},
  [202] = {.lex_state = 53, .external_lex_state = 2},
  [203] = {.lex_state = 53, .external_lex_state = 2},
  [204] = {.lex_state = 53, .external_lex_state = 2},
  [205] = {.lex_state = 54, .external_lex_state = 2},
  [206] = {.lex_state = 54, .external_lex_state = 2},
  [207] = {.lex_state = 54, .external_lex_state = 2},
  [208] = {.lex_state = 54, .external_lex_state = 2},
  [209] = {.lex_state = 54, .external_lex_state = 2},
  [210] = {.lex_state = 54, .external_lex_state = 2},
  [211] = {.lex_state = 54, .external_lex_state = 2},
  [212] = {.lex_state = 54, .external_lex_state = 2},
  [213] = {.lex_state = 54, .external_lex_state = 2},
  [214] = {.lex_state = 54, .external_lex_state = 2},
  [215] = {.lex_state = 54, .external_lex_state = 2},
  [216] = {.lex_state = 54, .external_lex_state = 2},
  [217] = {.lex_state = 54, .external_lex_state = 2},
  [218] = {.lex_state = 54, .external_lex_state = 2},
  [219] = {.lex_state = 54, .external_lex_state = 2},
  [220] = {.lex_state = 54, .external_lex_state = 2},
  [221] = {.lex_state = 54, .external_lex_state = 2},
  [222] = {.lex_state = 54, .external_lex_state = 2},
  [223] = {.lex_state = 53, .external_lex_state = 2},
  [224] = {.lex_state = 53, .external_lex_state = 2},
  [225] = {.lex_state = 54, .external_lex_state = 2},
  [226] = {.lex_state = 54, .external_lex_state = 2},
  [227] = {.lex_state = 54, .external_lex_state = 2},
  [228] = {.lex_state = 54, .external_lex_state = 2},
  [229] = {.lex_state = 54, .external_lex_state = 2},
  [230] = {.lex_state = 54, .external_lex_state = 2},
  [231] = {.lex_state = 54, .external_lex_state = 2},
  [232] = {.lex_state = 54, .external_lex_state = 2},
  [233] = {.lex_state = 54, .external_lex_state = 2},
  [234] = {.lex_state = 54, .external_lex_state = 2},
  [235] = {.lex_state = 54, .external_lex_state = 2},
  [236] = {.lex_state = 54, .external_lex_state = 2},
  [237] = {.lex_state = 54, .external_lex_state = 2},
  [238] = {.lex_state = 54, .external_lex_state = 2},
  [239] = {.lex_state = 54, .external_lex_state = 2},
  [240] = {.lex_state = 54, .external_lex_state = 2},
  [241] = {.lex_state = 54, .external_lex_state = 2},
  [242] = {.lex_state = 54, .external_lex_state = 2},
  [243] = {.lex_state = 54, .external_lex_state = 2},
  [244] = {.lex_state = 54, .external_lex_state = 2},
  [245] = {.lex_state = 54, .external_lex_state = 2},
  [246] = {.lex_state = 54, .external_lex_state = 2},
  [247] = {.lex_state = 53, .external_lex_state = 2},
  [248] = {.lex_state = 54, .external_lex_state = 2},
  [249] = {.lex_state = 54, .external_lex_state = 2},
  [250] = {.lex_state = 54, .external_lex_state = 2},
  [251] = {.lex_state = 54, .external_lex_state = 2},
  [252] = {.lex_state = 54, .external_lex_state = 2},
  [253] = {.lex_state = 54, .external_lex_state = 2},
  [254] = {.lex_state = 54, .external_lex_state = 2},
  [255] = {.lex_state = 54, .external_lex_state = 2},
  [256] = {.lex_state = 54, .external_lex_state = 2},
  [257] = {.lex_state = 54, .external_lex_state = 2},
  [258] = {.lex_state = 54, .external_lex_state = 2},
  [259] = {.lex_state = 51, .external_lex_state = 2},
  [260] = {.lex_state = 51, .external_lex_state = 2},
  [261] = {.lex_state = 51, .external_lex_state = 2},
  [262] = {.lex_state = 51, .external_lex_state = 2},
  [263] = {.lex_state = 51, .external_lex_state = 2},
  [264] = {.lex_state = 51, .external_lex_state = 2},
  [265] = {.lex_state = 51, .external_lex_state = 2},
  [266] = {.lex_state = 51, .external_lex_state = 2},
  [267] = {.lex_state = 51, .external_lex_state = 2},
  [268] = {.lex_state = 51, .external_lex_state = 2},
  [269] = {.lex_state = 51, .external_lex_state = 2},
  [270] = {.lex_state = 51, .external_lex_state = 2},
  [271] = {.lex_state = 51, .external_lex_state = 2},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 56},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 57},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 57},
  [280] = {.lex_state = 57},
  [281] = {.lex_state = 57},
  [282] = {.lex_state = 57},
  [283] = {.lex_state = 57},
  [284] = {.lex_state = 57},
  [285] = {.lex_state = 57},
  [286] = {.lex_state = 57},
  [287] = {.lex_state = 57},
  [288] = {.lex_state = 57},
  [289] = {.lex_state = 57},
  [290] = {.lex_state = 57},
  [291] = {.lex_state = 57},
  [292] = {.lex_state = 57},
  [293] = {.lex_state = 57},
  [294] = {.lex_state = 57},
  [295] = {.lex_state = 57},
  [296] = {.lex_state = 57},
  [297] = {.lex_state = 57},
  [298] = {.lex_state = 57},
  [299] = {.lex_state = 57},
  [300] = {.lex_state = 57},
  [301] = {.lex_state = 57},
  [302] = {.lex_state = 57},
  [303] = {.lex_state = 57},
  [304] = {.lex_state = 57},
  [305] = {.lex_state = 57},
  [306] = {.lex_state = 57},
  [307] = {.lex_state = 57},
  [308] = {.lex_state = 57},
  [309] = {.lex_state = 57},
  [310] = {.lex_state = 57},
  [311] = {.lex_state = 57},
  [312] = {.lex_state = 57},
  [313] = {.lex_state = 57},
  [314] = {.lex_state = 57},
  [315] = {.lex_state = 57},
  [316] = {.lex_state = 57},
  [317] = {.lex_state = 57},
  [318] = {.lex_state = 57},
  [319] = {.lex_state = 57},
  [320] = {.lex_state = 57},
  [321] = {.lex_state = 57},
  [322] = {.lex_state = 57},
  [323] = {.lex_state = 57},
  [324] = {.lex_state = 57},
  [325] = {.lex_state = 57},
  [326] = {.lex_state = 57},
  [327] = {.lex_state = 57},
  [328] = {.lex_state = 57},
  [329] = {.lex_state = 57},
  [330] = {.lex_state = 57},
  [331] = {.lex_state = 3},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 3},
  [334] = {.lex_state = 51, .external_lex_state = 2},
  [335] = {.lex_state = 3},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 3},
  [339] = {.lex_state = 3},
  [340] = {.lex_state = 3},
  [341] = {.lex_state = 3},
  [342] = {.lex_state = 3},
  [343] = {.lex_state = 3},
  [344] = {.lex_state = 3},
  [345] = {.lex_state = 3},
  [346] = {.lex_state = 3},
  [347] = {.lex_state = 3},
  [348] = {.lex_state = 3},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 3},
  [351] = {.lex_state = 3},
  [352] = {.lex_state = 3},
  [353] = {.lex_state = 3},
  [354] = {.lex_state = 3},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 1},
  [359] = {.lex_state = 51, .external_lex_state = 4},
  [360] = {.lex_state = 1, .external_lex_state = 5},
  [361] = {.lex_state = 1, .external_lex_state = 5},
  [362] = {.lex_state = 51, .external_lex_state = 4},
  [363] = {.lex_state = 51, .external_lex_state = 4},
  [364] = {.lex_state = 1, .external_lex_state = 5},
  [365] = {.lex_state = 51, .external_lex_state = 4},
  [366] = {.lex_state = 56},
  [367] = {.lex_state = 1},
  [368] = {.lex_state = 51, .external_lex_state = 4},
  [369] = {.lex_state = 1, .external_lex_state = 5},
  [370] = {.lex_state = 51, .external_lex_state = 4},
  [371] = {.lex_state = 56},
  [372] = {.lex_state = 51, .external_lex_state = 4},
  [373] = {.lex_state = 51, .external_lex_state = 4},
  [374] = {.lex_state = 56},
  [375] = {.lex_state = 51, .external_lex_state = 4},
  [376] = {.lex_state = 51, .external_lex_state = 4},
  [377] = {.lex_state = 51, .external_lex_state = 4},
  [378] = {.lex_state = 51, .external_lex_state = 4},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 1, .external_lex_state = 5},
  [381] = {.lex_state = 1, .external_lex_state = 5},
  [382] = {.lex_state = 56},
  [383] = {.lex_state = 51, .external_lex_state = 4},
  [384] = {.lex_state = 51, .external_lex_state = 4},
  [385] = {.lex_state = 51, .external_lex_state = 4},
  [386] = {.lex_state = 51, .external_lex_state = 4},
  [387] = {.lex_state = 1, .external_lex_state = 5},
  [388] = {.lex_state = 1},
  [389] = {.lex_state = 56},
  [390] = {.lex_state = 56},
  [391] = {.lex_state = 56},
  [392] = {.lex_state = 56},
  [393] = {.lex_state = 1, .external_lex_state = 5},
  [394] = {.lex_state = 56},
  [395] = {.lex_state = 56},
  [396] = {.lex_state = 51, .external_lex_state = 4},
  [397] = {.lex_state = 51, .external_lex_state = 4},
  [398] = {.lex_state = 1, .external_lex_state = 5},
  [399] = {.lex_state = 51, .external_lex_state = 4},
  [400] = {.lex_state = 51, .external_lex_state = 4},
  [401] = {.lex_state = 51, .external_lex_state = 4},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 1},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 1},
  [406] = {.lex_state = 51},
  [407] = {.lex_state = 1},
  [408] = {.lex_state = 1},
  [409] = {.lex_state = 3},
  [410] = {.lex_state = 1},
  [411] = {.lex_state = 3},
  [412] = {.lex_state = 3},
  [413] = {.lex_state = 1},
  [414] = {.lex_state = 1},
  [415] = {.lex_state = 1},
  [416] = {.lex_state = 3},
  [417] = {.lex_state = 1},
  [418] = {.lex_state = 1},
  [419] = {.lex_state = 3},
  [420] = {.lex_state = 3},
  [421] = {.lex_state = 1, .external_lex_state = 5},
  [422] = {.lex_state = 3},
  [423] = {.lex_state = 51, .external_lex_state = 4},
  [424] = {.lex_state = 3},
  [425] = {.lex_state = 51, .external_lex_state = 4},
  [426] = {.lex_state = 1, .external_lex_state = 5},
  [427] = {.lex_state = 4},
  [428] = {.lex_state = 1},
  [429] = {.lex_state = 4},
  [430] = {.lex_state = 4},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 51},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 51},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 56},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 56},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 56},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 56},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 56},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 56},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 56},
  [501] = {.lex_state = 1},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 56},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 53},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 51},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 1},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 53},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 51},
  [533] = {.lex_state = 56},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 56},
  [536] = {.lex_state = 56},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 56},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_keyword] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_integer_expression] = ACTIONS(1),
    [sym_float_expression] = ACTIONS(1),
    [sym__hpath_start] = ACTIONS(1),
    [sym_spath_expression] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_ellipses] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_rec] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(1),
    [sym__indented_escape_sequence] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_inherit] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE2] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_string_fragment] = ACTIONS(1),
    [sym__indented_string_fragment] = ACTIONS(1),
    [sym__path_start] = ACTIONS(1),
    [sym_path_fragment] = ACTIONS(1),
    [sym_dollar_escape] = ACTIONS(1),
    [sym__indented_dollar_escape] = ACTIONS(1),
  },
  [1] = {
    [sym_source_code] = STATE(531),
    [sym__expression] = STATE(530),
    [sym_variable_expression] = STATE(225),
    [sym_path_expression] = STATE(225),
    [sym_hpath_expression] = STATE(225),
    [sym__expr_function_expression] = STATE(389),
    [sym_function_expression] = STATE(389),
    [sym_formals] = STATE(447),
    [sym_assert_expression] = STATE(389),
    [sym_with_expression] = STATE(389),
    [sym_let_expression] = STATE(389),
    [sym__expr_if] = STATE(389),
    [sym_if_expression] = STATE(389),
    [sym__expr_op] = STATE(329),
    [sym_has_attr_expression] = STATE(329),
    [sym_unary_expression] = STATE(329),
    [sym_binary_expression] = STATE(329),
    [sym__expr_apply_expression] = STATE(77),
    [sym_apply_expression] = STATE(77),
    [sym__expr_select_expression] = STATE(77),
    [sym_select_expression] = STATE(77),
    [sym__expr_simple] = STATE(225),
    [sym_parenthesized_expression] = STATE(225),
    [sym_attrset_expression] = STATE(225),
    [sym_let_attrset_expression] = STATE(225),
    [sym_rec_attrset_expression] = STATE(225),
    [sym_string_expression] = STATE(225),
    [sym_indented_string_expression] = STATE(225),
    [sym_list_expression] = STATE(225),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_integer_expression] = ACTIONS(9),
    [sym_float_expression] = ACTIONS(11),
    [sym__hpath_start] = ACTIONS(13),
    [sym_spath_expression] = ACTIONS(11),
    [sym_uri_expression] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_let] = ACTIONS(21),
    [anon_sym_if] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(29),
    [anon_sym_rec] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [sym_comment] = ACTIONS(3),
    [sym__path_start] = ACTIONS(39),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(528), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [97] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(371), 1,
      sym__expression,
    STATE(438), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [194] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(514), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [291] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    STATE(536), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [388] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(510), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [485] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(506), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [582] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    STATE(535), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [679] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    STATE(497), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [776] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    STATE(538), 1,
      sym__expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [873] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(537), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [970] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(478), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1067] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(534), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1164] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    STATE(533), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1261] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(488), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1358] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(371), 1,
      sym__expression,
    STATE(439), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1455] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(485), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1552] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(482), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1649] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(479), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1746] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    STATE(475), 1,
      sym__expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1843] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(471), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1940] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(371), 1,
      sym__expression,
    STATE(447), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2037] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(507), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2134] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    STATE(188), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(151), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
    ACTIONS(147), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [2217] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(442), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2314] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(499), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2411] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(502), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2508] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(468), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2605] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(371), 1,
      sym__expression,
    STATE(440), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2702] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(462), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2799] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(505), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2896] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(456), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2993] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(484), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3090] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(519), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3187] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    STATE(466), 1,
      sym__expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3284] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(461), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3381] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(481), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3478] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(459), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3575] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(480), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3672] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(476), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3769] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    STATE(489), 1,
      sym__expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3866] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(490), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3963] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(495), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(389), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4060] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(366), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4154] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4248] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(374), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4342] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(391), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4436] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(392), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4530] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(382), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4624] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(382), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4718] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(394), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4812] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(392), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4906] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(374), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5000] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(366), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5094] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(366), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5188] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(382), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5282] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(395), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5376] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(374), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5470] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(395), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5564] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(382), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5658] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(394), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5752] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(394), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5846] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(366), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5940] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6034] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(439), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(395), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6128] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(394), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6222] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(391), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6316] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6410] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(395), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6504] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(392), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6598] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(391), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6692] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(374), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6786] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6880] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(391), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6974] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(392), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [7068] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    STATE(256), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(151), 6,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(147), 11,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [7148] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    STATE(255), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(151), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
    ACTIONS(147), 12,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [7228] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    STATE(258), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(151), 6,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(147), 11,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [7308] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(177), 1,
      sym_path_fragment,
    STATE(83), 1,
      aux_sym_path_expression_repeat1,
    STATE(87), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7364] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(177), 1,
      sym_path_fragment,
    STATE(83), 1,
      aux_sym_path_expression_repeat1,
    STATE(87), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7420] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(187), 1,
      sym_path_fragment,
    STATE(79), 1,
      aux_sym_path_expression_repeat1,
    STATE(87), 1,
      sym__immediate_interpolation,
    ACTIONS(183), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(185), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7476] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(193), 1,
      sym_path_fragment,
    STATE(80), 1,
      aux_sym_path_expression_repeat1,
    STATE(87), 1,
      sym__immediate_interpolation,
    ACTIONS(189), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(191), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7532] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(199), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(202), 1,
      sym_path_fragment,
    STATE(83), 1,
      aux_sym_path_expression_repeat1,
    STATE(87), 1,
      sym__immediate_interpolation,
    ACTIONS(195), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(197), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 28,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7634] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      anon_sym_DOT,
    STATE(88), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7684] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      anon_sym_DOT,
    STATE(86), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(217), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7734] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(224), 28,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7780] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      anon_sym_DOT,
    STATE(86), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(228), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7830] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 25,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [7877] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 1,
      anon_sym_COLON,
    ACTIONS(242), 1,
      anon_sym_AT,
    ACTIONS(236), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(238), 25,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [7926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(246), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(250), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8016] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(254), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(258), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8106] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(262), 1,
      sym_path_fragment,
    STATE(115), 1,
      aux_sym_path_expression_repeat1,
    STATE(176), 1,
      sym__immediate_interpolation,
    ACTIONS(189), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(191), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8158] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(264), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(266), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(272), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8248] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(274), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(277), 1,
      sym_path_fragment,
    STATE(98), 1,
      aux_sym_path_expression_repeat1,
    STATE(187), 1,
      sym__immediate_interpolation,
    ACTIONS(195), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(197), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(280), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(282), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8388] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(286), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(290), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8476] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(294), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(298), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8564] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(302), 1,
      sym_path_fragment,
    STATE(98), 1,
      aux_sym_path_expression_repeat1,
    STATE(187), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8616] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      anon_sym_DOT,
    ACTIONS(304), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(306), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(238), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8706] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(312), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(316), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8794] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(318), 1,
      sym_path_fragment,
    STATE(111), 1,
      aux_sym_path_expression_repeat1,
    STATE(187), 1,
      sym__immediate_interpolation,
    ACTIONS(189), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(191), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8846] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(302), 1,
      sym_path_fragment,
    STATE(98), 1,
      aux_sym_path_expression_repeat1,
    STATE(187), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8898] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(320), 1,
      sym_path_fragment,
    STATE(117), 1,
      aux_sym_path_expression_repeat1,
    STATE(176), 1,
      sym__immediate_interpolation,
    ACTIONS(183), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(185), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(324), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8994] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(326), 1,
      sym_path_fragment,
    STATE(105), 1,
      aux_sym_path_expression_repeat1,
    STATE(187), 1,
      sym__immediate_interpolation,
    ACTIONS(183), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(185), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9046] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(328), 1,
      sym_path_fragment,
    STATE(124), 1,
      aux_sym_path_expression_repeat1,
    STATE(176), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9098] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(330), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(332), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9142] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(328), 1,
      sym_path_fragment,
    STATE(124), 1,
      aux_sym_path_expression_repeat1,
    STATE(176), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9194] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(258), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9238] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(336), 1,
      sym_path_fragment,
    STATE(121), 1,
      aux_sym_path_expression_repeat1,
    STATE(183), 1,
      sym__immediate_interpolation,
    ACTIONS(189), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(191), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9290] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(338), 1,
      sym_path_fragment,
    STATE(122), 1,
      aux_sym_path_expression_repeat1,
    STATE(183), 1,
      sym__immediate_interpolation,
    ACTIONS(183), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(185), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9342] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(340), 1,
      sym_path_fragment,
    STATE(123), 1,
      aux_sym_path_expression_repeat1,
    STATE(183), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9394] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(340), 1,
      sym_path_fragment,
    STATE(123), 1,
      aux_sym_path_expression_repeat1,
    STATE(183), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9446] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(345), 1,
      sym_path_fragment,
    STATE(123), 1,
      aux_sym_path_expression_repeat1,
    STATE(183), 1,
      sym__immediate_interpolation,
    ACTIONS(195), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(197), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9498] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(348), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(351), 1,
      sym_path_fragment,
    STATE(124), 1,
      aux_sym_path_expression_repeat1,
    STATE(176), 1,
      sym__immediate_interpolation,
    ACTIONS(195), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(197), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9550] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(254), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9594] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(316), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9710] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(295), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9783] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(306), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9856] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(297), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9929] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(279), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10002] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(291), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10075] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(320), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10148] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(301), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10221] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(323), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10294] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10367] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(302), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10440] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(303), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10513] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10586] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(311), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10659] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(305), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10732] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(307), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10805] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10878] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(309), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10951] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(310), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11024] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11097] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(317), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11170] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(322), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11243] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(325), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11316] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(327), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11389] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(292), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11462] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(293), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11535] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(288), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11608] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(296), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11681] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(279), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11754] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(284), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11827] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(328), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11900] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(312), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11973] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(324), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12046] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(285), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12119] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(321), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12192] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(279), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12265] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(299), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12338] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(294), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12411] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(314), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12484] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(279), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12557] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(330), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12630] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(298), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12703] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(319), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12776] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [12891] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_COLON,
    ACTIONS(360), 1,
      anon_sym_AT,
    ACTIONS(236), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(238), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [12937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [12979] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(362), 1,
      anon_sym_DOT,
    STATE(174), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(217), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13025] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 1,
      anon_sym_DOT,
    STATE(175), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(217), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13071] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(224), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13113] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_COLON,
    ACTIONS(370), 1,
      anon_sym_AT,
    ACTIONS(236), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(238), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13159] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13203] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 1,
      anon_sym_DOT,
    STATE(179), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(217), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13249] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 1,
      anon_sym_DOT,
    STATE(174), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(228), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13295] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 1,
      anon_sym_DOT,
    STATE(192), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13341] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 1,
      anon_sym_DOT,
    STATE(180), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13387] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(224), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13429] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13473] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 1,
      anon_sym_COLON,
    ACTIONS(381), 1,
      anon_sym_AT,
    ACTIONS(236), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(238), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13519] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(224), 24,
      sym__path_start,
      sym_path_fragment,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(385), 25,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13647] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(387), 1,
      anon_sym_DOT,
    STATE(190), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13693] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(387), 1,
      anon_sym_DOT,
    STATE(179), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(228), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 24,
      sym__path_start,
      sym_path_fragment,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13781] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 1,
      anon_sym_DOT,
    STATE(175), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(228), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(258), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(246), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13909] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(254), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(258), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13991] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(250), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(254), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(246), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14114] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(250), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(254), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(246), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14237] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(258), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14278] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(250), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(316), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(330), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(332), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(324), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(254), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(258), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(290), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14639] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(286), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(290), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(280), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(282), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(330), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(332), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(330), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(332), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(324), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(286), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(258), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(294), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(272), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15039] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 1,
      anon_sym_or,
    ACTIONS(264), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(266), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15081] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      anon_sym_or,
    ACTIONS(264), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(266), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15123] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 1,
      anon_sym_DOT,
    ACTIONS(304), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(306), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15165] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(280), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(282), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(298), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(298), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(294), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15365] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(286), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(272), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(280), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(282), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(316), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15525] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(312), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15565] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(312), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15605] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 1,
      anon_sym_DOT,
    ACTIONS(304), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(306), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15647] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(290), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(272), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15727] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(254), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(324), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15807] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(298), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15847] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(294), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(254), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15927] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 1,
      anon_sym_DOT,
    ACTIONS(304), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(306), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15969] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(238), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16009] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_or,
    ACTIONS(264), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(266), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16051] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(316), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(312), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(258), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(238), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(238), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(385), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16368] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(385), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(385), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16485] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(401), 1,
      anon_sym_RBRACK,
    STATE(263), 1,
      aux_sym_list_expression_repeat1,
    STATE(334), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16550] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(403), 1,
      anon_sym_RBRACK,
    STATE(265), 1,
      aux_sym_list_expression_repeat1,
    STATE(334), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16615] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(405), 1,
      anon_sym_RBRACK,
    STATE(260), 1,
      aux_sym_list_expression_repeat1,
    STATE(334), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16680] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(407), 1,
      anon_sym_RBRACK,
    STATE(265), 1,
      aux_sym_list_expression_repeat1,
    STATE(334), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16745] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(409), 1,
      anon_sym_RBRACK,
    STATE(265), 1,
      aux_sym_list_expression_repeat1,
    STATE(334), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16810] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(411), 1,
      anon_sym_RBRACK,
    STATE(262), 1,
      aux_sym_list_expression_repeat1,
    STATE(334), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16875] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_integer_expression,
    ACTIONS(422), 1,
      sym__hpath_start,
    ACTIONS(425), 1,
      anon_sym_LBRACE,
    ACTIONS(428), 1,
      anon_sym_let,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(434), 1,
      anon_sym_rec,
    ACTIONS(437), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(446), 1,
      anon_sym_RBRACK,
    ACTIONS(448), 1,
      sym__path_start,
    STATE(265), 1,
      aux_sym_list_expression_repeat1,
    STATE(334), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(419), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16940] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(451), 1,
      anon_sym_RBRACK,
    STATE(265), 1,
      aux_sym_list_expression_repeat1,
    STATE(334), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17005] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(453), 1,
      anon_sym_RBRACK,
    STATE(266), 1,
      aux_sym_list_expression_repeat1,
    STATE(334), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17070] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    STATE(257), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(225), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17129] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    STATE(127), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17188] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    STATE(253), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(237), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17247] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    STATE(254), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(245), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(254), 19,
      sym_identifier,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [17339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(250), 19,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
  [17372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(258), 19,
      sym_identifier,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [17405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(246), 19,
      sym_identifier,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [17438] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      anon_sym_DOT,
    STATE(276), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(217), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(458), 18,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17504] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_DOT,
    STATE(276), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(228), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(466), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(464), 18,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17570] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_DOT,
    STATE(278), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(211), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17604] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(283), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(228), 14,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [17637] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(281), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(211), 14,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [17670] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 1,
      anon_sym_DOT,
    STATE(283), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(217), 14,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [17703] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(485), 1,
      anon_sym_STAR,
    ACTIONS(487), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(479), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(481), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(483), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [17747] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(485), 1,
      anon_sym_STAR,
    ACTIONS(487), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(493), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(473), 11,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [17787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(246), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
  [17815] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(254), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
  [17843] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [17875] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(485), 1,
      anon_sym_STAR,
    ACTIONS(487), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(497), 1,
      anon_sym_AMP_AMP,
    ACTIONS(499), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(501), 1,
      anon_sym_DASH_GT,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(479), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(481), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(483), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(495), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [17925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(258), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
  [17953] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [17985] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(485), 1,
      anon_sym_STAR,
    ACTIONS(487), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(493), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(473), 11,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [18025] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(485), 1,
      anon_sym_STAR,
    ACTIONS(487), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(497), 1,
      anon_sym_AMP_AMP,
    ACTIONS(499), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(501), 1,
      anon_sym_DASH_GT,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(479), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(481), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(483), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [18075] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(485), 1,
      anon_sym_STAR,
    ACTIONS(487), 1,
      anon_sym_SLASH,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(466), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(464), 12,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [18113] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(485), 1,
      anon_sym_STAR,
    ACTIONS(487), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(481), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(483), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 9,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [18155] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(485), 1,
      anon_sym_STAR,
    ACTIONS(487), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(497), 1,
      anon_sym_AMP_AMP,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(479), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(481), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(483), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [18201] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(485), 1,
      anon_sym_STAR,
    ACTIONS(487), 1,
      anon_sym_SLASH,
    ACTIONS(491), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 12,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [18237] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_STAR,
    ACTIONS(509), 1,
      anon_sym_SLASH,
    ACTIONS(511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18274] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_STAR,
    ACTIONS(509), 1,
      anon_sym_SLASH,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 9,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18307] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(523), 1,
      anon_sym_AMP_AMP,
    ACTIONS(525), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(531), 1,
      anon_sym_DASH_GT,
    ACTIONS(533), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(515), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(517), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(519), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(521), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18354] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18383] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(533), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(515), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18420] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      anon_sym_else,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(523), 1,
      anon_sym_AMP_AMP,
    ACTIONS(525), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(531), 1,
      anon_sym_DASH_GT,
    ACTIONS(533), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(515), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(517), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(519), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(521), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18467] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18496] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(523), 1,
      anon_sym_AMP_AMP,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(533), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(515), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(517), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(519), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(521), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 3,
      anon_sym_else,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18539] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_STAR,
    ACTIONS(509), 1,
      anon_sym_SLASH,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(466), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(464), 9,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18574] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(533), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(515), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(517), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(519), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(521), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 4,
      anon_sym_else,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18615] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(533), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(515), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18652] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(533), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(515), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(519), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(521), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18691] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 9,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18724] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18753] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(541), 1,
      anon_sym_STAR,
    ACTIONS(543), 1,
      anon_sym_SLASH,
    ACTIONS(466), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(539), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(464), 9,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18788] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 1,
      anon_sym_then,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(541), 1,
      anon_sym_STAR,
    ACTIONS(543), 1,
      anon_sym_SLASH,
    ACTIONS(551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(553), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(555), 1,
      anon_sym_DASH_GT,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(539), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(547), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(549), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18835] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_STAR,
    ACTIONS(509), 1,
      anon_sym_SLASH,
    ACTIONS(511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(559), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(561), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18874] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(541), 1,
      anon_sym_STAR,
    ACTIONS(543), 1,
      anon_sym_SLASH,
    ACTIONS(551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(539), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(547), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(549), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 3,
      anon_sym_then,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18917] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_STAR,
    ACTIONS(509), 1,
      anon_sym_SLASH,
    ACTIONS(511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(559), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(561), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(563), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 4,
      ts_builtin_sym_end,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18958] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(541), 1,
      anon_sym_STAR,
    ACTIONS(543), 1,
      anon_sym_SLASH,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(539), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(547), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(549), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 4,
      anon_sym_then,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18999] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_STAR,
    ACTIONS(509), 1,
      anon_sym_SLASH,
    ACTIONS(511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 1,
      anon_sym_AMP_AMP,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(559), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(561), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(563), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 3,
      ts_builtin_sym_end,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19042] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19071] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19100] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      ts_builtin_sym_end,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_STAR,
    ACTIONS(509), 1,
      anon_sym_SLASH,
    ACTIONS(511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 1,
      anon_sym_AMP_AMP,
    ACTIONS(567), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(569), 1,
      anon_sym_DASH_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(559), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(561), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(563), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19147] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(541), 1,
      anon_sym_STAR,
    ACTIONS(543), 1,
      anon_sym_SLASH,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(493), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(539), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19184] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(541), 1,
      anon_sym_STAR,
    ACTIONS(543), 1,
      anon_sym_SLASH,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(493), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(539), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19221] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_STAR,
    ACTIONS(509), 1,
      anon_sym_SLASH,
    ACTIONS(511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19258] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(541), 1,
      anon_sym_STAR,
    ACTIONS(543), 1,
      anon_sym_SLASH,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(539), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(547), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(549), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19297] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      anon_sym_then,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(541), 1,
      anon_sym_STAR,
    ACTIONS(543), 1,
      anon_sym_SLASH,
    ACTIONS(551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(553), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(555), 1,
      anon_sym_DASH_GT,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(539), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(547), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(549), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19344] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(541), 1,
      anon_sym_STAR,
    ACTIONS(543), 1,
      anon_sym_SLASH,
    ACTIONS(493), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 9,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19377] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(493), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19406] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 1,
      ts_builtin_sym_end,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_STAR,
    ACTIONS(509), 1,
      anon_sym_SLASH,
    ACTIONS(511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(513), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 1,
      anon_sym_AMP_AMP,
    ACTIONS(567), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(569), 1,
      anon_sym_DASH_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(559), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(561), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(563), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19453] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(466), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(515), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(464), 9,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19488] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      sym_identifier,
    ACTIONS(573), 1,
      anon_sym_RBRACE,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(435), 1,
      sym_formal,
    STATE(483), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19531] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      sym_identifier,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(583), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(435), 1,
      sym_formal,
    STATE(508), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19574] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      sym_identifier,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(585), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(435), 1,
      sym_formal,
    STATE(512), 1,
      sym_attrpath,
    STATE(516), 1,
      sym_binding_set,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19617] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 4,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_rec,
    ACTIONS(589), 11,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [19640] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      sym_identifier,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(591), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(435), 1,
      sym_formal,
    STATE(467), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19683] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(595), 1,
      anon_sym_LBRACE,
    ACTIONS(597), 1,
      anon_sym_in,
    ACTIONS(599), 1,
      anon_sym_inherit,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(504), 1,
      sym_binding_set,
    STATE(532), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19723] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(601), 1,
      anon_sym_LBRACE,
    ACTIONS(603), 1,
      anon_sym_in,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(500), 1,
      sym_binding_set,
    STATE(532), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19763] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    ACTIONS(607), 1,
      anon_sym_in,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(458), 1,
      sym_binding_set,
    STATE(532), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19803] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(609), 1,
      anon_sym_LBRACE,
    ACTIONS(611), 1,
      anon_sym_in,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(470), 1,
      sym_binding_set,
    STATE(532), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19843] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(613), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(508), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19880] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(615), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(512), 1,
      sym_attrpath,
    STATE(523), 1,
      sym_binding_set,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19917] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(617), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(493), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19954] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(619), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(473), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19991] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(621), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(492), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20028] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(623), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(512), 1,
      sym_attrpath,
    STATE(516), 1,
      sym_binding_set,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20065] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(625), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(463), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20102] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(627), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(512), 1,
      sym_attrpath,
    STATE(520), 1,
      sym_binding_set,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20139] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(629), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(467), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20176] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(631), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(483), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20213] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(633), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(472), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20250] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(635), 1,
      anon_sym_RBRACE,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(464), 1,
      sym_binding_set,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20287] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(637), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20321] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(639), 1,
      anon_sym_in,
    STATE(354), 1,
      aux_sym_binding_set_repeat1,
    STATE(532), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20355] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_identifier,
    ACTIONS(644), 1,
      anon_sym_in,
    ACTIONS(646), 1,
      anon_sym_DQUOTE,
    ACTIONS(649), 1,
      anon_sym_inherit,
    ACTIONS(652), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(354), 1,
      aux_sym_binding_set_repeat1,
    STATE(532), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20389] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_identifier,
    ACTIONS(646), 1,
      anon_sym_DQUOTE,
    ACTIONS(652), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
    ACTIONS(657), 1,
      anon_sym_inherit,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(512), 1,
      sym_attrpath,
    STATE(436), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(409), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20423] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    STATE(367), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(498), 1,
      sym_inherited_attrs,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [20449] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    ACTIONS(664), 1,
      anon_sym_LPAREN,
    STATE(367), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(518), 1,
      sym_inherited_attrs,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [20475] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    STATE(367), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(486), 1,
      sym_inherited_attrs,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [20498] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(668), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(383), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20519] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(679), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(682), 1,
      sym__indented_dollar_escape,
    ACTIONS(676), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20540] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(689), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(691), 1,
      sym__indented_dollar_escape,
    ACTIONS(687), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20561] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(701), 1,
      sym_dollar_escape,
    ACTIONS(695), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20582] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(704), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20603] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(691), 1,
      sym__indented_dollar_escape,
    ACTIONS(708), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(710), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20624] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(712), 1,
      anon_sym_DQUOTE,
    ACTIONS(714), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(375), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20645] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20658] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    ACTIONS(718), 1,
      anon_sym_SEMI,
    STATE(379), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [20681] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(720), 1,
      anon_sym_DQUOTE,
    ACTIONS(722), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(384), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20702] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(691), 1,
      sym__indented_dollar_escape,
    ACTIONS(724), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(726), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(361), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20723] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(728), 1,
      anon_sym_DQUOTE,
    ACTIONS(730), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(363), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20744] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20757] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(734), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20778] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(736), 1,
      anon_sym_DQUOTE,
    ACTIONS(738), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(376), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20799] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20812] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(742), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20833] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(744), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20854] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(746), 1,
      anon_sym_DQUOTE,
    ACTIONS(748), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(378), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20875] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(750), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20896] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      sym_identifier,
    ACTIONS(755), 1,
      anon_sym_SEMI,
    ACTIONS(757), 1,
      anon_sym_DQUOTE,
    ACTIONS(760), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(379), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [20919] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(691), 1,
      sym__indented_dollar_escape,
    ACTIONS(763), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(687), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20940] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(691), 1,
      sym__indented_dollar_escape,
    ACTIONS(765), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(687), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20961] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20974] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(769), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20995] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(771), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21016] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(773), 1,
      anon_sym_DQUOTE,
    ACTIONS(775), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(396), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21037] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(777), 1,
      anon_sym_DQUOTE,
    ACTIONS(779), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(401), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21058] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(691), 1,
      sym__indented_dollar_escape,
    ACTIONS(781), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(783), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(398), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [21079] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    STATE(367), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(487), 1,
      sym_inherited_attrs,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [21102] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21115] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21128] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(789), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21141] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21154] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(691), 1,
      sym__indented_dollar_escape,
    ACTIONS(793), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(795), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(381), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [21175] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21188] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21201] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21222] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(803), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21243] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(691), 1,
      sym__indented_dollar_escape,
    ACTIONS(805), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(687), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [21264] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(809), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(397), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21285] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(811), 1,
      anon_sym_DQUOTE,
    ACTIONS(813), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(372), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21306] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(672), 1,
      sym_dollar_escape,
    ACTIONS(815), 1,
      anon_sym_DQUOTE,
    ACTIONS(706), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(362), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21327] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 1,
      sym_identifier,
    ACTIONS(819), 1,
      anon_sym_DQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(224), 1,
      sym_attrpath,
    STATE(189), 2,
      sym_string_expression,
      sym_interpolation,
  [21347] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(823), 1,
      sym_identifier,
    STATE(277), 1,
      sym_attrpath,
    STATE(280), 2,
      sym_string_expression,
      sym_interpolation,
  [21367] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 1,
      sym_identifier,
    ACTIONS(827), 1,
      anon_sym_DQUOTE,
    ACTIONS(829), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(96), 1,
      sym_attrpath,
    STATE(85), 2,
      sym_string_expression,
      sym_interpolation,
  [21387] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(831), 1,
      sym_identifier,
    ACTIONS(833), 1,
      anon_sym_DQUOTE,
    ACTIONS(835), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(223), 1,
      sym_attrpath,
    STATE(181), 2,
      sym_string_expression,
      sym_interpolation,
  [21407] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(462), 1,
      anon_sym_DOT,
    ACTIONS(839), 1,
      anon_sym_QMARK,
    STATE(278), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(837), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21427] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      sym_identifier,
    ACTIONS(843), 1,
      anon_sym_DQUOTE,
    ACTIONS(845), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(247), 1,
      sym_attrpath,
    STATE(182), 2,
      sym_string_expression,
      sym_interpolation,
  [21447] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_DQUOTE,
    ACTIONS(851), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(277), 1,
      sym_attrpath,
    STATE(282), 2,
      sym_string_expression,
      sym_interpolation,
  [21467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(853), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(855), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21480] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DQUOTE,
    ACTIONS(835), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(857), 1,
      sym_identifier,
    STATE(200), 2,
      sym_string_expression,
      sym_interpolation,
  [21497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(861), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21510] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(859), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21523] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(849), 1,
      anon_sym_DQUOTE,
    ACTIONS(851), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(863), 1,
      sym_identifier,
    STATE(273), 2,
      sym_string_expression,
      sym_interpolation,
  [21540] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 1,
      anon_sym_DQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(865), 1,
      sym_identifier,
    STATE(204), 2,
      sym_string_expression,
      sym_interpolation,
  [21557] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(863), 1,
      sym_identifier,
    STATE(273), 2,
      sym_string_expression,
      sym_interpolation,
  [21574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(869), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21587] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 1,
      anon_sym_DQUOTE,
    ACTIONS(845), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(871), 1,
      sym_identifier,
    STATE(197), 2,
      sym_string_expression,
      sym_interpolation,
  [21604] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_DQUOTE,
    ACTIONS(829), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(873), 1,
      sym_identifier,
    STATE(92), 2,
      sym_string_expression,
      sym_interpolation,
  [21621] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(877), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21634] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(855), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(853), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21647] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(246), 4,
      sym__indented_string_fragment,
      sym__indented_dollar_escape,
      sym__indented_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(877), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(875), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21673] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 5,
      sym_string_fragment,
      sym_dollar_escape,
      anon_sym_DQUOTE,
      sym_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21684] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(867), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21697] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 5,
      sym_string_fragment,
      sym_dollar_escape,
      anon_sym_DQUOTE,
      sym_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21708] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(879), 4,
      sym__indented_string_fragment,
      sym__indented_dollar_escape,
      sym__indented_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21721] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 1,
      sym_identifier,
    ACTIONS(883), 1,
      anon_sym_RBRACE,
    ACTIONS(885), 1,
      sym_ellipses,
    STATE(448), 1,
      sym_formal,
  [21737] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 4,
      sym_identifier,
      anon_sym_SEMI,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21747] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(881), 1,
      sym_identifier,
    ACTIONS(889), 1,
      anon_sym_RBRACE,
    STATE(435), 1,
      sym_formal,
  [21763] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 1,
      sym_identifier,
    ACTIONS(891), 1,
      anon_sym_RBRACE,
    ACTIONS(893), 1,
      sym_ellipses,
    STATE(448), 1,
      sym_formal,
  [21779] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(895), 1,
      anon_sym_RBRACE,
    ACTIONS(897), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      aux_sym_formals_repeat1,
  [21792] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_EQ,
    ACTIONS(462), 1,
      anon_sym_DOT,
    STATE(276), 1,
      aux_sym_attrpath_repeat1,
  [21805] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 1,
      anon_sym_RBRACE,
    ACTIONS(901), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      aux_sym_formals_repeat1,
  [21818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_QMARK,
    ACTIONS(837), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21829] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_RBRACE,
    ACTIONS(906), 1,
      anon_sym_COMMA,
    STATE(431), 1,
      aux_sym_formals_repeat1,
  [21842] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(462), 1,
      anon_sym_DOT,
    STATE(432), 1,
      aux_sym_attrpath_repeat1,
  [21855] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21863] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 1,
      anon_sym_COLON,
    ACTIONS(912), 1,
      anon_sym_AT,
  [21873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(914), 1,
      anon_sym_COLON,
    ACTIONS(916), 1,
      anon_sym_AT,
  [21883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_COLON,
    ACTIONS(920), 1,
      anon_sym_AT,
  [21893] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(455), 1,
      sym_formals,
  [21903] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21911] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(457), 1,
      sym_formals,
  [21921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(469), 1,
      sym_formals,
  [21931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(515), 1,
      sym_formals,
  [21941] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_COLON,
    ACTIONS(930), 1,
      anon_sym_AT,
  [21959] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21967] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21975] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21983] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21991] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 1,
      sym_identifier,
    STATE(448), 1,
      sym_formal,
  [22009] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(942), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [22017] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      anon_sym_COLON,
  [22024] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(946), 1,
      anon_sym_SEMI,
  [22031] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 1,
      anon_sym_COLON,
  [22038] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(950), 1,
      anon_sym_in,
  [22045] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 1,
      anon_sym_RPAREN,
  [22052] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
  [22059] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 1,
      anon_sym_RBRACE,
  [22066] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_RPAREN,
  [22073] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(958), 1,
      anon_sym_RBRACE,
  [22080] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 1,
      anon_sym_RBRACE,
  [22087] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      anon_sym_COLON,
  [22094] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 1,
      anon_sym_else,
  [22101] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 1,
      anon_sym_RBRACE,
  [22108] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 1,
      anon_sym_RBRACE,
  [22115] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 1,
      anon_sym_COLON,
  [22122] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 1,
      anon_sym_in,
  [22129] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_RBRACE,
  [22136] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 1,
      anon_sym_RBRACE,
  [22143] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 1,
      anon_sym_RBRACE,
  [22150] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 1,
      anon_sym_COLON,
  [22157] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 1,
      anon_sym_else,
  [22164] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 1,
      anon_sym_SEMI,
  [22171] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      anon_sym_LBRACE,
  [22178] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 1,
      anon_sym_RPAREN,
  [22185] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 1,
      anon_sym_RBRACE,
  [22192] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_SEMI,
  [22199] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      anon_sym_RBRACE,
  [22206] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 1,
      anon_sym_RBRACE,
  [22213] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      anon_sym_RBRACE,
  [22220] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 1,
      anon_sym_SEMI,
  [22227] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      anon_sym_RBRACE,
  [22234] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 1,
      anon_sym_SEMI,
  [22241] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 1,
      anon_sym_SEMI,
  [22248] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1006), 1,
      anon_sym_RBRACE,
  [22255] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 1,
      anon_sym_else,
  [22262] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_SEMI,
  [22269] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      anon_sym_COLON,
  [22276] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_RBRACE,
  [22283] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 1,
      anon_sym_RBRACE,
  [22290] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_LBRACE,
  [22297] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 1,
      anon_sym_RBRACE,
  [22304] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 1,
      anon_sym_LBRACE,
  [22311] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 1,
      anon_sym_then,
  [22318] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_SEMI,
  [22325] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 1,
      anon_sym_RBRACE,
  [22332] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_in,
  [22339] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1030), 1,
      sym_identifier,
  [22346] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      anon_sym_RPAREN,
  [22353] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      anon_sym_LBRACE,
  [22360] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 1,
      anon_sym_in,
  [22367] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      anon_sym_SEMI,
  [22374] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 1,
      anon_sym_SEMI,
  [22381] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 1,
      anon_sym_SEMI,
  [22388] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 1,
      anon_sym_RBRACE,
  [22395] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      anon_sym_DOLLAR,
  [22402] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1046), 1,
      anon_sym_SEMI,
  [22409] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 1,
      sym_identifier,
  [22416] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1050), 1,
      anon_sym_EQ,
  [22423] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 1,
      anon_sym_LBRACE,
  [22430] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 1,
      anon_sym_RBRACE,
  [22437] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 1,
      anon_sym_COLON,
  [22444] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 1,
      anon_sym_RBRACE,
  [22451] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 1,
      sym_identifier,
  [22458] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 1,
      anon_sym_SEMI,
  [22465] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      anon_sym_RBRACE,
  [22472] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 1,
      anon_sym_RBRACE,
  [22479] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 1,
      anon_sym_RBRACE,
  [22486] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 1,
      anon_sym_LBRACE,
  [22493] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1072), 1,
      anon_sym_RBRACE,
  [22500] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_COLON,
  [22507] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 1,
      anon_sym_COLON,
  [22514] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      sym_identifier,
  [22521] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1078), 1,
      anon_sym_DOLLAR,
  [22528] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 1,
      anon_sym_RPAREN,
  [22535] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1082), 1,
      anon_sym_RBRACE,
  [22542] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1084), 1,
      ts_builtin_sym_end,
  [22549] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1086), 1,
      ts_builtin_sym_end,
  [22556] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1088), 1,
      anon_sym_EQ,
  [22563] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1090), 1,
      anon_sym_then,
  [22570] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_RPAREN,
  [22577] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1094), 1,
      anon_sym_then,
  [22584] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_then,
  [22591] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      anon_sym_SEMI,
  [22598] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      anon_sym_else,
  [22605] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1102), 1,
      anon_sym_LBRACE,
  [22612] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1104), 1,
      anon_sym_RBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 97,
  [SMALL_STATE(4)] = 194,
  [SMALL_STATE(5)] = 291,
  [SMALL_STATE(6)] = 388,
  [SMALL_STATE(7)] = 485,
  [SMALL_STATE(8)] = 582,
  [SMALL_STATE(9)] = 679,
  [SMALL_STATE(10)] = 776,
  [SMALL_STATE(11)] = 873,
  [SMALL_STATE(12)] = 970,
  [SMALL_STATE(13)] = 1067,
  [SMALL_STATE(14)] = 1164,
  [SMALL_STATE(15)] = 1261,
  [SMALL_STATE(16)] = 1358,
  [SMALL_STATE(17)] = 1455,
  [SMALL_STATE(18)] = 1552,
  [SMALL_STATE(19)] = 1649,
  [SMALL_STATE(20)] = 1746,
  [SMALL_STATE(21)] = 1843,
  [SMALL_STATE(22)] = 1940,
  [SMALL_STATE(23)] = 2037,
  [SMALL_STATE(24)] = 2134,
  [SMALL_STATE(25)] = 2217,
  [SMALL_STATE(26)] = 2314,
  [SMALL_STATE(27)] = 2411,
  [SMALL_STATE(28)] = 2508,
  [SMALL_STATE(29)] = 2605,
  [SMALL_STATE(30)] = 2702,
  [SMALL_STATE(31)] = 2799,
  [SMALL_STATE(32)] = 2896,
  [SMALL_STATE(33)] = 2993,
  [SMALL_STATE(34)] = 3090,
  [SMALL_STATE(35)] = 3187,
  [SMALL_STATE(36)] = 3284,
  [SMALL_STATE(37)] = 3381,
  [SMALL_STATE(38)] = 3478,
  [SMALL_STATE(39)] = 3575,
  [SMALL_STATE(40)] = 3672,
  [SMALL_STATE(41)] = 3769,
  [SMALL_STATE(42)] = 3866,
  [SMALL_STATE(43)] = 3963,
  [SMALL_STATE(44)] = 4060,
  [SMALL_STATE(45)] = 4154,
  [SMALL_STATE(46)] = 4248,
  [SMALL_STATE(47)] = 4342,
  [SMALL_STATE(48)] = 4436,
  [SMALL_STATE(49)] = 4530,
  [SMALL_STATE(50)] = 4624,
  [SMALL_STATE(51)] = 4718,
  [SMALL_STATE(52)] = 4812,
  [SMALL_STATE(53)] = 4906,
  [SMALL_STATE(54)] = 5000,
  [SMALL_STATE(55)] = 5094,
  [SMALL_STATE(56)] = 5188,
  [SMALL_STATE(57)] = 5282,
  [SMALL_STATE(58)] = 5376,
  [SMALL_STATE(59)] = 5470,
  [SMALL_STATE(60)] = 5564,
  [SMALL_STATE(61)] = 5658,
  [SMALL_STATE(62)] = 5752,
  [SMALL_STATE(63)] = 5846,
  [SMALL_STATE(64)] = 5940,
  [SMALL_STATE(65)] = 6034,
  [SMALL_STATE(66)] = 6128,
  [SMALL_STATE(67)] = 6222,
  [SMALL_STATE(68)] = 6316,
  [SMALL_STATE(69)] = 6410,
  [SMALL_STATE(70)] = 6504,
  [SMALL_STATE(71)] = 6598,
  [SMALL_STATE(72)] = 6692,
  [SMALL_STATE(73)] = 6786,
  [SMALL_STATE(74)] = 6880,
  [SMALL_STATE(75)] = 6974,
  [SMALL_STATE(76)] = 7068,
  [SMALL_STATE(77)] = 7148,
  [SMALL_STATE(78)] = 7228,
  [SMALL_STATE(79)] = 7308,
  [SMALL_STATE(80)] = 7364,
  [SMALL_STATE(81)] = 7420,
  [SMALL_STATE(82)] = 7476,
  [SMALL_STATE(83)] = 7532,
  [SMALL_STATE(84)] = 7588,
  [SMALL_STATE(85)] = 7634,
  [SMALL_STATE(86)] = 7684,
  [SMALL_STATE(87)] = 7734,
  [SMALL_STATE(88)] = 7780,
  [SMALL_STATE(89)] = 7830,
  [SMALL_STATE(90)] = 7877,
  [SMALL_STATE(91)] = 7926,
  [SMALL_STATE(92)] = 7971,
  [SMALL_STATE(93)] = 8016,
  [SMALL_STATE(94)] = 8061,
  [SMALL_STATE(95)] = 8106,
  [SMALL_STATE(96)] = 8158,
  [SMALL_STATE(97)] = 8204,
  [SMALL_STATE(98)] = 8248,
  [SMALL_STATE(99)] = 8300,
  [SMALL_STATE(100)] = 8344,
  [SMALL_STATE(101)] = 8388,
  [SMALL_STATE(102)] = 8432,
  [SMALL_STATE(103)] = 8476,
  [SMALL_STATE(104)] = 8520,
  [SMALL_STATE(105)] = 8564,
  [SMALL_STATE(106)] = 8616,
  [SMALL_STATE(107)] = 8662,
  [SMALL_STATE(108)] = 8706,
  [SMALL_STATE(109)] = 8750,
  [SMALL_STATE(110)] = 8794,
  [SMALL_STATE(111)] = 8846,
  [SMALL_STATE(112)] = 8898,
  [SMALL_STATE(113)] = 8950,
  [SMALL_STATE(114)] = 8994,
  [SMALL_STATE(115)] = 9046,
  [SMALL_STATE(116)] = 9098,
  [SMALL_STATE(117)] = 9142,
  [SMALL_STATE(118)] = 9194,
  [SMALL_STATE(119)] = 9238,
  [SMALL_STATE(120)] = 9290,
  [SMALL_STATE(121)] = 9342,
  [SMALL_STATE(122)] = 9394,
  [SMALL_STATE(123)] = 9446,
  [SMALL_STATE(124)] = 9498,
  [SMALL_STATE(125)] = 9550,
  [SMALL_STATE(126)] = 9594,
  [SMALL_STATE(127)] = 9667,
  [SMALL_STATE(128)] = 9710,
  [SMALL_STATE(129)] = 9783,
  [SMALL_STATE(130)] = 9856,
  [SMALL_STATE(131)] = 9929,
  [SMALL_STATE(132)] = 10002,
  [SMALL_STATE(133)] = 10075,
  [SMALL_STATE(134)] = 10148,
  [SMALL_STATE(135)] = 10221,
  [SMALL_STATE(136)] = 10294,
  [SMALL_STATE(137)] = 10367,
  [SMALL_STATE(138)] = 10440,
  [SMALL_STATE(139)] = 10513,
  [SMALL_STATE(140)] = 10586,
  [SMALL_STATE(141)] = 10659,
  [SMALL_STATE(142)] = 10732,
  [SMALL_STATE(143)] = 10805,
  [SMALL_STATE(144)] = 10878,
  [SMALL_STATE(145)] = 10951,
  [SMALL_STATE(146)] = 11024,
  [SMALL_STATE(147)] = 11097,
  [SMALL_STATE(148)] = 11170,
  [SMALL_STATE(149)] = 11243,
  [SMALL_STATE(150)] = 11316,
  [SMALL_STATE(151)] = 11389,
  [SMALL_STATE(152)] = 11462,
  [SMALL_STATE(153)] = 11535,
  [SMALL_STATE(154)] = 11608,
  [SMALL_STATE(155)] = 11681,
  [SMALL_STATE(156)] = 11754,
  [SMALL_STATE(157)] = 11827,
  [SMALL_STATE(158)] = 11900,
  [SMALL_STATE(159)] = 11973,
  [SMALL_STATE(160)] = 12046,
  [SMALL_STATE(161)] = 12119,
  [SMALL_STATE(162)] = 12192,
  [SMALL_STATE(163)] = 12265,
  [SMALL_STATE(164)] = 12338,
  [SMALL_STATE(165)] = 12411,
  [SMALL_STATE(166)] = 12484,
  [SMALL_STATE(167)] = 12557,
  [SMALL_STATE(168)] = 12630,
  [SMALL_STATE(169)] = 12703,
  [SMALL_STATE(170)] = 12776,
  [SMALL_STATE(171)] = 12849,
  [SMALL_STATE(172)] = 12891,
  [SMALL_STATE(173)] = 12937,
  [SMALL_STATE(174)] = 12979,
  [SMALL_STATE(175)] = 13025,
  [SMALL_STATE(176)] = 13071,
  [SMALL_STATE(177)] = 13113,
  [SMALL_STATE(178)] = 13159,
  [SMALL_STATE(179)] = 13203,
  [SMALL_STATE(180)] = 13249,
  [SMALL_STATE(181)] = 13295,
  [SMALL_STATE(182)] = 13341,
  [SMALL_STATE(183)] = 13387,
  [SMALL_STATE(184)] = 13429,
  [SMALL_STATE(185)] = 13473,
  [SMALL_STATE(186)] = 13519,
  [SMALL_STATE(187)] = 13563,
  [SMALL_STATE(188)] = 13605,
  [SMALL_STATE(189)] = 13647,
  [SMALL_STATE(190)] = 13693,
  [SMALL_STATE(191)] = 13739,
  [SMALL_STATE(192)] = 13781,
  [SMALL_STATE(193)] = 13827,
  [SMALL_STATE(194)] = 13868,
  [SMALL_STATE(195)] = 13909,
  [SMALL_STATE(196)] = 13950,
  [SMALL_STATE(197)] = 13991,
  [SMALL_STATE(198)] = 14032,
  [SMALL_STATE(199)] = 14073,
  [SMALL_STATE(200)] = 14114,
  [SMALL_STATE(201)] = 14155,
  [SMALL_STATE(202)] = 14196,
  [SMALL_STATE(203)] = 14237,
  [SMALL_STATE(204)] = 14278,
  [SMALL_STATE(205)] = 14319,
  [SMALL_STATE(206)] = 14359,
  [SMALL_STATE(207)] = 14399,
  [SMALL_STATE(208)] = 14439,
  [SMALL_STATE(209)] = 14479,
  [SMALL_STATE(210)] = 14519,
  [SMALL_STATE(211)] = 14559,
  [SMALL_STATE(212)] = 14599,
  [SMALL_STATE(213)] = 14639,
  [SMALL_STATE(214)] = 14679,
  [SMALL_STATE(215)] = 14719,
  [SMALL_STATE(216)] = 14759,
  [SMALL_STATE(217)] = 14799,
  [SMALL_STATE(218)] = 14839,
  [SMALL_STATE(219)] = 14879,
  [SMALL_STATE(220)] = 14919,
  [SMALL_STATE(221)] = 14959,
  [SMALL_STATE(222)] = 14999,
  [SMALL_STATE(223)] = 15039,
  [SMALL_STATE(224)] = 15081,
  [SMALL_STATE(225)] = 15123,
  [SMALL_STATE(226)] = 15165,
  [SMALL_STATE(227)] = 15205,
  [SMALL_STATE(228)] = 15245,
  [SMALL_STATE(229)] = 15285,
  [SMALL_STATE(230)] = 15325,
  [SMALL_STATE(231)] = 15365,
  [SMALL_STATE(232)] = 15405,
  [SMALL_STATE(233)] = 15445,
  [SMALL_STATE(234)] = 15485,
  [SMALL_STATE(235)] = 15525,
  [SMALL_STATE(236)] = 15565,
  [SMALL_STATE(237)] = 15605,
  [SMALL_STATE(238)] = 15647,
  [SMALL_STATE(239)] = 15687,
  [SMALL_STATE(240)] = 15727,
  [SMALL_STATE(241)] = 15767,
  [SMALL_STATE(242)] = 15807,
  [SMALL_STATE(243)] = 15847,
  [SMALL_STATE(244)] = 15887,
  [SMALL_STATE(245)] = 15927,
  [SMALL_STATE(246)] = 15969,
  [SMALL_STATE(247)] = 16009,
  [SMALL_STATE(248)] = 16051,
  [SMALL_STATE(249)] = 16091,
  [SMALL_STATE(250)] = 16131,
  [SMALL_STATE(251)] = 16171,
  [SMALL_STATE(252)] = 16211,
  [SMALL_STATE(253)] = 16251,
  [SMALL_STATE(254)] = 16290,
  [SMALL_STATE(255)] = 16329,
  [SMALL_STATE(256)] = 16368,
  [SMALL_STATE(257)] = 16407,
  [SMALL_STATE(258)] = 16446,
  [SMALL_STATE(259)] = 16485,
  [SMALL_STATE(260)] = 16550,
  [SMALL_STATE(261)] = 16615,
  [SMALL_STATE(262)] = 16680,
  [SMALL_STATE(263)] = 16745,
  [SMALL_STATE(264)] = 16810,
  [SMALL_STATE(265)] = 16875,
  [SMALL_STATE(266)] = 16940,
  [SMALL_STATE(267)] = 17005,
  [SMALL_STATE(268)] = 17070,
  [SMALL_STATE(269)] = 17129,
  [SMALL_STATE(270)] = 17188,
  [SMALL_STATE(271)] = 17247,
  [SMALL_STATE(272)] = 17306,
  [SMALL_STATE(273)] = 17339,
  [SMALL_STATE(274)] = 17372,
  [SMALL_STATE(275)] = 17405,
  [SMALL_STATE(276)] = 17438,
  [SMALL_STATE(277)] = 17473,
  [SMALL_STATE(278)] = 17504,
  [SMALL_STATE(279)] = 17539,
  [SMALL_STATE(280)] = 17570,
  [SMALL_STATE(281)] = 17604,
  [SMALL_STATE(282)] = 17637,
  [SMALL_STATE(283)] = 17670,
  [SMALL_STATE(284)] = 17703,
  [SMALL_STATE(285)] = 17747,
  [SMALL_STATE(286)] = 17787,
  [SMALL_STATE(287)] = 17815,
  [SMALL_STATE(288)] = 17843,
  [SMALL_STATE(289)] = 17875,
  [SMALL_STATE(290)] = 17925,
  [SMALL_STATE(291)] = 17953,
  [SMALL_STATE(292)] = 17985,
  [SMALL_STATE(293)] = 18025,
  [SMALL_STATE(294)] = 18075,
  [SMALL_STATE(295)] = 18113,
  [SMALL_STATE(296)] = 18155,
  [SMALL_STATE(297)] = 18201,
  [SMALL_STATE(298)] = 18237,
  [SMALL_STATE(299)] = 18274,
  [SMALL_STATE(300)] = 18307,
  [SMALL_STATE(301)] = 18354,
  [SMALL_STATE(302)] = 18383,
  [SMALL_STATE(303)] = 18420,
  [SMALL_STATE(304)] = 18467,
  [SMALL_STATE(305)] = 18496,
  [SMALL_STATE(306)] = 18539,
  [SMALL_STATE(307)] = 18574,
  [SMALL_STATE(308)] = 18615,
  [SMALL_STATE(309)] = 18652,
  [SMALL_STATE(310)] = 18691,
  [SMALL_STATE(311)] = 18724,
  [SMALL_STATE(312)] = 18753,
  [SMALL_STATE(313)] = 18788,
  [SMALL_STATE(314)] = 18835,
  [SMALL_STATE(315)] = 18874,
  [SMALL_STATE(316)] = 18917,
  [SMALL_STATE(317)] = 18958,
  [SMALL_STATE(318)] = 18999,
  [SMALL_STATE(319)] = 19042,
  [SMALL_STATE(320)] = 19071,
  [SMALL_STATE(321)] = 19100,
  [SMALL_STATE(322)] = 19147,
  [SMALL_STATE(323)] = 19184,
  [SMALL_STATE(324)] = 19221,
  [SMALL_STATE(325)] = 19258,
  [SMALL_STATE(326)] = 19297,
  [SMALL_STATE(327)] = 19344,
  [SMALL_STATE(328)] = 19377,
  [SMALL_STATE(329)] = 19406,
  [SMALL_STATE(330)] = 19453,
  [SMALL_STATE(331)] = 19488,
  [SMALL_STATE(332)] = 19531,
  [SMALL_STATE(333)] = 19574,
  [SMALL_STATE(334)] = 19617,
  [SMALL_STATE(335)] = 19640,
  [SMALL_STATE(336)] = 19683,
  [SMALL_STATE(337)] = 19723,
  [SMALL_STATE(338)] = 19763,
  [SMALL_STATE(339)] = 19803,
  [SMALL_STATE(340)] = 19843,
  [SMALL_STATE(341)] = 19880,
  [SMALL_STATE(342)] = 19917,
  [SMALL_STATE(343)] = 19954,
  [SMALL_STATE(344)] = 19991,
  [SMALL_STATE(345)] = 20028,
  [SMALL_STATE(346)] = 20065,
  [SMALL_STATE(347)] = 20102,
  [SMALL_STATE(348)] = 20139,
  [SMALL_STATE(349)] = 20176,
  [SMALL_STATE(350)] = 20213,
  [SMALL_STATE(351)] = 20250,
  [SMALL_STATE(352)] = 20287,
  [SMALL_STATE(353)] = 20321,
  [SMALL_STATE(354)] = 20355,
  [SMALL_STATE(355)] = 20389,
  [SMALL_STATE(356)] = 20423,
  [SMALL_STATE(357)] = 20449,
  [SMALL_STATE(358)] = 20475,
  [SMALL_STATE(359)] = 20498,
  [SMALL_STATE(360)] = 20519,
  [SMALL_STATE(361)] = 20540,
  [SMALL_STATE(362)] = 20561,
  [SMALL_STATE(363)] = 20582,
  [SMALL_STATE(364)] = 20603,
  [SMALL_STATE(365)] = 20624,
  [SMALL_STATE(366)] = 20645,
  [SMALL_STATE(367)] = 20658,
  [SMALL_STATE(368)] = 20681,
  [SMALL_STATE(369)] = 20702,
  [SMALL_STATE(370)] = 20723,
  [SMALL_STATE(371)] = 20744,
  [SMALL_STATE(372)] = 20757,
  [SMALL_STATE(373)] = 20778,
  [SMALL_STATE(374)] = 20799,
  [SMALL_STATE(375)] = 20812,
  [SMALL_STATE(376)] = 20833,
  [SMALL_STATE(377)] = 20854,
  [SMALL_STATE(378)] = 20875,
  [SMALL_STATE(379)] = 20896,
  [SMALL_STATE(380)] = 20919,
  [SMALL_STATE(381)] = 20940,
  [SMALL_STATE(382)] = 20961,
  [SMALL_STATE(383)] = 20974,
  [SMALL_STATE(384)] = 20995,
  [SMALL_STATE(385)] = 21016,
  [SMALL_STATE(386)] = 21037,
  [SMALL_STATE(387)] = 21058,
  [SMALL_STATE(388)] = 21079,
  [SMALL_STATE(389)] = 21102,
  [SMALL_STATE(390)] = 21115,
  [SMALL_STATE(391)] = 21128,
  [SMALL_STATE(392)] = 21141,
  [SMALL_STATE(393)] = 21154,
  [SMALL_STATE(394)] = 21175,
  [SMALL_STATE(395)] = 21188,
  [SMALL_STATE(396)] = 21201,
  [SMALL_STATE(397)] = 21222,
  [SMALL_STATE(398)] = 21243,
  [SMALL_STATE(399)] = 21264,
  [SMALL_STATE(400)] = 21285,
  [SMALL_STATE(401)] = 21306,
  [SMALL_STATE(402)] = 21327,
  [SMALL_STATE(403)] = 21347,
  [SMALL_STATE(404)] = 21367,
  [SMALL_STATE(405)] = 21387,
  [SMALL_STATE(406)] = 21407,
  [SMALL_STATE(407)] = 21427,
  [SMALL_STATE(408)] = 21447,
  [SMALL_STATE(409)] = 21467,
  [SMALL_STATE(410)] = 21480,
  [SMALL_STATE(411)] = 21497,
  [SMALL_STATE(412)] = 21510,
  [SMALL_STATE(413)] = 21523,
  [SMALL_STATE(414)] = 21540,
  [SMALL_STATE(415)] = 21557,
  [SMALL_STATE(416)] = 21574,
  [SMALL_STATE(417)] = 21587,
  [SMALL_STATE(418)] = 21604,
  [SMALL_STATE(419)] = 21621,
  [SMALL_STATE(420)] = 21634,
  [SMALL_STATE(421)] = 21647,
  [SMALL_STATE(422)] = 21660,
  [SMALL_STATE(423)] = 21673,
  [SMALL_STATE(424)] = 21684,
  [SMALL_STATE(425)] = 21697,
  [SMALL_STATE(426)] = 21708,
  [SMALL_STATE(427)] = 21721,
  [SMALL_STATE(428)] = 21737,
  [SMALL_STATE(429)] = 21747,
  [SMALL_STATE(430)] = 21763,
  [SMALL_STATE(431)] = 21779,
  [SMALL_STATE(432)] = 21792,
  [SMALL_STATE(433)] = 21805,
  [SMALL_STATE(434)] = 21818,
  [SMALL_STATE(435)] = 21829,
  [SMALL_STATE(436)] = 21842,
  [SMALL_STATE(437)] = 21855,
  [SMALL_STATE(438)] = 21863,
  [SMALL_STATE(439)] = 21873,
  [SMALL_STATE(440)] = 21883,
  [SMALL_STATE(441)] = 21893,
  [SMALL_STATE(442)] = 21903,
  [SMALL_STATE(443)] = 21911,
  [SMALL_STATE(444)] = 21921,
  [SMALL_STATE(445)] = 21931,
  [SMALL_STATE(446)] = 21941,
  [SMALL_STATE(447)] = 21949,
  [SMALL_STATE(448)] = 21959,
  [SMALL_STATE(449)] = 21967,
  [SMALL_STATE(450)] = 21975,
  [SMALL_STATE(451)] = 21983,
  [SMALL_STATE(452)] = 21991,
  [SMALL_STATE(453)] = 21999,
  [SMALL_STATE(454)] = 22009,
  [SMALL_STATE(455)] = 22017,
  [SMALL_STATE(456)] = 22024,
  [SMALL_STATE(457)] = 22031,
  [SMALL_STATE(458)] = 22038,
  [SMALL_STATE(459)] = 22045,
  [SMALL_STATE(460)] = 22052,
  [SMALL_STATE(461)] = 22059,
  [SMALL_STATE(462)] = 22066,
  [SMALL_STATE(463)] = 22073,
  [SMALL_STATE(464)] = 22080,
  [SMALL_STATE(465)] = 22087,
  [SMALL_STATE(466)] = 22094,
  [SMALL_STATE(467)] = 22101,
  [SMALL_STATE(468)] = 22108,
  [SMALL_STATE(469)] = 22115,
  [SMALL_STATE(470)] = 22122,
  [SMALL_STATE(471)] = 22129,
  [SMALL_STATE(472)] = 22136,
  [SMALL_STATE(473)] = 22143,
  [SMALL_STATE(474)] = 22150,
  [SMALL_STATE(475)] = 22157,
  [SMALL_STATE(476)] = 22164,
  [SMALL_STATE(477)] = 22171,
  [SMALL_STATE(478)] = 22178,
  [SMALL_STATE(479)] = 22185,
  [SMALL_STATE(480)] = 22192,
  [SMALL_STATE(481)] = 22199,
  [SMALL_STATE(482)] = 22206,
  [SMALL_STATE(483)] = 22213,
  [SMALL_STATE(484)] = 22220,
  [SMALL_STATE(485)] = 22227,
  [SMALL_STATE(486)] = 22234,
  [SMALL_STATE(487)] = 22241,
  [SMALL_STATE(488)] = 22248,
  [SMALL_STATE(489)] = 22255,
  [SMALL_STATE(490)] = 22262,
  [SMALL_STATE(491)] = 22269,
  [SMALL_STATE(492)] = 22276,
  [SMALL_STATE(493)] = 22283,
  [SMALL_STATE(494)] = 22290,
  [SMALL_STATE(495)] = 22297,
  [SMALL_STATE(496)] = 22304,
  [SMALL_STATE(497)] = 22311,
  [SMALL_STATE(498)] = 22318,
  [SMALL_STATE(499)] = 22325,
  [SMALL_STATE(500)] = 22332,
  [SMALL_STATE(501)] = 22339,
  [SMALL_STATE(502)] = 22346,
  [SMALL_STATE(503)] = 22353,
  [SMALL_STATE(504)] = 22360,
  [SMALL_STATE(505)] = 22367,
  [SMALL_STATE(506)] = 22374,
  [SMALL_STATE(507)] = 22381,
  [SMALL_STATE(508)] = 22388,
  [SMALL_STATE(509)] = 22395,
  [SMALL_STATE(510)] = 22402,
  [SMALL_STATE(511)] = 22409,
  [SMALL_STATE(512)] = 22416,
  [SMALL_STATE(513)] = 22423,
  [SMALL_STATE(514)] = 22430,
  [SMALL_STATE(515)] = 22437,
  [SMALL_STATE(516)] = 22444,
  [SMALL_STATE(517)] = 22451,
  [SMALL_STATE(518)] = 22458,
  [SMALL_STATE(519)] = 22465,
  [SMALL_STATE(520)] = 22472,
  [SMALL_STATE(521)] = 22479,
  [SMALL_STATE(522)] = 22486,
  [SMALL_STATE(523)] = 22493,
  [SMALL_STATE(524)] = 22500,
  [SMALL_STATE(525)] = 22507,
  [SMALL_STATE(526)] = 22514,
  [SMALL_STATE(527)] = 22521,
  [SMALL_STATE(528)] = 22528,
  [SMALL_STATE(529)] = 22535,
  [SMALL_STATE(530)] = 22542,
  [SMALL_STATE(531)] = 22549,
  [SMALL_STATE(532)] = 22556,
  [SMALL_STATE(533)] = 22563,
  [SMALL_STATE(534)] = 22570,
  [SMALL_STATE(535)] = 22577,
  [SMALL_STATE(536)] = 22584,
  [SMALL_STATE(537)] = 22591,
  [SMALL_STATE(538)] = 22598,
  [SMALL_STATE(539)] = 22605,
  [SMALL_STATE(540)] = 22612,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_code, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(539),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(496),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(513),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(522),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_op, 1),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(503),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr_op, 1),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(460),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(494),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(477),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hpath_expression, 2),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hpath_expression, 2),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_path_expression, 2),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path_expression, 2),
  [183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hpath_expression, 1),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hpath_expression, 1),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [189] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_path_expression, 1),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path_expression, 1),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [195] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_path_expression_repeat1, 2),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2),
  [199] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(26),
  [202] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(83),
  [205] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__immediate_interpolation, 3, .production_id = 17),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__immediate_interpolation, 3, .production_id = 17),
  [209] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrpath, 1, .production_id = 4),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrpath, 1, .production_id = 4),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(418),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26),
  [219] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(418),
  [222] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_path_expression_repeat1, 1, .production_id = 3),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 1, .production_id = 3),
  [226] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrpath, 2, .production_id = 11),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrpath, 2, .production_id = 11),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrset_expression, 2),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrset_expression, 2),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 2),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_expression, 1, .production_id = 1),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_expression, 1, .production_id = 1),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 3, .production_id = 17),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 3, .production_id = 17),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 25),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 25),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_expression, 2),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_expression, 2),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_expression, 3),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_expression, 3),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_select_expression, 3, .production_id = 23),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_select_expression, 3, .production_id = 23),
  [268] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [270] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrset_expression, 3),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrset_expression, 3),
  [274] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(4),
  [277] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(98),
  [280] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_attrset_expression, 3),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_attrset_expression, 3),
  [284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3, .production_id = 17),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3, .production_id = 17),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rec_attrset_expression, 3),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rec_attrset_expression, 3),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_indented_string_expression, 3),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_indented_string_expression, 3),
  [296] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_expression, 3, .production_id = 18),
  [298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_expression, 3, .production_id = 18),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [304] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr_select_expression, 1),
  [306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_select_expression, 1),
  [308] = {.entry = {.count = 1, .reusable = false}}, SHIFT(404),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_indented_string_expression, 2),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_indented_string_expression, 2),
  [314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_expression, 2),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_expression, 2),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [322] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_attrset_expression, 4),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_attrset_expression, 4),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rec_attrset_expression, 4),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rec_attrset_expression, 4),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [342] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(37),
  [345] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(123),
  [348] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(28),
  [351] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(124),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_select_expression, 5, .production_id = 37),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_select_expression, 5, .production_id = 37),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [362] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(417),
  [365] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(410),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [372] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(414),
  [375] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [377] = {.entry = {.count = 1, .reusable = false}}, SHIFT(410),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_apply_expression, 2, .production_id = 9),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_apply_expression, 2, .production_id = 9),
  [387] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [413] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(107),
  [416] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(106),
  [419] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(106),
  [422] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(81),
  [425] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(340),
  [428] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(503),
  [431] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(27),
  [434] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(496),
  [437] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(370),
  [440] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(387),
  [443] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(264),
  [446] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19),
  [448] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(82),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [455] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(415),
  [458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_has_attr_expression, 3, .production_id = 21),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_has_attr_expression, 3, .production_id = 21),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 7),
  [466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 7),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [470] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(413),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 22),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [477] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [481] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [487] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [493] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 22),
  [495] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_if, 1),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [515] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [529] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [543] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [547] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [559] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [571] = {.entry = {.count = 1, .reusable = false}}, SHIFT(406),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [587] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 1, .production_id = 8),
  [589] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 1, .production_id = 8),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(436),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [597] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [599] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [607] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binding_set, 1, .production_id = 6),
  [639] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binding_set, 1, .production_id = 6),
  [641] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(436),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15),
  [646] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(386),
  [649] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(356),
  [652] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(34),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15),
  [657] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(357),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [674] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2),
  [676] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2), SHIFT_REPEAT(360),
  [679] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2), SHIFT_REPEAT(36),
  [682] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2), SHIFT_REPEAT(509),
  [685] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2),
  [695] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2), SHIFT_REPEAT(362),
  [698] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2), SHIFT_REPEAT(43),
  [701] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2), SHIFT_REPEAT(527),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [708] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [716] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 3, .production_id = 20),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inherited_attrs, 1, .production_id = 13),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [724] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_expression, 6, .production_id = 39),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [740] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 3, .production_id = 10),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [752] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26), SHIFT_REPEAT(428),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26),
  [757] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26), SHIFT_REPEAT(386),
  [760] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26), SHIFT_REPEAT(34),
  [763] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [765] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 3, .production_id = 16),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [781] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [785] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert_expression, 4, .production_id = 30),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_with_expression, 4, .production_id = 31),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 4, .production_id = 32),
  [793] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 5, .production_id = 33),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 5, .production_id = 36),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [805] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal, 1, .production_id = 1),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [853] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 1, .production_id = 5),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 1, .production_id = 5),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [859] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inherit, 3, .production_id = 27),
  [861] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inherit, 3, .production_id = 27),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [867] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binding, 4, .production_id = 35),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binding, 4, .production_id = 35),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [875] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inherit_from, 6, .production_id = 40),
  [877] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inherit_from, 6, .production_id = 40),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 1, .production_id = 4),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_formals_repeat1, 2, .production_id = 29),
  [901] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_formals_repeat1, 2, .production_id = 29), SHIFT_REPEAT(453),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [906] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [908] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 3, .production_id = 14),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal, 3, .production_id = 24),
  [926] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 4, .production_id = 14),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_formals_repeat1, 2, .production_id = 14),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 4, .production_id = 28),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 3, .production_id = 12),
  [938] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 5, .production_id = 34),
  [940] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 5, .production_id = 28),
  [942] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 6, .production_id = 38),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1084] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_code, 1, .production_id = 2),
  [1086] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_string_fragment = 0,
  ts_external_token__indented_string_fragment = 1,
  ts_external_token__path_start = 2,
  ts_external_token_path_fragment = 3,
  ts_external_token_dollar_escape = 4,
  ts_external_token__indented_dollar_escape = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_string_fragment] = sym_string_fragment,
  [ts_external_token__indented_string_fragment] = sym__indented_string_fragment,
  [ts_external_token__path_start] = sym__path_start,
  [ts_external_token_path_fragment] = sym_path_fragment,
  [ts_external_token_dollar_escape] = sym_dollar_escape,
  [ts_external_token__indented_dollar_escape] = sym__indented_dollar_escape,
};

static const bool ts_external_scanner_states[6][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_string_fragment] = true,
    [ts_external_token__indented_string_fragment] = true,
    [ts_external_token__path_start] = true,
    [ts_external_token_path_fragment] = true,
    [ts_external_token_dollar_escape] = true,
    [ts_external_token__indented_dollar_escape] = true,
  },
  [2] = {
    [ts_external_token__path_start] = true,
  },
  [3] = {
    [ts_external_token__path_start] = true,
    [ts_external_token_path_fragment] = true,
  },
  [4] = {
    [ts_external_token_string_fragment] = true,
    [ts_external_token_dollar_escape] = true,
  },
  [5] = {
    [ts_external_token__indented_string_fragment] = true,
    [ts_external_token__indented_dollar_escape] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_nix_external_scanner_create(void);
void tree_sitter_nix_external_scanner_destroy(void *);
bool tree_sitter_nix_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_nix_external_scanner_serialize(void *, char *);
void tree_sitter_nix_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_nix(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_keyword,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_nix_external_scanner_create,
      tree_sitter_nix_external_scanner_destroy,
      tree_sitter_nix_external_scanner_scan,
      tree_sitter_nix_external_scanner_serialize,
      tree_sitter_nix_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
