/*
 * Convert "od" output back to a binary file
 *
 * The input is:
00000000: 5841 0000 005f 5841 0000 0000 5841 0000 XA..._XA....XA..
00000010: 00fa 0000 fa00 1000 ........
 * where the input appears bigendian (0x58 is 'X', 0x41 is 'A' etc)
 *
 * See https://sourceforge.net/p/sox/bugs/299
 */

#include <unistd.h>

static char buf[] = {
    0x58, 0x41, 0x00, 0x00, 0x00, 0x5f, 0x58, 0x41, 0x00, 0x00, 0x00, 0x00, 0x58, 0x41, 0x00, 0x00,
    0x00, 0xfa, 0x00, 0x00, 0xfa, 0x00, 0x10, 0x00
};

int
main()
{
    return (write(1, buf, sizeof(buf)) == sizeof(buf));
}

