/*
 * System call printing.
 *
 */

#ifndef AUDIT_SYSCALL_H
#define AUDIT_SYSCALL_H

#include <sys/socket.h>

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(array) (sizeof(array) / sizeof(*(array)))
#endif

#define MAX_ARGS	8
struct syscall_data {
	unsigned int	major, minor;
	int		result;
	unsigned int	nargs;
	struct syscall_arg {
	    int		type;
	    const void *data;
	    size_t	len;
	}		args[MAX_ARGS];
};

/*
 * Print primitives
 */
struct bitname {
	const char *	name;
	unsigned int	value;
	unsigned int	mask;
};
#define defbit(bit)	{ #bit, bit, bit }

struct symbol {
	const char *	name;
	unsigned long	value;
};
#define defsym(sym)	{ #sym, sym }


extern void		syscall_print(struct syscall_data *);
extern int		rtnetlink_print(const struct aud_msg_netlink *, size_t);
extern void		__print_bits(u_int64_t, const struct bitname *);
extern void		__print_symbolic(u_int64_t, const struct symbol *);
extern void		__print_sockaddr(const struct sockaddr *, size_t);
extern void		__print_hwaddr(const struct sockaddr *, size_t);
extern void		__print_af(int);
extern void		__print_ifc_flags(int);
extern void		__print_netaddr(int, const void *, size_t);
extern void		__print_result(long);
extern void		__print_integer(const char *fmt, const void *, size_t);


#endif /* AUDIT_SYSCALL_H */
