/*
 * On bi-arch systems, make sure we run the binary
 * matching the kernel's word size.
 *
 * You can now install aucat and aucat64 on ppc systems. If you
 * invoke aucat, it will automatically exec aucat64 if it notices
 * it's running on a 64bit kernel.
 *
 * Copyright (C) 2003, SuSE Linux AG
 * Written by okir@suse.de
 */

#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>

#include <linux/unistd.h>
#include <linux/sys.h>

#include <laus.h>
#include <laussrv.h>

void
audit_check_biarch(char **argv)
{
	struct utsname	uts;
	unsigned int	user_arch, kern_arch;
	char		*new_name, *old_name;

	user_arch = sizeof(long) * 8;

	if (uname(&uts) < 0) {
		perror("uname");
		exit(1);
	}

	if (!strcmp(uts.machine, "ppc64")
	 || !strcmp(uts.machine, "x86_64")
	 || !strcmp(uts.machine, "ia64")
	 || !strcmp(uts.machine, "s390x")) {
		kern_arch = 64;
	} else {
		kern_arch = 32;
	}
	
	if (kern_arch == user_arch)
		return;

	old_name = argv[0];
	if (old_name == NULL) {
		fprintf(stderr,
			"argv[0] is NULL, cannot run %ubit app\n",
		       	kern_arch);
		exit(1);
	}
	new_name = (char *) malloc(strlen(old_name) + 3);
	sprintf(new_name, "%s%u", old_name, kern_arch);
	argv[0] = new_name;


	/* Prevent recursion */
	if (getenv("__LAUS_RECURSION") != NULL) {
		fprintf(stderr,
			"Captain Kirk, we're being sucked into a black hole.\n"
			"The %s binary doesn't seem to match the kernel's word size\n",
			old_name);
		exit(1);
	}

	putenv("__LAUS_RECURSION=1");

	/* Now exec the real one */
	execvp(new_name, argv);

	perror(new_name);
	exit(1);
}
