/*
 * Utility functions.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include "auditd.h"

static int	read_pidfile(const char *pathname);

int
make_pidfile(const char *pathname, int force)
{
	char	pids[32], tempname[1024], *sp;
	int	fd, res;
	pid_t	pid;

	if (!force
	 && (pid = read_pidfile(pathname)) > 0
	 && kill(pid, 0) < 0 && errno == ESRCH) {
		log_err(LOG_NOTICE, "Removed stale lock %s", pathname);
		unlink(pathname);
	}

	assert(strlen(pathname) + sizeof("fenceXXXXXX") < sizeof(tempname));
	strcpy(tempname, pathname);
	if ((sp = strrchr(tempname, '/')) != 0) {
		sp += 1;
	} else {
		sp = tempname;
	}
	strcpy(sp, "fenceXXXXXX");

	if ((fd = mkstemp(tempname)) < 0)
		return 0;

	fchmod(fd, 0644);

	sprintf(pids, "%u\n", getpid());
	write(fd, pids, strlen(pids));
	close(fd);

	if (force)
		res = rename(tempname, pathname);
	else
		res = link(tempname, pathname);

	if (res < 0)
		log_err(LOG_NOTICE, "Failed to lock %s: %m", pathname);
	unlink(tempname);
	return res;
}

static int
read_pidfile(const char *pathname)
{
	char	buffer[32];
	int	n, fd, pid;

	if ((fd = open(pathname, O_RDONLY)) < 0)
		return -1;

	n = read(fd, buffer, sizeof(buffer)-1);
	close(fd);

	if (n > 0) {
		buffer[n] = '\0';
		pid = atoi(buffer);
		if (pid > 0)
			return pid;
	}

	return -1;
}
