/*
 * Handle audit filters
 *
 * Copyright (C) 2003, SuSE Linux AG
 * Written by okir@suse.de
 */

#ifndef AUDITD_FILTER_H
#define AUDITD_FILTER_H

#include <linux/laus_audit.h>
#include <stdio.h>

#include "parser.h"

typedef struct cf_set {
	cf_object_t	base;
	unsigned int	count;
	char **		values;
} cf_set_t;

typedef struct cf_expr {
	cf_object_t	base;
	int		type;	/* for predicates */
	unsigned int	use	   : 1,
			exported   : 1,
			simplified : 1;
	struct audit_filter data;
} cf_expr_t;

typedef struct cf_filter {
	cf_object_t	base;
	cf_expr_t *	expr;
} cf_filter_t;

#define FC_FILTER_ALWAYS ((cf_expr_t *) 1)
#define FC_FILTER_NEVER ((cf_expr_t *) 0)

extern int		cf_name_to_target(const char *);
extern const char *	cf_target_to_name(unsigned int);
extern int		cf_constant(const char *, unsigned long *);
extern int		cf_syslog_facility(const char *name);
extern int		cf_syslog_priority(const char *name);

extern cf_set_t *	cf_set_new(const char *name);
extern cf_set_t *	cf_set_find(const char *name);
extern void		cf_set_add(struct cf_set *set, const char *s);
extern cf_filter_t *	cf_predicate_new(const char *, cf_expr_t *);
extern cf_filter_t *	cf_predicate_find(const char *);
extern cf_filter_t *	cf_filter_new(const char *, cf_expr_t *);
extern cf_filter_t *	cf_filter_find(const char *name);
extern void		cf_filter_print(FILE *fp, cf_filter_t *f);
extern cf_filter_t *	cf_syscall_new(const char *);
extern cf_filter_t *	cf_syscall_find(const char *);
extern int		cf_syscall_export(unsigned int, const char *);
extern cf_expr_t *	cf_expr_new(int op, ...);
extern cf_expr_t *	cf_expr_lookup(unsigned int);
extern int		cf_expr_simplify(cf_expr_t **ptr);
extern void		cf_expr_print(FILE *, cf_expr_t *);

#endif /* AUDITD_FILTER_H */
