/* -*- mode: C; tab-width:8;  -*-

	aclDrv.h - driver types
*/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file aclApi.c for more informations about authors
 *
 */

#ifndef ACLDRV_H
#define ACLDRV_H

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <assert.h>
#include <unistd.h>
#include <signal.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdarg.h>

#include "context.h"
#include "macros.h"
#include "matrix.h"
#include "texture.h"
#include "types.h"
#include "vb.h"
#include "xform.h"
#include "clip.h"
#include "vbrender.h"

#include <X11/Xlib.h>
#include <X11/extensions/xf86dga.h>
#include <X11/extensions/xf86vmode.h>

#include <GL/aclmesa.h>



#if 1
#define TDEBUG
#endif

#if 0
#define TPDEBUG
#endif

#define TINFO "<aclMesa DD>: "
#include "tracker.h"


#define ACLMESA_DGA_ON              0x1
#define ACLMESA_VIDMODE_ON          0x2



typedef struct acl_vidmode_data {
    Display * dpy;
    XF86VidModeModeInfo * vm_current_modeline;
    ACLuint sonpid;
    ACLuint Vflags;
} aclXVidModeData, *aclXVidModeDataPtr;

typedef void (*acl_sighandler_t)(int);


    
extern void aclSetupDDPointers( GLcontext * );

extern ACLint aclXInitVidModes( Display *, ACLuint, ACLuint );

extern ACLvoid aclXSetDefaultVidModes( ACLvoid );

#endif
