
/*****************************************************************************
 *                                    G P m                                  *
 *                    Generic kernel module for PCI hardware                 *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* Author: simon pogarcic, sim@suse.de */
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _SCANPCI_GPM_H_
#define _SCANPCI_GPM_H_

/* ------------------------------------------------------------------------- */
/*
 * The Device and Vendor Id could sometimes vary on different cards,
 * although the target chip has the same name/functionality; In this place
 * you can define appropriate values for your hardware scan or add new records
 * to cover all cases for your application.
 */
/* The fields:
 * 1. device description (max. 32 chars),
 * 2. chip class (should be defined in specific project_gpm.h file),
 * 3. vendor id,
 * 4. device id,
 * 5. irq handler flags (0/FAST_IRQ)
 * 6. base regions to mmap in kernel space, BASE_NONE or BASE(0-5)
 */
#if defined(GPM_MODULE_OBJECT) || defined(GPM_CLIENT_OBJECT)

#ifdef __KERNEL__
static GPMDev_t SupportedDevices[MAX_DEV_ALOWED] = {
    
    {"3Dlabs Permedia", CHIP_CLASS_PERMEDIA, 0x3d3d, 0x0004,
	0,
	BASE(0) },

    {"3Dlabs Permedia 2", CHIP_CLASS_PERMEDIA2, 0x3d3d, 0x0007,
	0,
	BASE(0) },

    {"3Dlabs Permedia 2v", CHIP_CLASS_PERMEDIA2, 0x3d3d, 0x0009,
	0,
	BASE(0) },

    {"3Dlabs GLINT Delta", CHIP_CLASS_DELTA, 0x3d3d, 0x0003,
	0,
	BASE(0) },

    {"TI Permedia", CHIP_CLASS_PERMEDIA, 0x104c, 0x3d04,
	0,
	BASE(0) },

    {"TI Permedia 2", CHIP_CLASS_PERMEDIA2, 0x104c, 0x3d07,
	0,
	BASE(0) },
};
#endif

#endif

/*
 * The number of elements in above SupportedDev array - don't mess with
 * this and >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> KEEP IT ALWAYS UP-TO-DATE !!!
 */
#define NUMBER_OF_SUPPORTED_DEVICES					6



/* ------------------------------------------------------------------------- */
/*
 * Some cards can have multiple devices on board; To group devices for
 * one PCI card, update this structure to appropriate values.
 */
/* The fields:
 * 1. card desription (max. 32 chars)
 * 2. the card type enumerator
 * 2. number of PCI devices on card
 * 3. the list of PCI devices to search for (as in SupportedDevices)
 */
#if defined(GPM_MODULE_OBJECT) || defined(GPM_CLIENT_OBJECT)

static GPMCard_t SupportedCards[MAX_CARDS_ALOWED] = {
    
    {"PERMEDIA + Delta", CARD_PERMEDIA_DELTA,
      2, { CHIP_CLASS_PERMEDIA, CHIP_CLASS_DELTA } },

    {"PERMEDIA 2", CARD_PERMEDIA2,
      1, { CHIP_CLASS_PERMEDIA2 } },
};

#endif

/*
 * The number of elements in above SupportedCards array - don't play with
 * this and >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> KEEP IT ALWAYS UP-TO-DATE !!!
 */
#define NUMBER_OF_SUPPORTED_CARDS					2



#endif
