
/*****************************************************************************
 *                                  G P M o d                                *
 *                    Generic kernel module for PCI hardware                 *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* Author: simon pogarcic, sim@suse.de */
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _PROJECT_GPM_H_
#define _PROJECT_GPM_H_



#define CHIP_CLASS_300SX		0x01
#define CHIP_CLASS_500TX		0x02
#define CHIP_CLASS_MX			0x03
#define CHIP_CLASS_PERMEDIA		0x04
#define CHIP_CLASS_PERMEDIA2		0x05
#define CHIP_CLASS_DELTA		0x06



#define CARD_GLINT_500TX_DELTA		0x01
#define CARD_GLINT_MX_DELTA		0x02
#define CARD_PERMEDIA_DELTA		0x03
#define CARD_PERMEDIA2			0x04



#define RD_NONE				0x00
#define RD_UNKNOWN			0x01
#define RD_IBM_526DB			0x02
#define RD_IBM_526			0x03
#define RD_IBM_524			0x04
#define RD_IBM_624			0x05
#define RD_IBM_640			0x06



#define RAM_UNKNOWN			0x00
#define RAM_SDRAM			0x01
#define RAM_SGRAM			0x02



#define IRQTYPE_500TX			0x01
#define IRQTYPE_MX			0x02
#define IRQTYPE_PERMEDIA		0x03
#define IRQTYPE_PERMEDIA2		0x04
#define IRQTYPE_DELTA			0x05



#define IRQ_NONE			0x00
#define IRQ_DMA				0x01
#define IRQ_SYNC			0x02
#define IRQ_EXT				0x04
#define IRQ_ERR				0x08
#define IRQ_VRET			0x10



#define IS_CHIP_CLASS_TX(c) \
    ( (c) == CHIP_CLASS_500TX )

#define IS_CHIP_CLASS_MX(c) \
    ( (c) == CHIP_CLASS_MX )

#define IS_CHIP_CLASS_PM(c) \
    ( (c) == CHIP_CLASS_PERMEDIA )

#define IS_CHIP_CLASS_PM2(c) \
    ( (c) == CHIP_CLASS_PERMEDIA2 )



#define IS_CHIP_FAMILY_TXMX(c) \
    ( (c) == CHIP_CLASS_500TX || (c) == CHIP_CLASS_MX )

#define IS_CHIP_FAMILY_PM(c) \
    ( (c) == CHIP_CLASS_PERMEDIA || (c) == CHIP_CLASS_PERMEDIA2 )

#define IS_CHIP_FAMILY_GLINT(c) \
    ( (c) == CHIP_CLASS_300SX || (c) == CHIP_CLASS_500TX || \
      (c) == CHIP_CLASS_MX || (c) == CHIP_CLASS_PERMEDIA || \
      (c) == CHIP_CLASS_PERMEDIA2 )



#endif
